<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:output method="html" encoding="ISO-8859-1"/>
  <xsl:decimal-format name="nf" decimal-separator="," grouping-separator="." /> 

  <xsl:template match="/">
    <table>
     <tr>
        <th colspan="2">&#160;</th>
        <th class="num">PV</th>
        <th class="num">EV</th>
        <th class="num">PEV</th>
        <th class="num">&#160;</th>
        <th class="num">&#160;</th>
      </tr>
      <tr>
        <th>&#160;</th>
        <th colspan="1"><div style="text-align: right;">Summen</div></th>
        <td class="num"><xsl:value-of select="format-number(sum(/*/*/*/@PV), '0,00', 'nf')"/></td>
        <td class="num"><xsl:value-of select="format-number(sum(/*/*/*/@EV), '0,00', 'nf')"/></td>
        <td class="num"><xsl:value-of select="format-number(sum(/*/*/*/@PEV), '0,00', 'nf')"/></td>
        <td class="num">&#160;</td>
        <td class="num">&#160;</td>
      </tr>
      <tr>
        <th>Id</th>
        <th>Name</th>
        <th class="num">PV</th>
        <th class="num">EV</th>
        <th class="num">PEV</th>
        <th class="num">TV</th>
        <th class="num">OV</th>
      </tr>
      <xsl:choose>
        <xsl:when test="/*/orderby/@val = 'PV'">
          <xsl:apply-templates select="/*/items/item"><xsl:sort select="@PV" order="descending" data-type="number"/></xsl:apply-templates>
        </xsl:when>
        <xsl:when test="/*/orderby/@val = 'EV'">
          <xsl:apply-templates select="/*/items/item"><xsl:sort select="@EV" order="descending" data-type="number"/></xsl:apply-templates>
        </xsl:when>
        <xsl:when test="/*/orderby/@val = 'PEV'">
          <xsl:apply-templates select="/*/items/item"><xsl:sort select="@PEV" order="descending" data-type="number"/></xsl:apply-templates>
        </xsl:when>
        <xsl:when test="/*/orderby/@val = 'TV'">
          <xsl:apply-templates select="/*/items/item"><xsl:sort select="@TV" order="descending" data-type="number"/></xsl:apply-templates>
        </xsl:when>
        <xsl:when test="/*/orderby/@val = 'OV'">
          <xsl:apply-templates select="/*/items/item"><xsl:sort select="@OV" order="descending" data-type="number"/></xsl:apply-templates>
        </xsl:when>
      </xsl:choose>
    </table>

  </xsl:template>

  <xsl:template match="item">    
    <tr>
      <td><xsl:value-of select="@Id"/></td>
      <td><xsl:value-of select="@Name"/></td>
      <td class="num"><xsl:value-of select="format-number(@PV, '0,000', 'nf')"/></td>
      <td class="num"><xsl:value-of select="format-number(@EV, '0,000', 'nf')"/></td>
      <td class="num"><xsl:value-of select="format-number(@PEV, '0,000', 'nf')"/></td>
      <td class="num"><xsl:value-of select="format-number(@TV, '0,000', 'nf')"/></td>
      <td class="num"><xsl:value-of select="format-number(@OV, '0,000', 'nf')"/></td>
    </tr>
  </xsl:template>

</xsl:stylesheet>
