<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:decimal-format name="nf" decimal-separator="," grouping-separator="." /> 

  <xsl:template match="/">
<!--
    <html>
    <body>
    <link rel="stylesheet" href="css/style.css" type="text/css"/>
-->
    <table>
      <tr>
        <th>Be.Nr.</th>
        <th>Re.Nr.</th>
        <th>Datum</th>
        <th>Name</th>
        <th>Id</th>
        <th>UID</th>
        <xsl:for-each select="/*/vat_values/*">
          <th class="num">Umsatz <xsl:value-of select="@val"/>%</th>
	</xsl:for-each>
        <th class="num">Brutto</th>
      </tr>
      <xsl:apply-templates select="/*/order"/>
      <tr>
        <td>
	  <xsl:attribute name="colspan">
            <xsl:value-of select="7 + count(/*/vat_values/*)"/>
          </xsl:attribute>
          &#160;
        </td>
      </tr>
      <tr>
        <th colspan="6">Umsatzsummen:</th>
        <xsl:for-each select="/*/vat_values/*">
          <xsl:variable name="src" select="."/>
          <td class="num"><xsl:value-of select="format-number(round(sum(/*/order/item[@VAT=$src/@val]/@Netto) * 100) * .01, '0,00', 'nf')"/></td>
	</xsl:for-each>
      </tr>
      <tr>
        <th colspan="6">MWStsummen:</th>
        <xsl:for-each select="/*/vat_values/*">
          <xsl:variable name="src" select="."/>
          <td class="num"><xsl:value-of select="format-number(round(sum(/*/order/item[@VAT=$src/@val]/@Netto) * $src/@val)* .01, '0,00', 'nf')"/></td>
	</xsl:for-each>
      </tr>
    </table>
    <br/>

    <xsl:variable name="totalNetto">
      <xsl:call-template name="getTotalNetto"/>
    </xsl:variable>
    <xsl:variable name="totalMWSt">
      <xsl:call-template name="getTotalMWSt"/>
    </xsl:variable>
    
    <table>
      <tr>
        <th>Gesamtumsatz Netto:</th>
        <td class="num"><xsl:value-of select="format-number($totalNetto, '0,00', 'nf')"/></td>
      </tr>
      <tr>
        <th>Gesamtumsatz Brutto:</th>
        <td class="num"><xsl:value-of select="format-number($totalNetto + $totalMWSt, '0,00', 'nf')"/></td>
      </tr>
      <tr>
        <th>Gesamtumsatz MWSt:</th>
        <td class="num"><xsl:value-of select="format-number($totalMWSt, '0,00', 'nf')"/></td>
      </tr>
    </table>
<!--
    </body>
    </html>
-->
  </xsl:template>

  <xsl:template match="order">
    <xsl:variable name="src" select="."/>
    <tr>
      <td><xsl:value-of select="@OrderId"/></td>
      <td><xsl:value-of select="@BillId"/></td>
      <td><xsl:value-of select="@Date"/></td>
      <td><xsl:value-of select="@Name"/></td>
      <td><xsl:value-of select="@DId"/></td>
      <td><xsl:value-of select="@VatId"/></td>
	
      <xsl:for-each select="/*/vat_values/*">
        <xsl:variable name="src2" select="."/>
        <td class="num">
          <xsl:variable name="res">
 	    <xsl:for-each select="$src/*">
              <xsl:if test="@VAT=$src2/@val">
                <xsl:value-of select="format-number(@Netto, '0,00', 'nf')"/>
              </xsl:if>
            </xsl:for-each>       
          </xsl:variable>        
          <xsl:choose>
            <xsl:when test="$res"><xsl:value-of select="$res"/></xsl:when>
            <xsl:otherwise>&#160;</xsl:otherwise>
          </xsl:choose>
        </td>
      </xsl:for-each>

      <td class="num">
        <xsl:if test="@brutto">
          <xsl:value-of select="format-number(@brutto, '0,00', 'nf')"/>
        </xsl:if>
      </td>
    </tr>
  </xsl:template>


  <xsl:template name="getTotalNetto">
    <xsl:param name="pos" select="1"/>
    <xsl:variable name="src" select="/*/vat_values/item[$pos]"/>
    <xsl:choose>
      <xsl:when test="$src">
        <xsl:variable name="further">
          <xsl:call-template name="getTotalNetto">
            <xsl:with-param name="pos" select="$pos + 1"/>
          </xsl:call-template>
        </xsl:variable>
        <xsl:value-of select="$further + round(sum(/*/order/item[@VAT=$src/@val]/@Netto) * 100) * 0.01"/>
      </xsl:when>
      <xsl:otherwise>0</xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  
   <xsl:template name="getTotalMWSt">
    <xsl:param name="pos" select="1"/>
    <xsl:variable name="src" select="/*/vat_values/item[$pos]"/>
    <xsl:choose>
      <xsl:when test="$src">
        <xsl:variable name="further">
          <xsl:call-template name="getTotalMWSt">
            <xsl:with-param name="pos" select="$pos + 1"/>
          </xsl:call-template>
        </xsl:variable>
        <xsl:value-of select="$further + round(sum(/*/order/item[@VAT=$src/@val]/@Netto) * $src/@val) * 0.01"/>
      </xsl:when>
      <xsl:otherwise>0</xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  
</xsl:stylesheet>
