<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:decimal-format name="nf" decimal-separator="," grouping-separator="." /> 

  <xsl:template match="/">
<!--
    <html>
    <body>
      <link rel="stylesheet" href="css/style.css" type="text/css"/>
-->
      <link rel="stylesheet" href="dtree.css" type="text/css"/>
      <script language="javaScript">
        <xsl:text>function handle(id) { var x = document.getElementById('div_' + id); var y = document.getElementById('img_' + id); </xsl:text>
        <xsl:text>if (x.style.display == "none") {x.style.display = "block"; y.src = y.src.replace("plus", "minus") } </xsl:text>
        <xsl:text>else {x.style.display = "none"; y.src = y.src.replace("minus", "plus") } }</xsl:text>
      </script>
      <div class="dtree">
        <img src="img/base.gif"/>
        <xsl:choose>
          <xsl:when test="/evolution/names/item/@Id > 0">
            <br/>
            <xsl:apply-templates select="/evolution/names/item">
              <xsl:sort select="@OrganizationBonus" data-type="number" order="descending"/>
            </xsl:apply-templates>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>Evolution OV = </xsl:text><xsl:value-of select="format-number(/*/names/item/@OrganizationBonus, '0,000', 'nf')"/>
            <br/>
            <xsl:apply-templates select="/evolution/names/item/item">
              <xsl:sort select="@OrganizationBonus" data-type="number" order="descending"/>
            </xsl:apply-templates>
          </xsl:otherwise>
        </xsl:choose> 
      </div>
<!--
    </body>
    </html>
-->
  </xsl:template>
  
  <xsl:template name="getMoreBefore">
    <xsl:if test="@Id > 0">
      <xsl:for-each select="..">
        <xsl:call-template name="getMoreBefore"/>
      </xsl:for-each>
      <xsl:choose>
        <xsl:when test="following-sibling::*">
          <img src="img/line.gif"/>
        </xsl:when>
        <xsl:otherwise>
          <img src="img/empty.gif"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:if>
  </xsl:template>

  <xsl:template name="getBefore">
    <xsl:for-each select="..">
      <xsl:call-template name="getMoreBefore"/>
    </xsl:for-each>
    <a>
      <xsl:attribute name="href">
        <xsl:text>javascript:handle(</xsl:text><xsl:value-of select="@Id"/><xsl:text>)</xsl:text>
      </xsl:attribute>
      <xsl:choose>
        <xsl:when test="following-sibling::*">
          <img src="img/plus.gif">
            <xsl:attribute name="Id">img_<xsl:value-of select="@Id"/></xsl:attribute>
          </img>
        </xsl:when>
        <xsl:otherwise>
          <img src="img/plusbottom.gif">
            <xsl:attribute name="Id">img_<xsl:value-of select="@Id"/></xsl:attribute>
          </img>
        </xsl:otherwise>
      </xsl:choose>
    </a>
  </xsl:template>

  <xsl:template name="getBefore2">
    <xsl:call-template name="getMoreBefore"/>
    <xsl:choose>
      <xsl:when test="*">
        <img src="img/line.gif"/>
      </xsl:when>
      <xsl:otherwise>
        <img src="img/empty.gif"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template match="item">
    <xsl:variable name="Id" select="@Id"/>
    <xsl:variable name="LevelId" select="@LevelId"/>
    <xsl:variable name="bonus" select="/*/bonus//item[@Id=$Id]"/>
    <xsl:call-template name="getBefore"/><img src="img/folder.gif"/>
    <xsl:variable name="info">
      <xsl:value-of select="@Id"/>&#160;<xsl:value-of select="@Name"/>, &#160;<xsl:value-of select="/*/levels/item[@Id=$LevelId]/@Name"/>
      <xsl:choose>
        <xsl:when test="not(@active='false')">
	      <xsl:text>, &#160;OV = </xsl:text><xsl:value-of select="format-number(@OrganizationBonus, '0,000', 'nf')"/>
	    </xsl:when>
	    <xsl:otherwise>
	      <xsl:text> &#160;(deaktiviert)</xsl:text>
	    </xsl:otherwise>
      </xsl:choose>
	</xsl:variable>
	
    <a>
      <xsl:attribute name="href">javascript:clickhandler(<xsl:value-of select="@Id"/>)</xsl:attribute>
      <xsl:value-of select="$info"/>
    </a>
    <br/>
    <div style="position:block;display:none">
      <xsl:attribute name="id">div_<xsl:value-of select="@Id"/></xsl:attribute>
      <xsl:call-template name="getBefore2"/>&#160;
      <xsl:text>Adresse = </xsl:text>
      <xsl:value-of select="@Country"/><xsl:text>-</xsl:text>
      <xsl:value-of select="@ZipCode"/><xsl:text> </xsl:text>
      <xsl:value-of select="@City"/><xsl:text>, </xsl:text>
      <xsl:value-of select="@Street"/>
      <br/>
      <xsl:call-template name="getBefore2"/>&#160;
      <xsl:text>Telefon = </xsl:text><xsl:value-of select="@Phone"/>
      <br/>
      <xsl:call-template name="getBefore2"/>&#160;
      <xsl:text>E-Mail = </xsl:text><xsl:value-of select="@EMail"/>
      <br/>
      <xsl:call-template name="getBefore2"/>&#160;
      <xsl:text>EV  = </xsl:text><xsl:value-of select="format-number(sum($bonus/@TotalBonus), '0,000', 'nf')"/><xsl:text>, </xsl:text>
      <xsl:text>TV1 = </xsl:text><xsl:value-of select="format-number(sum($bonus/@TotalBonusLevel1), '0,000', 'nf')"/><xsl:text>, </xsl:text>
      <xsl:text>TV2 = </xsl:text><xsl:value-of select="format-number(sum($bonus/@TotalBonusLevel2), '0,000', 'nf')"/><xsl:text>, </xsl:text>
      <xsl:text>TV3 = </xsl:text><xsl:value-of select="format-number(sum($bonus/@TotalBonusLevel3), '0,000', 'nf')"/>
      <br/>
      <xsl:apply-templates select="item">
        <xsl:sort select="@OrganizationBonus" data-type="number" order="descending"/>
      </xsl:apply-templates>
    </div>
  </xsl:template>

</xsl:stylesheet>