<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:output method="html" encoding="ISO-8859-1"/>
  <xsl:decimal-format name="nf" decimal-separator="," grouping-separator="." />

  <xsl:template match="/">
<!-- 
    <html>
    <head>
    <link rel="stylesheet" href="css/style.css" type="text/css"/>
    </head>
    <body>
-->

    <xsl:choose>
      <xsl:when test="/*/detail">
        <xsl:apply-templates select="evolution/names/item"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:apply-templates select="evolution/names//item">
          <xsl:sort select="@Name"/>
        </xsl:apply-templates>
        <table>
	      <col width="590px"/>
	      <col width="100px"/>
	      <tr>
	        <th>Netto gesamt:</th>
	        <td class="num"><xsl:value-of select="format-number(/*/total/@Netto, '0,00', 'nf')"/></td>
	      </tr>
	      <tr>
	        <th>MWSt gesamt:</th>
	        <td class="num"><xsl:value-of select="format-number(/*/total/@VAT, '0,00', 'nf')"/></td>
	      </tr>
	      <tr>
	        <th>Brutto gesamt:</th>
	        <td class="num"><xsl:value-of select="format-number(/*/total/@Netto + /*/total/@VAT, '0,00', 'nf')"/></td>
	      </tr>
	      <tr>
	        <th>Bonusauszahlung in % gemessen am Gesamtbonuswert in diesem Monat:</th>
	        <td class="num"><xsl:value-of select="format-number(/*/total/@Ratio, '0,00', 'nf')"/>&#160;%</td>
	      </tr>
	    </table>
      </xsl:otherwise>
    </xsl:choose>
<!-- 
    </body>
    </html>
-->
  </xsl:template>

  <!-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->

  <xsl:template name="managerbonuslevelbonus">
    <xsl:param name="level"/>
    <xsl:param name="src"/>
    <xsl:param name="active"/>

    <xsl:variable name="children" select="$src//item[@ActiveSponsor=$src/@Id and @LevelId >= 300]"/>
    <xsl:choose>
      <xsl:when test="$level > 1">
        <xsl:variable name="res">
          <total>
            <xsl:choose>
              <xsl:when test="$active > 0">
                <xsl:variable name="children" select="$src//item[@ActiveSponsor=$src/@Id and @LevelId >= 300]"/>
                <xsl:for-each select="$children">
                  <item>
                    <xsl:call-template name="managerbonuslevelbonus">
                      <xsl:with-param name="level" select="$level - 1"/>
                      <xsl:with-param name="src" select="."/>
                      <xsl:with-param name="active" select="$active"/>
                    </xsl:call-template>
                  </item>
                </xsl:for-each>
              </xsl:when>
              <xsl:otherwise>
                <xsl:variable name="children" select="$src/item[@LevelId >= 300]"/>
                <xsl:for-each select="$children">
                  <item>
                    <xsl:call-template name="managerbonuslevelbonus">
                      <xsl:with-param name="level" select="$level - 1"/>
                      <xsl:with-param name="src" select="."/>
                      <xsl:with-param name="active" select="$active"/>
                    </xsl:call-template>
                  </item>
                </xsl:for-each>
              </xsl:otherwise>
            </xsl:choose>
          </total>
        </xsl:variable>
        <xsl:variable name="resnodeset" select="$res"/>
        <xsl:value-of select="sum($resnodeset/total/item)"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:choose>
          <xsl:when test="$active > 0">
            <xsl:variable name="children" select="$src//item[@ActiveSponsor=$src/@Id and @LevelId >= 300]"/>
            <xsl:value-of select="sum($children/@TotalBonus)"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:variable name="children" select="$src/item[@LevelId >= 300]"/>
            <xsl:value-of select="sum($children/@TotalBonus)"/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <!-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->

  <xsl:template name="managerbonuslevel">
    <xsl:param name="level"/>
    <xsl:param name="level2" select="$level"/>
    <xsl:param name="src"/>
    <xsl:param name="active"/>

    <xsl:choose>
      <xsl:when test="$level > 1">
        <xsl:choose>
          <xsl:when test="$active > 0">
            <xsl:variable name="children" select="$src//item[@ActiveSponsor=$src/@Id and @LevelId >= 300]"/>
            <xsl:for-each select="$children">          
              <xsl:call-template name="managerbonuslevel">
                <xsl:with-param name="level" select="$level - 1"/>
                <xsl:with-param name="level2" select="$level2"/>
                <xsl:with-param name="src" select="."/>
                <xsl:with-param name="active" select="$active"/>
              </xsl:call-template>
            </xsl:for-each>
          </xsl:when>
          <xsl:otherwise>
            <xsl:variable name="children" select="$src/item[@LevelId >= 300]"/>
            <xsl:for-each select="$children">          
              <xsl:call-template name="managerbonuslevel">
                <xsl:with-param name="level" select="$level - 1"/>
                <xsl:with-param name="level2" select="$level2"/>
                <xsl:with-param name="src" select="."/>
                <xsl:with-param name="active" select="$active"/>
              </xsl:call-template>
            </xsl:for-each>
          </xsl:otherwise>
        </xsl:choose>  
      </xsl:when>
      <xsl:otherwise>
        <xsl:choose>
          <xsl:when test="$active > 0">
            <xsl:variable name="children" select="$src//item[@ActiveSponsor=$src/@Id and @LevelId >= 300]"/>
            <xsl:for-each select="$children">
              <xsl:variable name="src" select="."/>
              <xsl:if test="@TotalNetto > 0">
                <tr>
                  <xsl:variable name="LevelName" select="/*/levels/item[@Id=$src/@LevelId]/@Name"/>
                  <xsl:variable name="Name" select="/*/names//item[@Id=$src/@Id]/@Name"/>
                  <td><xsl:value-of select="$src/@Id"/>&#160;<xsl:value-of select="$Name"/></td>
                  <td><xsl:value-of select="$LevelName"/>&#160;</td>
                  <td class="num">&#160;</td>
                  <td class="num"><xsl:value-of select="format-number($src/@TotalBonus, '0,00', 'nf')"/></td>
                  <td class="num">&#160;</td>
                </tr>
              </xsl:if>
            </xsl:for-each>
          </xsl:when>
          <xsl:otherwise>
            <xsl:variable name="children" select="$src/item[@LevelId >= 300]"/>
            <xsl:for-each select="$children">
              <xsl:variable name="src" select="."/>
              <xsl:if test="@TotalNetto > 0">
                <tr>
                  <xsl:variable name="LevelName" select="/*/levels/item[@Id=$src/@LevelId]/@Name"/>
                  <xsl:variable name="Name" select="/*/names//item[@Id=$src/@Id]/@Name"/>
                  <td><xsl:value-of select="$src/@Id"/>&#160;<xsl:value-of select="$Name"/></td>
                  <td><xsl:value-of select="$LevelName"/>&#160;</td>
                  <td class="num">&#160;</td>
                  <td class="num"><xsl:value-of select="format-number($src/@TotalBonus, '0,00', 'nf')"/></td>
                  <td class="num">&#160;</td>
                </tr>
              </xsl:if>
            </xsl:for-each>
          </xsl:otherwise>
        </xsl:choose>  
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <!-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->

  <xsl:template name="managerbonusleveltotal">
    <xsl:param name="level"/>
    <xsl:param name="src"/>
    <xsl:param name="active"/>
    
    <xsl:variable name="totalBonus">
      <xsl:call-template name="managerbonuslevelbonus">
        <xsl:with-param name="level" select="$level"/>
        <xsl:with-param name="src" select="$src"/>
        <xsl:with-param name="active" select="$active"/>
      </xsl:call-template>
    </xsl:variable>
    
    <tr class="highline">
      <td>Total <xsl:value-of select="$level"/>. Ebene</td>
      <td>&#160;</td>
      <td class="num">&#160;</td>
      <td class="num"><xsl:value-of select="format-number($totalBonus, '0,00', 'nf')"/></td>
      <td class="num">&#160;</td>
    </tr>
  </xsl:template>

  <!-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->

  <xsl:template name="managerbonuslevelsummary">
    <xsl:param name="level"/>
    <xsl:param name="value"/>
    <xsl:param name="src"/>
    <xsl:param name="active"/>

    <xsl:variable name="bonus">
      <xsl:call-template name="managerbonuslevelbonus">
        <xsl:with-param name="level" select="$level"/>
        <xsl:with-param name="src" select="$src"/>
        <xsl:with-param name="active" select="$active"/>
      </xsl:call-template>
    </xsl:variable>

    <xsl:variable name="factor">
      <xsl:choose>
        <xsl:when test="$bonus=0">0</xsl:when>
        <xsl:otherwise><xsl:value-of select="($value * 100) div $bonus"/></xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <tr>
      <td>Teambonus <xsl:value-of select="$level"/>. Ebene</td>
      <td><xsl:if test="$factor = 0 and $bonus > 0"><xsl:text>Qualifikation nicht erreicht</xsl:text></xsl:if></td>
      <td class="num"><xsl:value-of select="format-number($bonus, '0,00', 'nf')"/></td>
      <td class="num"><xsl:value-of select="format-number($factor, '0,0', 'nf')"/>&#160;%</td>
      <td class="num"><xsl:value-of select="format-number($value, '0,00', 'nf')"/></td>
    </tr>
  </xsl:template>

  <!-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->

  <xsl:template name="moredetails">
    <xsl:param name="src"/>
    <xsl:variable name="Id" select="$src/@Id"/>
    <xsl:variable name="LevelId" select="@Id"/>
    <xsl:variable name="levelsrc" select="/*/levels/item[@Id=$LevelId]"/>
    
    <!-- personal -->
    <xsl:variable name="namesrc" select="/*/names//item[@Id=$Id]"/>

    <tr class="highline">
      <td><xsl:value-of select="$Id"/>&#160;<xsl:value-of select="$namesrc/@Name"/></td>
      <td><xsl:value-of select="$levelsrc/@Name"/></td>
      <td class="num">&#160;</td>
      <td class="num"><xsl:value-of select="format-number($src/@PersonalBonus, '0,00', 'nf')"/></td>
      <td class="num"><xsl:value-of select="format-number($src/@PersonalTradeMargin, '0,00', 'nf')"/></td>
    </tr>

    <!-- level 1 downline -->

    <xsl:for-each select="/*/levels/item[@Id &lt; 300]">
      <xsl:variable name="Level" select="@Id"/>
      <xsl:variable name="LevelName" select="@Name"/>
      <xsl:variable name="TBF" select="1"/>
      <xsl:variable name="bonussrc" select="$src/item[@LevelId=$Level and @PersonalBonus > 0]"/>
      <xsl:for-each select="$namesrc/item">
        <xsl:variable name="Id2" select="@Id"/>
        <xsl:variable name="childsrc" select="$bonussrc[@Id = $Id2]"/>
        <xsl:if test="$childsrc">
          <tr>
            <td><xsl:value-of select="@Id"/>&#160;<xsl:value-of select="@Name"/></td>
            <td><xsl:value-of select="$LevelName"/></td>
            <td class="num">&#160;</td>
            <td class="num"><xsl:value-of select="format-number($childsrc/@PersonalBonus,'0,00', 'nf')"/></td>
            <td class="num">
              <xsl:choose>
                <xsl:when test="$TBF > 0"><xsl:value-of select="format-number($childsrc/@PersonalTradeMargin,'0,00', 'nf')"/></xsl:when>
                <xsl:otherwise>&#160;</xsl:otherwise>
              </xsl:choose>
            </td>
          </tr>
        </xsl:if>
      </xsl:for-each>
        <xsl:if test="count($bonussrc)">
          <tr class="highline">
            <td><xsl:text>Total</xsl:text>&#160;<xsl:value-of select="$LevelName"/></td>
            <td>&#160;</td>
            <td class="num">&#160;</td>
            <td class="num"><xsl:value-of select="format-number(sum($bonussrc/@PersonalBonus), '0,00', 'nf')"/></td>
            <td class="num">
            <xsl:choose>
              <xsl:when test="$TBF > 0">
                <xsl:value-of select="format-number(sum($bonussrc/@PersonalTradeMargin), '0,00', 'nf')"/>
              </xsl:when>
              <xsl:otherwise>&#160;</xsl:otherwise>
            </xsl:choose>
          </td>
        </tr>
      </xsl:if>
    </xsl:for-each>

    <!-- manager downline -->
    <xsl:variable name="active"><xsl:value-of select="sum($src/@TotalNetto) - sum($src/@tbq - 250)"/></xsl:variable>

    <xsl:call-template name="managerbonuslevel">
      <xsl:with-param name="src" select="$src"/><xsl:with-param name="level" select="1"/><xsl:with-param name="active" select="$active"/>
    </xsl:call-template>
    <xsl:call-template name="managerbonusleveltotal">
      <xsl:with-param name="src" select="$src"/><xsl:with-param name="level" select="1"/><xsl:with-param name="active" select="$active"/>
    </xsl:call-template>
    <xsl:call-template name="managerbonuslevel">
      <xsl:with-param name="src" select="$src"/><xsl:with-param name="level" select="2"/><xsl:with-param name="active" select="$active"/>
    </xsl:call-template>
    <xsl:call-template name="managerbonusleveltotal">
      <xsl:with-param name="src" select="$src"/><xsl:with-param name="level" select="2"/><xsl:with-param name="active" select="$active"/>
    </xsl:call-template>
    <xsl:call-template name="managerbonuslevel">
      <xsl:with-param name="src" select="$src"/><xsl:with-param name="level" select="3"/><xsl:with-param name="active" select="$active"/>
    </xsl:call-template>
    <xsl:call-template name="managerbonusleveltotal">
      <xsl:with-param name="src" select="$src"/><xsl:with-param name="level" select="3"/><xsl:with-param name="active" select="$active"/>
    </xsl:call-template>

    <!-- summary -->

    <tr>
      <td colspan="2">&#160;</td>
      <th class="num">Bonuswert</th>
      <th class="num">%</th>
      <th class="num">Bonus</th>
    </tr>

    <!-- personal -->

    <tr>
      <xsl:variable name="value"><xsl:value-of select="sum($src/@DistributorBonus)"/></xsl:variable>
      <xsl:variable name="bonus"><xsl:value-of select="sum($src/@TotalBonus)"/></xsl:variable>
      <xsl:variable name="factor">
        <xsl:choose>
          <xsl:when test="$bonus=0">0</xsl:when>
          <xsl:otherwise><xsl:value-of select="($value * 100) div $bonus"/></xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <td>EV</td>
      <td>&#160;</td>
      <td class="num"><xsl:value-of select="format-number($bonus, '0,00', 'nf')"/></td>
      <td class="num"><xsl:value-of select="format-number($factor, '0,0', 'nf')"/>&#160;%</td>
      <td class="num"><xsl:value-of select="format-number($value, '0,00', 'nf')"/></td>
    </tr>

    <xsl:call-template name="managerbonuslevelsummary">
      <xsl:with-param name="src" select="$src"/>
      <xsl:with-param name="level" select="1"/>
      <xsl:with-param name="value" select="sum($src/@TeamBonusLevel1)"/>
      <xsl:with-param name="active" select="$active"/>
    </xsl:call-template>
    <xsl:call-template name="managerbonuslevelsummary">
      <xsl:with-param name="src" select="$src"/>
      <xsl:with-param name="level" select="2"/>
      <xsl:with-param name="value" select="sum($src/@TeamBonusLevel2)"/>
      <xsl:with-param name="active" select="$active"/>
    </xsl:call-template>
    <xsl:call-template name="managerbonuslevelsummary">
      <xsl:with-param name="src" select="$src"/>
      <xsl:with-param name="level" select="3"/>
      <xsl:with-param name="value" select="sum($src/@TeamBonusLevel3)"/>
      <xsl:with-param name="active" select="$active"/>
    </xsl:call-template>

    <!-- trade margin -->
    <tr>
      <td>Handelsspanne</td>
      <td>&#160;</td>
      <td class="num">&#160;</td>
      <td class="num">&#160;</td>
      <td class="num"><xsl:value-of select="format-number(sum($src/@TotalTradeMargin), '0,00', 'nf')"/></td>
    </tr>
    
  </xsl:template>

  <!-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->

  <xsl:template name="details">
    <xsl:variable name="Id" select="@Id"/>
    <xsl:variable name="src" select="/*/bonus//item[@Id=$Id]"/>
    <xsl:if test="$src">
        <xsl:variable name="MVF">1</xsl:variable>
 
        <tr><td colspan="5">&#160;</td></tr>
        <tr>
          <td colspan="5">
            <table>
              <col width="390"/>
              <col span="4" width="75"/>
              <tr>
                <th>&#160;</th>
                <th class="centered">EV</th>
                <th class="centered">TV1</th>
                <th class="centered">TV2</th>
                <th class="centered">TV3</th>
              </tr>
              <tr class="highline">
                <td>&#160;</td>
                <td class="num"><xsl:value-of select="format-number(sum($src/@TotalBonus) * $MVF, '0,00', 'nf')"/></td>
                <td class="num"><xsl:value-of select="format-number(sum($src/@TotalBonusLevel1) * $MVF, '0,00', 'nf')"/></td>
                <td class="num"><xsl:value-of select="format-number(sum($src/@TotalBonusLevel2) * $MVF, '0,00', 'nf')"/></td>
                <td class="num"><xsl:value-of select="format-number(sum($src/@TotalBonusLevel3) * $MVF, '0,00', 'nf')"/></td>
              </tr>
            </table>
          </td>
        </tr>
        <tr><td colspan="5">&#160;</td></tr>
        <tr>
          <td colspan="3">&#160;</td>
          <th class="num">Bonuswert</th>
          <th class="num">Handelsspanne</th>
        </tr>
        <xsl:call-template name="moredetails">
          <xsl:with-param name="src" select="$src"/>
        </xsl:call-template>
    </xsl:if>
  </xsl:template>

  <!-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->

  <xsl:template match="item">
    <xsl:variable name="Id" select="@Id"/>
    <xsl:variable name="bonus" select="/*/bonus//item[@Id = $Id]"/>
    <xsl:if test="$bonus and $Id > 0 and $bonus/@TotalBonus + $bonus/@TotalBonusLevel1 + $bonus/@TotalBonusLevel2 + $bonus/@TotalBonusLevel3 > 0 ">
    <table>
      <col width="250px"/>
      <col width="180px"/>
      <col width="80px"/>
      <col width="80px"/>
      <col width="100px"/>

      <tr class="header">
        <th colspan="4">
          <xsl:value-of select="@Id"/>&#160;<xsl:value-of select="@L"/>
          <xsl:text> </xsl:text><xsl:value-of select="@T"/><xsl:value-of select="@Name"/>
          <xsl:value-of select="@Address"/>
        </th>
        <th>
          <xsl:text>&#160;</xsl:text>
	      <xsl:if test="/*/print_enabled">
            <input type="button" value="Drucken">
              <xsl:attribute name="onclick">
                <xsl:text>generatePDF('</xsl:text>
                <xsl:value-of select="$Id"/>
                <xsl:text>')</xsl:text>
              </xsl:attribute>
            </input>
          </xsl:if>
        </th>
      </tr>
      <xsl:call-template name="details"/>

      <xsl:variable name="MWSt" select="sum(@MWSt)"/>

      <xsl:variable name="src" select="/*/bonus//item[@Id=$Id]"/>
      
      <xsl:variable name="DB" select="sum($src/@DistributorBonus)"/>
      <xsl:variable name="TB" select="sum($src/@TotalTradeMargin)"/>
      
      <xsl:variable name="MB1" select="sum($src/@TeamBonusLevel1)"/>
      <xsl:variable name="MB2" select="sum($src/@TeamBonusLevel2)"/>
      <xsl:variable name="MB3" select="sum($src/@TeamBonusLevel3)"/>
      <xsl:variable name="MB" select="$MB1 + $MB2 + $MB3"/>
      
      <xsl:variable name="aDB">0<xsl:if test="$DB > 0"><xsl:value-of select="$DB"/></xsl:if></xsl:variable>
      <xsl:variable name="aMB">0<xsl:if test="$MB > 0"><xsl:value-of select="$MB"/></xsl:if></xsl:variable>
      <xsl:variable name="aTB">0<xsl:if test="$TB > 0"><xsl:value-of select="$TB"/></xsl:if></xsl:variable>

      <xsl:variable name="abonus" select="$aDB + $aMB + $aTB"/>
      <xsl:variable name="bonus">
        <xsl:choose>
          <xsl:when test="$abonus > 0"><xsl:value-of select="$abonus"/></xsl:when>
          <xsl:otherwise>0</xsl:otherwise>
        </xsl:choose>
      </xsl:variable>

      <tr>
        <th>Bonus</th>
        <td colspan="3">
          <xsl:text>&#160;</xsl:text>
          <xsl:if test="$DB &lt; 0"><xsl:text>Qualifikation nicht erreicht</xsl:text></xsl:if>
       </td>
       <td class="num"><xsl:value-of select="format-number(translate($DB,'-',0), '0,00', 'nf')"/></td>
      </tr>
      <tr>
        <th>Teambonus</th>
        <td colspan="3">
          <xsl:text>&#160;</xsl:text>
          <xsl:if test="$MB &lt; 0"><xsl:text>Qualifikation nicht erreicht</xsl:text></xsl:if>
        </td>
        <td class="num"><xsl:value-of select="format-number(translate($MB,'-',0), '0,00', 'nf')"/></td>
      </tr>
      <tr>
        <th>Handelsspanne</th>
        <td colspan="3">
        <xsl:text>&#160;</xsl:text>
          <xsl:if test="$TB &lt; 0"><xsl:text>Qualifikation nicht erreicht</xsl:text></xsl:if>
        </td>
        <td class="num"><xsl:value-of select="format-number(translate($TB,'-',0), '0,00', 'nf')"/></td>
      </tr>
      <tr>
        <td colspan="5">&#160;</td>
      </tr>

      <tr>
        <th colspan="4">Total Bonus</th>
        <td class="num"><xsl:value-of select="format-number(round($bonus * 100) * .01, '0,00', 'nf')"/></td>
      </tr>
      <xsl:choose>
        <xsl:when test="substring(@Id, 1, 2) = '43'">
          <tr>
            <th colspan="4">MwSt&#160;<xsl:value-of select="$MWSt"/>&#160;%</th>
            <td class="num"><xsl:value-of select="format-number(round($bonus * $MWSt) * 0.01, '0,00', 'nf')"/></td>
	      </tr>
	      <tr>
	       <th colspan="4">berweisungsbetrag</th>
	       <td class="num"><xsl:value-of select="format-number((round($bonus * 100) + round($bonus * $MWSt)) * 0.01, '0,00', 'nf')"/></td>
	      </tr>
	    </xsl:when>
	    <xsl:otherwise>
         <xsl:if test="string-length(@VatID) &gt; 5 and not(substring(@Id, 1, 2) = '41')">
             <tr>
              <td colspan="5">Die Steuerschuld geht ber auf Empfnger.</td>
	        </tr>
	      </xsl:if>
	    </xsl:otherwise>
	  </xsl:choose>
    </table><br/>
    <br/>
    </xsl:if>
  </xsl:template>

  <!-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->

</xsl:stylesheet>
