<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
  <xsl:decimal-format name="nf" decimal-separator="," grouping-separator="." />
 
  <xsl:template match="/">
    <fo:root>
      <fo:layout-master-set>

        <fo:simple-page-master master-name="portrait"
                  page-height="29.7cm" 
                  page-width="21cm"
                  margin-top="25mm" 
                  margin-bottom="25mm" 
                  margin-left="20mm" 
                  margin-right="20mm">
           <fo:region-body margin-top="3cm" margin-left="1.5cm"/>
           <fo:region-before extent="3cm"/>
         </fo:simple-page-master>
       </fo:layout-master-set>

       <fo:page-sequence master-reference="portrait">
          <fo:static-content flow-name="xsl-region-before">
            <fo:block font-size="12pt" line-height="14pt" font-family="Times">
              <fo:table table-layout="fixed">
                <fo:table-column column-width="80mm"/>
                <fo:table-column column-width="85mm"/>
                <fo:table-body>
                  <fo:table-row>
                    <fo:table-cell>
                      <fo:block font-weight="bold">Evolution Handelsgmbh</fo:block>
                      <fo:block>
                        <xsl:text>Downline Artikel </xsl:text>
                        <xsl:value-of select="/*/info/item[@name='from']/@val"/>- <xsl:value-of select="/*/info/item[@name='to']/@val"/>
                      </fo:block>
                      <fo:block>
                        <xsl:text>Downline: </xsl:text>
                        <xsl:value-of select="/*/info/item[@name='did']/@val"/>
                      </fo:block>
                      <xsl:if test="/*/info/item[@name='art_ids']">
                        <fo:block>
                          <xsl:text>Artikel: </xsl:text>
                          <xsl:value-of select="/*/info/item[@name='art_ids']/@val"/>
                        </fo:block>
                      </xsl:if>
                    </fo:table-cell>
                    <fo:table-cell>
                      <fo:block text-align="right">A-9500 Villach, Hausergasse 28</fo:block>
                      <fo:block text-align="right">Tel: (04242)-22560</fo:block>
                      <fo:block text-align="right">Fax: (04242)-22562</fo:block>
                    </fo:table-cell>
                  </fo:table-row>
                </fo:table-body>
              </fo:table>
            </fo:block>
          </fo:static-content>

         <fo:flow flow-name="xsl-region-body">
            <fo:block font-size="10pt" line-height="12pt" font-family="Times">
              <fo:table table-layout="fixed">
                <fo:table-column column-width="80mm"/>
                <fo:table-column column-width="18mm"/>
                <fo:table-column column-width="18mm"/>
                <fo:table-column column-width="18mm"/>
                <fo:table-header>
                  <fo:table-row>
                    <fo:table-cell><fo:block font-weight="bold">Name</fo:block></fo:table-cell>
                    <fo:table-cell><fo:block font-weight="bold" text-align="right">Anzahl</fo:block></fo:table-cell>
                    <fo:table-cell><fo:block font-weight="bold" text-align="right">Punkte</fo:block></fo:table-cell>
                    <fo:table-cell><fo:block font-weight="bold" text-align="right">Bonus</fo:block></fo:table-cell>
                  </fo:table-row>                 
                  <fo:table-row><fo:table-cell number-columns-spanned="4"><fo:block space-before="-7pt"><fo:leader leader-pattern="rule" leader-length="100%"/></fo:block></fo:table-cell></fo:table-row>
                </fo:table-header>
                <fo:table-body>
                  <xsl:apply-templates select="/*/item"/>
                </fo:table-body>
              </fo:table>
            </fo:block>
          </fo:flow>
       </fo:page-sequence>
     </fo:root>
  </xsl:template>

  <xsl:template match="item">
    <fo:table-row>
      <fo:table-cell><fo:block>
	<xsl:for-each select="../ancestor::*">&#160;&#160;&#160;</xsl:for-each>
	<xsl:value-of select="@Id"/>&#160;<xsl:value-of select="@Name"/>
      </fo:block></fo:table-cell>
      <fo:table-cell><fo:block text-align="right"><xsl:value-of select="sum(descendant-or-self::*/@TQuantity)"/></fo:block></fo:table-cell>
      <fo:table-cell><fo:block text-align="right"><xsl:value-of select="format-number(sum(descendant-or-self::*/@TPoints), '0,000', 'nf')"/></fo:block></fo:table-cell>
      <fo:table-cell><fo:block text-align="right"><xsl:value-of select="format-number(sum(descendant-or-self::*/@TBonus), '0,00', 'nf')"/></fo:block></fo:table-cell>
    </fo:table-row>
    <xsl:apply-templates select="item"/>
  </xsl:template>

</xsl:stylesheet>
