<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
  <xsl:decimal-format name="nf" decimal-separator="," grouping-separator="." /> 
  
  <!-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->

  <xsl:variable name="title1"><xsl:value-of select="/names/info/@title1"/></xsl:variable>
  <xsl:variable name="title2"><xsl:value-of select="/names/info/@title2"/></xsl:variable>

  <xsl:template match="/">
    <fo:root>
      <fo:layout-master-set>

      <!-- layout for the first page -->
        <fo:simple-page-master master-name="portrait"
                  page-height="29.7cm" 
                  page-width="21cm"
                  margin-top="-12pt" 
                  margin-bottom="0mm" 
                  margin-left="7mm" 
                  margin-right="0mm">
           <fo:region-body/>
         </fo:simple-page-master>
       </fo:layout-master-set>
       
       <fo:page-sequence master-reference="portrait">
          <fo:flow flow-name="xsl-region-body">
            <fo:block font-size="10pt" line-height="12pt" font-family="Times">
              <fo:table table-layout="fixed">
                <fo:table-column column-width="70mm"/>
                <fo:table-column column-width="70mm"/>
                <fo:table-column column-width="63mm"/>
                <fo:table-body>
                  <xsl:variable name="src" select="/names/item"/>
                  <xsl:call-template name="filltable">
                    <xsl:with-param name="src" select="$src"/>
                  </xsl:call-template>
                </fo:table-body>
              </fo:table>
            </fo:block>
          </fo:flow>
       </fo:page-sequence>
     </fo:root>
  </xsl:template>
   
  <xsl:template name="filltable">
    <xsl:param name="src"/>
    <xsl:param name="pos" select="1"/>
    
    <xsl:if test="$src[$pos]">
      <fo:table-row height="38.0mm">
        <xsl:apply-templates select="$src[$pos]"/>
        <xsl:if test="$src[$pos + 1]">
          <xsl:apply-templates select="$src[$pos + 1]"/>
        </xsl:if>
        <xsl:if test="$src[$pos + 2]">
          <xsl:apply-templates select="$src[$pos + 2]"/>
        </xsl:if>
      </fo:table-row>
      <xsl:if test="$src[$pos + 3]">
        <xsl:call-template name="filltable">
          <xsl:with-param name="src" select="$src"/>
          <xsl:with-param name="pos" select="$pos + 3"/>
        </xsl:call-template>
      </xsl:if>
    </xsl:if>
  </xsl:template>
  
  
  <xsl:template match="item">
    <fo:table-cell display-align="center">
      <fo:block font-size="8pt" line-height="10pt"><xsl:value-of select="$title1"/></fo:block>
      <fo:block font-size="8pt" line-height="10pt"><xsl:value-of select="$title2"/></fo:block>   
      <fo:block space-before="16pt"><xsl:value-of select="@L"/></fo:block>
      <fo:block><xsl:value-of select="concat(@T, @Name)"/> </fo:block>
      <fo:block><xsl:value-of select="@Street"/></fo:block>
      <fo:block><xsl:value-of select="concat(@Country, ' ', @ZipCode, ' ', @City)"/></fo:block>
      <fo:block space-before="6pt"><xsl:value-of select="@EMail"/></fo:block>
    </fo:table-cell>
  </xsl:template>

</xsl:stylesheet>