<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
  <xsl:decimal-format name="nf" decimal-separator="," grouping-separator="." /> 
  
  <!-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->

  <xsl:template match="/">
    <fo:root>
      <fo:layout-master-set>

      <!-- layout for the first page -->
        <fo:simple-page-master master-name="portrait"
                  page-height="29.7cm" 
                  page-width="21cm"
                  margin-top="25mm" 
                  margin-bottom="25mm" 
                  margin-left="25mm" 
                  margin-right="25mm">
           <fo:region-body margin-top="3cm" margin-left="25mm"/>
            <fo:region-before extent="3cm"/>
         </fo:simple-page-master>
       </fo:layout-master-set>
       
       <fo:page-sequence master-reference="portrait">
          <fo:static-content flow-name="xsl-region-before">
            <fo:block font-size="12pt" line-height="14pt" font-family="Times">
              <fo:table table-layout="fixed">
                <fo:table-column column-width="80mm"/>
                <fo:table-column column-width="80mm"/>
                <fo:table-body>
                  <fo:table-row>
                    <fo:table-cell>
                      <fo:block font-weight="bold">Evolution Handelsgmbh</fo:block>
                      <fo:block>
                        <xsl:text>Lieferscheinsummen: </xsl:text>
                        <xsl:value-of select="/*/info/item[@name='from']/@val"/>- <xsl:value-of select="/*/info/item[@name='to']/@val"/>
                      </fo:block>
                      <fo:block>
                        <xsl:text>Downline: </xsl:text>
                        <xsl:value-of select="/*/info/item[@name='did']/@val"/>
                      </fo:block>
                    </fo:table-cell>
                    <fo:table-cell>
                      <fo:block text-align="right">A-9500 Villach, Hausergasse 28</fo:block>
                      <fo:block text-align="right">Tel: (04242)-22560</fo:block>
                      <fo:block text-align="right">Fax: (04242)-22562</fo:block>
                    </fo:table-cell>
                  </fo:table-row>
                </fo:table-body>
              </fo:table>
            </fo:block>
          </fo:static-content>
          <fo:flow flow-name="xsl-region-body">
            <fo:block font-size="10pt" line-height="12pt" font-family="Times">
              <fo:table table-layout="fixed">
                <fo:table-column column-width="15mm"/>
                <fo:table-column column-width="15mm"/>
                <fo:table-column column-width="15mm"/>
                <fo:table-column column-width="15mm"/>
                <fo:table-column column-width="15mm"/>
                <fo:table-column column-width="15mm"/>
                <fo:table-body>
                  <fo:table-row>
                    <fo:table-cell number-columns-spanned="2"><fo:block/></fo:table-cell>
                    <fo:table-cell><fo:block text-align="right" font-weight="bold">Bonus</fo:block></fo:table-cell>
                    <fo:table-cell><fo:block text-align="right" font-weight="bold">Netto</fo:block></fo:table-cell>
                    <fo:table-cell><fo:block text-align="right" font-weight="bold">MWSt</fo:block></fo:table-cell>
                    <fo:table-cell><fo:block text-align="right" font-weight="bold">Brutto</fo:block></fo:table-cell>
                  </fo:table-row>
                  <fo:table-row>
                    <xsl:variable name="src" select="/*/distributor/item"/>
                    <fo:table-cell number-columns-spanned="2"><fo:block font-weight="bold">Gesamtsummen</fo:block></fo:table-cell>
                    <fo:table-cell><fo:block text-align="right"><xsl:value-of select="format-number(sum($src/@Bonus), '0,00', 'nf')"/></fo:block></fo:table-cell>
                    <fo:table-cell><fo:block text-align="right"><xsl:value-of select="format-number(sum($src/@Netto), '0,00', 'nf')"/></fo:block></fo:table-cell>
                    <fo:table-cell><fo:block text-align="right"><xsl:value-of select="format-number(sum($src/@Brutto) - sum($src/@Netto), '0,00', 'nf')"/></fo:block></fo:table-cell>
                    <fo:table-cell><fo:block text-align="right"><xsl:value-of select="format-number(sum($src/@Brutto), '0,00', 'nf')"/></fo:block></fo:table-cell>
                  </fo:table-row>
                  <xsl:apply-templates select="/*/distributor"/>
                </fo:table-body>
              </fo:table>
            </fo:block>
          </fo:flow>
       </fo:page-sequence>
     </fo:root>
  </xsl:template>
  
  <xsl:template match="distributor">
      <fo:table-row><fo:table-cell number-columns-spanned="6"><fo:block space-before="12pt"/></fo:table-cell></fo:table-row>
      <fo:table-row>
        <fo:table-cell number-columns-spanned="2"><fo:block font-weight="bold">Distributor:</fo:block></fo:table-cell>
        <fo:table-cell number-columns-spanned="4"><fo:block><xsl:value-of select="@Did"/>&#160;<xsl:value-of select="@Name"/></fo:block></fo:table-cell>
      </fo:table-row>
      <fo:table-row>
        <fo:table-cell number-columns-spanned="2"><fo:block font-weight="bold">Ort</fo:block></fo:table-cell>
        <fo:table-cell number-columns-spanned="4"><fo:block><xsl:value-of select="@City"/></fo:block></fo:table-cell>
      </fo:table-row>
      <fo:table-row>
        <fo:table-cell><fo:block font-weight="bold">Rech.Nr.</fo:block></fo:table-cell>
        <fo:table-cell><fo:block font-weight="bold">Datum</fo:block></fo:table-cell>
        <fo:table-cell><fo:block text-align="right" font-weight="bold">Bonus</fo:block></fo:table-cell>
        <fo:table-cell><fo:block text-align="right" font-weight="bold">Netto</fo:block></fo:table-cell>
        <fo:table-cell><fo:block text-align="right" font-weight="bold">MWSt</fo:block></fo:table-cell>
        <fo:table-cell><fo:block text-align="right" font-weight="bold">Brutto</fo:block></fo:table-cell>
      </fo:table-row>
      <fo:table-row><fo:table-cell number-columns-spanned="6"><fo:block space-before="-7pt"><fo:leader leader-pattern="rule" leader-length="100%"/></fo:block></fo:table-cell></fo:table-row>
      <xsl:apply-templates select="item"/>
      <fo:table-row><fo:table-cell number-columns-spanned="6"><fo:block space-before="-7pt"><fo:leader leader-pattern="rule" leader-length="100%"/></fo:block></fo:table-cell></fo:table-row>
      <fo:table-row>
        <fo:table-cell number-columns-spanned="2"><fo:block font-weight="bold">Summen:</fo:block></fo:table-cell>
        <fo:table-cell><fo:block text-align="right"><xsl:value-of select="format-number(sum(item/@Bonus), '0,00', 'nf')"/></fo:block></fo:table-cell>
        <fo:table-cell><fo:block text-align="right"><xsl:value-of select="format-number(sum(item/@Netto), '0,00', 'nf')"/></fo:block></fo:table-cell>
        <fo:table-cell><fo:block text-align="right"><xsl:value-of select="format-number(sum(item/@Brutto) - sum(item/@Netto), '0,00', 'nf')"/></fo:block></fo:table-cell>
        <fo:table-cell><fo:block text-align="right"><xsl:value-of select="format-number(sum(item/@Brutto), '0,00', 'nf')"/></fo:block></fo:table-cell>
      </fo:table-row>
  </xsl:template>

  <xsl:template match="item">
    <fo:table-row>
      <fo:table-cell><fo:block><xsl:value-of select="@BillingId"/></fo:block></fo:table-cell>
      <fo:table-cell><fo:block><xsl:value-of select="@BillingDate"/></fo:block></fo:table-cell>
      <fo:table-cell><fo:block text-align="right"><xsl:value-of select="format-number(@Bonus, '0,00', 'nf')"/></fo:block></fo:table-cell>
      <fo:table-cell><fo:block text-align="right"><xsl:value-of select="format-number(@Netto, '0,00', 'nf')"/></fo:block></fo:table-cell>
      <fo:table-cell><fo:block text-align="right"><xsl:value-of select="format-number(@Brutto - @Netto, '0,00', 'nf')"/></fo:block></fo:table-cell>
      <fo:table-cell><fo:block text-align="right"><xsl:value-of select="format-number(@Brutto, '0,00', 'nf')"/></fo:block></fo:table-cell>
    </fo:table-row>
  </xsl:template>

</xsl:stylesheet>