<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
  <xsl:decimal-format name="nf" decimal-separator="," grouping-separator="." />
 
  <xsl:template name="getTotal">
    <xsl:param name="pos" select="1"/>
    <xsl:param name="src"/>
    <xsl:choose>
      <xsl:when test="$src[$pos]">
        <xsl:variable name="further">
          <xsl:call-template name="getTotal">
            <xsl:with-param name="pos" select="$pos + 1"/>
            <xsl:with-param name="src" select="$src"/>
          </xsl:call-template>
        </xsl:variable>
        <xsl:variable name="current" select="$src[$pos]"/>
        <xsl:value-of select="$further + $current/@Quantity * $current/@Price"/>
      </xsl:when>
      <xsl:otherwise>0</xsl:otherwise>
    </xsl:choose>
  </xsl:template>  
 
  <xsl:template match="/">
    <fo:root>
      <fo:layout-master-set>

        <fo:simple-page-master master-name="portrait"
                  page-height="29.7cm" 
                  page-width="21cm"
                  margin-top="25mm" 
                  margin-bottom="25mm" 
                  margin-left="20mm" 
                  margin-right="20mm">
           <fo:region-body margin-top="3cm" margin-left="5mm"/>
           <fo:region-before extent="3cm"/>
         </fo:simple-page-master>
       </fo:layout-master-set>

       <fo:page-sequence master-reference="portrait">
          <fo:static-content flow-name="xsl-region-before">
            <fo:block font-size="12pt" line-height="14pt" font-family="Times">
              <fo:table table-layout="fixed">
                <fo:table-column column-width="80mm"/>
                <fo:table-column column-width="85mm"/>
                <fo:table-body>
                  <fo:table-row>
                    <fo:table-cell>
                      <fo:block font-weight="bold">Evolution Handelsgmbh</fo:block>
                      <fo:block>
                        <xsl:text>Artikel Ranking EK: </xsl:text>
                        <xsl:value-of select="/*/info/item[@name='from']/@val"/>- <xsl:value-of select="/*/info/item[@name='to']/@val"/>
                      </fo:block>
                      <fo:block>
                        <xsl:text>Downline: </xsl:text>
                        <xsl:value-of select="/*/info/item[@name='downline']/@val"/>
                      </fo:block>
                    </fo:table-cell>
                    <fo:table-cell>
                      <fo:block text-align="right">A-9500 Villach, Hausergasse 28</fo:block>
                      <fo:block text-align="right">Tel: (04242)-22560</fo:block>
                      <fo:block text-align="right">Fax: (04242)-22562</fo:block>
                    </fo:table-cell>
                  </fo:table-row>
                </fo:table-body>
              </fo:table>
            </fo:block>
          </fo:static-content>

         <fo:flow flow-name="xsl-region-body">
            <fo:block font-size="10pt" line-height="12pt" font-family="Times">
              <fo:table table-layout="fixed">
                <fo:table-column column-width="10mm"/>
                <fo:table-column column-width="20mm"/>
                <fo:table-column column-width="75mm"/>
                <fo:table-column column-width="15mm"/>
                <fo:table-column column-width="15mm"/>
                <fo:table-column column-width="20mm"/>
                <fo:table-header>
                  <fo:table-row>
                    <fo:table-cell number-columns-spanned="4"><fo:block font-weight="bold"></fo:block></fo:table-cell>
                    <fo:table-cell><fo:block font-weight="bold" text-align="right">Stck</fo:block></fo:table-cell>
                    <fo:table-cell><fo:block font-weight="bold" text-align="right">EK Gesamt</fo:block></fo:table-cell>
                  </fo:table-row>                 
                  <fo:table-row>
                    <fo:table-cell number-columns-spanned="4"><fo:block font-weight="bold" text-align="right">Total</fo:block></fo:table-cell>
                    <fo:table-cell><fo:block font-weight="bold" text-align="right"><xsl:value-of select="sum(/*/item/@Quantity)"/></fo:block></fo:table-cell>
                    <xsl:variable name="val">
                       <xsl:call-template name="getTotal"><xsl:with-param name="src" select="/*/item"/></xsl:call-template>
                    </xsl:variable>
                    <fo:table-cell><fo:block font-weight="bold" text-align="right"><xsl:value-of select="format-number($val, '0,00', 'nf')"/></fo:block></fo:table-cell>
                  </fo:table-row>
                </fo:table-header>
                <fo:table-body>
                </fo:table-body>
              </fo:table>

              <fo:table table-layout="fixed" space-before="12pt">
                <fo:table-column column-width="10mm"/>
                <fo:table-column column-width="20mm"/>
                <fo:table-column column-width="75mm"/>
                <fo:table-column column-width="15mm"/>
                <fo:table-column column-width="15mm"/>
                <fo:table-column column-width="20mm"/>
                <fo:table-header>
                  <fo:table-row>
                    <fo:table-cell><fo:block font-weight="bold"></fo:block></fo:table-cell>
                    <fo:table-cell><fo:block font-weight="bold">ArtNr.</fo:block></fo:table-cell>
                    <fo:table-cell><fo:block font-weight="bold">Bezeichnung</fo:block></fo:table-cell>
                    <fo:table-cell><fo:block font-weight="bold" text-align="right">Einkaufspreis</fo:block></fo:table-cell>
                    <fo:table-cell><fo:block font-weight="bold" text-align="right">Stck</fo:block></fo:table-cell>
                    <fo:table-cell><fo:block font-weight="bold" text-align="right">EK Gesamt</fo:block></fo:table-cell>
                  </fo:table-row>                 
                  <fo:table-row><fo:table-cell number-columns-spanned="6"><fo:block space-before="-7pt"><fo:leader leader-pattern="rule" leader-length="100%"/></fo:block></fo:table-cell></fo:table-row>
                </fo:table-header>
                <fo:table-body>
                  <xsl:apply-templates select="/*/item"/>
                </fo:table-body>
              </fo:table>
            </fo:block>
          </fo:flow>
       </fo:page-sequence>
     </fo:root>
  </xsl:template>

  <xsl:template match="item">
    <fo:table-row>
      <fo:table-cell><fo:block><xsl:value-of select="position()"/></fo:block></fo:table-cell>
      <fo:table-cell><fo:block><xsl:value-of select="@Id"/></fo:block></fo:table-cell>
      <fo:table-cell><fo:block><xsl:value-of select="@Name"/></fo:block></fo:table-cell>
      <fo:table-cell><fo:block text-align="right"><xsl:value-of select="format-number(@Price, '0,00', 'nf')"/></fo:block></fo:table-cell>
      <fo:table-cell><fo:block text-align="right"><xsl:value-of select="@Quantity"/></fo:block></fo:table-cell>
      <fo:table-cell><fo:block text-align="right"><xsl:value-of select="format-number(@Quantity * @Price, '0,00', 'nf')"/></fo:block></fo:table-cell>
    </fo:table-row>
    <xsl:apply-templates select="item"/>
  </xsl:template>
</xsl:stylesheet>
