<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
  <xsl:decimal-format name="nf" decimal-separator="," grouping-separator="." />
 
  <xsl:template match="/">
    <fo:root>
      <fo:layout-master-set>

        <fo:simple-page-master master-name="portrait"
                  page-height="29.7cm" 
                  page-width="21cm"
                  margin-top="25mm" 
                  margin-bottom="25mm" 
                  margin-left="20mm" 
                  margin-right="20mm">
           <fo:region-body margin-top="3cm" margin-left="5mm"/>
           <fo:region-before extent="3cm"/>
         </fo:simple-page-master>
       </fo:layout-master-set>

       <fo:page-sequence master-reference="portrait">
          <fo:static-content flow-name="xsl-region-before">
            <fo:block font-size="12pt" line-height="14pt" font-family="Times">
              <fo:table table-layout="fixed">
                <fo:table-column column-width="90mm"/>
                <fo:table-column column-width="75mm"/>
                <fo:table-body>
                  <fo:table-row>
                    <fo:table-cell>
                      <fo:block font-weight="bold">Evolution Handelsgmbh</fo:block>
                      <fo:block space-before="14pt">
                        <xsl:text>Distributoren Ranking </xsl:text>
                        <xsl:value-of select="/*/info/item[@name='from']/@val"/>- <xsl:value-of select="/*/info/item[@name='to']/@val"/>
                      </fo:block>
                      <fo:block>
                          <xsl:text>Beraterart: </xsl:text>
                          <xsl:value-of select="/*/info/item[@name='roles']/@val"/>
                      </fo:block>
                    </fo:table-cell>
                    <fo:table-cell>
                      <fo:block text-align="right">A-9500 Villach, Hausergasse 28</fo:block>
                      <fo:block text-align="right">Tel: (04242)-22560</fo:block>
                      <fo:block text-align="right">Fax: (04242)-22562</fo:block>
                    </fo:table-cell>
                  </fo:table-row>
                </fo:table-body>
              </fo:table>
            </fo:block>
          </fo:static-content>

         <fo:flow flow-name="xsl-region-body">
            <fo:block font-size="10pt" line-height="12pt" font-family="Times">
              <fo:table table-layout="fixed">
                <fo:table-column column-width="18mm"/>
                <fo:table-column column-width="50mm"/>
                <fo:table-column column-width="18mm"/>
                <fo:table-column column-width="18mm"/>
                <fo:table-column column-width="18mm"/>
                <fo:table-column column-width="18mm"/>
                <fo:table-column column-width="18mm"/>
                <!--<fo:table-header>
                </fo:table-header>-->
                <fo:table-body>
                  <fo:table-row>
                    <fo:table-cell number-columns-spanned="2"><fo:block/></fo:table-cell>
                    <fo:table-cell><fo:block text-align="right" font-weight="bold">PV</fo:block></fo:table-cell>
                    <fo:table-cell><fo:block text-align="right" font-weight="bold">EV</fo:block></fo:table-cell>
                    <fo:table-cell><fo:block text-align="right" font-weight="bold">PEV</fo:block></fo:table-cell>
                    <fo:table-cell><fo:block text-align="right" font-weight="bold"></fo:block></fo:table-cell>
                    <fo:table-cell><fo:block text-align="right" font-weight="bold"></fo:block></fo:table-cell>
                  </fo:table-row> 
                  <fo:table-row>
                    <fo:table-cell number-columns-spanned="1"><fo:block/></fo:table-cell>
                    <fo:table-cell><fo:block font-weight="bold" text-align="right">Summen</fo:block></fo:table-cell>
                    <fo:table-cell><fo:block text-align="right"><xsl:value-of select="format-number(sum(/*/*/*/@PV), '0,00', 'nf')"/></fo:block></fo:table-cell>
                    <fo:table-cell><fo:block text-align="right"><xsl:value-of select="format-number(sum(/*/*/*/@EV), '0,00', 'nf')"/></fo:block></fo:table-cell>
                    <fo:table-cell><fo:block text-align="right"><xsl:value-of select="format-number(sum(/*/*/*/@PEV), '0,00', 'nf')"/></fo:block></fo:table-cell>
                    <fo:table-cell><fo:block text-align="right"></fo:block></fo:table-cell>
                    <fo:table-cell><fo:block text-align="right"></fo:block></fo:table-cell>
                  </fo:table-row>
                  <fo:table-row>
                    <fo:table-cell><fo:block font-weight="bold">Id</fo:block></fo:table-cell>
                    <fo:table-cell><fo:block font-weight="bold">Name</fo:block></fo:table-cell>
                    <fo:table-cell><fo:block font-weight="bold" text-align="right">PV</fo:block></fo:table-cell>
                    <fo:table-cell><fo:block font-weight="bold" text-align="right">EV</fo:block></fo:table-cell>
                    <fo:table-cell><fo:block font-weight="bold" text-align="right">PEV</fo:block></fo:table-cell>
                    <fo:table-cell><fo:block font-weight="bold" text-align="right">TV</fo:block></fo:table-cell>
                    <fo:table-cell><fo:block font-weight="bold" text-align="right">OV</fo:block></fo:table-cell>
                  </fo:table-row>                 
                  <fo:table-row><fo:table-cell number-columns-spanned="7"><fo:block space-before="-7pt"><fo:leader leader-pattern="rule" leader-length="100%"/></fo:block></fo:table-cell></fo:table-row>
                  <xsl:choose>
                    <xsl:when test="/*/orderby/@val = 'PV'">
                      <xsl:apply-templates select="/*/items/item"><xsl:sort select="@PV" order="descending" data-type="number"/></xsl:apply-templates>
                    </xsl:when>
                    <xsl:when test="/*/orderby/@val = 'EV'">
                      <xsl:apply-templates select="/*/items/item"><xsl:sort select="@EV" order="descending" data-type="number"/></xsl:apply-templates>
                    </xsl:when>
                    <xsl:when test="/*/orderby/@val = 'PEV'">
                      <xsl:apply-templates select="/*/items/item"><xsl:sort select="@PEV" order="descending" data-type="number"/></xsl:apply-templates>
                    </xsl:when>
                    <xsl:when test="/*/orderby/@val = 'TV'">
                      <xsl:apply-templates select="/*/items/item"><xsl:sort select="@TV" order="descending" data-type="number"/></xsl:apply-templates>
                    </xsl:when>
                    <xsl:when test="/*/orderby/@val = 'OV'">
                      <xsl:apply-templates select="/*/items/item"><xsl:sort select="@OV" order="descending" data-type="number"/></xsl:apply-templates>
                    </xsl:when>
                  </xsl:choose>
                </fo:table-body>
              </fo:table>
            </fo:block>
          </fo:flow>
       </fo:page-sequence>
     </fo:root>
  </xsl:template>

  <xsl:template match="item">
    <fo:table-row>
      <fo:table-cell><fo:block><xsl:value-of select="@Id"/></fo:block></fo:table-cell>
      <fo:table-cell><fo:block><xsl:value-of select="@Name"/></fo:block></fo:table-cell>
      <fo:table-cell><fo:block text-align="right"><xsl:value-of select="format-number(@PV, '0,000', 'nf')"/></fo:block></fo:table-cell>
      <fo:table-cell><fo:block text-align="right"><xsl:value-of select="format-number(@EV, '0,000', 'nf')"/></fo:block></fo:table-cell>
      <fo:table-cell><fo:block text-align="right"><xsl:value-of select="format-number(@PEV, '0,000', 'nf')"/></fo:block></fo:table-cell>
      <fo:table-cell><fo:block text-align="right"><xsl:value-of select="format-number(@TV, '0,000', 'nf')"/></fo:block></fo:table-cell>
      <fo:table-cell><fo:block text-align="right"><xsl:value-of select="format-number(@OV, '0,000', 'nf')"/></fo:block></fo:table-cell>
    </fo:table-row>
  </xsl:template>
</xsl:stylesheet>
