<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
  <xsl:decimal-format name="nf" decimal-separator="," grouping-separator="." /> 

  <xsl:template match="/">
    
    <fo:root>
      <fo:layout-master-set>

      <!-- layout for the first page -->
        <fo:simple-page-master master-name="portrait"
                  page-height="29.7cm" 
                  page-width="21cm"
                  margin-top="10mm" 
                  margin-bottom="5mm" 
                  margin-left="10mm" 
                  margin-right="10mm">
           <fo:region-body margin-top="1cm" margin-bottom="1cm"/>
           <fo:region-before extent="1cm"/>
           <fo:region-after extent="5mm"/>
         </fo:simple-page-master>
         <fo:simple-page-master master-name="landscape"
                  page-width="29.7cm" 
                  page-height="21cm"
                  margin-top="10mm" 
                  margin-bottom="5mm" 
                  margin-left="10mm" 
                  margin-right="10mm">
           <fo:region-body margin-top="1cm" margin-bottom="1cm"/>
           <fo:region-before extent="1cm"/>
           <fo:region-after extent="5mm"/>
         </fo:simple-page-master>
       </fo:layout-master-set>

       <fo:page-sequence>
         <xsl:attribute name="master-reference">
           <xsl:choose>
             <xsl:when test="count(/*/vat_values/*) &lt; 4">portrait</xsl:when>
             <xsl:otherwise>landscape</xsl:otherwise>
           </xsl:choose>
         </xsl:attribute>
          <fo:static-content flow-name="xsl-region-before">
            <fo:block font-size="12pt" line-height="14pt" font-family="Times">
                      <fo:inline font-weight="bold">Evolution Handelsgmbh</fo:inline>
                      <fo:inline> Umsatzsteuervoranmeldung :</fo:inline>
                      <fo:inline font-weight="bold"><xsl:value-of select="/*/info[@name='date']/@val"/></fo:inline>
                      <fo:inline> Land : </fo:inline>
                      <fo:inline font-weight="bold">
                      	<xsl:choose>
                                         <xsl:when test="/*/info[@name='country']"><xsl:value-of select="/*/info[@name='country']/@val"/></xsl:when>
                                         <xsl:otherwise>Alle Lnder</xsl:otherwise>
                        </xsl:choose>  
                      </fo:inline>
<!--
              <fo:table table-layout="fixed">
                <fo:table-column column-width="90mm"/>
                <fo:table-column column-width="85mm"/>
                <fo:table-body>
                  <fo:table-row>
                    <fo:table-cell>
                      <fo:block font-weight="bold">Evolution Handelsgmbh</fo:block>
                      <fo:block>Umsatzsteuervoranmeldung : <xsl:value-of select="/*/info[@name='date']/@val"/></fo:block>
                      <fo:block>Land : <xsl:choose>
                                         <xsl:when test="/*/info[@name='country']"><xsl:value-of select="/*/info[@name='country']/@val"/></xsl:when>
                                         <xsl:otherwise>Alle Lnder</xsl:otherwise>
                                       </xsl:choose>  
                      </fo:block>
                    </fo:table-cell>
                    <fo:table-cell>
                      <fo:block text-align="right">A-9500 Villach, Hausergasse 28</fo:block>
                      <fo:block text-align="right">Tel: (04242)-22560</fo:block>
                      <fo:block text-align="right">Fax: (04242)-22562</fo:block>
                    </fo:table-cell>
                  </fo:table-row>
                </fo:table-body>
              </fo:table>
-->
            </fo:block>
          </fo:static-content>       
          
          <fo:static-content flow-name="xsl-region-after">
            <fo:block font-size="10pt" line-height="14pt" font-family="Times" text-align="center">
              <xsl:text>Seite </xsl:text><fo:page-number />/<fo:page-number-citation ref-id="end"/>  
            </fo:block>
          </fo:static-content> 
          
           <fo:flow flow-name="xsl-region-body">
            <fo:block font-size="10pt" line-height="12pt" font-family="Times">
              <fo:table table-layout="fixed">
                <fo:table-column column-width="11mm"/>
                <fo:table-column column-width="11mm"/>
                <fo:table-column column-width="15mm"/>
                <fo:table-column column-width="60mm"/>
                <fo:table-column column-width="15mm"/>
                <fo:table-column column-width="25mm"/>
		        <xsl:for-each select="/*/vat_values/*">
         	      <fo:table-column column-width="13mm"/>
	            </xsl:for-each>
                <fo:table-column column-width="15mm"/>
                <fo:table-header>
                  <fo:table-row>
                    <fo:table-cell><fo:block font-weight="bold">Be.Nr.</fo:block></fo:table-cell>
                    <fo:table-cell><fo:block font-weight="bold">Re.Nr.</fo:block></fo:table-cell>
                    <fo:table-cell><fo:block font-weight="bold">Datum</fo:block></fo:table-cell>
                    <fo:table-cell><fo:block font-weight="bold">Name</fo:block></fo:table-cell>
                    <fo:table-cell><fo:block font-weight="bold">Id</fo:block></fo:table-cell>
                    <fo:table-cell><fo:block font-weight="bold">UID</fo:block></fo:table-cell>

                    <xsl:for-each select="/*/vat_values/*">
                      <fo:table-cell><fo:block text-align="right" font-weight="bold">Umsatz <xsl:value-of select="@val"/>%</fo:block></fo:table-cell>
	                </xsl:for-each>
                    <fo:table-cell><fo:block text-align="right" font-weight="bold">Brutto</fo:block></fo:table-cell>
                  </fo:table-row>
                  <fo:table-row>
                    <fo:table-cell>
                      <xsl:attribute name="number-columns-spanned">
                        <xsl:value-of select="7 + count(/*/vat_values/*)"/>
                      </xsl:attribute>
                      <fo:block space-before="-7pt"><fo:leader leader-pattern="rule" leader-length="100%"/></fo:block>
                    </fo:table-cell>
                  </fo:table-row>
                </fo:table-header>

                <fo:table-body>
                  <xsl:apply-templates select="/*/order"/>
                  <fo:table-row>
                    <fo:table-cell>
	                  <xsl:attribute name="number-columns-spanned">
                        <xsl:value-of select="7 + count(/*/vat_values/*)"/>
                       </xsl:attribute>
		             <fo:block space-before="12pt"/>
   	               </fo:table-cell>
                  </fo:table-row>
                  <fo:table-row>
                    <fo:table-cell number-columns-spanned="6"><fo:block font-weight="bold">Umsatzsummen:</fo:block></fo:table-cell>
                    <xsl:for-each select="/*/vat_values/*">
                      <xsl:variable name="src" select="."/>
                      <fo:table-cell><fo:block text-align="right"><xsl:value-of select="format-number(round(sum(/*/order/item[@VAT=$src/@val]/@Netto) * 100) * 0.01, '0,00', 'nf')"/></fo:block></fo:table-cell>
	                </xsl:for-each>
                  </fo:table-row>
                  <fo:table-row>
                    <fo:table-cell number-columns-spanned="6"><fo:block font-weight="bold">MWStsummen:</fo:block></fo:table-cell>
                    <xsl:for-each select="/*/vat_values/*">
                      <xsl:variable name="src" select="."/>
                      <fo:table-cell><fo:block text-align="right"><xsl:value-of select="format-number(round(sum(/*/order/item[@VAT=$src/@val]/@Netto) * $src/@val) * .01, '0,00', 'nf')"/></fo:block></fo:table-cell>
	                </xsl:for-each>
                  </fo:table-row>
                </fo:table-body>
              </fo:table>
              
              <xsl:variable name="totalNetto">
                <xsl:call-template name="getTotalNetto"/>
              </xsl:variable>
              <xsl:variable name="totalMWSt">
                <xsl:call-template name="getTotalMWSt"/>
              </xsl:variable>
              
              <fo:table table-layout="fixed" space-before="20pt">
                <fo:table-column column-width="50mm"/>
                <fo:table-column column-width="15mm"/>
                <fo:table-body>
                  <fo:table-row>
                    <fo:table-cell><fo:block font-weight="bold">Gesamtumsatz Netto:</fo:block></fo:table-cell>
                    <fo:table-cell><fo:block text-align="right"><xsl:value-of select="format-number($totalNetto, '0,00', 'nf')"/></fo:block></fo:table-cell>
                  </fo:table-row>
                  <fo:table-row>
                    <fo:table-cell><fo:block font-weight="bold">Gesamtumsatz Brutto:</fo:block></fo:table-cell>
                    <fo:table-cell><fo:block text-align="right"><xsl:value-of select="format-number($totalNetto + $totalMWSt, '0,00', 'nf')"/></fo:block></fo:table-cell>
                  </fo:table-row>
                  <fo:table-row>
                    <fo:table-cell><fo:block font-weight="bold">Gesamtumsatz MWSt:</fo:block></fo:table-cell>
                    <fo:table-cell><fo:block text-align="right"><xsl:value-of select="format-number($totalMWSt, '0,00', 'nf')"/></fo:block></fo:table-cell>
                 </fo:table-row>
               </fo:table-body>
             </fo:table>
          </fo:block>
          <fo:block id="end"/>
        </fo:flow>
      </fo:page-sequence>
    </fo:root>
  </xsl:template>

  <xsl:template match="order">
    <xsl:variable name="src" select="."/>
    <fo:table-row>
      <fo:table-cell><fo:block><xsl:value-of select="@OrderId"/></fo:block></fo:table-cell>
      <fo:table-cell><fo:block><xsl:value-of select="@BillId"/></fo:block></fo:table-cell>
      <fo:table-cell><fo:block><xsl:value-of select="@Date"/></fo:block></fo:table-cell>
      <fo:table-cell><fo:block><xsl:value-of select="@Name"/></fo:block></fo:table-cell>
      <fo:table-cell><fo:block><xsl:value-of select="@DId"/></fo:block></fo:table-cell>
      <fo:table-cell><fo:block><xsl:value-of select="@VatId"/></fo:block></fo:table-cell>
	
	  <xsl:choose>
	    <xsl:when test="@brutto">
          <xsl:for-each select="/*/vat_values/*">
	        <xsl:variable name="src2" select="."/>
	        <fo:table-cell><fo:block text-align="right">
	          <xsl:variable name="res">
	 	        <xsl:for-each select="$src/*">
	              <xsl:if test="@VAT=$src2/@val">
	                <xsl:value-of select="format-number(@Netto, '0,00', 'nf')"/>
	              </xsl:if>
	            </xsl:for-each>       
	          </xsl:variable>        
	          <xsl:choose>
	            <xsl:when test="$res"><xsl:value-of select="$res"/></xsl:when>
	            <xsl:otherwise>&#160;</xsl:otherwise>
	          </xsl:choose>
	        </fo:block></fo:table-cell>
	      </xsl:for-each>
          <fo:table-cell><fo:block text-align="right">
            <xsl:value-of select="format-number(@brutto, '0,00', 'nf')"/>
          </fo:block></fo:table-cell>
	    </xsl:when>
	    <xsl:otherwise>
          <fo:table-cell>
            <xsl:attribute name="number-columns-spanned">
              <xsl:value-of select="count(/*/vat_values/*) + 1"/>
            </xsl:attribute>
            <fo:block text-align="center">-- storniert --</fo:block>
          </fo:table-cell>
	    </xsl:otherwise>
	  </xsl:choose>
    </fo:table-row>
  </xsl:template>

  <xsl:template name="getTotalNetto">
    <xsl:param name="pos" select="1"/>
    <xsl:variable name="src" select="/*/vat_values/item[$pos]"/>
    <xsl:choose>
      <xsl:when test="$src">
        <xsl:variable name="further">
          <xsl:call-template name="getTotalNetto">
            <xsl:with-param name="pos" select="$pos + 1"/>
          </xsl:call-template>
        </xsl:variable>
        <xsl:value-of select="$further + round(sum(/*/order/item[@VAT=$src/@val]/@Netto) * 100) * 0.01"/>
      </xsl:when>
      <xsl:otherwise>0</xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  
   <xsl:template name="getTotalMWSt">
    <xsl:param name="pos" select="1"/>
    <xsl:variable name="src" select="/*/vat_values/item[$pos]"/>
    <xsl:choose>
      <xsl:when test="$src">
        <xsl:variable name="further">
          <xsl:call-template name="getTotalMWSt">
            <xsl:with-param name="pos" select="$pos + 1"/>
          </xsl:call-template>
        </xsl:variable>
        <xsl:value-of select="$further + round(sum(/*/order/item[@VAT=$src/@val]/@Netto) * $src/@val) * 0.01"/>
      </xsl:when>
      <xsl:otherwise>0</xsl:otherwise>
    </xsl:choose>
  </xsl:template>
 
</xsl:stylesheet>
