<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
  <xsl:decimal-format name="nf" decimal-separator="," grouping-separator="." /> 
  <xsl:variable name="path" select="'WEB-INF'"/>
  
  <!-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->

  <xsl:template match="/">
    <fo:root>
      <fo:layout-master-set>

      <!-- layout for the first page -->
        <fo:simple-page-master master-name="portrait"
                  page-height="29.7cm"
                  page-width="21cm"
                  margin-top="0mm"
                  margin-bottom="0mm"
                  margin-left="0mm"
                  margin-right="0mm">
           <fo:region-before extent="6cm"/>
           <fo:region-body margin-top="60mm" margin-left="18mm" margin-right="18smm" margin-bottom="19mm"/>
           <fo:region-after extent="17mm"/>
         </fo:simple-page-master>
       </fo:layout-master-set>
       
       <fo:page-sequence master-reference="portrait">
          <fo:static-content flow-name="xsl-region-before">
            <fo:block text-align="center" font-family="Times">
              <fo:external-graphic height="3cm" space-before="5mm">
                <xsl:attribute name="src">url('<xsl:value-of select="$path"/>/xsl/pdf/img/logo_new.jpg')</xsl:attribute>
              </fo:external-graphic>
              <fo:block space-before="5mm">WEGBEREITER FR SEELISCH-GEISTIGE UND KRPERLICHE</fo:block>
              <fo:block>VITALITT UND GESUNDHEIT</fo:block>
            </fo:block>
          </fo:static-content>
          <fo:static-content flow-name="xsl-region-after">
            <fo:block text-align="center" font-size="7pt" font-family="Times">
			  <fo:block><fo:inline font-weight="bold">EVOLUTION GmbH,   Zentrale:</fo:inline> A-9500 Villach, Hausergasse 28</fo:block>
			  <fo:block><fo:inline font-weight="bold">Telefon:</fo:inline> +43 (0)4242 22560 Fax:  +43 (0)4242 22562,  <fo:inline font-weight="bold">Email:</fo:inline> office<xsl:text>@</xsl:text>evolution-international.com,  www.evolution-international.com</fo:block>
			  <fo:block><fo:inline font-weight="bold">Geschftsfhrer:</fo:inline> Herbert Schamberger   <fo:inline font-weight="bold">Firmenbuch:</fo:inline>  Handelsgericht Klagenfurt,  FN 211534 f,  Erfllungsort und Gerichtsstand Villach</fo:block>
			  <fo:block><fo:inline font-weight="bold">ATU:</fo:inline> 52537606,  <fo:inline font-weight="bold">Steuernummer D:</fo:inline> 147/695/17307</fo:block>
			  <fo:block><fo:inline font-weight="bold">Bank Austria:</fo:inline> BLZ 12000 <xsl:text>-</xsl:text> Kto. Nr. 505 756 108 00 <xsl:text>-</xsl:text> IBAN AT 07 12000 505 75610800 <xsl:text>-</xsl:text> BIC: BKAUATWW</fo:block>
			  <fo:block><fo:inline font-weight="bold">Bayerische Hypovereinsbank:</fo:inline> BLZ 700 202 70 <xsl:text>-</xsl:text> Kto<xsl:text>-</xsl:text>Nr: 665 876 594 <xsl:text>-</xsl:text> IBAN DE 07700202700665876594 <xsl:text>-</xsl:text>  BIC: HYVEDEMMXXX</fo:block>  
            </fo:block>
          </fo:static-content>
          <fo:flow flow-name="xsl-region-body">
            <fo:block font-size="12pt" line-height="16pt" font-family="Times">
              <xsl:apply-templates select="*"/>
            </fo:block>
          </fo:flow>
       </fo:page-sequence>
     </fo:root>
  </xsl:template>

  
  <!-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->
  
  <xsl:template match="address">
        <xsl:choose>
        <xsl:when test="@Company != ''">
        	<fo:block><xsl:value-of select="@Company"/></fo:block>
        </xsl:when>
        <xsl:otherwise>
	    	<fo:block><xsl:value-of select="@Title"/></fo:block>
	    	<fo:block><xsl:value-of select="@Name"/></fo:block>
        </xsl:otherwise>
      </xsl:choose>
    <fo:block><xsl:value-of select="@Street"/></fo:block>
    <fo:block><xsl:value-of select="@Country"/>-<xsl:value-of select="@Zip"/>&#160;<xsl:value-of select="@City"/></fo:block>
  </xsl:template>
  
  <!-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->
  <xsl:template match="header">  
    <fo:table table-layout="fixed">
      <fo:table-column column-width="100mm"/>
      <fo:table-column column-width="60mm"/>
      <fo:table-body>
        <fo:table-row>
          <fo:table-cell>
            <fo:block>
              <fo:block>&#160;</fo:block>
              <xsl:apply-templates select="orderer/address[@Type='billing']"/>
            </fo:block>
          </fo:table-cell>
          <fo:table-cell>
            <fo:block>
              <fo:block>LIEFERADRESSE:</fo:block>
              <xsl:apply-templates select="orderer/address[@Type='delivery']"/>
            </fo:block>
          </fo:table-cell>
        </fo:table-row>
      </fo:table-body>
    </fo:table>
   
    <fo:table table-layout="fixed" space-before="5mm">
      <fo:table-column column-width="40mm"/>
      <fo:table-column column-width="20mm"/>
      <fo:table-column column-width="30mm"/>
      <fo:table-column column-width="35mm"/>
      <fo:table-column column-width="35mm"/>
      <fo:table-body>
        <fo:table-row>
          <fo:table-cell><fo:block/></fo:table-cell>
          <fo:table-cell number-columns-spanned="2"><fo:block/></fo:table-cell>
          <fo:table-cell><fo:block>Lieferdatum:</fo:block></fo:table-cell>
          <fo:table-cell><fo:block><xsl:value-of select="@BillingDate"/></fo:block></fo:table-cell>
        </fo:table-row>
        <fo:table-row>
          <fo:table-cell>
          	<xsl:choose>
          		<xsl:when test="/order/header/@Credit = 'false'">
          			<fo:block>Rechnungsnummer:</fo:block>
          		</xsl:when>
          		<xsl:otherwise>
          			<fo:block>Gutschriftsnummer:</fo:block>
          		</xsl:otherwise>
          	</xsl:choose>
          </fo:table-cell>
          <fo:table-cell number-columns-spanned="2"><fo:block><xsl:value-of select="@BillId"/></fo:block></fo:table-cell>
          <fo:table-cell>
          	<xsl:choose>
          		<xsl:when test="/order/header/@Credit = 'false'">
		          	<fo:block>Rechnungsdatum:</fo:block>
          		</xsl:when>
          		<xsl:otherwise>
          			<fo:block>Gutschriftsdatum:</fo:block>
          		</xsl:otherwise>
          	</xsl:choose>
          </fo:table-cell>
          <fo:table-cell><fo:block><xsl:value-of select="@BillingDate"/></fo:block></fo:table-cell>
        </fo:table-row>
        <fo:table-row>
          <fo:table-cell><fo:block>Bestellnummer:</fo:block></fo:table-cell>
          <fo:table-cell number-columns-spanned="2"><fo:block><xsl:value-of select="@OrderId"/></fo:block></fo:table-cell>
          <fo:table-cell><fo:block>Bestelldatum:</fo:block></fo:table-cell>
          <fo:table-cell><fo:block><xsl:value-of select="@OrderDate"/></fo:block></fo:table-cell>
        </fo:table-row>
        <fo:table-row>
          <fo:table-cell>
            <fo:block>
              <xsl:choose>
                <xsl:when test="orderer/@LevelId = 100">Kunde:</xsl:when>
                <xsl:when test="orderer/@LevelId = 130">Silber Kunde:</xsl:when>
                <xsl:when test="orderer/@LevelId = 160">Gold Kunde:</xsl:when>
                <xsl:when test="orderer/@LevelId = 200">Platin Kunde:</xsl:when>
                <xsl:when test="orderer/@LevelId = 300 and orderer/@LevelSubtypeId = 0">Therapeut:</xsl:when>
                <xsl:when test="orderer/@LevelId = 300 and orderer/@LevelSubtypeId = 1">Therapeut-Arzt:</xsl:when>
                <xsl:when test="orderer/@LevelId = 330">Hndler:</xsl:when>
                <xsl:when test="orderer/@LevelId = 350">Grosshndler:</xsl:when>
                <xsl:when test="orderer/@LevelId = 370">Apotheker:</xsl:when>
                <xsl:when test="orderer/@LevelId = 400 and orderer/@LevelSubtypeId = 0">Berater:</xsl:when>
                <xsl:otherwise>Berater-Arzt:</xsl:otherwise>
              </xsl:choose>
            </fo:block>
          </fo:table-cell>
          <fo:table-cell number-columns-spanned="2"><fo:block><xsl:value-of select="orderer/@Id"/></fo:block></fo:table-cell>
          <fo:table-cell><fo:block>Telefon:</fo:block></fo:table-cell>
          <fo:table-cell><fo:block><xsl:value-of select="orderer/@Phone"/></fo:block></fo:table-cell>
        </fo:table-row>
        <fo:table-row>
          <fo:table-cell><fo:block>UID:</fo:block></fo:table-cell>
          <fo:table-cell number-columns-spanned="3"><fo:block><xsl:value-of select="orderer/@VatId"/></fo:block></fo:table-cell>
          <fo:table-cell><fo:block><xsl:value-of select="@Payment"/></fo:block></fo:table-cell>
        </fo:table-row>
      </fo:table-body>
    </fo:table>
  </xsl:template>
  
  <!-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->

  <xsl:template name="gettmwstlst">
    <xsl:param name="lst"/>
    <xsl:param name="pos" select="count($lst)"/>
    <xsl:variable name="prev">
      <xsl:choose>
        <xsl:when test= "$pos > 1">
          <xsl:call-template name="gettmwstlst">
            <xsl:with-param name="pos" select="$pos - 1"/>
            <xsl:with-param name="lst" select="$lst"/>
          </xsl:call-template>
        </xsl:when>
        <xsl:otherwise>0</xsl:otherwise>
      </xsl:choose>
    </xsl:variable> 
    <xsl:choose>
      <xsl:when test="number(/*/header/orderer/@LevelId) = 300 or number(/*/header/orderer/@LevelId) = 350 or number(/*/header/orderer/@LevelId) = 370 or number(/*/header/orderer/@LevelId) = 330 or /order/header/@CustomerDiscount = 'true'">
 		<xsl:value-of select="$prev + round($lst[$pos]/@Num * $lst[$pos]/@NettoTrader * $lst[$pos]/@Vat) * .01"/>
 	  </xsl:when>
 	  <xsl:otherwise>
 		<xsl:value-of select="$prev + round($lst[$pos]/@Num * $lst[$pos]/@Netto * $lst[$pos]/@Vat) * .01"/>
 	  </xsl:otherwise>
 	</xsl:choose>
  </xsl:template>
  
  <xsl:template name="gettmwstnettolst">
    <xsl:param name="lst"/>
    <xsl:param name="pos" select="count($lst)"/>
    <xsl:variable name="prev">
      <xsl:choose>
        <xsl:when test= "$pos > 1">
          <xsl:call-template name="gettmwstnettolst">
            <xsl:with-param name="pos" select="$pos - 1"/>
            <xsl:with-param name="lst" select="$lst"/>
          </xsl:call-template>
        </xsl:when>
        <xsl:otherwise>0</xsl:otherwise>
      </xsl:choose>
    </xsl:variable> 
    <xsl:choose>
      <xsl:when test="number(/*/header/orderer/@LevelId) = 300 or number(/*/header/orderer/@LevelId) = 350 or number(/*/header/orderer/@LevelId) = 370 or number(/*/header/orderer/@LevelId) = 330 or /order/header/@CustomerDiscount = 'true'">
 		<xsl:value-of select="$prev + round($lst[$pos]/@Num * $lst[$pos]/@NettoTrader * 100) * .01"/>
 	  </xsl:when>
 	  <xsl:otherwise>
 		<xsl:value-of select="$prev + round($lst[$pos]/@Num * $lst[$pos]/@Netto * 100) * .01"/>
 	  </xsl:otherwise>
 	</xsl:choose>
  </xsl:template>
  
  <!-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->

  <xsl:template name="displayMWStClasses">
    <xsl:for-each select="*"><xsl:sort select="@Vat" data-type="number"/>
      <xsl:variable name="pos" select="position()"/>
      <xsl:variable name="Vat" select="@Vat"/>
      <xsl:if test="$Vat > 0 and (pos = 1 or count(preceding-sibling::*[@Vat = $Vat]) = 0)">
      <xsl:variable name="tmwstx">
        <xsl:call-template name="gettmwstlst"><xsl:with-param name="lst" select="../*[@Vat=$Vat]"/></xsl:call-template>
      </xsl:variable>
      <fo:table-row>
        <fo:table-cell><fo:block>davon MWST <xsl:value-of select="$Vat"/>&#160;%</fo:block></fo:table-cell>
        <fo:table-cell><fo:block>EUR</fo:block></fo:table-cell> 
        <fo:table-cell><fo:block text-align="end"><xsl:value-of select="format-number($tmwstx, '0,00', 'nf')"/></fo:block></fo:table-cell> 
      </fo:table-row>
      </xsl:if>
    </xsl:for-each>    
  </xsl:template>
     
  <!-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->
  
  <xsl:template match="details">
    <fo:table table-layout="fixed">
      <fo:table-column column-width="10mm"/>
      <xsl:choose>
        <xsl:when test="number(/*/header/orderer/@LevelId) > 370">
          <fo:table-column column-width="85mm"/>
          <fo:table-column column-width="15mm"/>
          <fo:table-column column-width="15mm"/>
        </xsl:when>
        <xsl:when test="number(/*/header/orderer/@LevelId) = 300 or number(/*/header/orderer/@LevelId) = 350 or number(/*/header/orderer/@LevelId) = 330 or number(/*/header/orderer/@LevelId) = 370 or /order/header/@CustomerDiscount = 'true'">
          <fo:table-column column-width="55mm"/>
          <fo:table-column column-width="15mm"/>
          <fo:table-column column-width="15mm"/>
          <fo:table-column column-width="15mm"/>
          <fo:table-column column-width="15mm"/>
        </xsl:when>
        <xsl:otherwise>
          <fo:table-column column-width="100mm"/>
          <fo:table-column column-width="15mm"/>
        </xsl:otherwise>
      </xsl:choose>
      <fo:table-column column-width="15mm"/>
      <fo:table-column column-width="15mm"/>
      <fo:table-column column-width="15mm"/>
      <fo:table-body>
        <fo:table-row><fo:table-cell number-columns-spanned="9"><fo:block><fo:leader leader-pattern="rule" leader-length="100%"/></fo:block></fo:table-cell></fo:table-row>
        <fo:table-row font-weight="bold">
          <fo:table-cell><fo:block>Stk</fo:block></fo:table-cell>
          <fo:table-cell><fo:block>Artikel</fo:block></fo:table-cell>
          <fo:table-cell><fo:block>ArtNr</fo:block></fo:table-cell>
          <xsl:if test="number(/*/header/orderer/@LevelId) > 370">
            <fo:table-cell><fo:block text-align="end">BWert</fo:block></fo:table-cell>
          </xsl:if>
          <xsl:if test="number(/*/header/orderer/@LevelId) = 300 or number(/*/header/orderer/@LevelId) = 350 or number(/*/header/orderer/@LevelId) = 330 or number(/*/header/orderer/@LevelId) = 370 or /order/header/@CustomerDiscount = 'true'">
            <fo:table-cell><fo:block text-align="end">EK-Preis</fo:block></fo:table-cell>
            <fo:table-cell><fo:block start-indent="2mm">Rabatt%</fo:block></fo:table-cell>
            <fo:table-cell><fo:block start-indent="5mm">Rabatt</fo:block></fo:table-cell>
          </xsl:if>
          <fo:table-cell><fo:block text-align="end">Netto</fo:block></fo:table-cell>
          <fo:table-cell><fo:block text-align="end">MWSt</fo:block></fo:table-cell>
          <fo:table-cell><fo:block text-align="end">Gesamt</fo:block></fo:table-cell>
        </fo:table-row>
        <fo:table-row><fo:table-cell number-columns-spanned="9"><fo:block line-height="1mm" space-after="7pt"><fo:leader leader-pattern="rule" leader-length="100%"/></fo:block></fo:table-cell></fo:table-row>
        <xsl:apply-templates select="*"/>
        <fo:table-row><fo:table-cell number-columns-spanned="9"><fo:block line-height="1mm" space-after="14pt"><fo:leader leader-pattern="rule" leader-length="100%"/></fo:block></fo:table-cell></fo:table-row>
      </fo:table-body>
    </fo:table>

    <xsl:variable name="tnetto">
      <xsl:choose>
        <xsl:when test="number(/*/header/orderer/@LevelId) = 300 or number(/*/header/orderer/@LevelId) = 350 or number(/*/header/orderer/@LevelId) = 330 or number(/*/header/orderer/@LevelId) = 370 or /order/header/@CustomerDiscount = 'true'"><xsl:value-of select="/*/header/@TotalNettoTrader"/></xsl:when>
        <xsl:otherwise><xsl:value-of select="/*/header/@TotalNetto"/></xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:variable name="tbrutto">
      <xsl:choose>
        <xsl:when test="number(/*/header/orderer/@LevelId) = 300 or number(/*/header/orderer/@LevelId) = 350 or number(/*/header/orderer/@LevelId) = 330 or number(/*/header/orderer/@LevelId) = 370 or /order/header/@CustomerDiscount = 'true'"><xsl:value-of select="/*/header/@TotalBruttoTrader"/></xsl:when>
        <xsl:otherwise><xsl:value-of select="/*/header/@TotalBrutto"/></xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:variable name="tbonus"><xsl:value-of select="/*/header/@TotalBonus"/></xsl:variable>
    <xsl:variable name="tmwst"><xsl:value-of select="$tbrutto - $tnetto"/></xsl:variable>
            
    <fo:table table-layout="fixed">
      <fo:table-column column-width="75mm"/>
      <fo:table-column column-width="95mm"/>
      <fo:table-body>
        <fo:table-row>
          <fo:table-cell display-align="after">
            <fo:block font-weight="bold">
              <fo:block>Bezahlung durch&#160;:&#160;<xsl:value-of select="/*/header/@Payment"/></fo:block>
              <fo:block>Versandart&#160;:&#160;<xsl:value-of select="/*/header/@Shipping"/></fo:block>
            </fo:block>
          </fo:table-cell>
          <fo:table-cell>
            <fo:table table-layout="fixed">
              <fo:table-column column-width="70mm"/>
              <fo:table-column column-width="10mm"/>
              <fo:table-column column-width="15mm"/>
              <fo:table-body>
              <xsl:choose>
                <xsl:when test="/order/header/@FirstOrder = 'true'">
	                <fo:table-row font-weight="bold">
	                  <fo:table-cell number-columns-spanned="3">
			          	<xsl:choose>
			          		<xsl:when test="/order/header/@Credit = 'false'">
	                  			<fo:block>abzglich <xsl:value-of select="/order/header/@DiscountRate"/>% Rechnungsrabatt</fo:block>
			          		</xsl:when>
			          		<xsl:otherwise>
	                  			<fo:block>abzglich <xsl:value-of select="/order/header/@DiscountRate"/>% Gutschriftsrabatt</fo:block>
			          		</xsl:otherwise>
			          	</xsl:choose>	                  		
	                  </fo:table-cell> 
	                </fo:table-row>
                </xsl:when>
                <xsl:when test="number(/*/header/orderer/@LevelId) = 300 and number(/order/header/@DiscountRate) != 0">
	                <fo:table-row font-weight="bold">
	                  <fo:table-cell number-columns-spanned="3"><fo:block>Spezialrabatt von <xsl:value-of select="/order/header/@DiscountRate"/>% bercksichtigt!</fo:block></fo:table-cell> 
	                </fo:table-row>
                </xsl:when> 
                </xsl:choose>                        
                <xsl:if test="number(/*/header/orderer/@LevelId) > 370">
                  <fo:table-row>
                    <fo:table-cell><fo:block>Total Bonuswert:</fo:block></fo:table-cell> 
                    <fo:table-cell><fo:block>&#160;</fo:block></fo:table-cell> 
                    <fo:table-cell><fo:block text-align="end"><xsl:value-of select="format-number($tbonus,'0,00', 'nf')"/></fo:block></fo:table-cell> 
                  </fo:table-row>
                </xsl:if>
                <fo:table-row>
                  <fo:table-cell>
		          	<xsl:choose>
		          		<xsl:when test="/order/header/@Credit = 'false'">
			                <fo:block>Gesamtrechnungsbetrag Netto:</fo:block>
		          		</xsl:when>
		          		<xsl:otherwise>
		          			<fo:block>Gutschriftsbetrag Netto:</fo:block>
		          		</xsl:otherwise>
		          	</xsl:choose>
                  </fo:table-cell> 
                  <fo:table-cell><fo:block>EUR</fo:block></fo:table-cell> 
                  <fo:table-cell><fo:block text-align="end"><xsl:value-of select="format-number($tnetto,'0,00', 'nf')"/></fo:block></fo:table-cell> 
                </fo:table-row>
                <fo:table-row>
                  <fo:table-cell><fo:block>MWSt gesamt:</fo:block></fo:table-cell> 
                  <fo:table-cell><fo:block>EUR</fo:block></fo:table-cell> 
                  <fo:table-cell><fo:block text-align="end"><xsl:value-of select="format-number($tmwst,'0,00', 'nf')"/></fo:block></fo:table-cell> 
                </fo:table-row>
                <xsl:call-template name="displayMWStClasses"></xsl:call-template>
                <fo:table-row font-weight="bold">
                  <fo:table-cell>
			          	<xsl:choose>
		          		<xsl:when test="/order/header/@Credit = 'false'">
			                <fo:block>Gesamtrechnungsbetrag Brutto:</fo:block>
		          		</xsl:when>
		          		<xsl:otherwise>
		          			<fo:block>Gutschriftsbetrag Brutto:</fo:block>
		          		</xsl:otherwise>
		          	</xsl:choose>				                  
                  </fo:table-cell> 
                  <fo:table-cell><fo:block>EUR</fo:block></fo:table-cell> 
                  <fo:table-cell><fo:block text-align="end"><xsl:value-of select="format-number($tbrutto, '0,00', 'nf')"/></fo:block></fo:table-cell> 
                </fo:table-row>
                <xsl:if test="number(/*/header/orderer/@LevelId) = 350">
                	 <fo:table-row font-weight="bold">
	                   <fo:table-cell number-columns-spanned="3"><fo:block><fo:leader/></fo:block></fo:table-cell> 
	                </fo:table-row>
	                <fo:table-row font-weight="bold">
	                   <fo:table-cell number-columns-spanned="3"><fo:block>Zahlungsziel: <xsl:value-of select="/order/header/@SkontoDays"/> Tage ohne Abzug</fo:block></fo:table-cell> 
	                </fo:table-row>
                </xsl:if>
                <xsl:if test="number(/*/header/@PaymentId) = 6 and number(/*/header/orderer/@LevelId) != 350">
	                <fo:table-row font-weight="bold">
	                   <fo:table-cell number-columns-spanned="3"><fo:block>Zahlungsziel: <xsl:value-of select="/order/header/@SkontoDays"/> Tage ohne Abzug</fo:block></fo:table-cell> 
	                </fo:table-row>
                </xsl:if>
              </fo:table-body>
            </fo:table>
          </fo:table-cell>
        </fo:table-row>
      </fo:table-body>
    </fo:table>
    <xsl:if test="/order/header/orderer/@VatId != '' and starts-with(/order/header/orderer/@Id, '49')">
      <fo:block space-before="20pt">Innergemeinschaftliche Lieferung</fo:block>
    </xsl:if>
    <fo:table table-layout="fixed">
      <fo:table-column column-width="75mm"/>
      <fo:table-column column-width="95mm"/>
      <fo:table-body space-before="40pt" >
        <fo:table-row>
          <fo:table-cell/>
          <!-- <fo:table-cell>
            <fo:block font-weight="bold">Besuchen Sie unseren Webshop mit interessanten Vorteilen und Angeboten.</fo:block>
            <fo:block font-weight="bold">www.evolution-international.com</fo:block>
          </fo:table-cell> -->
        </fo:table-row>
      </fo:table-body>
    </fo:table>
    <fo:table table-layout="fixed" text-align="left">
    	<fo:table-column column-width="170mm"/>
    	<fo:table-body>
        	<fo:table-row>
               	<fo:table-cell>
              		<fo:block>Viele interessante Aktionen &#38; News auf:</fo:block>
              		<fo:block font-size="10pt">www.evolution-international.com</fo:block>
              		<fo:block font-size="10pt">www.facebook.com/Evolution-Gmbh</fo:block>
	        	</fo:table-cell>
           </fo:table-row>
        </fo:table-body>
    </fo:table>
  </xsl:template>
  <!-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->
    
  <xsl:template match="item">
    <fo:table-row>
      <fo:table-cell><fo:block><xsl:value-of select="@Num"/></fo:block></fo:table-cell>
      <fo:table-cell><fo:block><xsl:value-of select="@Name"/></fo:block></fo:table-cell>
      <fo:table-cell><fo:block><xsl:value-of select="@AId"/></fo:block></fo:table-cell>
      <xsl:if test="number(/*/header/orderer/@LevelId) > 370">
        <fo:table-cell><fo:block text-align="end"><xsl:value-of select="format-number(round((@Bonus) * @Num * 100) * .01, '0,00', 'nf')"/></fo:block></fo:table-cell>
      </xsl:if>
      <fo:table-cell><fo:block text-align="end"><xsl:value-of select="format-number(round(@Netto * 100) * .01, '0,00', 'nf')"/></fo:block></fo:table-cell>
      <xsl:if test="number(/*/header/orderer/@LevelId) = 300 or number(/*/header/orderer/@LevelId) = 350 or number(/*/header/orderer/@LevelId) = 330 or number(/*/header/orderer/@LevelId) = 370 or /order/header/@CustomerDiscount = 'true'">
        <fo:table-cell><fo:block text-align="end">
          <xsl:if test="@Netto > 0">
        	<xsl:value-of select="format-number(round((@Netto - @NettoTrader) div @Netto * 1000) * .1, '0,0', 'nf')"/>
        	<xsl:text>%</xsl:text>
          </xsl:if>
        </fo:block></fo:table-cell>
        <fo:table-cell><fo:block text-align="end"><xsl:value-of select="format-number(round((@Netto - @NettoTrader) * 100) * .01, '0,00', 'nf')"/></fo:block></fo:table-cell>
        <fo:table-cell><fo:block text-align="end"><xsl:value-of select="format-number(round(@NettoTrader * @Num * 100) * .01, '0,00', 'nf')"/></fo:block></fo:table-cell>
      </xsl:if>
      <fo:table-cell><fo:block text-align="end"><xsl:value-of select="format-number(round(@Vat * 100) * .01, '0,00', 'nf')"/></fo:block>&#160;%</fo:table-cell>
      <xsl:choose>
        <xsl:when test="number(/*/header/orderer/@LevelId) = 300 or number(/*/header/orderer/@LevelId) = 350 or number(/*/header/orderer/@LevelId) = 330 or number(/*/header/orderer/@LevelId) = 370 or /order/header/@CustomerDiscount = 'true'">
          <!-- <fo:table-cell><fo:block text-align="end"><xsl:value-of select="format-number(round(@BruttoTrader * @Num * 100) * .01, '0,00', 'nf')"/></fo:block></fo:table-cell> -->
          <fo:table-cell><fo:block text-align="end"><xsl:value-of select="format-number(round((@NettoTrader * @Num + (@NettoTrader * @Num * @Vat * .01)) * 100) * .01, '0,00', 'nf')"/></fo:block></fo:table-cell>
        </xsl:when>
        <xsl:otherwise>
          <!-- <fo:table-cell><fo:block text-align="end"><xsl:value-of select="format-number(round(@Brutto * @Num * 100) * .01, '0,00', 'nf')"/></fo:block></fo:table-cell> -->
          <fo:table-cell><fo:block text-align="end"><xsl:value-of select="format-number(round((@Netto * @Num + (@Netto * @Num * @Vat * .01)) * 100) * .01, '0,00', 'nf')"/></fo:block></fo:table-cell>
        </xsl:otherwise>
      </xsl:choose>
    </fo:table-row>
  </xsl:template>

  <!-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->
  
</xsl:stylesheet>