<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
  <xsl:decimal-format name="nf" decimal-separator="," grouping-separator="." /> 
  <xsl:variable name="path" select="'WEB-INF'"/>
  
  <!-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->

  <xsl:template match="/">
    <fo:root>
      <fo:layout-master-set>

      <!-- layout for the first page -->
        <fo:simple-page-master master-name="labels"
                  page-height="101.5mm"
                  page-width="146mm"
                  margin-top="13mm"
                  margin-bottom="0mm"
                  margin-left="64mm"
                  margin-right="0mm">
           <fo:region-body/>
         </fo:simple-page-master>
        <fo:simple-page-master master-name="portrait"
                  page-height="101.5mm"
                  page-width="146mm"
                  margin-top="16mm"
                  margin-bottom="0mm"
                  margin-left="10mm"
                  margin-right="10mm">
           <fo:region-body/>
         </fo:simple-page-master>
       </fo:layout-master-set>
       
       <xsl:apply-templates select="/orders/*"/>
     </fo:root>
  </xsl:template>


  <xsl:template match="order">
    <fo:page-sequence master-reference="labels">
      <fo:flow flow-name="xsl-region-body">
        <fo:block font-size="12pt" line-height="16pt" font-family="Times">
          <xsl:apply-templates select="*"/>
        </fo:block>
      </fo:flow>
    </fo:page-sequence>
  </xsl:template>

  <xsl:template match="message">
    <fo:page-sequence master-reference="portrait">
      <fo:flow flow-name="xsl-region-body">
        <fo:block font-size="16pt" font-family="Times">
         <xsl:value-of select="."/>
        </fo:block>
      </fo:flow>
    </fo:page-sequence>
  </xsl:template>
  
  <!-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->
  
  <xsl:template match="address">
    <fo:block><xsl:value-of select="@Name"/></fo:block>
    <fo:block><xsl:value-of select="@Street"/></fo:block>
    <fo:block><xsl:value-of select="@Country"/>-<xsl:value-of select="@Zip"/>&#160;<xsl:value-of select="@City"/></fo:block>
  </xsl:template>
  
  <!-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->
       
  <xsl:template match="header">     
    <xsl:variable name="address" select="orderer/address[@Type='delivery']"/>
    <fo:table table-layout="fixed" space-before="10mm">
      <fo:table-column column-width="20mm"/>
      <fo:table-column column-width="60mm"/>
      <fo:table-body>
        <fo:table-row height="20mm">
          <fo:table-cell>
            <fo:block/>
          </fo:table-cell>
          <fo:table-cell>
			<!-- Consignee -->
            <fo:block>
    		  <fo:block><xsl:value-of select="$address/@Name"/></fo:block>
            </fo:block>
          </fo:table-cell>
        </fo:table-row>
        <fo:table-row height="5.5mm">
          <fo:table-cell>
            <fo:block/>
          </fo:table-cell>
          <fo:table-cell >
            <fo:block>
    		  <xsl:value-of select="$address/@Street"/>
            </fo:block>
          </fo:table-cell>
        </fo:table-row>        
        <fo:table-row height="12mm">
          <fo:table-cell>
            <fo:block/>
          </fo:table-cell>
          <fo:table-cell >
			<!-- Country -->
            <fo:block>
    		  <xsl:value-of select="$address/@Country"/>-<xsl:value-of select="$address/@Zip"/>&#160;<xsl:value-of select="$address/@City"/>
            </fo:block>
          </fo:table-cell>
        </fo:table-row>
        <fo:table-row height="8mm">
          <fo:table-cell>
            <!-- CustomerNo -->
            <fo:block/>
          </fo:table-cell>
          <fo:table-cell>
            <!-- Content -->
            <fo:block space-before="3mm">
              <xsl:value-of select="orderer/@Phone"/>
            </fo:block>
          </fo:table-cell>
        </fo:table-row>
        <fo:table-row height="10mm">
          <fo:table-cell>
            <!-- Consignm. cons. of Parcels -->
            <fo:block/>
          </fo:table-cell>
          <fo:table-cell number-rows-spanned="3" start-indent="3mm">
            <!-- Consignor -->
            <fo:block space-before="7mm">
              <fo:block>EVOLUTION <fo:inline font-size="10pt">Ges.m.b.H.</fo:inline></fo:block>
              <fo:block>Lifestyle &amp; Kosmetik</fo:block>
              <fo:block font-size="10pt">9500 Villach, Hausergasse 28</fo:block>
              <fo:block font-size="10pt">Tel. 04242/22 5 60, Fax 22 5 62</fo:block>
            </fo:block>
          </fo:table-cell>
        </fo:table-row>
        <fo:table-row height="10mm">
          <fo:table-cell>
            <!-- Weights -->
            <fo:block/>
          </fo:table-cell>
        </fo:table-row>
        <fo:table-row height="10mm">
          <fo:table-cell>
            <!-- Date -->
            <fo:block space-before="7mm"><xsl:value-of select="@BillingDate"/></fo:block>
          </fo:table-cell>
        </fo:table-row>
      </fo:table-body>
    </fo:table>
  </xsl:template>

  <!-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->
  
</xsl:stylesheet>
