<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
  <xsl:decimal-format name="nf" decimal-separator="," grouping-separator="." /> 
  
  <!-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->

  <xsl:template match="/">
    <fo:root>
      <fo:layout-master-set>

      <!-- layout for the first page -->
        <fo:simple-page-master master-name="portrait"
                  page-height="29.7cm" 
                  page-width="21cm"
                  margin-top="15mm" 
                  margin-bottom="10mm" 
                  margin-left="15mm" 
                  margin-right="15mm">
           <fo:region-body margin-top="30mm" margin-bottom="5mm"/>
           <fo:region-before extent="30mm"/>
           <fo:region-after extent="5mm"/>
         </fo:simple-page-master>
       </fo:layout-master-set>
       <xsl:apply-templates select="*"/>
       <xsl:call-template name="Gesamt"/>       
      </fo:root>
  </xsl:template>

  <!-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->

  <xsl:template name="Gesamt">
    <fo:page-sequence master-reference="portrait">
      <fo:static-content flow-name="xsl-region-before">
        <fo:block text-align="center" font-size="10pt" font-weight="bold">
          <fo:table table-layout="fixed"> 
            <fo:table-column column-width="90mm"/>
            <fo:table-column column-width="90mm"/>
            <fo:table-body>
              <fo:table-row>
                <fo:table-cell>
                  <fo:block text-align="start">Evolution Handelsgmbh Network</fo:block>
                  <fo:block text-align="start" space-before="12pt"><xsl:value-of select="/*/*[1]/@MainTitle"/></fo:block>
                </fo:table-cell>
                <fo:table-cell>
                  <fo:block text-align="end">A-9500 Villach, Hausergasse 28</fo:block>
                  <fo:block text-align="end">Tel: (04242)-22560</fo:block>
                  <fo:block text-align="end">Fax: (04242)-22562</fo:block>
                </fo:table-cell>
              </fo:table-row>
            </fo:table-body>
          </fo:table>
        </fo:block>
        <fo:block text-align="center" font-size="12pt" font-weight="bold" space-before="12pt">
          <xsl:value-of select="/*/*[1]/@Title"/>
        </fo:block>
        <fo:block text-align="center" font-size="10pt" font-weight="bold">
          <xsl:text>GESAMT</xsl:text>
        </fo:block>
      </fo:static-content>
      <fo:static-content flow-name="xsl-region-after">
        <fo:block text-align="center" font-size="10pt">
          <fo:page-number/>&#160;/&#160;<fo:page-number-citation ref-id="end"/>
        </fo:block>
      </fo:static-content>
      <fo:flow flow-name="xsl-region-body">
        <fo:block font-size="10pt" line-height="14pt" font-family="Times">
          <fo:table table-layout="fixed">
            <fo:table-column column-width="18mm"/>
            <fo:table-column column-width="55mm"/>
            <fo:table-column column-width="37mm"/>              
            <fo:table-column column-width="16mm"/>
            <fo:table-column column-width="22mm"/>
            <fo:table-column column-width="16mm"/>
            <fo:table-column column-width="16mm"/>
             <fo:table-header>
                <fo:table-row>
                  <fo:table-cell number-columns-spanned="4"><fo:block/></fo:table-cell>
                  <xsl:choose>
                    <xsl:when test="/*/*[1]/@useVAT">
                  	  <fo:table-cell><fo:block font-weight="bold" text-align="end">Netto</fo:block></fo:table-cell>
                      <fo:table-cell><fo:block font-weight="bold" text-align="end">MWSt</fo:block></fo:table-cell>
                      <fo:table-cell><fo:block font-weight="bold" text-align="end">Brutto</fo:block></fo:table-cell>
                    </xsl:when>
                    <xsl:otherwise>
                  	  <fo:table-cell><fo:block font-weight="bold">UID</fo:block></fo:table-cell>
                  	  <fo:table-cell><fo:block font-weight="bold" text-align="end">Netto (UID)</fo:block></fo:table-cell>
                      <fo:table-cell><fo:block font-weight="bold" text-align="end">Netto</fo:block></fo:table-cell>
                    </xsl:otherwise>
                  </xsl:choose>
                </fo:table-row>
                <fo:table-row>
                  <fo:table-cell number-columns-spanned="7"><fo:block><fo:leader leader-pattern="rule" leader-length="100%"/></fo:block></fo:table-cell>
                </fo:table-row>
              </fo:table-header>
              <fo:table-body>
              <xsl:for-each select="/*/*"> 
                <fo:table-row>
                  <fo:table-cell number-columns-spanned="2"><fo:block/></fo:table-cell>
                  <fo:table-cell number-columns-spanned="2"><fo:block font-weight="bold">Total <xsl:value-of select="@SubTitle"/>: </fo:block></fo:table-cell>
                  <xsl:choose>
                    <xsl:when test="/*/*[1]/@useVAT">
                      <fo:table-cell><fo:block font-weight="bold" text-align="end"><xsl:value-of select="format-number(sum(*/@Netto), '#.##0,00', 'nf')"/></fo:block></fo:table-cell>
                      <fo:table-cell><fo:block font-weight="bold" text-align="end"><xsl:value-of select="format-number(sum(*/@VAT), '#.##0,00', 'nf')"/></fo:block></fo:table-cell>
                      <fo:table-cell><fo:block font-weight="bold" text-align="end"><xsl:value-of select="format-number(sum(*/@Netto) + sum(*/@VAT), '#.##0,00', 'nf')"/></fo:block></fo:table-cell>
                    </xsl:when>
                    <xsl:otherwise>
                      <fo:table-cell><fo:block></fo:block></fo:table-cell>
                      <fo:table-cell><fo:block font-weight="bold" text-align="end"><xsl:value-of select="format-number(sum(distributor[@UID]/@Netto), '#.##0,00', 'nf')"/></fo:block></fo:table-cell>
                      <fo:table-cell><fo:block font-weight="bold" text-align="end"><xsl:value-of select="format-number(sum(distributor[not(@UID)]/@Netto), '#.##0,00', 'nf')"/></fo:block></fo:table-cell>
                    </xsl:otherwise>
                  </xsl:choose>
                </fo:table-row>            
              </xsl:for-each>
              <fo:table-row><fo:table-cell number-columns-spanned="7"><fo:block space-before="14pt"/></fo:table-cell></fo:table-row>
              <fo:table-row>
                <fo:table-cell number-columns-spanned="2"><fo:block/></fo:table-cell>
                <fo:table-cell number-columns-spanned="2"><fo:block font-weight="bold" id="end">Gesamt: </fo:block></fo:table-cell>
                <xsl:choose>
                  <xsl:when test="/*/*[1]/@useVAT">
                    <fo:table-cell><fo:block font-weight="bold" text-align="end"><xsl:value-of select="format-number(sum(/*/*/*/@Netto), '#.##0,00', 'nf')"/></fo:block></fo:table-cell>
                    <fo:table-cell><fo:block font-weight="bold" text-align="end"><xsl:value-of select="format-number(sum(/*/*/*/@VAT), '#.##0,00', 'nf')"/></fo:block></fo:table-cell>
                    <fo:table-cell><fo:block font-weight="bold" text-align="end"><xsl:value-of select="format-number(sum(/*/*/*/@Netto) + sum(/*/*/*/@VAT), '#.##0,00', 'nf')"/></fo:block></fo:table-cell>
                  </xsl:when>
                  <xsl:otherwise>
                    <fo:table-cell><fo:block></fo:block></fo:table-cell>
                    <fo:table-cell><fo:block font-weight="bold" text-align="end"><xsl:value-of select="format-number(sum(/*/*/distributor[@UID]/@Netto), '#.##0,00', 'nf')"/></fo:block></fo:table-cell>
                    <fo:table-cell><fo:block font-weight="bold" text-align="end"><xsl:value-of select="format-number(sum(/*/*/distributor[not(@UID)]/@Netto), '#.##0,00', 'nf')"/></fo:block></fo:table-cell>
                  </xsl:otherwise>
                </xsl:choose>
              </fo:table-row>
              <xsl:if test="not(/*/*[1]/@useVAT)">
                <fo:table-row>
                  <fo:table-cell number-columns-spanned="2"><fo:block/></fo:table-cell>
                  <fo:table-cell number-columns-spanned="4"><fo:block font-weight="bold">Gesamt Netto(UID) + Netto: </fo:block></fo:table-cell>
                  <fo:table-cell><fo:block font-weight="bold" text-align="end"><xsl:value-of select="format-number(sum(/*/*/*/@Netto), '#.##0,00', 'nf')"/></fo:block></fo:table-cell>
                </fo:table-row>
              </xsl:if> 
            </fo:table-body>
          </fo:table>
        </fo:block>
      </fo:flow>
    </fo:page-sequence>
  </xsl:template>
 
  <!-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->
  
  <xsl:template match="section">
    <xsl:if test="distributor">
      <fo:page-sequence master-reference="portrait">
        <fo:static-content flow-name="xsl-region-before">
          <fo:block text-align="center" font-size="10pt" font-weight="bold">
            <fo:table table-layout="fixed"> 
              <fo:table-column column-width="90mm"/>
              <fo:table-column column-width="90mm"/>
              <fo:table-body>
                <fo:table-row>
                  <fo:table-cell>
                    <fo:block text-align="start">Evolution Handelsgmbh Network</fo:block>
                    <fo:block text-align="start" space-before="12pt"><xsl:value-of select="/*/*[1]/@MainTitle"/></fo:block>
                  </fo:table-cell>
                  <fo:table-cell>
                    <fo:block text-align="end">A-9500 Villach, Hausergasse 28</fo:block>
                    <fo:block text-align="end">Tel: (04242)-22560</fo:block>
                    <fo:block text-align="end">Fax: (04242)-22562</fo:block>
                  </fo:table-cell>
                </fo:table-row>
              </fo:table-body>
            </fo:table>
          </fo:block>
          <fo:block text-align="center" font-size="12pt" font-weight="bold" space-before="12pt">
            <xsl:value-of select="@Title"/>
          </fo:block>
          <fo:block text-align="center" font-size="10pt" font-weight="bold">
            <xsl:value-of select="@SubTitle"/>
            <xsl:value-of select="@Filename"/>
          </fo:block>
        </fo:static-content>
        <fo:static-content flow-name="xsl-region-after">
          <fo:block text-align="center" font-size="10pt">
            <fo:page-number/>&#160;/&#160;<fo:page-number-citation ref-id="end"/>
          </fo:block>
        </fo:static-content>

        <fo:flow flow-name="xsl-region-body">
          <fo:block font-size="10pt" line-height="14pt" font-family="Times">
            <fo:table table-layout="fixed">
              <fo:table-column column-width="18mm"/>
              <fo:table-column column-width="55mm"/>
              <fo:table-column column-width="37mm"/>              
              <fo:table-column column-width="16mm"/>
              <fo:table-column column-width="22mm"/>
              <fo:table-column column-width="16mm"/>
              <fo:table-column column-width="16mm"/>
              <fo:table-header>
                <fo:table-row>
                  <fo:table-cell><fo:block font-weight="bold">DNr</fo:block></fo:table-cell>
                  <fo:table-cell><fo:block font-weight="bold">Name</fo:block></fo:table-cell>
                  <fo:table-cell><fo:block font-weight="bold"><xsl:if test="@Id > 0">Nichtauszahlungsgrund</xsl:if></fo:block></fo:table-cell>
                  <xsl:choose>
                    <xsl:when test="@useVAT">
                      <fo:table-cell><fo:block font-weight="bold" text-align="end">MWst %</fo:block></fo:table-cell>
                      <fo:table-cell><fo:block font-weight="bold" text-align="end">Netto</fo:block></fo:table-cell>
                      <fo:table-cell><fo:block font-weight="bold" text-align="end">MWSt</fo:block></fo:table-cell>
                      <fo:table-cell><fo:block font-weight="bold" text-align="end">Brutto</fo:block></fo:table-cell>
                    </xsl:when>
                    <xsl:otherwise>
                      <fo:table-cell><fo:block></fo:block></fo:table-cell>
                      <fo:table-cell><fo:block font-weight="bold">UID</fo:block></fo:table-cell>
                      <fo:table-cell><fo:block font-weight="bold" text-align="end">Netto (UID)</fo:block></fo:table-cell>
                      <fo:table-cell><fo:block font-weight="bold" text-align="end">Netto</fo:block></fo:table-cell>
                    </xsl:otherwise>
                  </xsl:choose>
                </fo:table-row>
                <fo:table-row>
                  <fo:table-cell number-columns-spanned="7"><fo:block><fo:leader leader-pattern="rule" leader-length="100%"/></fo:block></fo:table-cell>
                </fo:table-row>
              </fo:table-header>
              <fo:table-body>
                <xsl:apply-templates select="*"><xsl:sort select="@Name"/></xsl:apply-templates>
                <fo:table-row>
                  <fo:table-cell number-columns-spanned="7"><fo:block space-before="14pt"/></fo:table-cell>
                </fo:table-row>
                <fo:table-row>
                  <fo:table-cell number-columns-spanned="2"><fo:block/></fo:table-cell>
                  <fo:table-cell number-columns-spanned="2"><fo:block font-weight="bold">Total:</fo:block></fo:table-cell>
                   <xsl:choose>
                    <xsl:when test="@useVAT">
                      <fo:table-cell><fo:block font-weight="bold" text-align="end"><xsl:value-of select="format-number(sum(*/@Netto), '#.##0,00', 'nf')"/></fo:block></fo:table-cell>
                      <fo:table-cell><fo:block font-weight="bold" text-align="end"><xsl:value-of select="format-number(sum(*/@VAT), '#.##0,00', 'nf')"/></fo:block></fo:table-cell>
                      <fo:table-cell><fo:block font-weight="bold" text-align="end"><xsl:value-of select="format-number(sum(*/@Netto) + sum(*/@VAT), '#.##0,00', 'nf')"/></fo:block></fo:table-cell>
                    </xsl:when>
                    <xsl:otherwise>
                      <fo:table-cell><fo:block></fo:block></fo:table-cell>
                      <fo:table-cell><fo:block font-weight="bold" text-align="end"><xsl:value-of select="format-number(sum(distributor[@UID]/@Netto), '#.##0,00', 'nf')"/></fo:block></fo:table-cell>
                      <fo:table-cell><fo:block font-weight="bold" text-align="end"><xsl:value-of select="format-number(sum(distributor[not(@UID)]/@Netto), '#.##0,00', 'nf')"/></fo:block></fo:table-cell>
                    </xsl:otherwise>
                  </xsl:choose>
                </fo:table-row>
                
                <xsl:if test="not(@useVAT)">
                  <fo:table-row>
                    <fo:table-cell number-columns-spanned="2"><fo:block/></fo:table-cell>
                    <fo:table-cell number-columns-spanned="4"><fo:block font-weight="bold">Total Netto(UID) + Netto: </fo:block></fo:table-cell>
                    <fo:table-cell><fo:block font-weight="bold" text-align="end"><xsl:value-of select="format-number(sum(*/@Netto), '#.##0,00', 'nf')"/></fo:block></fo:table-cell>
                  </fo:table-row>
                </xsl:if> 
                
              </fo:table-body>
            </fo:table>
          </fo:block>
        </fo:flow>
      </fo:page-sequence>
    </xsl:if>
  </xsl:template>
 
  <!-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->
  
  <xsl:template match="distributor">
    <fo:table-row>
      <fo:table-cell><fo:block><xsl:value-of select="@Id"/></fo:block></fo:table-cell>
      <fo:table-cell><fo:block><xsl:value-of select="@Name"/></fo:block></fo:table-cell>
      <fo:table-cell><fo:block><xsl:value-of select="@Info"/></fo:block></fo:table-cell>
      <xsl:choose>
        <xsl:when test="@VATFactor">
          <fo:table-cell><fo:block text-align="end"><xsl:value-of select="format-number(sum(@VATFactor), '#.##0,00', 'nf')"/></fo:block></fo:table-cell>
          <fo:table-cell><fo:block text-align="end"><xsl:value-of select="format-number(sum(@Netto), '#.##0,00', 'nf')"/></fo:block></fo:table-cell>     
          <fo:table-cell>
	        <fo:block text-align="end">
	          <xsl:if test="number(@VAT) > 0">
	            <xsl:value-of select="format-number(sum(@VAT), '#.###,00', 'nf')"/>
	          </xsl:if>
	        </fo:block>
      	  </fo:table-cell>
	      <fo:table-cell><fo:block text-align="end"><xsl:value-of select="format-number(sum(@Netto) + sum(@VAT), '#.##0,00', 'nf')"/></fo:block></fo:table-cell>     
      	</xsl:when>
      	<xsl:otherwise>
          <fo:table-cell><fo:block></fo:block></fo:table-cell>
	      <fo:table-cell><fo:block><xsl:value-of select="@UID"/></fo:block></fo:table-cell>
          <fo:table-cell><fo:block text-align="end"><xsl:if test="@UID"><xsl:value-of select="format-number(sum(@Netto), '#.##0,00', 'nf')"/></xsl:if></fo:block></fo:table-cell>     
          <fo:table-cell><fo:block text-align="end"><xsl:if test="not(@UID)"><xsl:value-of select="format-number(sum(@Netto), '#.##0,00', 'nf')"/></xsl:if></fo:block></fo:table-cell>     
      	</xsl:otherwise>
      </xsl:choose>
    </fo:table-row>
  </xsl:template>    

 <!-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->

</xsl:stylesheet>