<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
  xmlns:fo="http://www.w3.org/1999/XSL/Format">
  <xsl:decimal-format name="nf" decimal-separator="," grouping-separator="." />
  <xsl:variable name="path" select="'WEB-INF'"/>
  <xsl:template match="/">
    <fo:root>
      <fo:layout-master-set>
        <fo:simple-page-master master-name="portrait_first"
                  page-height="29.7cm"
                  page-width="21cm"
                  margin-top="0mm"
                  margin-bottom="5mm"
                  margin-left="0mm"
                  margin-right="0mm">
           <fo:region-before extent="6cm"/>
           <fo:region-body margin-top="70mm" margin-left="22mm" margin-right="22mm" margin-bottom="27mm"/>
           <fo:region-after region-name="after_first" extent="2.5cm"/>
        </fo:simple-page-master>
        <fo:simple-page-master master-name="portrait"
                  page-height="29.7cm"
                  page-width="21cm"
                  margin-top="15mm"
                  margin-bottom="5mm"
                  margin-left="22mm"
                  margin-right="22mm">
           <fo:region-body margin-bottom="15mm"/>
           <fo:region-after region-name="after" extent="10mm"/>
        </fo:simple-page-master>
        <fo:page-sequence-master master-name="psm" >
	      <fo:repeatable-page-master-alternatives>
		    <fo:conditional-page-master-reference master-reference="portrait_first" page-position="first" />
		    <fo:conditional-page-master-reference master-reference="portrait" page-position="rest" />
  	  	    <!-- recommended fallback procedure -->
		    <fo:conditional-page-master-reference master-reference="portrait" />
          </fo:repeatable-page-master-alternatives>
        </fo:page-sequence-master>
       </fo:layout-master-set>


       <fo:page-sequence master-reference="psm">
          <fo:static-content flow-name="xsl-region-before">
            <fo:block text-align="center" font-family="Times">
              <fo:external-graphic height="3cm" space-before="5mm">
                <xsl:attribute name="src">url('<xsl:value-of select="$path"/>/xsl/pdf/img/logo_new.jpg')</xsl:attribute>
              </fo:external-graphic>
              <fo:block space-before="5mm">WEGBEREITER FR SEELISCH-GEISTIGE UND KRPERLICHE</fo:block>
              <fo:block>VITALITT UND GESUNDHEIT</fo:block>
            </fo:block>
          </fo:static-content>
          <fo:static-content flow-name="after_first">
           <fo:block text-align="center" font-size="7pt" font-family="Times">
			  <fo:block><fo:inline font-weight="bold">EVOLUTION Handelsgesellschaft m.b.H.   Zentrale:</fo:inline> A-9500 Villach, Hausergasse 28</fo:block>
			  <fo:block><fo:inline font-weight="bold">Geschftsfhrer:</fo:inline> Herbert Schamberger   <fo:inline font-weight="bold">Auslieferungslager:</fo:inline> A-9500 Villach, Gerbergasse 32</fo:block>
			  <fo:block><fo:inline font-weight="bold">Firmenbuch:</fo:inline> Handelsgericht Klagenfurt, FN 211534 f   Erfllungsort und Gerichtsstand ist Villach   <fo:inline font-weight="bold">ATU</fo:inline> 52537606   <fo:inline font-weight="bold">Steuernummer/D</fo:inline> 147/695/17307</fo:block>
			  <fo:block><fo:inline font-weight="bold">Bankverbindung Bank Austria:</fo:inline> BLZ 12000 <xsl:text>-</xsl:text> Kto. Nr. 505 756 108 00 <xsl:text>-</xsl:text> IBAN AT 07 12000 505 75610800 <xsl:text>-</xsl:text> Swift: BKAUATWW</fo:block>
			  <fo:block><fo:inline font-weight="bold">Deutschland</fo:inline> IBAN DE 07700202700665876594 <xsl:text>-</xsl:text>  Swift: HYVEDEMMXXX</fo:block>  
            </fo:block>
          </fo:static-content>
	      <fo:static-content flow-name="after">
            <fo:block text-align="center" font-size="10pt">
              <fo:page-number/>&#160;/&#160;<fo:page-number-citation ref-id="end"/>
            </fo:block>
          </fo:static-content>
          <fo:flow flow-name="xsl-region-body">
            <fo:block font-size="8pt" line-height="12pt">
              <xsl:choose>
                <xsl:when test="/*/detail">
                  <xsl:apply-templates select="evolution/names/item"/>
                </xsl:when>
                <xsl:otherwise>
                  <xsl:apply-templates select="evolution/names//item">
                    <xsl:sort select="@Name"/>
                  </xsl:apply-templates>
                </xsl:otherwise>
              </xsl:choose>
              <fo:block id="end"/>
            </fo:block>
          </fo:flow>
       </fo:page-sequence>
     </fo:root>
  </xsl:template>

  <!-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->

  <xsl:template name="managerbonuslevelbonus">
    <xsl:param name="level"/>
    <xsl:param name="src"/>
    <xsl:param name="active"/>

    <xsl:variable name="children" select="$src//item[@ActiveSponsor=$src/@Id and @LevelId >= 300]"/>
    <xsl:choose>
      <xsl:when test="$level > 1">
        <xsl:variable name="res">
          <total>
            <xsl:choose>
              <xsl:when test="$active > 0">
                <xsl:variable name="children" select="$src//item[@ActiveSponsor=$src/@Id and @LevelId >= 300]"/>
                <xsl:for-each select="$children">
                  <item>
                    <xsl:call-template name="managerbonuslevelbonus">
                      <xsl:with-param name="level" select="$level - 1"/>
                      <xsl:with-param name="src" select="."/>
                      <xsl:with-param name="active" select="$active"/>
                    </xsl:call-template>
                  </item>
                </xsl:for-each>
              </xsl:when>
              <xsl:otherwise>
                <xsl:variable name="children" select="$src/item[@LevelId >= 300]"/>
                <xsl:for-each select="$children">
                  <item>
                    <xsl:call-template name="managerbonuslevelbonus">
                      <xsl:with-param name="level" select="$level - 1"/>
                      <xsl:with-param name="src" select="."/>
                      <xsl:with-param name="active" select="$active"/>
                    </xsl:call-template>
                  </item>
                </xsl:for-each>
              </xsl:otherwise>
            </xsl:choose>
          </total>
        </xsl:variable>
        <xsl:variable name="resnodeset" select="$res"/>
        <xsl:value-of select="sum($resnodeset/total/item)"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:choose>
          <xsl:when test="$active > 0">
            <xsl:variable name="children" select="$src//item[@ActiveSponsor=$src/@Id and @LevelId >= 300]"/>
            <xsl:value-of select="sum($children/@TotalBonus)"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:variable name="children" select="$src/item[@LevelId >= 300]"/>
            <xsl:value-of select="sum($children/@TotalBonus)"/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <!-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->

  <xsl:template name="managerbonuslevel">
    <xsl:param name="level"/>
    <xsl:param name="level2" select="$level"/>
    <xsl:param name="src"/>
    <xsl:param name="active"/>

    <xsl:choose>
      <xsl:when test="$level > 1">
        <xsl:choose>
          <xsl:when test="$active > 0">
            <xsl:variable name="children" select="$src//item[@ActiveSponsor=$src/@Id and @LevelId >= 300]"/>
            <xsl:for-each select="$children">          
              <xsl:call-template name="managerbonuslevel">
                <xsl:with-param name="level" select="$level - 1"/>
                <xsl:with-param name="level2" select="$level2"/>
                <xsl:with-param name="src" select="."/>
                <xsl:with-param name="active" select="$active"/>
              </xsl:call-template>
            </xsl:for-each>
          </xsl:when>
          <xsl:otherwise>
            <xsl:variable name="children" select="$src/item[@LevelId >= 300]"/>
            <xsl:for-each select="$children">          
              <xsl:call-template name="managerbonuslevel">
                <xsl:with-param name="level" select="$level - 1"/>
                <xsl:with-param name="level2" select="$level2"/>
                <xsl:with-param name="src" select="."/>
                <xsl:with-param name="active" select="$active"/>
              </xsl:call-template>
            </xsl:for-each>
          </xsl:otherwise>
        </xsl:choose>  
      </xsl:when>
      <xsl:otherwise>
        <xsl:choose>
          <xsl:when test="$active > 0">
            <xsl:variable name="children" select="$src//item[@ActiveSponsor=$src/@Id and @LevelId >= 300]"/>
            <xsl:for-each select="$children">
              <xsl:variable name="src" select="."/>
              <xsl:if test="@TotalNetto > 0">
                <fo:table-row>
                  <xsl:variable name="LevelName" select="/*/levels/item[@Id=$src/@LevelId]/@Name"/>
                  <xsl:variable name="Name" select="/*/names//item[@Id=$src/@Id]/@Name"/>
                  <fo:table-cell><fo:block><xsl:value-of select="$src/@Id"/>&#160;<xsl:value-of select="$Name"/></fo:block></fo:table-cell>
                  <fo:table-cell><fo:block><xsl:value-of select="$LevelName"/>&#160;</fo:block></fo:table-cell>
                  <fo:table-cell><fo:block/></fo:table-cell>
                  <fo:table-cell><fo:block text-align="end"><xsl:value-of select="format-number($src/@TotalBonus, '0,00', 'nf')"/></fo:block></fo:table-cell>
                  <fo:table-cell><fo:block/></fo:table-cell>
                </fo:table-row>
              </xsl:if>
            </xsl:for-each>
          </xsl:when>
          <xsl:otherwise>
            <xsl:variable name="children" select="$src/item[@LevelId >= 300]"/>
            <xsl:for-each select="$children">
              <xsl:variable name="src" select="."/>
              <xsl:if test="@TotalNetto > 0">
                <fo:table-row>
                  <xsl:variable name="LevelName" select="/*/levels/item[@Id=$src/@LevelId]/@Name"/>
                  <xsl:variable name="Name" select="/*/names//item[@Id=$src/@Id]/@Name"/>
                  <fo:table-cell><fo:block><xsl:value-of select="$src/@Id"/>&#160;<xsl:value-of select="$Name"/></fo:block></fo:table-cell>
                  <fo:table-cell><fo:block><xsl:value-of select="$LevelName"/>&#160;</fo:block></fo:table-cell>
                  <fo:table-cell><fo:block/></fo:table-cell>
                  <fo:table-cell><fo:block text-align="end"><xsl:value-of select="format-number($src/@TotalBonus, '0,00', 'nf')"/></fo:block></fo:table-cell>
                  <fo:table-cell><fo:block/></fo:table-cell>
                </fo:table-row>
              </xsl:if>
            </xsl:for-each>
          </xsl:otherwise>
        </xsl:choose>  
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <!-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->

  <xsl:template name="managerbonusleveltotal">
    <xsl:param name="level"/>
    <xsl:param name="src"/>
    <xsl:param name="active"/>
    
    <xsl:variable name="totalBonus">
      <xsl:call-template name="managerbonuslevelbonus">
        <xsl:with-param name="level" select="$level"/>
        <xsl:with-param name="src" select="$src"/>
        <xsl:with-param name="active" select="$active"/>
      </xsl:call-template>
    </xsl:variable>
    
    <fo:table-row>
      <fo:table-cell><fo:block font-weight="bold">Total <xsl:value-of select="$level"/>. Ebene</fo:block></fo:table-cell>
      <fo:table-cell><fo:block/></fo:table-cell>
      <fo:table-cell><fo:block/></fo:table-cell>
      <fo:table-cell><fo:block font-weight="bold" text-align="end"><xsl:value-of select="format-number($totalBonus, '0,00', 'nf')"/></fo:block></fo:table-cell>
      <fo:table-cell><fo:block/></fo:table-cell>
    </fo:table-row>
  </xsl:template>

  <!-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->

  <xsl:template name="managerbonuslevelsummary">
    <xsl:param name="level"/>
    <xsl:param name="value"/>
    <xsl:param name="src"/>
    <xsl:param name="active"/>

    <xsl:variable name="bonus">
      <xsl:call-template name="managerbonuslevelbonus">
        <xsl:with-param name="level" select="$level"/>
        <xsl:with-param name="src" select="$src"/>
        <xsl:with-param name="active" select="$active"/>
      </xsl:call-template>
    </xsl:variable>

    <xsl:variable name="factor">
      <xsl:choose>
        <xsl:when test="$bonus=0">0</xsl:when>
        <xsl:otherwise><xsl:value-of select="($value * 100) div $bonus"/></xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <fo:table-row>
      <fo:table-cell><fo:block>Teambonus <xsl:value-of select="$level"/>. Ebene</fo:block></fo:table-cell>
      <fo:table-cell><fo:block><xsl:if test="$factor = 0 and $bonus > 0"><xsl:text>Qualifikation nicht erreicht</xsl:text></xsl:if></fo:block></fo:table-cell>
      <fo:table-cell><fo:block text-align="end"><xsl:value-of select="format-number($bonus, '0,00', 'nf')"/></fo:block></fo:table-cell>
      <fo:table-cell><fo:block text-align="end"><xsl:value-of select="format-number($factor, '0,0', 'nf')"/>&#160;%</fo:block></fo:table-cell>
      <fo:table-cell><fo:block text-align="end"><xsl:value-of select="format-number($value, '0,00', 'nf')"/></fo:block></fo:table-cell>
    </fo:table-row>
  </xsl:template>

  <!-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->

  <xsl:template name="moredetails">
    <xsl:param name="src"/>
    <xsl:variable name="Id" select="$src/@Id"/>
    <xsl:variable name="LevelId" select="@Id"/>
    <xsl:variable name="levelsrc" select="/*/levels/item[@Id=$LevelId]"/>
    
    <!-- personal -->
    <xsl:variable name="namesrc" select="/*/names//item[@Id=$Id]"/>

    <fo:table-row>
      <fo:table-cell><fo:block font-weight="bold"><xsl:value-of select="$Id"/>&#160;<xsl:value-of select="$namesrc/@Name"/></fo:block></fo:table-cell>
      <fo:table-cell><fo:block font-weight="bold"><xsl:value-of select="$levelsrc/@Name"/></fo:block></fo:table-cell>
      <fo:table-cell><fo:block text-align="end" font-weight="bold"/></fo:table-cell>
      <fo:table-cell><fo:block text-align="end" font-weight="bold"><xsl:value-of select="format-number($src/@PersonalBonus, '0,00', 'nf')"/></fo:block></fo:table-cell>
      <fo:table-cell><fo:block text-align="end" font-weight="bold"><xsl:value-of select="format-number($src/@PersonalTradeMargin, '0,00', 'nf')"/></fo:block></fo:table-cell>
    </fo:table-row>

    <!-- level 1 downline -->

    <xsl:for-each select="/*/levels/item[@Id &lt; 300]">
      <xsl:variable name="Level" select="@Id"/>
      <xsl:variable name="LevelName" select="@Name"/>
      <xsl:variable name="TBF" select="1"/>
      <xsl:variable name="bonussrc" select="$src/item[@LevelId=$Level and @PersonalBonus > 0]"/>
      <xsl:for-each select="$namesrc/item">
        <xsl:variable name="Id2" select="@Id"/>
        <xsl:variable name="childsrc" select="$bonussrc[@Id = $Id2]"/>
        <xsl:if test="$childsrc">
          <fo:table-row>
            <fo:table-cell><fo:block><xsl:value-of select="@Id"/>&#160;<xsl:value-of select="@Name"/></fo:block></fo:table-cell>
            <fo:table-cell><fo:block><xsl:value-of select="$LevelName"/></fo:block></fo:table-cell>
            <fo:table-cell><fo:block text-align="end"/></fo:table-cell>
            <fo:table-cell><fo:block text-align="end"><xsl:value-of select="format-number($childsrc/@PersonalBonus,'0,00', 'nf')"/></fo:block></fo:table-cell>
            <fo:table-cell><fo:block text-align="end">
              <xsl:choose>
                <xsl:when test="$TBF > 0"><xsl:value-of select="format-number($childsrc/@PersonalTradeMargin,'0,00', 'nf')"/></xsl:when>
                <xsl:otherwise>&#160;</xsl:otherwise>
              </xsl:choose>
            </fo:block></fo:table-cell>
          </fo:table-row>
        </xsl:if>
      </xsl:for-each>
        <xsl:if test="count($bonussrc)">
          <fo:table-row>
            <fo:table-cell><fo:block font-weight="bold"><xsl:text>Total</xsl:text>&#160;<xsl:value-of select="$LevelName"/></fo:block></fo:table-cell>
            <fo:table-cell><fo:block font-weight="bold"/></fo:table-cell>
            <fo:table-cell><fo:block font-weight="bold" text-align="end"/></fo:table-cell>
            <fo:table-cell><fo:block font-weight="bold" text-align="end"><xsl:value-of select="format-number(sum($bonussrc/@PersonalBonus), '0,00', 'nf')"/></fo:block></fo:table-cell>
            <fo:table-cell><fo:block font-weight="bold" text-align="end">
            <xsl:choose>
              <xsl:when test="$TBF > 0">
                <xsl:value-of select="format-number(sum($bonussrc/@PersonalTradeMargin), '0,00', 'nf')"/>
              </xsl:when>
              <xsl:otherwise>&#160;</xsl:otherwise>
            </xsl:choose>
          </fo:block></fo:table-cell>
        </fo:table-row>
      </xsl:if>
    </xsl:for-each>

    <!-- manager downline -->
    <xsl:variable name="active"><xsl:value-of select="sum($src/@TotalBonus)"/></xsl:variable>

    <xsl:call-template name="managerbonuslevel">
      <xsl:with-param name="src" select="$src"/><xsl:with-param name="level" select="1"/><xsl:with-param name="active" select="$active"/>
    </xsl:call-template>
    <xsl:call-template name="managerbonusleveltotal">
      <xsl:with-param name="src" select="$src"/><xsl:with-param name="level" select="1"/><xsl:with-param name="active" select="$active"/>
    </xsl:call-template>
    <xsl:call-template name="managerbonuslevel">
      <xsl:with-param name="src" select="$src"/><xsl:with-param name="level" select="2"/><xsl:with-param name="active" select="$active"/>
    </xsl:call-template>
    <xsl:call-template name="managerbonusleveltotal">
      <xsl:with-param name="src" select="$src"/><xsl:with-param name="level" select="2"/><xsl:with-param name="active" select="$active"/>
    </xsl:call-template>
    <xsl:call-template name="managerbonuslevel">
      <xsl:with-param name="src" select="$src"/><xsl:with-param name="level" select="3"/><xsl:with-param name="active" select="$active"/>
    </xsl:call-template>
    <xsl:call-template name="managerbonusleveltotal">
      <xsl:with-param name="src" select="$src"/><xsl:with-param name="level" select="3"/><xsl:with-param name="active" select="$active"/>
    </xsl:call-template>

    <!-- summary -->

    <fo:table-row>
      <fo:table-cell><fo:block font-weight="bold" text-align="end"/></fo:table-cell>
      <fo:table-cell><fo:block font-weight="bold" text-align="end">Bonuswert</fo:block></fo:table-cell>
      <fo:table-cell><fo:block font-weight="bold" text-align="end">%</fo:block></fo:table-cell>
      <fo:table-cell><fo:block font-weight="bold" text-align="end">Bonus</fo:block></fo:table-cell>
    </fo:table-row>

    <!-- personal -->

    <fo:table-row>
      <xsl:variable name="value"><xsl:value-of select="sum($src/@DistributorBonus)"/></xsl:variable>
      <xsl:variable name="bonus"><xsl:value-of select="sum($src/@TotalBonus)"/></xsl:variable>
      <xsl:variable name="factor">
        <xsl:choose>
          <xsl:when test="$bonus=0">0</xsl:when>
          <xsl:otherwise><xsl:value-of select="($value * 100) div $bonus"/></xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <fo:table-cell><fo:block>EV</fo:block></fo:table-cell>
      <fo:table-cell><fo:block/></fo:table-cell>
      <fo:table-cell><fo:block text-align="end"><xsl:value-of select="format-number($bonus, '0,00', 'nf')"/></fo:block></fo:table-cell>
      <fo:table-cell><fo:block text-align="end"><xsl:value-of select="format-number($factor, '0,0', 'nf')"/>&#160;%</fo:block></fo:table-cell>
      <fo:table-cell><fo:block text-align="end"><xsl:value-of select="format-number($value, '0,00', 'nf')"/></fo:block></fo:table-cell>
    </fo:table-row>

    <xsl:call-template name="managerbonuslevelsummary">
      <xsl:with-param name="src" select="$src"/>
      <xsl:with-param name="level" select="1"/>
      <xsl:with-param name="value" select="sum($src/@TeamBonusLevel1)"/>
      <xsl:with-param name="active" select="$active"/>
    </xsl:call-template>
    <xsl:call-template name="managerbonuslevelsummary">
      <xsl:with-param name="src" select="$src"/>
      <xsl:with-param name="level" select="2"/>
      <xsl:with-param name="value" select="sum($src/@TeamBonusLevel2)"/>
      <xsl:with-param name="active" select="$active"/>
    </xsl:call-template>
    <xsl:call-template name="managerbonuslevelsummary">
      <xsl:with-param name="src" select="$src"/>
      <xsl:with-param name="level" select="3"/>
      <xsl:with-param name="value" select="sum($src/@TeamBonusLevel3)"/>
      <xsl:with-param name="active" select="$active"/>
    </xsl:call-template>

    <!-- trade margin -->
    <fo:table-row>
      <fo:table-cell><fo:block>Handelsspanne</fo:block></fo:table-cell>
      <fo:table-cell><fo:block/></fo:table-cell>
      <fo:table-cell><fo:block text-align="end"/></fo:table-cell>
      <fo:table-cell><fo:block text-align="end"/></fo:table-cell>
      <fo:table-cell><fo:block text-align="end"><xsl:value-of select="format-number(sum($src/@TotalTradeMargin), '0,00', 'nf')"/></fo:block></fo:table-cell>
    </fo:table-row>
    
  </xsl:template>

  <!-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->

  <xsl:template name="details">
    <xsl:variable name="Id" select="@Id"/>
    <xsl:variable name="src" select="/*/bonus//item[@Id=$Id]"/>
    <xsl:if test="$src">
        <xsl:variable name="MVF">1</xsl:variable>
 
        <fo:table-row><fo:table-cell number-columns-spanned="5"><fo:block/></fo:table-cell></fo:table-row>
        <fo:table-row>
          <fo:table-cell number-columns-spanned="5">
            <fo:table>
              <fo:table-column column-width="90mm"/>
              <fo:table-column column-width="18mm"/>
              <fo:table-column column-width="18mm"/>
              <fo:table-column column-width="18mm"/>
              <fo:table-column column-width="18mm"/>
              <fo:table-body>
                <fo:table-row>
                  <fo:table-cell><fo:block font-weight="bold"/></fo:table-cell>
                  <fo:table-cell><fo:block font-weight="bold" text-align="end">EV</fo:block></fo:table-cell>
                  <fo:table-cell><fo:block font-weight="bold" text-align="end">TV1</fo:block></fo:table-cell>
                  <fo:table-cell><fo:block font-weight="bold" text-align="end">TV2</fo:block></fo:table-cell>
                  <fo:table-cell><fo:block font-weight="bold" text-align="end">TV3</fo:block></fo:table-cell>
                </fo:table-row>
                <fo:table-row>
                  <fo:table-cell><fo:block font-weight="bold"/></fo:table-cell>
                  <fo:table-cell><fo:block font-weight="bold" text-align="end"><xsl:value-of select="format-number(sum($src/@TotalBonus) * $MVF, '0,00', 'nf')"/></fo:block></fo:table-cell>
                  <fo:table-cell><fo:block font-weight="bold" text-align="end"><xsl:value-of select="format-number(sum($src/@TotalBonusLevel1) * $MVF, '0,00', 'nf')"/></fo:block></fo:table-cell>
                  <fo:table-cell><fo:block font-weight="bold" text-align="end"><xsl:value-of select="format-number(sum($src/@TotalBonusLevel2) * $MVF, '0,00', 'nf')"/></fo:block></fo:table-cell>
                  <fo:table-cell><fo:block font-weight="bold" text-align="end"><xsl:value-of select="format-number(sum($src/@TotalBonusLevel3) * $MVF, '0,00', 'nf')"/></fo:block></fo:table-cell>
                </fo:table-row>
              </fo:table-body>
            </fo:table>
          </fo:table-cell>
        </fo:table-row>
        <fo:table-row><fo:table-cell number-columns-spanned="5"><fo:block/></fo:table-cell></fo:table-row>
        <fo:table-row>
          <fo:table-cell number-columns-spanned="3"><fo:block/></fo:table-cell>
          <fo:table-cell><fo:block font-weight="bold" text-align="end">Bonuswert</fo:block></fo:table-cell>
          <fo:table-cell><fo:block font-weight="bold" text-align="end">Handelsspanne</fo:block></fo:table-cell>
        </fo:table-row>
        <xsl:call-template name="moredetails">
          <xsl:with-param name="src" select="$src"/>
        </xsl:call-template>
    </xsl:if>
  </xsl:template>
  
  <!-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->

  <xsl:template match="item">
    <xsl:variable name="Id" select="@Id"/>
    <xsl:variable name="LevelId" select="@LevelId"/>
    <xsl:variable name="bonus" select="/*/bonus//item[@Id = $Id]"/>
    <xsl:if test="$bonus and $Id > 0 and $bonus/@TotalBonus + $bonus/@TotalBonusLevel1 + $bonus/@TotalBonusLevel2 + $bonus/@TotalBonusLevel3 > 0 ">
    <fo:table table-layout="fixed">
      <fo:table-column column-width="65mm"/>
      <fo:table-column column-width="38mm"/>
      <fo:table-column column-width="19mm"/>
      <fo:table-column column-width="19mm"/>
      <fo:table-column column-width="24mm"/>
      <fo:table-body>

     <fo:table-row>
        <fo:table-cell number-columns-spanned="2">
          <fo:block font-size="12pt" font-family="Times" line-height="14pt">
            <xsl:value-of select="@L"/>
            <xsl:text> </xsl:text><xsl:value-of select="@T"/><xsl:value-of select="@Name"/>
            <xsl:value-of select="@Address"/>
          </fo:block>
        </fo:table-cell>
        <fo:table-cell number-columns-spanned="3">
          <fo:block font-size="12pt" text-align="right" font-family="Times" line-height="14pt">
          </fo:block>
        </fo:table-cell>
      </fo:table-row>
      <fo:table-row>
        <fo:table-cell number-columns-spanned="2">
          <fo:block font-size="12pt" font-family="Times" line-height="14pt">
            <xsl:value-of select="@Street"/>
          </fo:block>
        </fo:table-cell>
        <fo:table-cell number-columns-spanned="3">
          <fo:block font-size="12pt" text-align="right" font-family="Times" line-height="14pt">
            <xsl:value-of select="/*/levels/item[@Id=$LevelId]/@Name"/>
          </fo:block>
        </fo:table-cell>
      </fo:table-row>
      <fo:table-row>
        <fo:table-cell>
          <fo:block font-size="12pt" font-family="Times" line-height="14pt">
            <xsl:value-of select="@Country"/>-<xsl:value-of select="@ZipCode"/>&#160;<xsl:value-of select="@City"/>
          </fo:block>
        </fo:table-cell>
        <fo:table-cell number-columns-spanned="4">
          <fo:block font-size="12pt" text-align="right" font-family="Times" line-height="14pt">
            <xsl:text>UID:</xsl:text>&#160;<xsl:value-of select="@VatID"/></fo:block>
        </fo:table-cell>
      </fo:table-row>
      <fo:table-row>
        <fo:table-cell>
          <fo:block font-size="12pt" font-family="Times" line-height="14pt">
            <xsl:value-of select="@Id"/>
          </fo:block>
        </fo:table-cell>
        <fo:table-cell number-columns-spanned="4">
          <fo:block font-size="12pt" text-align="right" font-family="Times" line-height="14pt">
            <xsl:text>Bonusabrechnung fr den Zeitraum</xsl:text>&#160;<xsl:value-of select="/*/month/@Value"/></fo:block>
        </fo:table-cell>
      </fo:table-row>
      <fo:table-row>
        <fo:table-cell number-columns-spanned="5">
          <fo:block font-size="12pt" space-before="16pt" font-family="Times" line-height="16pt">
            <xsl:text>Gratulation! Sie haben (mit Ihrem Team) im oben angegebenen Zeitraum </xsl:text>
            <xsl:text>folgendes Ergebnis bei EVOLUTION erreicht:</xsl:text>
          </fo:block>
        </fo:table-cell>
      </fo:table-row>

      <fo:table-row>
         <fo:table-cell number-columns-spanned="5">
           <fo:block line-height="1mm" space-before="4pt" space-after="14pt"><fo:leader leader-pattern="rule" leader-length="100%"/></fo:block>
         </fo:table-cell>
      </fo:table-row>

      
      <xsl:call-template name="details"/>

      <xsl:variable name="MWSt" select="sum(@MWSt)"/>

      <xsl:variable name="src" select="/*/bonus//item[@Id=$Id]"/>
      
      <xsl:variable name="DB" select="sum($src/@DistributorBonus)"/>
      <xsl:variable name="TB" select="sum($src/@TotalTradeMargin)"/>
      
      <xsl:variable name="MB1" select="sum($src/@TeamBonusLevel1)"/>
      <xsl:variable name="MB2" select="sum($src/@TeamBonusLevel2)"/>
      <xsl:variable name="MB3" select="sum($src/@TeamBonusLevel3)"/>
      <xsl:variable name="MB" select="$MB1 + $MB2 + $MB3"/>
      
      <xsl:variable name="aDB">0<xsl:if test="$DB > 0"><xsl:value-of select="$DB"/></xsl:if></xsl:variable>
      <xsl:variable name="aMB">0<xsl:if test="$MB > 0"><xsl:value-of select="$MB"/></xsl:if></xsl:variable>
      <xsl:variable name="aTB">0<xsl:if test="$TB > 0"><xsl:value-of select="$TB"/></xsl:if></xsl:variable>

      <xsl:variable name="abonus" select="$aDB + $aMB + $aTB"/>
      <xsl:variable name="bonus">
        <xsl:choose>
          <xsl:when test="$abonus > 0"><xsl:value-of select="$abonus"/></xsl:when>
          <xsl:otherwise>0</xsl:otherwise>
        </xsl:choose>
      </xsl:variable>

      <fo:table-row>
        <fo:table-cell><fo:block font-weight="bold">Bonus</fo:block></fo:table-cell>
        <fo:table-cell number-columns-spanned="3"><fo:block>
          <xsl:text>&#160;</xsl:text>
          <xsl:if test="$DB &lt; 0"><xsl:text>Qualifikation nicht erreicht</xsl:text></xsl:if>
        </fo:block></fo:table-cell>
        <fo:table-cell><fo:block text-align="end"><xsl:value-of select="format-number(translate($DB,'-',0), '0,00', 'nf')"/></fo:block></fo:table-cell>
      </fo:table-row>
      <fo:table-row>
        <fo:table-cell><fo:block font-weight="bold">Teambonus</fo:block></fo:table-cell>
        <fo:table-cell number-columns-spanned="3"><fo:block>
          <xsl:text>&#160;</xsl:text>
          <xsl:if test="$MB &lt; 0"><xsl:text>Qualifikation nicht erreicht</xsl:text></xsl:if>
        </fo:block></fo:table-cell>
        <fo:table-cell><fo:block text-align="end"><xsl:value-of select="format-number(translate($MB,'-',0), '0,00', 'nf')"/></fo:block></fo:table-cell>
      </fo:table-row>
      <fo:table-row>
        <fo:table-cell><fo:block font-weight="bold">Handelsspanne</fo:block></fo:table-cell>
        <fo:table-cell number-columns-spanned="3"><fo:block>
          <xsl:text>&#160;</xsl:text>
          <xsl:if test="$TB &lt; 0"><xsl:text>Qualifikation nicht erreicht</xsl:text></xsl:if>
        </fo:block></fo:table-cell>
        <fo:table-cell><fo:block text-align="end"><xsl:value-of select="format-number(translate($TB,'-',0), '0,00', 'nf')"/></fo:block></fo:table-cell>
      </fo:table-row>
      <fo:table-row>
        <fo:table-cell number-columns-spanned="5"><fo:block/></fo:table-cell>
      </fo:table-row>

      <fo:table-row>
        <fo:table-cell number-columns-spanned="4"><fo:block font-weight="bold">Total Bonus</fo:block></fo:table-cell>
        <fo:table-cell><fo:block text-align="end"><xsl:value-of select="format-number(round($bonus * 100) * .01, '0,00', 'nf')"/></fo:block></fo:table-cell>
      </fo:table-row>
      <xsl:choose>
        <xsl:when test="substring(@Id, 1, 2) = '43'">
          <fo:table-row>
      	    <fo:table-cell number-columns-spanned="4"><fo:block font-weight="bold">MwSt&#160;<xsl:value-of select="$MWSt"/>&#160;%</fo:block></fo:table-cell>
            <fo:table-cell><fo:block text-align="end"><xsl:value-of select="format-number(round($bonus * $MWSt) * 0.01, '0,00', 'nf')"/></fo:block></fo:table-cell>
	      </fo:table-row>
	      <fo:table-row>
            <fo:table-cell number-columns-spanned="4"><fo:block font-weight="bold">berweisungsbetrag</fo:block></fo:table-cell>
	        <fo:table-cell><fo:block text-align="end"><xsl:value-of select="format-number((round($bonus * 100) + round($bonus * $MWSt)) * 0.01, '0,00', 'nf')"/></fo:block></fo:table-cell>
	      </fo:table-row>
	    </xsl:when>
	    <xsl:otherwise>
          <xsl:if test="string-length(@VatID) &gt; 5 and not(substring(@Id, 1, 2) = '41')">
            <fo:table-row>
              <fo:table-cell number-columns-spanned="5"><fo:block>Die Steuerschuld geht ber auf Empfnger.</fo:block></fo:table-cell>
	        </fo:table-row>
	      </xsl:if>	    
	    </xsl:otherwise>
	  </xsl:choose>
	</fo:table-body>
	</fo:table>
    </xsl:if>
  </xsl:template>

  <!-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->

</xsl:stylesheet>
