<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
  <xsl:decimal-format name="nf" decimal-separator="," grouping-separator="." /> 
  
  <!-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->

  <xsl:template match="/">
    <fo:root>
      <fo:layout-master-set>

      <!-- layout for the first page -->
        <fo:simple-page-master master-name="portrait"
                  page-height="29.7cm" 
                  page-width="21cm"
                  margin-top="15mm" 
                  margin-bottom="15mm" 
                  margin-left="15mm" 
                  margin-right="15mm">
           <fo:region-body margin-top="10mm"/>
           <fo:region-before extent="10mm"/>
         </fo:simple-page-master>
       </fo:layout-master-set>
       
       <fo:page-sequence master-reference="portrait">
          <fo:static-content flow-name="xsl-region-before">
             <fo:block text-align="center" font-size="12pt" font-weight="bold">
               <xsl:value-of select="/*/header/@title"/>
             </fo:block>
             <fo:block  text-align="center" font-size="10pt" font-weight="bold">
               <xsl:value-of select="/*/header/@subtitle"/>
            </fo:block>
          </fo:static-content>

          <fo:flow flow-name="xsl-region-body">
            <fo:block font-size="12pt" line-height="16pt" font-family="Times">
              <fo:table table-layout="fixed">
                <fo:table-column column-width="42mm"/>
                <fo:table-column column-width="25mm"/>
                <fo:table-column column-width="42mm"/>
                <fo:table-column column-width="18mm"/>
                <fo:table-column column-width="38mm"/>
                <fo:table-column column-width="15mm"/>
                <fo:table-body>
                  <xsl:if test="//bank">
                    <xsl:apply-templates select="*"/>
                    <fo:table-row>
                      <fo:table-cell number-columns-spanned="6"><fo:block space-before="5mm"/></fo:table-cell>
                    </fo:table-row>
                    <fo:table-row>
                      <fo:table-cell number-columns-spanned="4"><fo:block/></fo:table-cell>
                      <fo:table-cell><fo:block font-weight="bold">Total:</fo:block></fo:table-cell>
                      <fo:table-cell><fo:block text-align="end"><xsl:value-of select="format-number(sum(//bank/order/@Val), '0,00',   'nf')"/></fo:block></fo:table-cell>
                    </fo:table-row>
                  </xsl:if>
                  <xsl:if test="//creditcard[@Organization='Visa']">
                    <xsl:apply-templates select="*" mode="Visa"/>
                    <fo:table-row>
                      <fo:table-cell number-columns-spanned="6"><fo:block space-before="5mm"/></fo:table-cell>
                    </fo:table-row>
                    <fo:table-row>
                      <fo:table-cell number-columns-spanned="3"><fo:block/></fo:table-cell>
                      <fo:table-cell number-columns-spanned="2"><fo:block font-weight="bold">Total Visa:</fo:block></fo:table-cell>
                      <fo:table-cell><fo:block text-align="end"><xsl:value-of select="format-number(sum(//creditcard[@Organization='Visa']/order/@Val), '0,00',   'nf')"/></fo:block></fo:table-cell>
                    </fo:table-row>
                  </xsl:if>
                  <xsl:if test="//creditcard[@Organization='Mastercard']">
                    <fo:table-row>
                      <fo:table-cell number-columns-spanned="6">
                        <fo:block>
                          <xsl:if test="//creditcard[@Organization='Visa']">
                            <xsl:attribute name="break-before">page</xsl:attribute>
                          </xsl:if>
                        </fo:block>
                      </fo:table-cell>
                    </fo:table-row>
                    <xsl:apply-templates select="*" mode="Mastercard"/>
                    <fo:table-row>
                      <fo:table-cell number-columns-spanned="6"><fo:block space-before="5mm"/></fo:table-cell>
                    </fo:table-row>
                    <fo:table-row>
                      <fo:table-cell number-columns-spanned="3"><fo:block/></fo:table-cell>
                      <fo:table-cell number-columns-spanned="2"><fo:block font-weight="bold">Total Mastercard:</fo:block></fo:table-cell>
                      <fo:table-cell><fo:block text-align="end"><xsl:value-of select="format-number(sum(//creditcard[@Organization='Mastercard']/order/@Val), '0,00',   'nf')"/></fo:block></fo:table-cell>
                    </fo:table-row>
                  </xsl:if>
                </fo:table-body>
              </fo:table>
            </fo:block>
          </fo:flow>
       </fo:page-sequence>
     </fo:root>
  </xsl:template>


  <xsl:template match="distributor" mode="Visa">
    <xsl:variable name="src" select="creditcard[@Organization='Visa']"/>
    <xsl:if test="$src">
      <fo:table-row>
        <fo:table-cell number-columns-spanned="6"><fo:block space-before="5mm"/></fo:table-cell>
      </fo:table-row>
      <fo:table-row>
        <fo:table-cell><fo:block font-weight="bold">Vertr.partner/Kunde:</fo:block></fo:table-cell>
        <fo:table-cell><fo:block><xsl:value-of select="@Id"/></fo:block></fo:table-cell>
        <fo:table-cell number-columns-spanned="2"><fo:block><xsl:value-of select="@Name"/></fo:block></fo:table-cell>
        <fo:table-cell number-columns-spanned="2"><fo:block><xsl:value-of select="@Info"/></fo:block></fo:table-cell>
      </fo:table-row>
      <xsl:apply-templates select="$src"/>
    </xsl:if>
  </xsl:template>

  <xsl:template match="distributor" mode="Mastercard">
    <xsl:variable name="src" select="creditcard[@Organization='Mastercard']"/>
    <xsl:if test="$src">
      <fo:table-row>
        <fo:table-cell number-columns-spanned="6"><fo:block space-before="5mm"/></fo:table-cell>
      </fo:table-row>
      <fo:table-row>
        <fo:table-cell><fo:block font-weight="bold">Vertr.partner/Kunde:</fo:block></fo:table-cell>
        <fo:table-cell><fo:block><xsl:value-of select="@Id"/></fo:block></fo:table-cell>
        <fo:table-cell number-columns-spanned="2"><fo:block><xsl:value-of select="@Name"/></fo:block></fo:table-cell>
        <fo:table-cell number-columns-spanned="2"><fo:block><xsl:value-of select="@Info"/></fo:block></fo:table-cell>
      </fo:table-row>
      <xsl:apply-templates select="$src"/>
    </xsl:if>
  </xsl:template>
  
  <xsl:template match="distributor">
    <fo:table-row>
      <fo:table-cell number-columns-spanned="6"><fo:block space-before="5mm"/></fo:table-cell>
    </fo:table-row>
    <fo:table-row>
      <fo:table-cell><fo:block font-weight="bold">Vertr.partner/Kunde:</fo:block></fo:table-cell>
      <fo:table-cell><fo:block><xsl:value-of select="@Id"/></fo:block></fo:table-cell>
      <fo:table-cell number-columns-spanned="2"><fo:block><xsl:value-of select="@Name"/></fo:block></fo:table-cell>
      <fo:table-cell number-columns-spanned="2"><fo:block><xsl:value-of select="@Info"/></fo:block></fo:table-cell>
    </fo:table-row>
    <xsl:apply-templates select="bank"/>
  </xsl:template>
 
  <xsl:template match="bank">
    <fo:table-row>
      <fo:table-cell><fo:block font-weight="bold">Bankverbindung:</fo:block></fo:table-cell>
      <fo:table-cell><fo:block><xsl:value-of select="@AccountNumber"/></fo:block></fo:table-cell>
      <fo:table-cell><fo:block><xsl:value-of select="@BankName"/></fo:block></fo:table-cell>
      <fo:table-cell><fo:block><xsl:value-of select="@BankCode"/></fo:block></fo:table-cell>
      <fo:table-cell><fo:block font-weight="bold">Re.Total:</fo:block></fo:table-cell>
      <fo:table-cell><fo:block text-align="end"><xsl:value-of select="format-number(sum(*/@Val), '0,00', 'nf')"/></fo:block></fo:table-cell>
    </fo:table-row>
    <xsl:apply-templates select="*"/>
  </xsl:template>

  <xsl:template match="creditcard">
    <fo:table-row>
      <fo:table-cell><fo:block font-weight="bold">Kreditkarte:</fo:block></fo:table-cell>
      <fo:table-cell number-columns-spanned="2">
        <fo:block><xsl:value-of select="@CreditcartNumber"/>&#160;<xsl:value-of select="@Organization"/></fo:block>
      </fo:table-cell>
      <fo:table-cell><fo:block><xsl:value-of select="@ValidUntil"/></fo:block></fo:table-cell>
      <fo:table-cell><fo:block font-weight="bold">Re.Total:</fo:block></fo:table-cell>
      <fo:table-cell><fo:block text-align="end"><xsl:value-of select="format-number(sum(*/@Val), '0,00', 'nf')"/></fo:block></fo:table-cell>
    </fo:table-row>
    <xsl:apply-templates select="*"/>
  </xsl:template>

  <xsl:template match="order">
    <fo:table-row>
      <fo:table-cell><fo:block font-weight="bold">Bestellnummer:</fo:block></fo:table-cell>
      <fo:table-cell><fo:block><xsl:value-of select="@Id"/></fo:block></fo:table-cell>
      <fo:table-cell><fo:block font-weight="bold">Bestelldatum:</fo:block></fo:table-cell>
      <fo:table-cell><fo:block><xsl:value-of select="@Date"/></fo:block></fo:table-cell>
      <fo:table-cell><fo:block font-weight="bold">Rechnungsbetrag:</fo:block></fo:table-cell>
      <fo:table-cell><fo:block text-align="end"><xsl:value-of select="format-number(@Val, '0,00', 'nf')"/></fo:block></fo:table-cell>
    </fo:table-row>
  </xsl:template>
    
</xsl:stylesheet>