
param ($folder2zip, $path2archive, $archive, $generation)

$folder2zip_full = (Get-Item -LiteralPath "$folder2zip").FullName
$folder2zip_stem = split-path $folder2zip -leafBase
$tempdir = "..\archive"
$folder2zip_arch = "$archive#$generation.zip"

get-Host

write-host "$folder2zip zipping to ... $archive .... $folder2zip_arch" 
try
{
 Compress-Archive -ErrorAction Stop -Force -Path $folder2zip -DestinationPath "$tempdir\$folder2zip_arch"
}
catch
{
 Write-Output "something went wrong while zipping $folder2zip - $PSItem"
 throw
}
write-host "$folder2zip zipped"


write-host "$folder2zip_arch moving ..." 
try
{
 Move-Item -Path "$tempdir\$folder2zip_arch" -Destination "$path2archive\$folder2zip_arch" -Force
}
catch
{
    Write-Output "something went wrong while moving $folder2zip_arch - $PSItem"
	throw
}
write-host "$folder2zip_arch moved" 