
param ($file2zip, $path2archive)

$file2zip_full = (Get-Item -LiteralPath "$file2zip").FullName
$file2zip_stem = split-path $file2zip -leafBase
$tempdir = "..\dump"
$file2zip_arch = "$file2zip_stem.zip"

get-Host


write-host "$file2zip zipping ..." 
try
{
 Compress-Archive -ErrorAction Stop -Force -Path $file2zip -DestinationPath "$tempdir\$file2zip_arch"
}
catch
{
 Write-Output "something went wrong while zipping $file2zip - $PSItem"
 throw
}
write-host "$file2zip zipped"


write-host "$file2zip_arch moving ..." 
try
{
 Move-Item -Path "$tempdir\$file2zip_arch" -Destination "$path2archive\$file2zip_arch" -Force
}
catch
{
    Write-Output "something went wrong while moving $file2zip_arch - $PSItem"
	throw
}
write-host "$file2zip_arch moved" 


write-host "$file2zip_full temp file deleting ..." 
try
{	
Remove-Item -Path "$file2zip_full"
}
catch
{
    Write-Output "something went wrong while removing $file2zip_full - $PSItem"
	throw
}
write-host "$file2zip_full temp file deleted" 
#>
	  