 echo off

set subfolder=%1
set mysqlroot=%2
set db2dump=%3
set generation=%4
set mysqlconf=%5

set toolroot=..\..\mysql-UBIStools
set dumproot=..\dump
set archroot=\\usnas210.intranet.unicredit.it\us_mstr_at_gen$\mysql-dump\%subfolder%
set fileext=.sql  

set filesuffix=%generation%%fileext%
set dumpfile_stem=%dumproot%\%db2dump%_dump
set dumpfile=%dumpfile_stem%_%filesuffix%

set conffile=%toolroot%\conf\%mysqlconf%

echo.--------------------------------- 
echo.--- UBIS mysql dump assistant ---
echo.--------------------------------- 
echo.%date% %time% dump %db2dump% to %dumpfile% and archive to %archroot%
echo.%date% %time% using config %conffile%
echo.%date% %time% using parameter 1 - subfolder ... %subfolder%
echo.%date% %time% using parameter 2 - mysqlroot ... %mysqlroot%
echo.%date% %time% using parameter 2 - db2dump ..... %db2dump%
echo.%date% %time% using parameter 3 - generation .. %generation%
echo.%date% %time% using parameter 4 - mysqlconf ... %mysqlconf%
echo.--------------------------------- 
echo.%date% %time% start dump %db2dump% to backup folder

%mysqlroot%\bin\mysqldump.exe --defaults-extra-file="%conffile%" %db2dump% > "%dumpfile%"

rem pwsh.exe -ExecutionPolicy Bypass -Command "get-Host"

pwsh.exe -ExecutionPolicy Bypass -Command ".\CompressAndMoveDump.ps1 -file2zip '%dumpfile%' -path2archive '%archroot%'"

rem pwsh.exe -ExecutionPolicy Bypass -Command ".\RemoveSource.ps1 -file2zip '%dumpfile%'"

echo.%date% %time% ended dump %db2dump% to backup folder
echo.--- good bye --------------------- 
echo.--------------------------------- 