<?php

// the metadata connection, from the ET_CONNECTIONS keys
define('ET_METADATA_CONNECTION', 	'MySQL');
// system Zagreus connection
define('ET_ZAGREUS_CONNECTION', 	'Zagreus');

// define all the connections in the system. Names must be the same as in ET_CONNECTION metadata table
// these samples are for the 4 supported dbms
// definitions are database dependent (different databases in the same dbms needs multiple definitions)

const ET_CONNECTIONS = [
		"Oracle"=>array (
				PHPGRID_DB_TYPE						=> DB_TYPE_OCI805,
				PHPGRID_DB_DISPLAY_NAME				=> "Oracle database",
				//port is optionable
				PHPGRID_DB_HOSTNAME					=> "myhostname.com:1521",
				PHPGRID_DB_USERNAME					=> "username",
				PHPGRID_DB_PASSWORD					=> "*****",
				//simply the service name or SID=...
				PHPGRID_DB_NAME						=> "XE",
				// possible PHPGRID_DB_CHARSET values: AL32UTF8, iso-8859-2, utf-8
				PHPGRID_DB_CHARSET					=> "AL32UTF8",
				PHPGRID_DISPLAY_NUMBER_DECIMALPOINT	=> ",",
				PHPGRID_SOURCE_DATE_FORMAT			=> "Y-m-d",
				PHPGRID_DISPLAY_DATE_FORMAT 		=> "Y-m-d",
				PHPGRID_SOURCE_DATETIME_FORMAT		=> "d-b-y h:i:s,f A",
				PHPGRID_DISPLAY_DATETIME_FORMAT		=> "Y-m-d H:i:s",
				PHPGRID_CONN_TYPE 					=> CONN_TYPE_DATABASE,
				PHPGRID_DB_PW_ENCRYPTED 			=> false
		),
		"Oracle_tnsnames.ora"=>array (
				PHPGRID_DB_TYPE						=> DB_TYPE_OCI805,
				PHPGRID_DB_DISPLAY_NAME				=> "Oracle connection use tnsnames.ora",
				// PHPGRID_DB_HOSTNAME must be false
				PHPGRID_DB_HOSTNAME					=> false,
				PHPGRID_DB_USERNAME					=> "username",
				PHPGRID_DB_PASSWORD					=> "*****",
				// TNS Name defined in tnsnames.ora (or ONAMES or HOSTNAMES), eg. 'myTNS'
				PHPGRID_DB_NAME						=> "myTNS",
				// possible PHPGRID_DB_CHARSET values: AL32UTF8, iso-8859-2, utf-8
				PHPGRID_DB_CHARSET					=> "AL32UTF8",
				PHPGRID_DISPLAY_NUMBER_DECIMALPOINT	=> ",",
				PHPGRID_SOURCE_DATE_FORMAT			=> "Y-m-d",
				PHPGRID_DISPLAY_DATE_FORMAT 		=> "Y-m-d",
				PHPGRID_SOURCE_DATETIME_FORMAT		=> "d-b-y h:i:s,f A",
				PHPGRID_DISPLAY_DATETIME_FORMAT		=> "Y-m-d H:i:s",
				PHPGRID_CONN_TYPE 					=> CONN_TYPE_DATABASE,
				PHPGRID_DB_PW_ENCRYPTED 			=> false
		),
		"SQL_Server_ODBC"=>array(
				PHPGRID_DB_TYPE						=> DB_TYPE_ODBC_MSSQL,
				PHPGRID_DB_DISPLAY_NAME				=> "SQL Server",
				PHPGRID_DB_HOSTNAME					=> "odbc_connection_name",
				PHPGRID_DB_USERNAME					=> "username",
				PHPGRID_DB_PASSWORD					=> "******",
				//schema must be included!
				//if there are multiple schemas, multiple connections need to be defined
				PHPGRID_DB_NAME						=> "sample_db.dbo",
				// possible PHPGRID_DB_CHARSET values: AL32UTF8, iso-8859-2, utf-8
				PHPGRID_DB_CHARSET					=> "iso-8859-2",
				PHPGRID_DISPLAY_NUMBER_DECIMALPOINT	=> ",",
				PHPGRID_SOURCE_DATE_FORMAT			=>"Y-m-d",
				PHPGRID_DISPLAY_DATE_FORMAT			=>"Y-m-d",
				PHPGRID_SOURCE_DATETIME_FORMAT		=>"Y-m-d H:i:s.f",
				PHPGRID_DISPLAY_DATETIME_FORMAT		=>"Y-m-d H:i:s",
				PHPGRID_CONN_TYPE 					=> CONN_TYPE_DATABASE,
				PHPGRID_DB_PW_ENCRYPTED 			=> false
		),
		"SQL_Server_native"=>array(
				PHPGRID_DB_TYPE						=> DB_TYPE_MSSQL,
				PHPGRID_DB_DISPLAY_NAME				=>"SQL Server native connection",
				PHPGRID_DB_HOSTNAME					=>"myhostname.com,1433",
				PHPGRID_DB_USERNAME					=>"username",
				PHPGRID_DB_PASSWORD					=>"******",
				PHPGRID_DB_NAME						=>"my-db.my-schema",
				/*
				 * PHPGRID_DB_CHARSET accepts only 2 values in that case: SQLSRV_ENC_CHAR (as a constant) or 'UTF-8' (as a string)
				 * https://docs.microsoft.com/en-us/sql/connect/php/connection-options?view=sql-server-ver15
				 * https://www.php.net/manual/en/sqlsrv.constants.php
				 * SQLSRV_ENC_CHAR: Data is returned in 8-bit characters as specified in the code page of the Windows locale that is set on the system.
				 * Any multi-byte characters or characters that do not map into this code page are substituted with a single byte question mark (?) character.
				 * This is the default encoding.
				 */
				PHPGRID_DB_CHARSET					=>"UTF-8",
				PHPGRID_DISPLAY_NUMBER_DECIMALPOINT	=>",",
				PHPGRID_SOURCE_DATE_FORMAT			=>"Y-m-d",
				PHPGRID_DISPLAY_DATE_FORMAT			=>"Y-m-d",
				PHPGRID_SOURCE_DATETIME_FORMAT		=>"Y-m-d H:i:s.f",
				PHPGRID_DISPLAY_DATETIME_FORMAT		=>"Y-m-d H:i:s",
				PHPGRID_DB_PW_ENCRYPTED 			=> false
		),
		"Teradata_ODBC"=>array(
				PHPGRID_DB_TYPE						=> DB_TYPE_ODBC_TERADATA,
				PHPGRID_DB_DISPLAY_NAME				=> "Teradata database",
				PHPGRID_DB_HOSTNAME					=> "odbc_connection_name",
				PHPGRID_DB_USERNAME					=> "username",
				PHPGRID_DB_PASSWORD					=> "****",
				PHPGRID_DB_NAME						=> "sample_db",
				// possible PHPGRID_DB_CHARSET values: AL32UTF8, iso-8859-2, utf-8
				PHPGRID_DB_CHARSET					=> "iso-8859-2",
				PHPGRID_DISPLAY_NUMBER_DECIMALPOINT	=> ",",
				PHPGRID_SOURCE_DATE_FORMAT			=> "Y-m-d",
				PHPGRID_DISPLAY_DATE_FORMAT			=> "Y-m-d",
				PHPGRID_SOURCE_DATETIME_FORMAT 		=> "Y-m-d H:i:s.f",
				PHPGRID_DISPLAY_DATETIME_FORMAT		=> "Y-m-d H:i:s",
				// optional
				//PHPGRID_AUTH_MECHANISM=>"LDAP"
				//possible values: LDAP, TD2
				PHPGRID_CONN_TYPE 					=> CONN_TYPE_DATABASE,
				PHPGRID_DB_PW_ENCRYPTED 			=> false
		),
		"MySQL"=>array(
				PHPGRID_DB_TYPE						=> DB_TYPE_MYSQLI,
				PHPGRID_DB_DISPLAY_NAME				=> "MySQL database",
				PHPGRID_DB_HOSTNAME					=> "myhostname.com",
				PHPGRID_DB_USERNAME					=> "username",
				PHPGRID_DB_PASSWORD					=> "******",
				PHPGRID_DB_NAME						=> "sample_db",
				// possible PHPGRID_DB_CHARSET values: AL32UTF8, iso-8859-2, utf-8
				PHPGRID_DB_CHARSET					=> "utf-8",
				PHPGRID_DISPLAY_NUMBER_DECIMALPOINT	=> ",",
				PHPGRID_CONN_TYPE 					=> CONN_TYPE_DATABASE,
				PHPGRID_DB_PW_ENCRYPTED 			=> false
		),
		"Zagreus" => array (
				PHPGRID_WS_DISPLAY_NAME				=> "Zagreus connection",
				PHPGRID_WS_ENDPOINT 				=> "http://MyZagreusHost:7323/zagreus/services/ws/zagreuswebbaseservice",
				PHPGRID_WSDL_LOCATION 				=> "http://MyZagreusHost:7323/zagreus/zagreuswebbaseservice.wsdl",
				PHPGRID_WS_USERNAME 				=> "*****",
				PHPGRID_WS_PASSWORD 				=> "*****",
				PHPGRID_CONN_TYPE		 			=>	CONN_TYPE_WEBSERVICE,
				PHPGRID_WS_PASSWORD_ENCRYPTED 		=> false
		)
];

//DATE and DATETIME formats:
//Y: 	year, 4 digits
//y: 	year 2 digits
//m:	month, numeric (00-12)
//M:	month name (January-December)
//d:	day of month, numeric (00-31)
//H:	hour (00-23)
//h,I:	hour (01-12)
//i:	minutes, numeric (00-59)
//s,S:	seconds (00-59)
//p:	am/pm
//r:	time, 12-hour (hh:mm:ss) followed by AM or PM)
//T:	time, 24 hour (hh:mm:ss)
//f:	microseconds (000000-999999)
//b:	month, numeric (00-12) only for Oracle connections

//LDAPS / LDAP:
const ET_LDAP_AUTHENTICATION = array(
	
		//ldaps
		PHPGRID_DB_HOSTNAME	=>"ldaps://my.hostname.com:636",
		PHPGRID_DB_DN 		=>"dc=my,dc=hostname,dc=com",
		
		//simple ldap
		//PHPGRID_DB_HOSTNAME	=>"ldap://my.hostname.com:389",
		//PHPGRID_DB_DN 		=>"dc=my,dc=hostname,dc=com",
);

?>
