<?php
	//callable objects binding level
	define('BINDING_LEVEL_TABLE',			 	0);
	define('BINDING_LEVEL_LINE', 				1);
	
	//user parameter settings
	// saved default catalog for user
			
	// you can override the DEFAULT_CATALOG_DISPLAY_TEXT_PATTERN for a particular user
	define('USER_PARAM_CATALOG_DISPLAY_TEXT_PATTERN', 	'catalog_display_text_pattern');
	
	// you can override the DEFAULT_CATALOG_ORDER_BY for a particular user
	define('USER_PARAM_CATALOG_ORDER_BY',			 	'catalog_order_by');
	
	// position of the excel import and callable object windows 
	define('USER_PARAM_POPUP_POSITION_UPLOAD', 			'popup_position_upload');
	define('USER_PARAM_POPUP_POSITION_CALLABLES', 		'popup_position_callables');
	define('USER_PARAM_POPUP_POSITION_UPLOADANDPROCESS','popup_position_upload_and_process');
	
	// user catalog settings:
	// grid dimensions, e.g.: w=703;h=375
	define('USER_PARAM_GRID_DIMENSONS',					'grid_dimensions');	
	
	// this prefix needs a column name, like: col_width_COL_NAME
	// value: e.g. 213
	define('USER_PARAM_COL_WIDTH',						'col_width');	
	
	// catalog specific caption for advanced filter dialog. for all users, use: *ANY
	define('USER_PARAM_FILTER_CAPTION',					'caption_dynamic_filter');	
	
	// the user can open and close the left menubar, which contains the grid related menu items
	// values: opened / closed
	define('USER_PARAM_SIDEBAR_STATE',					'sidebar_state');
	
	// same as 'USER_PARAM_SIDEBAR_STATE' but on admin pages
	define('USER_PARAM_SIDEBAR_STATE_ADMIN',			'sidebar_state_admin');
	
	// the user can open and close the table selector and filtering menu secgtion
	// values: opened / closed
	define('USER_PARAM_TABLE_SELECTOR_STATE',			'table_selector_state');
	
	// values for  USER_PARAM_SIDEBAR_STATE and USER_PARAM_TABLE_SELECTOR_STATE
	define('USER_PARAM_OPENED',							'opened');
	define('USER_PARAM_CLOSED',							'closed');
	
	// values for user parameter level
	define('USER_PARAM_LEVEL_COLUMN',					'column');
	define('USER_PARAM_LEVEL_CATALOG',					'catalog');
	define('USER_PARAM_LEVEL_USER',						'user');
	
	// KEY column of the et_user_parameter table
	define('USER_PARAM_COL_NAME_KEY',					'param_id');
	
	// swap admin menu item if available
	define('USER_PARAM_SWAP',							'swap_table');
	// the menu item in the case of reverse direction menu items
	define('USER_PARAM_REVERSE_PAGE_MENU_ITEM',			'reverse_page_menu_item');
	
	// the default page in the case of reverse direction menu items 
	define('USER_PARAM_REVERSE_PAGE_TARGET',			'reverse_page_target');
	
	// the selected admin menu item
	define('USER_PARAM_ADMIN_MENU_STATE', 				'admin_menu_state');

	// if admin logs out from admin are after next login he/she'll land there
	define('USER_PARAM_LOAD_ADMIN_PAGE_AFTER_LOGIN', 	'load_admin_page_after_login');
	
	// catalog level parameters array
	define('USER_PARAM_NAME_ARRAY_CATALOG_LEVEL',		[USER_PARAM_GRID_DIMENSONS, USER_PARAM_FILTER_CAPTION]);
	
	// column level parameters array
	define('USER_PARAM_NAME_ARRAY_COLUMN_LEVEL',		[USER_PARAM_COL_WIDTH, "col_name"]);
	
	// user level parameters array (only popup_position is handled differently)
	define('USER_PARAM_NAME_ARRAY_USER_LEVEL',			[USER_PARAM_TABLE_SELECTOR_STATE, USER_PARAM_SIDEBAR_STATE, USER_PARAM_CATALOG_ORDER_BY,
														USER_PARAM_CATALOG_DISPLAY_TEXT_PATTERN, USER_PARAM_DEFAULT_CATALOG_INSTANCE_ID,USER_PARAM_POPUP_POSITION_UPLOAD,
														USER_PARAM_POPUP_POSITION_CALLABLES, USER_PARAM_ADMIN_MENU_STATE, USER_PARAM_LOAD_ADMIN_PAGE_AFTER_LOGIN,
														USER_PARAM_POPUP_POSITION_UPLOADANDPROCESS]);
	
	//SQL -- the SQL_ prefix is already reserved so QUERY is used
	//QUERY_ANY is used to refer to all users logical group only!
	define('QUERY_ANY', 								'*ALL_GROUP');
	define('QUERY_NONE',								'*NONE');
	
	//dynamic menu:
	//target page constants, ET_TRANSACTION, TARGETPAGE column possible values
	define('TARGET_PAGE_NIOTA',				 			'niota.php');
	define('TARGET_PAGE_EXECUTE_CALLBALE', 				'execute_callable.php');
	
	// ET_CALLABLE_OBJECT, callobject_type:
	// 0: stored procedure call
	// 1: sql call
	
	// ET_MASTER_DETAIL, linktype:
	// 0: master-detail link
	// 1: advanced filter link
	
	// ET_CATALOG_OBJECT_CALLABLE, binding_level
	// 0: table level
	// 1: line level
	
	// ET_CATALOG_OBJECT_COLUMN_PROP ordinal_position_pkey NEEDS TO BE SET FOR VIEWS!!!!
	
	// CONSTRAINT operations are listed in :  ET_LOOKUP_VALUE_SYSTEM
	
	// catalog instance name for admin object instances
	define('INSTANCE_NAME_ADMIN_OBJECTS',				"*ADMIN");
	
	// password column in et_user table
	define ('COLUMN_NAME_PASSWORD', 					"password");
	
	//categories in et_lookup_value_system table. Used in admin pages as lookups.
	define('SYSTEM_LOOKUP_CONSTRAINT',					"constraint");
	define('SYSTEM_LOOKUP_COLUMN_TYPE',					"column_type");
	define('SYSTEM_LOOKUP_CALLABLE_OBJECT_TYPE',		"callable_object_type");
	define('SYSTEM_LOOKUP_TARGET_PAGE',					"target_page");
	define('SYSTEM_LOOKUP_USERGROUP_TYPE', 				"usergroup_type");
	define('SYSTEM_LOOKUP_TRANSACTION_PARAM_NAME',		"transaction_param_name");
	define('SYSTEM_LOOKUP_USER_PARAMETER',				"user_parameter");
	define('SYSTEM_LOOKUP_CALLABLE_BINDING_LEVEL',		"callable_binding_level");
	define('SYSTEM_LOOKUP_CONN_TPYE',					"conn_type");
	
?>