<?php
	// ---
	// START OF GENERAL FORMAT OPTIONS
	// ---


	// ---
	// color theme for user grid pages and admin pages
	// supported values:
	//
	// VEGA 			blue
	// VULCAN 			red/pink
	// SHELIA 		yellow/brown
	// MOSS 			green
	// SALVA			gray
	// ILARI			purple
	// RISA				red/orange
	// BROWDA			sunny
	// PREENOS		    grey/dark blue
	// TARSUS		    deep blue
	// --- 
	define('COLOR_THEME', 					'TARSUS');
	define('COLOR_THEME_ADMIN', 			'SALVA');
	
	// ---
	// colors and form dimension for admin pages
	// --- 
	define('COLOR_INACTIV_TEXT',			'#FF0040');
	define('COLOR_INACTIV_BACKGROUND',		'#E6E6E6');
	define('FORMSIZE_ADMINPAGE_SMALL',		'600');
	define('FORMSIZE_ADMINPAGE_MEDIUM',		'800');
	define('FORMSIZE_ADMINPAGE_LARGE',		'1200');
	define('CAPTION_ADMINPAGE_OPEN_TAG',    '<h2>');
	define('CAPTION_ADMINPAGE_CLOSE_TAG',   '</h2>');
	
	// ---
	// page headers
	// configurable settings:
	//
	// COMPANY_LOGO 		use small .png image with your companies logo
	// PRODUCT_NAME			default "niota" - you can rename it to your needs
	// CLAIM				default ".fascinating.logical" - you can rename it to your needs
	// INSTALLATION_NAME	default "niota+Version" - can be use as $installation replacement parameter in stored procedure calls / callable objects scripts
	//
	// ---	
	define('COMPANY_LOGO', 					'niotaLogo.png');
	define('PRODUCT_NAME', 					'niota');
	define('CLAIM',							' .fascinating.logical ');
	define('INSTALLATION_NAME',				'niota');
	
	// ---
	// grid area
	//
	// GRID_AREA_LANGUAGE
	// 	de				GERMAND/DEUTSCH
	// 	en				ENGLISH/ENGLISCH
	// FEEDBACK_MSG_DELAY				delay time of hide grid editing feedback message (milliseconds)
	// DEFAULT_PAGE_SIZE_GRID 			the number of rows on user grid pages
	// DEFAULT_PAGE_SIZE_ADMIN			the number of rows on admin pages
	// 	10, 20, 30, 50, 100, -1 (all rows)
	//
	// ---	
	define('GRID_AREA_LANGUAGE',		'en');
	define('SYSTEM_LANGUAGE',			'en');
	define('DEFAULT_PAGE_SIZE_GRID', 	50);
	define('DEFAULT_PAGE_SIZE_ADMIN', 	50);
	define('FEEDBACK_MSG_DELAY', 		5000);
	
	// ---
	// widths of combo - boxes in user grid pages
	// configurable settings:
	//
	// PHPGRID_LOOKUP_COMBO_DEFAULT_WIDTH		width of lookup combo during grid editing
	// PHPGRID_EDIT_FORM_DEFAULT_WIDTH			width of default edit form
	// WIDTH_TABLE_SELECTOR						width of table selector drop down list
	// WIDTH_FILTER_CONNECTION					width of connection filter drop down list
	// WIDTH_FILTER_CATEGORY					width of category filter drop down list
	//
	// ---	
	define('PHPGRID_LOOKUP_COMBO_DEFAULT_WIDTH', 	300);
	define('PHPGRID_EDIT_FORM_DEFAULT_WIDTH', 		500);
	define('WIDTH_TABLE_SELECTOR', 			'450px');
	define('WIDTH_FILTER_CONNECTION', 		'150px');
	define('WIDTH_FILTER_CATEGORY', 		'150px');
	
	// ---
	// content of table selector combo-box in user grid pages
	// configurable settings:
	//
	// SHOW_TABLE_SELECTOR_BY_DEFAULT			true/false (show / hide table selector)
	// DEFAULT_CATALOG_DISPLAY_TEXT_PATTERN		pattern and list of pattern-variables to build the table list (
	// DEFAULT_CATALOG_ORDER_BY					order by clause of catalog list 
	// pattern for combo box in main grid page
	//	%cat_id% 			: catalog id
	//	%inst_name% 		: instance name
	//	%inst_descr%		: instance description
	//	%conn_name% 		: connection name
	//	%conn_disp_name% 	: connection display name
	//  %obj%				: the catalog object name (table or view name)
	//	%desc%				: description (not recommended, can be too long)
	//  %obj_cat%			: object category
	//
	// ---	
	define('SHOW_TABLE_SELECTOR_BY_DEFAULT',			true);
	define('DEFAULT_CATALOG_DISPLAY_TEXT_PATTERN',		'%conn_disp_name% - %obj% - %cat_id% - %inst_descr%');
	define('DEFAULT_CATALOG_ORDER_BY',					'catalog_id, object, instance_name, conn_name');
	
	// ---
	// user grid format settings
	// configurable settings:
	//
	// APPLY_CUSTOM_FORMATTING						true/false
	//
	//			true: apply custom formatting (generic, database level, table level)
	//			false: switch of all custom formatting
	//
	// CUSTOM_FORMAT_FOLDER							root folder of custom format files - this path is relative to the niota root folder.
	// CUSTOM_FORMATTING_BY_CATALOG_NAME			true/false
	//
	// 			true: CUSTOM_FORMAT_FOLDER + "/" + <FORMATFOLDER_SUBFOLDER_CONNECTION> folder is the root of the formatter files
	// 				  connection subfolders are mandatory!!!
	// 				  folder is also root folder for the database formatfiles (arranged by connection)!!!
	//                The simple table name is the name of the formatter file e.g. for table dbo.T_CURRENCY the formatter file is T_CURRENCY.php
	//
	// 			false: CUSTOM_FORMAT_FOLDER + "/" + FORMATFOLDER_SUBFOLDER_CATALOG_ID folder is the root of the formatter files
	//                The catalog id of an object is the name of the formatter file e.g. for table dbo.T_CURRENCY the formatter file is 202.php
	//
	// CUSTOM_FORMAT_SUBFOLDER_GENERAL				subfolder of CUSTOM_FORMAT_FOLDER where generic format files are located
	// CUSTOM_FORMAT_SUBFOLDER_CATALOG_ID			subfolder of CUSTOM_FORMAT_FOLDER when formatter files are named like the catalog id
	// CUSTOM_FORMAT_SUBFOLDER_IMAGES				subfolder of CUSTOM_FORMAT_FOLDER for menu item images and own icons and background images
	// CUSTOM_FORMAT_SUBFOLDER_CONNECTION			subfolder of CUSTOM_FORMAT_FOLDER for format folders on connectionlevel (if CUSTOM_FORMATTING_BY_CATALOG_NAME = true)
	//
	//
	// CUSTOM_FORMAT_FILE_GENERAL					format file name in folder CUSTOM_FORMAT_SUBFOLDER_GENERAL as overall format file. Applied always as first formatter
	//
	// CUSTOM_FORMAT_FILE_SPLIT_BY_LANGUAGE			true/false
	//
	//			true: on tablename level or/and catalog id level a formatter file with a language code of the activated language is applied as well
	//				  e.g. T_CURRENCY_en.php or 202_en.php
	// ---	
	define('APPLY_CUSTOM_FORMATTING', 				true);
	define('CUSTOM_FORMATTING_BY_CATALOG_NAME', 	true);
	define('CUSTOM_FORMAT_FOLDER', 					'formattings');
	define('CUSTOM_FORMAT_SUBFOLDER_GENERAL', 		'general');
	define('CUSTOM_FORMAT_SUBFOLDER_CATALOG_ID', 	'catalog_id');
	define('CUSTOM_FORMAT_SUBFOLDER_CONNECTION', 	'connection');
	define('CUSTOM_FORMAT_SUBFOLDER_IMAGES', 		'images');
	define('CUSTOM_FORMAT_FILE_GENERAL', 			'defaultformatter.php');
	define('CUSTOM_FORMAT_FILE_SPLIT_BY_LANGUAGE',	 true);
	
	// ---
	// help and info settings
	// configurable settings:
	//
	// CUSTOM_HELP_FILE_SPLIT_BY_LANGUAGE			true/false  does the default login_help.html exist on language level or not (login_help_en.html or login_help.html)
	// HELP_CUSTOM_FILE_GRID						URL to own help pages - called from grid editing
	// HELP_CUSTOM_FILE_ADMIN						URL to own help pages - called from admin pages
	//
	// URLs for help pages may contain placeholders
	// 	$documentRoot		- document root direcotry of Apache 
	//	$confFolder			- substituted as 'conf' 
	//	$clientFolder		- current client folder
	// 	$niotaRoot			- path part which strats at Apache's document root and ends at 'niota' folder						 
	// 	$customFormatFolder - substituted as 'formattings'
	// 	$languageCode		- en / de
	// 	$tableName			- current catalog-object-instance object name.
	// 	$adminPage			- references for 'option key' (ok) in the page URL of the current admin page. Only for 'HELP_CUSTOM_FILE_ADMIN'
	//	
	//	Important! If you use proxy then do not use the variable $documentRoot - it will resolves the IP address/DNS 
	//	of the source machine! Instead you can define absoulte path from the document root.
	//	E.g. #1: "/niota/conf/my-folder/my-help.html" ==> refers to file
	//								'C://Apache24/htdocs/niota/conf/my-folder/my-help.html' or 
	//								'/var/www/htdocs/niota/conf/my-folder/my-help.html'
	//	
	//	E.g. #2: $niotaRoot/$confFolder/$clientFolder/$customFormatFolder/webhelp/my-help.html ==> refers to file 
	//								'C://Apache24/htdocs/niota/conf/my-cilent/formattings/webhelp/my-help.html' or 
	//								'/var/www/htdocs/niota/conf/my-cilent/formattings/webhelp/my-hlep.html'
	//
	// see some further samples below:
	//
	// define('HELP_CUSTOM_FILE_GRID',		 '$documentRoot/$niotaRoot/$customFormatFolder/webhelp/$languageCode/$tableName.html');
	// define('HELP_CUSTOM_FILE_GRID',       'http://www.niota.at');
	// define('HELP_CUSTOM_FILE_ADMIN',		 '$documentRoot/$niotaRoot/$customFormatFolder/webhelp/$languageCode/$adminPage.html');
	// define('HELP_CUSTOM_FILE_ADMIN',      'http://www.niota.at');
	//
	// --- 	
	define('CUSTOM_HELP_FILE_SPLIT_BY_LANGUAGE',  false);
	define('HELP_CUSTOM_FILE_GRID',              'https://support.etixpert.com/tableeditor/documentation/doku.php?id=start');
	define('HELP_CUSTOM_FILE_ADMIN',             'https://support.etixpert.com/tableeditor/documentation/doku.php?id=start');
		
	// ---
	// END OF GENERAL FORMAT OPTIONS
	// ---
	
	// ---
	// DEPRECATED FORMAT OPTIONS --- WILL BE REMOVED IN ONE OF THE NEXT RELEASES
	// ---
	define('CUSTOM_WEB_DOCS_IN_LANG_FOLDER',		false);
	
	
	