<?php

	// NIOTA v5.0.1 RUNS WITH NIOTA METADATA V2.2
	//----------------------------------------------
	// ---
	// START OF SYSTEM DEFAULTS CONFIGURATION
	// --- 	

	// default time zone
	date_default_timezone_set("Europe/Vienna");
	
	// ---
	// logging
	// configurable settings:
	//
	// LOGFILE_LINE_SEPARATOR				characters \ whitespace characters for log file end of line (shipped with: "\r\n")
	// LOGGING_SOURCE_EDIT					text/action code in logfile when logged from grid edit (shipped with: 'EDIT')
	// LOGGING_SOURCE_EXCEL_IMPORT			text/action code in logfile when logged from EXCEL import (shipped with: 'IMPORT')
	// LOGGING_SOURCE_EXCEL_IMPORT_PARTIAL	text/action code in logfile when logged from EXCEL partial import (shipped with: 'IMPORT-PARTIAL')
	// LOGGING_SOURCE_EXCEL_EXPORT			text/action code in logfile when logged from EXCEL export (shipped with: 'IMPORT-EXPORT')
	// LOGGING_SOURCE_CALL					text/action code in logfile when logged an execution of a callable object (shipped with: 'CALL'
	//
	// LOG_EXCEL_EXPORT_IMPORT_TO_FILE		true/false
	//
	//			true: EXCEL import commands are logged in detail (delete/insert) when logging is enabled for connection where target table is located
	//			false: EXCEL import commands are not logged
	//
	// LOG_EXCEL_EXPORT_IMPORT_THROUGH_CONNECTION true/false
	//
	//			true: EXCEL import commands are logged in detail (delete/insert) when logging is enabled for connection where target table is located
	//			false: EXCEL import commands are not logged
	// ---	
	define('LOGFILE_LINE_SEPARATOR',					"\r\n");	
	define('LOGGING_SOURCE_EDIT',						'EDIT');
	define('LOGGING_SOURCE_EXCEL_IMPORT',				'IMPORT');
	define('LOGGING_SOURCE_EXCEL_IMPORT_PARTIAL',		'IMPORT-PARTIAL');
	define('LOGGING_SOURCE_EXCEL_EXPORT',				'EXPORT');
	define('LOGGING_SOURCE_CALL',						'CALL');
	define('LOGGING_SOURCE_VALIDATION',					'VALIDATION');
	define('LOG_EXCEL_EXPORT_IMPORT_TO_FILE',			true);	 
	define('LOG_EXCEL_EXPORT_IMPORT_THROUGH_CONNECTION',true);
	
	// ---
	// validation feature
	// configurable settings:
	//
	// MAXNUMBER_VALIDATIONERR 			number of errors before procedure is aborted (shipped with: -1 -> no limit)
	// MAXNUMBER_VALIDATIONMSG 			number of records to (shipped with: -1 -> log all)
	// MAXNUMBER_VALIDATIONROW 			number of records to check in the table (shipped with: -1 -> check all rows)
	//
	// ---
	define('MAXNUMBER_VALIDATIONERR', 					-1);
	define('MAXNUMBER_VALIDATIONMSG',					-1);
	define('MAXNUMBER_VALIDATIONROW', 					-1);
	define('VALIDATION_CHUNK_SIZE', 				 10000);
	
	// ---
	// grid display / SQL generating
	// configurable settings:
	//
	// USE_DEFAULT_PK_ORDER_BY			true/false
	//
	//			true: ORDER BY clause based on primary key is generated
	//			false: no ORDER BY clause is generated
	//
	// DEFAULT_GRID_ORDER_BY 			ASC/DESC
	// SYSTEM_OBJECT_ALIAS_GRID			string + pattern for alias clause for editing table when catalog object join is used
	//
	// 		SYSTEM_OBJECT_ALIAS_GRID = "" => no alias
	// 		SYSTEM_OBJECT_ALIAS_GRID = "a" => the alias is the given character or string.
	// 		SYSTEM_OBJECT_ALIAS_GRID = "abc%cat_id%" => the alias is the given character or string concatenated with the actual catalog ID.
	//
	// ---	
	define('USE_DEFAULT_PK_ORDER_BY',					false);
	define('DEFAULT_GRID_ORDER_BY',						'ASC');
	define('SYSTEM_OBJECT_ALIAS_GRID',					'a%cat_id%');
	
	// ---
	// advanced filter
	// configurable settings:
	//
	// SELECTION_TABLE_FIELD_USERNAME		column name where the username is saved in the filtering table (shipped with: 'username')
	// SELECTION_TABLE_FIELD_SAVE_DEFAULT   column name where the 'save as default' flag is read (shipped with 'ZZ_SAVE_DEFAULT')
	// ADVANCED_FILTER_CAPTION_DEFAULT		caption text of advanced filter form (shipped with 'Filter')
	//
	// 	 can be overwritten on catalog instance level by having a user catalog setting
	//	 use the catalog id, instance name and the 'caption_dynamic_filter' param name, and the caption as param value. Use *ANY for username.
	//
	// ---
	define('SELECTION_TABLE_FIELD_USERNAME', 			'username');
	define('SELECTION_TABLE_FIELD_SAVE_DEFAULT', 		'ZZ_SAVE_DEFAULT');
	define('ADVANCED_FILTER_CAPTION_DEFAULT',			'Filter');
	
	// ---
	// callable object (stored procedures/webservices/scripts)
	// configurable settings:
	//
	// DISPLAY_CALLABLE_MESSAGE_SUMMARY		number of custom message lines before to group it into summary message
	// CUSTOM_SCRIPT_FOLDER					(main/root) folder where custom scripts are located
	// CUSTOM_CALLABLE_SUBFOLDER_WS			subfolder of CUSTOM_SCRIPT_FOLDER for web-service calls / soap calls .xml-files
	// CUSTOM_CALLABLE_SUBFOLDER_SQL		subfolder of CUSTOM_SCRIPT_FOLDER for sql script-files
	//
	// ---	
	define('DISPLAY_CALLABLE_MESSAGE_SUMMARY', 			0);
	define('CUSTOM_SCRIPT_FOLDER', 						'scripts');
	define('CUSTOM_CALLABLE_SUBFOLDER_WS', 				'webservice');
	define('CUSTOM_CALLABLE_SUBFOLDER_SQL',				'sqlscript');
	
	define('CUSTOM_CALLABLE_SELFSIGNIN_WS',				'sign_in.xml');	
	define('CUSTOM_CALLABLE_VERIFYEMAIL_WS',			'send_email.xml');	
	// ---
	// file upload
	// configurable settings:
	//
	// CUSTOM_UPLOAD_FOLDER					subfolder for upload files relative to niota root folder (direct EXCEL upload uses different folder)
	// CUSTOM_UPLOAD_FOLDER_NETWORK			true/false (is upload folder a network share or not)
	// CUSTOM_UPLOAD_VALID_EXTENSIONS		list of file extensions valid for upload.
	//
	// 	for folder placed on a network drive use a fully qualified path with the server IP address
	//   	192.168.100.56/shared-folder-root/my-uploads/
	//   	backslash can be escaped with backslash ==> folder\\subfolder = folder\subfolder as a result
	// define('CUSTOM_UPLOAD_FOLDER', '\\\\192.168.0.170\\my-network-folder\\my-subfolder\\niota-file-upload\\');
	// define('CUSTOM_UPLOAD_FOLDER', 'uploads'); = "c:\Apache24\htdocs\niota\uploads\"
	// define('CUSTOM_UPLOAD_FOLDER', 'my_mainfolder/my_uploads_subfolder/'); = "c:\Apache24\htdocs\niota\my_mainfolder\my_uploads_subfolder\"
	//
	// ---	
	define('CUSTOM_UPLOAD_FOLDER_NETWORK',				false);
	define('CUSTOM_UPLOAD_FOLDER', 						'uploads');
	define('CUSTOM_UPLOAD_VALID_EXTENSIONS', 			array("xls", "xlsx", "doc", "docx", "pdf", "csv", "txt", "png", "PNG", "jpg"));
	
	// ---
	// admin page features
	// configurable settings:
	//
	// PROPERTY_FOLDER_PATH_CALLABLES_BINDING_ADMIN		folder where file with config for binding between admin pages and related callable object is done
	// PROPERTY_FILE_CALLABLES_BINDING					file where binding between admin pages and related callable object is done
	// 		default for niota V3xx: 'et_callable_object_binding.prop'
	// 		default for niota V400: 'et_callable_object_binding_V400.prop'
	//
	// ---		
	define('PROPERTY_FOLDER_PATH_CALLABLES_BINDING_ADMIN', 'etixpert/admin/config/callables');
	define('PROPERTY_FILE_CALLABLES_BINDING', 'et_callable_object_binding_V500.prop');
	
	// ---
	// system help
	// configurable settings:
	//
	// HELP_SYSTEM_FILE_GRID
	// HELP_SYSTEM_FILE_ADMIN
	//
	// ---		
	define('HELP_SYSTEM_FILE_GRID',  'https://support.etixpert.com/tableeditor/documentation/doku.php?id=start');
	define('HELP_SYSTEM_FILE_ADMIN', 'https://support.etixpert.com/tableeditor/documentation/doku.php?id=start');

	// ---
	// registration page terms of use link
	define("TERMS_OF_USE_LINK", 			"https://support.etixpert.com/tableeditor/documentation");
	

	// add this lines at the end of existing system_defaults.php
	
	// ---
	// extended system configuration in metadb tables
	// configurable settings:
	//
	// APPLICATION_CODE_DEFAULT							text/string (up to five characters which is set as custom default value) (shipped with: 'CUST')
	//		choose a value that fits your company / your project. Do not user "niota"
	//
	// ---
	define('CUSTOM_APPLICATION_CODE_DEFAULT',			'CUST');
	
	// ---
	// date and datetime handling:
	// the setting ADODB_FUTURE_DATE_CUTOFF_YEARS sets the maximum date and datetime value can be passed to the db
	// comparing to the current date
	// e.g.: ADODB_FUTURE_DATE_CUTOFF_YEARS = 100 => max date is '2121-07-14'
	// ---
	define('ADODB_FUTURE_DATE_CUTOFF_YEARS', 1000);
	
	//---
	//PW POLICY CONFIGURATION - minimum length is configurable
	//setting is applied during registartion and personal page
	//checked special characters are: !"#$%&'()*+,\-./:;<=>?@[\]^_`{|}~
	define('APPLY_PW_POLICY', 				true);
	define('PW_POLICY_MIN_LENGTH',			8);
	define('PW_POLICY_LOWER_MATCH_COUNT',	1);
	define('PW_POLICY_UPPER_MATCH_COUNT',	1);
	define('PW_POLICY_DIGIT_MATCH_COUNT',	1);
	define('PW_POLICY_SPECIAL_MATCH_COUNT',	1);
	
	//---
	//validation link lifetime in hours
	define('VALIDATION_LINK_LIFETIME',		4);
	
	//---
	//registration help content file - WITHOUT HTML EXTENSION!
	define('REGISTRATION_FORM_HELP',		'registration_info');
	define('REGISTRATION_HELP',				'register_help');
?>
