<?php 
use phpGrid\C_DataBase as C_DataBase;
use phpGrid\C_Utility as C_Utility;
use phpGrid\C_SessionMaker as C_SessionMaker;

require_once(__DIR__ . '/conf/conf.php');



$session = C_SessionMaker::getSession(FRAMEWORK);

$gridName   			= isset($_GET['gn']) ? $_GET['gn'] : die('PHPGRID_ERROR: ULR parameter "gn" is not defined.');
$data_type  			= isset($_GET['dt']) ? $_GET['dt']:'json';
$virtualColumnPosition 	= isset($_GET['vcp']) ? $_GET['vcp'] : -1;
$adminDatagrid 			= isset($_GET['adg']) ? $_GET['adg'] : false;
$catalogInstanceId		= isset($_GET['cii']) ? $_GET['cii'] : null;
$logicalLink			= isset($_GET['sll']) ? $_GET['sll'] : null;
$fixedValues			= (!is_null($catalogInstanceId) && $adminDatagrid) ? ET_BrowsingStore::getBrowsingStore()->get_mergedColumns($catalogInstanceId, $logicalLink) : array();
//$catalogInstaceIdAdmin	= $adminDatagrid ? $_SESSION[SESS_CATALOG_INSTANCE_ID_MASTER_ADMIN] : null;
$advancedFilter 		= isset($_GET['advancedFilter']) ? $_GET['advancedFilter'] : false;

$userName 				= $_SESSION[SESS_USERNAME]; 

$grid_sql	= $session->get(GRID_SESSION_KEY.'_'.$gridName.'_sql');
$sql_key	= unserialize($session->get(GRID_SESSION_KEY.'_'.$gridName.'_sql_key'));
$sql_fkey	= $session->get(GRID_SESSION_KEY.'_'.$gridName.'_sql_fkey');
$sql_table	= $session->get(GRID_SESSION_KEY.'_'.$gridName.'_sql_table');
$sql_filter	= $session->get(GRID_SESSION_KEY.'_'.$gridName.'_sql_filter');
$db_connection = unserialize($session->get(GRID_SESSION_KEY.'_'.$gridName.'_db_connection'));
$cn = $db_connection;
$db = new C_DataBase($cn["hostname"],$cn["username"],$cn["password"],$cn["dbname"],$cn["dbtype"],$cn["dbcharset"],array(), $cn["dbauthmechanism"], $cn['passwordEncrypted']);
$db_type = $cn["dbtype"];
$db_charset = $cn["dbcharset"];

//etixpert extension starts
$br 			= ET_BrowsingStore::getBrowsingStore();
//$gridIdentifier = $br->generateGridIdentifier($catalogInstanceId, $logicalLink);
//$gridSqlObj 	= $br->get_gridSqlObject($gridIdentifier);
$gridSqlObj 	= $br->get_gridSqlObject($catalogInstanceId);
$objectJoinAlias = $gridSqlObj->getObjectJoinAlias();
//etixpert extension ends

$page = $_GET['page'];
$limit = $_GET['rows'];  // get how many rows we want to have into the grid - rowNum parameter in the grid
$sidx = $_GET['sidx'];  // get index row - i.e. user click to sort. At first time sortname parameter - // after that the index from colModel
$sord = $_GET['sord'];  // sorting order - at first time sortorder
$do	= isset($_GET['do']) ? $_GET['do'] : 1; 

$rs     = $db->select_limit($grid_sql, 1, 0);

// prepare sql where statement.
//$sqlWhhere is the WHERE condition of the filter input placed on the grid (magnifier icon)
// 2. query filter. Set by magnifier icon - column filter on the top of each column
$sqlWhere = "";
$searchOn = (isset($_REQUEST['_search']) && $_REQUEST['_search'] =='true')?true:false;
if($searchOn) {
    $col_dbnames = array();
    $col_dbnames = $db->get_col_dbnames($rs);        

	//print_r($col_dbnames);
	// check if the key is actual a database field. If true, add it to SQL Where (sqlWhere) statement
    foreach($_REQUEST as $key=>$value) {
		//echo 'key:'. $key ."\n";
        if(in_array($key, $col_dbnames)){
            $fm_type = $db->field_metatype($rs, $db->field_index($rs, $key));

            $colName = !empty($objectJoinAlias) ? $objectJoinAlias . "." . $key : $key;
            
            switch ($fm_type) {
                case 'I':
                case 'N':
                case 'R': case 'SERIAL':
                case 'L':
                	//$sqlWhere .= " AND ".$key." = ".$value;
                	//etixpert change:
                	$sqlWhere .= " AND ".$colName." = ".$value;
                	break;
                default:
                	//$sqlWhere .= " AND ".$key." LIKE '".$value."%'";
                	//etixpert change:
                	$sqlWhere .= " AND ".$colName." LIKE '".$value."%'";
                	break;
            }			
        }
        
    }

    //integrated toolbar and advanced search    
    if(isset($_REQUEST['filters']) && $_REQUEST['filters'] !=''){
        $operation = array("eq"=>" ='%s' ","ne"=>" !='%s' ","lt"=>" < %s ",
            "le"=>" <= %s ","gt"=>" > %s ","ge"=>" >= %s ",
            "bw"=>" like '%s%%' ","bn"=>" not like '%s%%' " ,
            "in"=> " in (%s) ","ni"=> " not in (%s) ",
            "ew"=> " like '%%%s' ","en"=> " not like '%%%s' ",
            "cn"=> " like '%%%s%%' ","nc"=> " not like '%%%s%%' ");
            
        $filters = json_decode(stripcslashes($_REQUEST['filters']));
        $groupOp = $filters->groupOp;	// AND/OR
        $rules = $filters->rules;
		        
        for( $i=0; $i<count($rules); $i++ ){       

            $filter = $operation[$rules[$i]->op];

            // surround date fields with quotes for SQL date comparison
            
            $fm_type = $db->field_metatype($rs, $db->field_index($rs, $rules[$i]->field));
            
           
            
            
            if( $fm_type == 'D' ){

                $dateOps = array('eq', 'ne', 'lt', 'le', 'gt', 'ge');                
                $op = $rules[$i]->op;                
                if( in_array( $op, $dateOps ) ){
                    $filter = str_replace("%s", "'%s'", $filter);
                } 
            }
            
            // apply filter finally
            //$sqlWhere .=  $groupOp . " ". $rules[$i]->field . sprintf($filter, C_Utility::add_slashes($rules[$i]->data));
            //etixpert change: and add object join alias
            $fieldName = !empty($objectJoinAlias) ? $objectJoinAlias . "." . $rules[$i]->field : $rules[$i]->field;
            $sqlWhere .=  $groupOp . " ". $fieldName . sprintf($filter, C_Utility::add_slashes($rules[$i]->data));
        }
    }
}

// remove leading sql AND/OR
$pos = strpos($sqlWhere,'AND ');
if ($pos !== false) {
	$sqlWhere = substr_replace($sqlWhere,'',$pos,strlen('AND '));
}
$pos = strpos($sqlWhere,'OR ');
if ($pos !== false) {
	$sqlWhere = substr_replace($sqlWhere,'',$pos,strlen('OR '));
}

/* (MySql only) Allow reserved keywords (hyphen) in column names for sorting */
if($db_type == 'mysql' || $db_type == 'mysql_dsn'){
    if(strpos($sidx, '-') !== false){  // only escape column name contains '-'
        $sidx = '`'.strtoupper($sidx).'`';
    }
}

//etixpert change
$sqlOrderBy = "";
// set ORDER BY. Don't use if user hasn't select a sort
if ($do == 0) {
	$pos = strpos(strtolower($grid_sql), "order by");
	if ($pos) {
		$grid_sql = substr($grid_sql, 0, $pos);
	}
	$sqlOrderBy = (!$sidx) ? "" : " ORDER BY $sidx $sord";
}

if ($searchOn) {
	$gridSqlObj->setWhereColumnSearch($sqlWhere);
}

$gridSqlObj->setOrderByPhpGrid($sqlOrderBy);
$gridSqlObj->setWhereSqlFilter($sql_filter);


// ********* prepare the final query ***********************
$SQL = $gridSqlObj->generateSql($advancedFilter);
 //echo $SQL;
//etixpert ends

$collateSettings 	= array();
$collateChanged		= false;
if ($advancedFilter && $db_type == DB_TYPE_OCI805) {
	$sessionCollate = "";
	$newSettings	= array();
	$newSettings['NLS_SORT'] = 'binary_ci';
	$newSettings['NLS_COMP'] =  'LINGUISTIC';
	$collateSettings['origSettings'] = ET_ConnHelper::getDBSessionCollationBehavior($db->db, $db_type);	
	ET_ConnHelper::setDBSessionCollationBehavior($db->db, $db_type, $newSettings);
	$collateChanged = true;
	
	//echo ET_ConnHelper::getDBSessionCollationBehavior($db->db, $db_type);
}
// ******************* execute query finally *****************

// calculate the starting position of the rows 
$start = $limit*$page - $limit;
// if for some reasons start position is negative set it to 0. typical case is that the user type 0 for the requested page 
if($start <0) $start = 0; 
if($db_type != 'pdo_odbc_db2'){ $db->db->SetFetchMode(ADODB_FETCH_BOTH); }

$result = $db->select_limit($SQL, $limit, $start);

// ************************ pagination ************************
//$SQL = "select creditLimit, city, country, zz_save_default from test.dbo.customers_selection where username = 'admin'";
//original
$count = $db->num_rows($db->db_query($SQL)); // total record count used for pagination (unfortunate performance penality).
	
// calculate the total pages for the query 
if( $count > 0 && $limit > 0) { 
	$total_pages = ceil($count/$limit); 
}else{
	$total_pages = 0; 
} 
// if for some reasons the requested page is greater than the total set the requested page to total page 
if ($page > $total_pages) $page=$total_pages;

// *************** return results in XML or JSON ************
// $data_type = $dg->get_jq_datatype();

switch($data_type)
{
    // render xml. Must set appropriate header information. 
    case "xml":
        $data = "<?xml version='1.0' encoding='utf-8'?>";
        $data .=  "<rows>";
        $data .= "<page>".$page."</page>";
        $data .= "<total>".$total_pages."</total>";
        $data .= "<records>".$count."</records>"; 
        while($row = $db->fetch_array_assoc($result)) {
            $data .= "<row id='". gen_rowids($row, $sql_key) ."'>";
            for($i = 0; $i < $db->num_fields($result); $i++) {
                $col_name = $db->field_name($result, $i);             
                    $data .= "<cell>". $row[$col_name] ."</cell>";    
            }  
            $data .= "</row>";       
        }
        $data .= "</rows>";    

        header("Content-type: text/xml;charset=utf-8");
        echo $data;   
        break;
                 
    case "json":

        $response = new stdClass();   // define anonymous objects
        $response->page = $page;
        $response->total = $total_pages;
        $response->records = $count;
        $i=0;
        $data = array();
        
        $mergedIndexes = array();
		$mergedIndexesSet = FALSE;		
              
        ob_start();
        
        $result->MoveFirst();
        
        if ($advancedFilter && (!isset($result->fields[SELECTION_TABLE_FIELD_USERNAME]) || $result->numRows() === 0)) {
        	//we do not display the filtering form
        	//error message is set in cls_datagrid.php -> display_form_only()
        	
        	echo "<script>alert('" . \ET_DisplayHelper::localize(
        				"ADVANCED_FILTER_NO_MATCH", [$userName, SELECTION_TABLE_FIELD_USERNAME], PAGE_TYPE_GRID, "niota"). "');
				</script>";
        	return;
        } 
              
        while($row = $db->fetch_array_assoc($result)) {
          
        	unset($data);
        	$pkArray = [];
            $offset = 0;
            
            //Etixpert change starts
            if($virtualColumnPosition == 0) {
            	$data[] = "";
            	$offset = 1;
            }
            
            for($j = 0; $j < $db->num_fields($result); $j++) {
              
            	$col_name = $db->field_name($result, $j);
            	$colValue = $row[$col_name];
            	
                if ($advancedFilter) {
                	//we do not display the filtering form
                	//error message is set in cls_datagrid.php -> display_form_only()                	
                	if ((strtolower(SELECTION_TABLE_FIELD_USERNAME) == strtolower($col_name)) && (SELECTION_TABLE_FIELD_USERNAME != $sql_key[0] || strtoupper($colValue) !== strtoupper($_SESSION[SESS_USERNAME]))) {                		
                		return;
                	}
                }
                
                if (strtolower(COLUMN_NAME_PASSWORD) == strtolower($col_name)) {
                	//$data[] = "";
                	$colValue = "";
                } else if ($db_type == "odbc_mssql" || $db_type == DB_TYPE_MSSQL) {
                	
                	$colValue = iconv($db_charset, "utf-8", $colValue);	//2017-07-19
                } else if ($db_type == 'odbc_teradata') {                	
                	
                	//etixpert change:
                	$colType = getColTypeFromResult($result, $col_name);
                	
                	if (strpos(strtoupper($colType), "TIMESTAMP") !== false) {
                		
                		$dotPos 			= strrpos($row[$col_name], '.');
                		$dotMilliSecPos 	= strlen($row[$col_name]) - 7;
                		
                		if ($dotPos === $dotMilliSecPos) {                			
                			$colValue = substr($colValue, 0, $dotPos);
                		}
                	}
                	$colValue = rtrim(iconv($db_charset, "utf-8", $colValue));
                	
                } else {
                	//no conversion is needed
                	//original:
                	//$data[] = $row[$col_name];
                }                 	
              
            
	            if (in_array($col_name, $sql_key)) {
	            	$pkArray[] = $colValue;
	            }
	            //etixpert modd: 		(source: https://phpgrid.uservoice.com/knowledgebase/articles/927966-escape-html-characters-in-datagrid)
	            $data[] 	= htmlspecialchars($colValue);
	            
	            //$colValue = htmlspecialchars($colValue);
	            //$data[] 	= $colValue;
	            //etixpertt change ends
	        }
        
       	 	$response->rows[$i]['id']=C_Utility::gen_rowids2($pkArray, $sql_key); //$row[$sql_key];
            
            if ($mergedIndexesSet) {
            	for ($k = 0; $k < count($mergedIndexes); $k++) {
            		$mergedIndex = $mergedIndexes[$k];
            		$col1_index = $mergedIndex['col1_index'] + $offset;
            		$col2_index = $mergedIndex['col2_index'] + $offset;
            		$col_target = $mergedIndex['col_target_index'] + $offset;
            		$delimiter  = $mergedIndex['delimiter'];
            		$data[$col_target] = $data[$col1_index] . $delimiter . $data[$col2_index];
            		            		
            	}
            }
            
            $response->rows[$i]['cell'] = $data;            
            $data = array();    // reset array

            $i++;
        }
        
        echo json_encode($response);  
        break;
} 

if (!empty($collateSettings)) {
	if ($collateChanged) {
		ET_ConnHelper::setDBSessionCollationBehavior($db->db, $db_type, $collateSettings['origSettings']);		
	}
}

// free resource       
$db = null;
$gridSqlObj->setWhereSqlFilter("");
$gridSqlObj->setOrderByAdvancedFiltering("");
//$br->set_gridSqlObject($catalogInstanceId, $gridSqlObj);
//$br->flushBrowsingStore();
//etixpert function:
function getColTypeFromResult($result, $colName) {
	
	$fieldObjectArray = $result->_fieldobjects;
	
	for ($i = 0; $i < count($fieldObjectArray); $i++) {
		$actualFieldObj = $fieldObjectArray[$i];
		$actualColName = $actualFieldObj->name;
		
		if ($actualColName === $colName) {
			return $actualFieldObj->type;
		}
	}
	return "";
	
}
?>