<?php


use phpGrid\C_DataBase as C_DataBase;
use phpGrid\C_DataGrid as C_DataGrid;
use phpGrid\C_Utility as C_Utility;
use phpGrid\C_SessionMaker as C_SessionMaker;
require_once(__DIR__ . '/conf/conf.php');

$session = C_SessionMaker::getSession(FRAMEWORK);

if (!isset($HTTP_POST_VARS) && isset($_POST)){ $HTTP_POST_VARS = $_POST;}  // backward compability when register_long_arrays = off in config


//  ob_start();
//  var_dump($_POST);
//  $res = ob_get_clean();


$gridName   		= isset($_GET['gn']) ? $_GET['gn'] : die('PHPGRID_ERROR: URL parameter "gn" is not defined');
$advancedFilter 	= FALSE;
$advancedFilter 	= isset($_GET['advancedFilter']);
$subgridNumber 		= isset($_GET['sgn']) ? $_GET['sgn'] : '';
$catalogInstanceId 	= $_GET['catalog_instance_id'];
$adminDatagrid		= isset($_GET['adg']) ? $_GET['adg'] : false; 
$logicalLink		= isset($_GET['sll']) ? $_GET['sll'] : "";
$editFlags			= isset($_GET['ef']) ? $_GET['ef'] : 0;
$fixedValues		= (!is_null($catalogInstanceId) && $adminDatagrid) ? ET_BrowsingStore::getBrowsingStore()->get_fixedValues($catalogInstanceId, $logicalLink) : array();
//var_dump($fixedValues);
$advancedFilterSaveAs 	= 0;
$catalogInstanceIdAdmin = isset($_SESSION[SESS_CATALOG_INSTANCE_ID_MASTER_ADMIN]) ? $_SESSION[SESS_CATALOG_INSTANCE_ID_MASTER_ADMIN] : null;


foreach ($_POST as $key => $value) {
	$actKeyLower = strtolower($key);
	if ($actKeyLower == strtolower(SELECTION_TABLE_FIELD_SAVE_DEFAULT)) {
		$advancedFilterSaveAs = $_POST[$key];
	}		
}

 


$grid_sql 		= $session->get(GRID_SESSION_KEY.'_'.$gridName.'_sql');
$sql_key    	= unserialize($session->get(GRID_SESSION_KEY.'_'.$gridName.'_sql_key'));
$sql_fkey   	= $session->get(GRID_SESSION_KEY.'_'.$gridName.'_sql_fkey');
$sql_mfkey  	= $session->get(GRID_SESSION_KEY.'_'.$gridName.'_sql_mfkey');
$sql_table  	= $session->get(GRID_SESSION_KEY.'_'.$gridName.'_sql_table');
$sql_filter 	= $session->get(GRID_SESSION_KEY.'_'.$gridName.'_sql_filter');
$db_connection 	= unserialize($session->get(GRID_SESSION_KEY.'_'.$gridName.'_db_connection'));
// $is_debug    = $session->get(GRID_SESSION_KEY.'_'.$gridName.'_is_debug');
$has_multiselect = $session->get(GRID_SESSION_KEY.'_'.$gridName.'_has_multiselect');
$col_readonly 	= unserialize($session->get(GRID_SESSION_KEY.'_'.$gridName.'_col_readonly'));
$col_hiddens 	= unserialize($session->get(GRID_SESSION_KEY.'_'.$gridName.'_col_hiddens'));

//establish db connection
$cn = $db_connection;
//etixpert
	
$db 		= new C_DataBase($cn["hostname"],$cn["username"],$cn["password"],$cn["dbname"],$cn["dbtype"],$cn["dbcharset"], array(), $cn["dbauthmechanism"], $cn['passwordEncrypted']);
$db_type 	= $cn["dbtype"];
$db_charset = $cn["dbcharset"];
$connName 	= ET_BrowsingStore::getBrowsingStore()->get_connName($catalogInstanceId);

// if it is a masterdetail grid, obtain the value of the foreign key to save it when later adding new
$src = isset($_GET['src'])?$_GET['src']:'';
if($src=='md' || $src=='sg'){
    $fkey = $_GET['fkey'];
    $fkey_value = $_GET['fkey_value'];

    if(C_Utility::is_debug()){
        echo 'fkey: ' ."\n";
        print_r($fkey);
        echo  "\n";
        echo 'fkey_value: ' ."\n";
        print_r($fkey_value);
    }
}

$arrFields  = array();
$advFilterFields  = array();
$pk         = $sql_key; // $dg->get_sql_key();      // Array: primary key
$pk_val     = explode(",",$_POST[JQGRID_ROWID_KEY]); // e.g. "10104---141,10103---14111", convert to Array
$oper       = isset($_POST['oper']) ? $_POST['oper'] : ''; // operan type
$sqlCrud    = '';     // CRUD sql

// ###### DEBUG ONLY #############
if(C_Utility::is_debug()){
    echo  "\n";
    echo 'pk: ' ."\n";
    print_r($pk);
    echo 'pk_val: ' ."\n";
    print_r($pk_val);
	
}
// ###############################

if($oper != ''){
    $rs     = $db->select_limit($grid_sql, 1, 1);
    // EXCLUDING: 'oper', non-table-field, and auto increment, fields.
   // if(PHPGRID_DB_TYPE == 'pdo_odbc_db2')
   //etixpert change (only if statement)
   
   if($db_type == 'pdo_odbc_db2'){
        $db2_metcolumns = $db->db2_field_metacolumns();

        foreach($HTTP_POST_VARS as $key => $value){
            if($key != 'oper'){
                for($i=0;$i<count($db2_metcolumns);$i++){
                    if($db2_metcolumns[$i]['NAME'] == $key && $db2_metcolumns[$i]['IDENTITY'] == 'N'){
                        $arrFields[$key] = $value;
                    }
                }
            }
        }
    }else{
    	
    	//read-only fields are ommited from $_POST. we have to push them to set fixed values:
    	pushReadOnlyWithDefaultValuesToValidList($HTTP_POST_VARS, $fixedValues, $col_readonly);
    	$idCount = 0;
    	
        foreach($HTTP_POST_VARS as $key => $value) {
        	
        	$columnPartOfFixedValues = key_exists($key, $fixedValues);        	
        	        	
            if($key != 'oper' && !($db_type == "oci805" && $key == "id")) {
            	            	
	         	$obj_field 	= $db->field_metacolumn($sql_table, $key);
	         	
	         	//id is a "fake" element if not in the column list -> $obj_field object cannot be made
	         	if ($obj_field == false) continue;
	         	//jqGrid row-id is always passed in POST as "id" but we can have id in column list as well
	         	if (strtoupper($key) == "ID") {
	         		$idCount ++;
	         		//if we have already an id column - the 1st one is the real one	         		
	         		if ($idCount > 1) continue;	         		
	         	}
	         	
	         	//$obj_field->primary_key does not exist in the case of each connection
	         	$columnPK 				= in_array($obj_field->name, $pk);
	         	$columnReadOnly			= in_array($key, $col_readonly);
	         	$columnHidden			= isset($col_hiddens[$key]);
	         	
                if ($advancedFilter && $advancedFilterSaveAs == 0) {	
                	
					if (strtolower($key) == strtolower(SELECTION_TABLE_FIELD_SAVE_DEFAULT))	{
						$arrFields[$key] = $value;
					}					
					if(!$columnHidden && $obj_field) {
						$advFilterFields[$key] = $value;
					}
                } 
                /*if a col is empty and passed to the ADVANCED-FILTER the SQL will crash -> eg select ... where col = NULL...
                 * but columns with fixed values must take part in the field list => value will be filled later from source col!*/
                else if ($columnReadOnly && empty($value) && !$columnPartOfFixedValues) {
                	//$advFilterFields[$key] = $value;
                } else {
                	// check field type. do not save field is either auto increment (MySQL) or meta type is 'R' (MS SQL, PostgreSQL)					                	
                	if ($obj_field) {
                		
                		if (isset($obj_field->identity)) {                			
                			if ($obj_field->identity == '') {
                				$arrFields[$key] = $value;
                				
                				if (!$columnHidden) {
                					$advFilterFields[$key] = $value;
                				}
                			}
                		} else if(isset($obj_field->auto_increment)) {      // MySQL, MS SQL                			
                			if (!$obj_field->auto_increment) {
                				$arrFields[$key] = $value;
                				
                				if (!$columnHidden) {
                					$advFilterFields[$key] = $value;
                				}
                			}
                		} else if ((isset($obj_field->type))) {                			
                			if($obj_field->type != 'SERIAL') {       // Postgres
                				$arrFields[$key] = $value;
                				
                				if (!$columnHidden) {
                					$advFilterFields[$key] = $value;
                				}
                			}
                		} else if ($db->field_metatype($rs, $db->field_index($rs, $key)) != 'R') {   // Others? Check field type directly by field index                			
                			$arrFields[$key] = $value;
                			                			
                			if (!$columnHidden) {
                				$advFilterFields[$key] = $value;                			
                			}
                		} 
                		
                		// if PK col is not filled we omit it from SQL. it can get value from fixed values setting
                		if ($columnPK && $value == '' && !$columnPartOfFixedValues) {
                			unset($arrFields[$key]);
                		}                		
                		
                		if (isset($arrFields[$key])) {
                			
                			if (($editFlags & EDIT_FLAG_FORCE_LINKTYPE_MD) == EDIT_FLAG_FORCE_LINKTYPE_MD) {
                				$arrFields["linktype"] = "0";
                			}
                			else if (($editFlags & EDIT_FLAG_FORCE_LINKTYPE_AF) == EDIT_FLAG_FORCE_LINKTYPE_AF) {
                			//else if ($editFlags & EDIT_FLAG_FORCE_LINKTYPE_AF) {
                				$arrFields["linktype"] = "1";
                			}
                			
                			if (isset($fixedValues[$key])) {                				
                				$fixedDef 	= $fixedValues[$key];
                				$colValue 	= $fixedDef;
                				
                				$colValue = ET_PropertiesAdmin::getInstance()->resolveColumnValues($colValue, $HTTP_POST_VARS);                				
                				$colValue = ET_PropertiesAdmin::getInstance()->resolveAndCallFunction($colValue);
                				
                				$arrFields[$key]	= $colValue;
                			} 
                		}
                	}
                }
                
            }
        } //FOREACH ENDS HERE!
        
    }        
   
    // prefill a detail grid with the value of the foreign key from master grid when adding
    // ONLY prefill when fkey_value is not set or left blank because user CAN enter a different fkey_value via form that is different from what its parent has.
    //
    // ###### DEBUG ONLY #############
    
    if($src =='sg' && $oper == 'add'){
        if(!isset($_POST[$fkey]) || (isset($_POST[$fkey]) && $_POST[$fkey] == '')){
            $arrFields[$fkey] = $fkey_value;
        }
    } elseif($src=='md' && $oper == 'add'){
        if(!isset($_POST[$sql_fkey]) || (isset($_POST[$sql_fkey]) && $_POST[$sql_fkey] == '')){
            $arrFields[$sql_fkey] = $fkey_value;
        }
    }
   
    // Add single quote to PK Value if it's not an integer(I), numeric(N), or autocrement int(R)
    // Richard 9/2013 - added composite PK support with quote_fields
    $sql_where = '';
    if($oper != 'add'){
    	
        $pk_val_new = $db->quote_fields($rs, $sql_key, $pk_val);
       
        // An alternative version (better? by <raul at rolvas dot com>). 
        // Must set CONCAT_NULL_YIELDS_NULL to ON in ADOdb
        //etixpert         
        if($db_type == 'odbc_mssql_native' || $db_type == 'odbc_mssql'  || $db_type == DB_TYPE_MSSQL){        	
        	//*******	IMPORTANT	******//
        	// THIS IS ONLY THE UPDATE STMT! where condition for DELETE stmt is set up later and overwrites this $sql_where
        	// so here is the UPDATE $sql_where is set up! that's why only $pk_val_new[0] is used originally in phpgrid code.
        	// mssql compund PK is get in string in thath way: "('pk1_val', 'pk2_val', ...)"
        	
        	//trimming the extra '(' and ')' characters from the beginning and the end of values        	
        	$pk_val_new_str = strval($pk_val_new[0]);
        	$pk_val_new_str = substr($pk_val_new_str, 1);
        	$pk_val_new_str = substr($pk_val_new_str, 0, strlen($pk_val_new_str) - 1);
        	
        	foreach (array_combine($sql_key, explode(',', $pk_val_new_str)) as $pk_name => $pk_value) {        	
        		$sql_where .= " $pk_name = $pk_value AND"; 
			}			
            $sql_where = preg_replace('/AND$/', '', $sql_where);
            
        } else { 
            $sql_where = ' ('. implode(',', $sql_key) .') IN ('. implode(',', 
            $pk_val_new) .') '; 
        }
		
        // ###### DEBUG ONLY ######################
        if(C_Utility::is_debug()){ 
			echo 'sql_where: '. $sql_where ."\n"; 
			//file_put_contents('./log_'.date("j.n.Y").'.txt', "sqlKey: " . implode(',', $sql_key) . "\n", FILE_APPEND);		
		}
        // #########################################
    }

	


    // *** Note ***
    // Apparently, the SQL does not put single quote around numeric. This is preferred.
    // Why GetUpdateSQL, not AutoExecute()?
    // 1. $GetUpdateSQL($rs, $arrFields, $forceUpdate) does not require table name as parameter
    // 2. *** It only update values with valid field name ***
    // 3. AutoExecute() creates more overhead by validating whether rs is valid
    // 
    
   	$columnInfo = ET_BrowsingStore::getBrowsingStore()->get_selectedColumnInfo($catalogInstanceId);
    
    
    //TODO - get the reason of that trim:
    $arrFields = ET_StringCheck::rTrimValues($arrFields);
    $removePassword = false;
    $passWordColumnName = "";
 
    foreach ($arrFields as $key => $value) {
    	if (strtolower($key) == strtolower(COLUMN_NAME_PASSWORD)) {
    		if (empty($value)) {
    			$removePassword = true;
    			$passWordColumnName = $key;
    		}
    	}
    }
    
    if ($removePassword) {
    	unset($arrFields[$passWordColumnName]);
    }
    
    switch($oper){
        case 'add':
        	//ET_MetaDataConnector::getInstance()->setNullValuesForSQLQuery($arrFields, $columnInfo, $db_type);
        	
        	try{
        		ET_MetaDataConnector::getInstance()->setNullValuesForSQLQuery($arrFields, $columnInfo, $db_type, $oper);
        	} catch (Exception $e){
        		die ('PHPGRID_ERROR: ' . $e->getMessage());
        	}
        	        	
            $sqlCrud = $db->GetInsertSQL($rs, $arrFields, $sql_table);
            if ($adminDatagrid && !is_null($catalogInstanceIdAdmin)) {
            	if (strtolower($catalogInstanceIdAdmin) == strtolower(ET_SysTableHandler::getSpecificTableOrViewFullName(T_USER, ET_METADATA_CONNECTION)))
            		$sqlCrud = ET_GeneralHelperAdmin::replacePassword($sqlCrud);
            }            	
            break;
        case 'edit':
        	//ET_MetaDataConnector::getInstance()->setNullValuesForSQLQuery($arrFields, $columnInfo, $db_type);
        	try{
        		ET_MetaDataConnector::getInstance()->setNullValuesForSQLQuery($arrFields, $columnInfo, $db_type, $oper);
        	}catch (Exception $e){
        		die ('PHPGRID_ERROR: ' . $e->getMessage());
        	}
        		
        	//Etixpert change
        	$sqlFromRs = $rs->sql;
        	
        	if (strpos(strtolower($sqlFromRs), " where ")) {
        		
        		$pos = strpos(strtolower($sqlFromRs), " where ");
        		$sqlFromRs = substr($sqlFromRs, 0, $pos);
        		$rs->sql = $sqlFromRs;
        	}
        	//Etixpert change ends
        	
            $sqlCrud = $db->GetUpdateSQL($rs, $arrFields, $sql_table) .'  WHERE '. $sql_where; // $pk .'='. $pk_val;ű
            
            //Etixpert change
            if ($adminDatagrid && !is_null($catalogInstanceIdAdmin)) {
            	if (strtolower($catalogInstanceIdAdmin) == strtolower(ET_SysTableHandler::getSpecificTableOrViewFullName(T_USER, ET_METADATA_CONNECTION)))
            		$sqlCrud = ET_GeneralHelperAdmin::replacePassword($sqlCrud);
            }
            //Etixpert change ends
		    break;
        case 'del':
            // borrowed from _adodb_getupdatesql() in adodb-lib.inc.php
            preg_match("/FROM\s+".ADODB_TABLE_REGEX."/is", $grid_sql, $tableName);
            $tableName = $tableName[1];
            if($has_multiselect){     	

            	if ($db_type == 'odbc_mssql_native' || $db_type == DB_TYPE_ODBC_MSSQL || $db_type == DB_TYPE_ODBC_TERADATA || $db_type == DB_TYPE_MSSQL) {
					$sql_where = ET_MetaDataConnector::getInstance()->constructMultipleDeleteWhereConditionSQLServer($sql_key, $pk_val, $columnInfo);					
            	} else {
            		$pk_val_new = ET_MetaDataConnector::getInstance()->constructMultipleDeleteValueGroups($sql_key, $pk_val, $columnInfo);
            		$sql_where = ' ('. implode(',', $sql_key) .') IN ('. implode(',',
            				$pk_val_new) .') ';
            	}
            			
            	/*		
            	$needQuotes = isQuotesNeededForPK($_SESSION['selected_conn'], $_SESSION['selected_db'], $_SESSION['selected_table'], getConnection($_SESSION['selected_conn']));
            	//$needQuotes = true;
            	$in = $needQuotes ? "'" . $pk_val[0] . "'" : $pk_val[0];
            	if (is_array($pk_val)) {
            		if (count($pk_val) > 1) {
            			$in = $needQuotes ? implode("','", $pk_val) : implode(",", $pk_val);
            			if ($needQuotes) $in = "'" . $in . "'";
            		}		
            	}
                $sqlCrud = 'DELETE FROM '. $tableName .'  WHERE ('. implode(",", $pk) .') IN('. $in .')';       
                */
                
                $sqlCrud = 'DELETE FROM '. $tableName .'  WHERE '. $sql_where; 
            }else{
                $sqlCrud = 'DELETE FROM '. $tableName .'  WHERE '. $sql_where; // $pk .'='. $pk_val;
            }
            break;
    }
    
    if(C_Utility::is_debug()){
    
		//file_put_contents('./log_'.date("j.n.Y").'.txt', 'sqlCrud: '. $sqlCrud ."\n", FILE_APPEND);
		
		echo 'sqlCrud: '. $sqlCrud ."\n";
	}
	
    /* (MySql only) Allow reserved keywords (hyphen) in column names */
	//if(PHPGRID_DB_TYPE == 'mysql' || PHPGRID_DB_TYPE == 'mysql_dsn')
	//etixpert cahnge - condition
    if($db_type == 'mysql' || $db_type == 'mysql_dsn'){
        foreach($arrFields as $k => $v){
            if(strpos($k, '-') !== false){  // only escape column name contains '-'
                $sqlCrud = str_replace(strtoupper($k), '`'.strtoupper($k).'`', $sqlCrud);
            }
        }
    }
	
    if(C_Utility::is_debug()){ echo 'sqlCrud: '. $sqlCrud ."\n";}
    
    if($sqlCrud!='') {
        // passing an array of values to be used by PDO prepare()
        $kv 		= array();
        $logCrud 	= $sqlCrud;
      
        foreach($arrFields as $key => $value) { 
        	$kv[":".$key] = $value; 
        }
		               
        if ($db_type == 'odbc_mssql' || $db_type == 'odbc_teradata')
        	$sqlCrud = iconv("UTF-8",$db_charset,$sqlCrud);       	
        	//$sqlCrud = iconv("utf-8", "iso-8859-2", $sqlCrud);
      
        if ($advancedFilter === FALSE) {
        	$db->db_query($sqlCrud, $kv);
        	try {
        		ET_LoggingHelper::log($connName, $logCrud, LOGGING_SOURCE_EDIT);
        	} catch (Throwable $e) {
        		die('PHPGRID_ERROR: Logging error occured: ' . $e);
        	}        	
        } else {
        	if ($advancedFilterSaveAs == 1) {
        		echo "ADVANCED_FILTER_SAVED";
        	}
        	else {
        		echo "ADVANCED_FILTER_NO_MESSAGE";
        	}
        	
        	$_SESSION[SESS_ADVANCED_FILTER_FILTERED_CATALOG_FIRST_LOAD] = TRUE;
        	
        	$browsingStore = ET_BrowsingStore::getBrowsingStore();
        	$targetTableCatalogInstanceId = $_SESSION[SESS_ADVANCED_FILTER_FILTERED_INSTANCE_ID];
        	
        	$browsingStore->create_browsingState($targetTableCatalogInstanceId);
        	$browsingStore->flushBrowsingStore();
        	$browsingStore = ET_BrowsingStore::getBrowsingStore();
        	
        	$browsingStore->set_filterKeyPair($targetTableCatalogInstanceId, $advFilterFields);
        	$browsingStore->flushBrowsingStore();
        	
       		$db->db_query($sqlCrud, $kv);
        }
        
        if($oper == 'add'){
            echo '{"id":"'. $db->Insert_ID() .'"}';
        }else{
            // do not display debug if it's add (which is going to throw off the JSON returned)
            // ###### DEBUG ONLY ######################
            if(C_Utility::is_debug()) {
                print_r($arrFields);
                echo 'SQL: '. $sqlCrud ."\n";
            }
            // #########################################
        }
    }

}

$db = null;


function pushReadOnlyWithDefaultValuesToValidList(&$HTTP_POST_VARS, $fixedValues, $readOnlyFields) {
	
	for ($i = 0; $i < count($readOnlyFields); $i++) {
		$field = $readOnlyFields[$i];
				
		if (key_exists($field, $fixedValues)) {
			
			foreach ($fixedValues as $key => $val) {
				
				if (!key_exists($key, $HTTP_POST_VARS)) {
					$HTTP_POST_VARS[$key] = "";
				} else {
					continue;
				}
			}
		}	
		else {
			continue;
		}
	}
	
}

?>