<?php
	
	function handleUnauthorizedUser ($niotaUser) {
		
		if (isset ($_SESSION['username']) && !$niotaUser->get_isAdmin()) {
			ET_DisplayHelper::addErrorLine(ET_DisplayHelper::localize("ADMIN_PAGE_NO_ACCESS"), "niota");
			header("Location: ../niota.php");
		}
		else {
			header("Location: ../../login.php");
		}
		
		
	}
	
	function initializeMainSettings () {
		$ret = array();
		
		ini_set('max_execution_time', 3000);
		
		$bodyTag 				= new HTMLBody();
		$divContent 			= new HTMLDiv();
		$divMain 				= new HTMLDiv();
		
		
		$divMain->set_class("niota-bg-image-admin");
		$divContent->set_class("width-100perc height-100perc");
		
		$ret["divMain"]		 = $divMain;
		$ret["divContent"]	 = $divContent;
		$ret["bodyTag"]		 = $bodyTag;
		
		return $ret;
	}