<?php
	include ("admin_handler.php");
	include ("../niota_helper.php");
	
	
	if(!isset($_SESSION))
		session_start();

	
	
	function exception_handler($exception) {
		$currentPage = basename($_SERVER['SCRIPT_FILENAME']);
		
		if (!isset($_SESSION["uncought_exception"]))
			$_SESSION["uncought_exception"] = "";
			
			if (!empty($exception)) {
				$_SESSION["uncought_exception"] .= $exception;
			}
			
			ET_GeneralHelperAdmin::clearBuggyAdminPageSetting($currentPage);
			echo "<script>window.location = '../error.php';</script>";
			
	}
	
	function error_handler ($error, $errString) {
		$currentPage 	= basename($_SERVER['SCRIPT_FILENAME']);
		$responseStr    = "";
		$systemLogger   = new ET_LoggingHelperSystem();
		
		if (!isset($_SESSION["uncought_error"]))
			$_SESSION["uncought_error"] = "";
			
			if (!empty($errString)) {
				$_SESSION["uncought_error"] .= $errString;
			}
			
			if ($error === E_WARNING || $error == E_NOTICE) {
				
				$errorType = $error == E_WARNING ? "Warning! " : "Notice! ";
				
				if ($error == E_WARNING && !shouldThrowAwayWarning ($errString)) {
					//$responseStr .= $errorType . " " . ET_DisplayHelper::localize("MISCONFIGURATION_GENERAL") . " " . $errString;
					$responseStr .= $errorType . " " . $errString;
					
					if (isset(debug_backtrace()[0]))
						$responseStr .= " Stack trace:";
						
						for ($i = count(debug_backtrace()) -1; $i >= 0; $i--) {
							
							$backTrace =  debug_backtrace()[$i];
							if (isset($backTrace["file"])) {
								$responseStr .=  "<br>" . $backTrace['file'] . " Line: " .  $backTrace['line'];
							}
						}
						
						ET_DisplayHelper::addErrorLine($responseStr, basename(__FILE__, ".php"));
						$systemLogger->addSystemLogEntry(LOG_TYPE_ERROR, $responseStr);
						
						$_SESSION["uncought_error"] = "";
				}
			}
			else {
				
				ET_GeneralHelperAdmin::clearBuggyAdminPageSetting($currentPage);
				echo "<script>window.location = '../error.php';</script>";
			}
			
	}
	
	set_exception_handler("exception_handler");
	set_error_handler("error_handler");
	
	$niotaUser = null;
	
	if (!(isset ($_SESSION['username']))) {		
		$locationLogin 		= ET_PathHelper::getLoginPathWithClientDef();		
		header("Location: $locationLogin");
	}
	
	ET_CookieHandler::testCookieAccept();
	$niotaUser =  getAndResetNiotaUser();
	
	if (!$niotaUser->get_isAdmin()) {
		handleUnauthorizedUser($niotaUser);
	}
	
	$optionKey = isset($_GET['ok']) ? $_GET['ok'] : "";
	if ($tableKey != "") {
		
		$isTable = ET_GeneralHelperAdmin::isObjectTable($tableKey);
		
		$catalogInstanceId 									= ET_SysTableHandler::getSpecificTableOrViewFullName($tableKey, ET_METADATA_CONNECTION, $isTable);
		$_SESSION[SESS_CATALOG_INSTANCE_ID_MASTER_ADMIN] = $catalogInstanceId;
		$fullTableName = $catalogInstanceId;
		
		if ($detailTableKey_1 != '') {
			$isDetail1Table 			= ET_GeneralHelperAdmin::isObjectTable($detailTableKey_1);
			$detailCatalogInstanceId_1 	= ET_SysTableHandler::getSpecificTableOrViewFullName($detailTableKey_1, ET_METADATA_CONNECTION, $isDetail1Table);
			$detailFullTableName_1 = $detailCatalogInstanceId_1;
			$detailTableLogicalLink_1 = $detailFullTableName_1 . "_" . $optionKey. "_logical_link_1";
		}
		
		if ($detailTableKey_2 != '') {
			$isDetail2Table 			= ET_GeneralHelperAdmin::isObjectTable($detailTableKey_2);
			$detailCatalogInstanceId_2 	= ET_SysTableHandler::getSpecificTableOrViewFullName($detailTableKey_2, ET_METADATA_CONNECTION, $isDetail2Table);
			$detailFullTableName_2 = $detailCatalogInstanceId_2;
			$detailTableLogicalLink_2 = $detailFullTableName_2 .  "_" . $optionKey . "_logical_link_2";
		}
	}	
	
	ET_CallableObjectHelperAdmin::loadCallableObjects($optionKey);
	/*it's necessary to be able to load admin properties*/
	$niotaUser 		= ET_NiotaUser::getNiotaUserFromSession();
	//TODO send file name to the following functions:
	$callablesTable	= $niotaUser->getAdminTableLevelProps($optionKey, $fileName);
	$callablesLine	= $niotaUser->getAdminLineLevelProps($optionKey, $fileName);
	
	if (!empty($callablesLine) || !empty($callablesTable))
		$displayCallablesMenuItem 	= true;
	
	
	$resArr 		= initializeMainSettings();
	
	$divContent		= $resArr["divContent"];
	$divMain		= $resArr["divMain"];
	
	$htmlTag 				= new HTMLhtml();
	$headTag 				= new HTMLHead();
	$bodyTag				= new HTMLBody();
	
	$divUpperLine 			= new HTMLDiv();
	$divLowerLine 			= new HTMLDiv();
	$divNaviIconWrap		= new HTMLDiv();
	$divGridContainer		= new HTMLDiv();
	$divSidebar 			= new HTMLDiv();
	$divSidebarHeader		= new HTMLDiv();
	$divPageTitle			= new HTMLDiv();
	$divLogoAndTitleOuter	= new HTMLDiv();
	$divLogoAndTitleInner	= new HTMLDiv();
	
	$imgLogo				= new HTMLImage();
	$imgLogout 				= new HTMLImage();
	$imgPersonal			= new HTMLImage();
	$imgAdminPage			= new HTMLImage();
	$imgHelpCustom			= new HTMLImage();
	$imgHelpSystem			= new HTMLImage();
	
	$spanProdName			= new HTMLSpan();
	$spanClaim				= new HTMLSpan();
	$spanName				= new HTMLSpan();
	
	$aLogout				= new HTMLa();
	$aPersonal				= new HTMLa();
	$aNiotaPage				= new HTMLa();
	$aOpenMenu				= new HTMLa();
	$aHelpCustom			= new HTMLa();
	$aHelpSystem			= new HTMLa();
		
	$idsForJSSidebar		= array("sidebar_id", "sidebar_header_id");
	
	$imgLogout->set_src("../images/logout.png")->set_title(ET_DisplayHelper::localize("LOGOUT"))->set_class("margin-left-10px");
	$imgPersonal->set_src('../images/user.png')->set_title(ET_DisplayHelper::localize('PERSONAL_PAGE'))->set_class("margin-left-10px")->set_onclick("display_menu_features(\"modal_main\", \"\")");
	//$imgNiotaPage->set_src('../images/gridedit.png')->set_class();
	$imgAdminPage->set_src(NIOTA_ROOT_DIR. '/etixpert/images/gridedit.png')->set_onclick("saveCurrentSurface(false)");
	$imgHelpCustom->set_src("../images/help_custom.png")->set_title(ET_DisplayHelper::localize("HELP_CUSTOM"))->set_class("margin-left-10px");
	$imgHelpSystem->set_src("../images/help_system.png")->set_title(ET_DisplayHelper::localize("HELP_SYSTEM"))->set_class("margin-left-10px");
	
	$aLogout->set_href("../logout.php");
	$aPersonal->set_href("#");
	$aNiotaPage->set_href("../niota.php")->set_title(ET_DisplayHelper::localize("GRID_EDIT"));
	$aOpenMenu->set_href("#")->set_id("sidebar_open")->set_display_text(ET_DisplayHelper::localize("OPEN_TABLE_MENU") . "&nbsp;");
	
	$linkCustom = ET_DisplayHelper::setHelpLink(HELP_ICON_TYPE_ADMIN_CUSTOM, $fileName);
	$linkSystem = ET_DisplayHelper::setHelpLink(HELP_ICON_TYPE_ADMIN_SYSTEM, $fileName);
	
	if ($linkCustom !== false)
		$aHelpCustom->set_href($linkCustom)->set_target("_blank")->set_rel("noopener noreferrer");
	if ($linkSystem !== false)
		$aHelpSystem->set_href($linkSystem)->set_target("_blank")->set_rel("noopener noreferrer");
	
	$bodyTag->set_onload('callDrag(true);');
	$divUpperLine->set_class("bgcolor-deep height-7vh");
	$divLowerLine->set_class("bgcolor-mid height-7vh vertical-middle-content")->set_style("z-index: 1100");
	$divNaviIconWrap->set_class("vertical-middle-content float-right width-fit-content height-100perc margin-right-20px");
	$divGridContainer->set_class("grid_container_admin")->set_id("grid_container_id");
	//$divSidebar->set_class("sidebar_admin")->set_id("sidebar_id");
	$divSidebar->set_class("sidebar")->set_id("sidebar_id");
	$divSidebarHeader->set_class("sidebar-header vertical-middle-content")->set_id("sidebar_header_id")->set_onclick("openCloseMenuSection(\"sidebar\", \"" . USER_PARAM_CLOSED . "\", " . json_encode($idsForJSSidebar) . ", \"left\")");
	$divPageTitle->set_class("height-7-vh vertical-middle-content margin-left-20px");
	$divLogoAndTitleOuter->set_class("vertical-middle-content-inline height-100perc");
	
	$spanName->set_class("float-right margin-left-10px font-xl")->set_display_text($niotaUser->get_fullName());
	$spanProdName->set_class("font-xl");
	
	//$sidebarContent	= ET_DisplayHelperAdmin::setSidebarMenuItems($fileName, $displayCallablesMenuItem);
	$sidebarContent	= ET_DisplayHelperAdmin::setAdminOptionsSidebar($optionKey, $displayCallablesMenuItem);
	// TODO -> when sidebar has more content it could be opened and closed, settings will be saved
	//$sidebarState = isset($niotaUser->get_userSettings()[USER_PARAM_SIDEBAR_STATE_ADMIN]) ? $niotaUser->get_userSettings()[USER_PARAM_SIDEBAR_STATE_ADMIN] : USER_PARAM_OPENED;
	/*
	$sidebarState = USER_PARAM_OPENED;
	if ($sidebarState == USER_PARAM_CLOSED) {
		$divSidebarHeader->set_style("display: block");
		$divSidebar->set_style("display: none");
	}
	else {
		$divSidebar->set_style("display: block");
		$divSidebarHeader->set_style("display: none");
	}
	*/
	
	$htmlTag->printOpeningTag();
	$headTag->printOpeningTag();
	ET_DisplayHelper::generateAndPrintTabIconTag("admin");
	echo "<meta http-equiv='Content-Type' content='text/html; charset=utf-8'/>";
	echo "<meta name='viewport' content='width=device-width, initial-scale=1'>";
	ET_DisplayHelper::getNiotaColorTheme(true, true);
	echo "<script type='text/javascript' src='" . SERVER_ROOT . "/js/jquery-2.1.4.min.js'></script>";
	echo "<script type='text/javascript' src='" . SERVER_ROOT . "/js/jquery-ui-1.11.2.min.js'></script>";
	echo "<script src='../js/ajaxFunctions.js' type='text/javascript'></script>";
	echo "<script src='../js/eventHandlers.js' type='text/javascript'></script>";
	
	echo "<script src='" . SERVER_ROOT . "/js/notify.min.js' type='text/javascript'></script>";
	echo "<script src='" . SERVER_ROOT . "/etixpert/js/notify-styling.js' type='text/javascript'></script>";
	
	
	ET_DisplayHelper::printViewModeCorrector($fullTableName);
	
	$headTag->printClosingTag();
	$bodyTag->printOpeningTag();
	$divContent->printOpeningTag();
	$niotaUser->printPersonalModal(true, $fileName, $target);
	if (defined('COMPANY_LOGO'))
		$imgLogo->set_src(ET_DisplayHelper::getLogoPath("admin_header"))->set_style("display: inline-block;")->set_height("60")->set_class("margin-left-20px margin-top-tiny margin-right-10px");
		else
			ET_DisplayHelper::addErrorLine(ET_DisplayHelper::localize("ERROR_COMPANY_LOGO_CONSTANT"), "niota");
	
			$divUpperLine->printOpeningTag();
			$divLogoAndTitleOuter->printOpeningTag();
				$imgLogo->printOpeningTag();
				$divLogoAndTitleInner->printOpeningTag();	
					$spanProdName->printOpeningTag();
					if (defined('PRODUCT_NAME'))
						echo PRODUCT_NAME;
					else
						ET_DisplayHelper::addErrorLine(ET_DisplayHelper::localize("PRODUCT_NAME_NOT_DEFINED"), "admin.php");
						
					$spanProdName->printClosingTag();
					$spanClaim->printOpeningTag();
						
					if (defined('CLAIM'))
						echo CLAIM;
					else
						ET_DisplayHelper::addErrorLine(ET_DisplayHelper::localize("CLAIM_NOT_DEFINED"), "admin.php");
						
					$spanClaim->printClosingTag();
				$divLogoAndTitleInner->printClosingTag();
			$divLogoAndTitleOuter->printClosingTag();
			
					$divNaviIconWrap->printOpeningTag();
					//if admin area is done, this will be uncommented:
						if ($niotaUser->get_isAdmin()) {
							$aNiotaPage->printOpeningTag();
							$imgAdminPage->printOpeningTag();
							$aNiotaPage->printClosingTag();
						}
						$spanName->printOpeningTag();
						$spanName->printDisplayText();
						$spanName->printClosingTag();
						$aLogout->printOpeningTag();
							$imgLogout->printOpeningTag();
						$aLogout->printClosingTag();
						$aPersonal->printOpeningTag();
							$imgPersonal->printOpeningTag();
						$aPersonal->printClosingTag();
						$aHelpCustom->printOpeningTag();
							$imgHelpCustom->printOpeningTag();
						$aHelpCustom->printClosingTag();
						$aHelpSystem->printOpeningTag();
							$imgHelpSystem->printOpeningTag();
						$aHelpSystem->printClosingTag();						
					$divNaviIconWrap->printClosingTag();
	
	
				$divUpperLine->printClosingTag();
				/*	**********	UPPER MENU LINE ENDS	***********	*/
				
				$divLowerLine->printOpeningTag();
				$currentPageLink = ET_DisplayHelperAdmin::printAdminMenuItems($fileName, $optionKey, $catalogInstanceId);
					/*
					$divPageTitle->printOpeningTag();
						echo "<b>" . $optionKey . "</b>";
						ET_DisplayHelperAdmin::displayReverseIcon ($sidebarContent, $optionKey, $catalogInstanceId);
					$divPageTitle->printClosingTag();
					*/
				
				$divLowerLine->printClosingTag();
				
				/*	**********	LOWER MENU LINE ENDS	***********	*/
				
				$divContent->printOpeningTag();
					$divMain->printOpeningTag();
				
						if (!empty($callablesTable) || !empty($callablesLine)) {
							ET_DisplayHelper::printCallableObjectPopup($callablesTable, $callablesLine, $optionKey, $fileName);
							ET_DisplayHelper::printtCallableObjectFeedbackWindow();
						}
						
						if (!empty($sidebarContent)) {
						
								$divSidebar->printOpeningTag();
								//$imgCloseSidebar->printOpeningTag();
								//ET_DisplayHelperAdmin::displaySidebarItems ($sidebarContent, $optionKey, $catalogInstanceId);
								ET_DisplayHelperAdmin::displayAdminOptionsSidebar ($sidebarContent, $optionKey, $catalogInstanceId);
								$divSidebar->printClosingTag();
							}
						
						$divGridContainer->printOpeningTag();
		
		/* *******************	HTML section ends	******************* */
						

		
		