<?php

/*
 * ----------------------------------------------------------------
 * Here the look and feel of the admin pages is configured
 * ----------------------------------------------------------------
 */
/* ===========+========+===== changelog ==========================================
 -- YYYY.MM.DD | author | change
 -- -----------+--------+----------------------------------------------------------
 -- 2020.05.01   rre      add deployment-functions
 -- 2020.06.02   rre      switch reverse-pairs from constant_definition to admin_options
 -- 2022.03.01   rre      switched userconfig from superuser to admin security
 -- *******************************************************************************
 */
define ('ADMIN_GROUP_SYSTEMSETTING', 				'group_systemsetting');
define ('ADMIN_ACTION_MANAGE_CONNECTION', 			'connection');
define ('ADMIN_ACTION_MANAGE_LOGGING', 				'logging');
define ('ADMIN_ACTION_MANAGE_SYSTEMCONFIG',	   	    'systemconfig');
define ('ADMIN_ACTION_MANAGE_SEQUENCE',	   	        'sequence');
define ('ADMIN_ACTION_MANAGE_MESSAGETEXT',	   	    'messagetext');


define ('ADMIN_GROUP_CATALOG', 						'group_catalog');
define ('ADMIN_ACTION_MANAGE_CATALOG_ADD', 			'catalog_ADD');
define ('ADMIN_ACTION_MANAGE_CATALOG_ADDMAN', 		'catalog_ADDMAN');
define ('ADMIN_ACTION_MANAGE_CATALOG', 				'catalog');
define ('ADMIN_ACTION_MANAGE_CATALOG_ACCESS',		'catalog_access');
define ('ADMIN_ACTION_MANAGE_CATALOG_CONFIG',		'catalog_config');

define ('ADMIN_GROUP_LOOKUP', 						'group_lookup');
define ('ADMIN_ACTION_MANAGE_LOOKUP', 				'lookup');
define ('ADMIN_ACTION_MANAGE_CONSTRAINT', 			'constraint');
define ('ADMIN_ACTION_MANAGE_CATALOG_COLPROP',      'catalog_colprop');
define ('ADMIN_ACTION_MANAGE_CATALOG_COLFORMAT',    'catalog_colformat');

define ('ADMIN_GROUP_USER', 						'group_user');
define ('ADMIN_ACTION_MANAGE_USER', 				'user');
define ('ADMIN_ACTION_MANAGE_USERGROUP', 			'usergroup');
define ('ADMIN_ACTION_MANAGE_MEMBERSHIP',			'membership');

define ('ADMIN_GROUP_USERSETTING', 					'group_usersetting');
define ('ADMIN_ACTION_MANAGE_USERPARAMETER', 		'userparameter');
define ('ADMIN_ACTION_MANAGE_USERCONFIG',	   	    'userconfig');
define ('ADMIN_ACTION_MANAGE_USERCOMM',	   	        'usercomm');

define ('ADMIN_GROUP_CALLABLE', 					'group_callable');
define ('ADMIN_ACTION_MANAGE_CALLABLE',				'callable');
define ('ADMIN_ACTION_MANAGE_CALLABLE_ACCESS',		'callable_access');
define ('ADMIN_ACTION_MANAGE_CATALOG_CALLABLE',		'catalog_callable');

define ('ADMIN_GROUP_TRANSACTION',	 				'group_transaction');
define ('ADMIN_ACTION_MANAGE_TRANSACTION',			'transaction');
define ('ADMIN_ACTION_MANAGE_TRANSACTIONMENU',		'transactionmenu');
define ('ADMIN_ACTION_MANAGE_TRANSACTION_ACCESS',	'transaction_access');

define ('ADMIN_GROUP_TABLELINK',		 			'group_tablelink');
define ('ADMIN_ACTION_MANAGE_MASTER_DETAIL', 		'master_detail');
define ('ADMIN_ACTION_MANAGE_ADVANCED_FILTER', 		'advanced_filter');

define ('ADMIN_GROUP_METADB',   					'group_metadb');
define ('ADMIN_ACTION_MANAGE_METADBOBJECT',			'metadbobject');
define ('ADMIN_ACTION_MANAGE_METADBOBJECTLINK',		'metadbobjectlink');
define ('ADMIN_ACTION_MANAGE_METADBREPOSITORY',	    'repository');

// unused: define ('ADMIN_GROUP_DEPLOY',   					'group_deploy');
define ('ADMIN_ACTION_MANAGE_DEPLOYIMPORT',			'deployimport');
define ('ADMIN_ACTION_MANAGE_DEPLOYEXPORT',			'deployexport');
define ('ADMIN_ACTION_MANAGE_DEPLOYARCHIVE',	    'deployarchive');
define ('ADMIN_ACTION_MANAGE_DEPLOYLOG',            'deploylog');

define ('ADMIN_GROUP_FORMATDOMAIN',   				'group_formatdomain');
define ('ADMIN_ACTION_MANAGE_FORMATDOMAINLOGC',		'domain_logical');
define ('ADMIN_ACTION_MANAGE_FORMATDOMAINPHYS',		'domain_physical');
define ('ADMIN_ACTION_MANAGE_FORMATDOMAINSEMA',		'domain_semantic');
define ('ADMIN_GROUP_FORMAT',   					'group_format');
define ('ADMIN_ACTION_MANAGE_FORMATCOLUMNCOLL',		'column_collection');
define ('ADMIN_ACTION_MANAGE_FORMATCOLUMNEXT',		'column_format_extended');
define ('ADMIN_ACTION_MANAGE_FORMATOBJECTEXT',		'object_format_extended');

//"reverse" pages does not show up on the upper menu bar:
define ('ADMIN_ACTION_MANAGE_CATALOG_ACCESS_REVERSE',		'catalog_access_reverse');
define ('ADMIN_ACTION_MANAGE_MEMBERSHIP_REVERSE',			'membership_reverse');
define ('ADMIN_ACTION_MANAGE_TRANSACTION_ACCESS_REVERSE',	'transaction_access_reverse');
define ('ADMIN_ACTION_MANAGE_CALLABLE_ACCESS_REVERSE',		'callable_access_reverse');
define ('ADMIN_ACTION_MANAGE_CATALOG_CALLABLE_REVERSE',		'catalog_callable_reverse');
define ('ADMIN_ACTION_MANAGE_USERCONFIG_REVERSE',			'userconfig_reverse');
define ('ADMIN_ACTION_MANAGE_MESSAGETEXT_REVERSE',			'messagetext_reverse');
define ('ADMIN_ACTION_MANAGE_SEQUENCE_REVERSE',				'sequence_reverse');
define ('ADMIN_ACTION_MANAGE_SYSTEMCONFIG_REVERSE',			'systemconfig_reverse');

	// Here is the menu structure of the admin icons	
const ADMIN_OPTIONS = array(
		array("group" => ADMIN_GROUP_SYSTEMSETTING, "actions" => [
//				array("action" => ADMIN_ACTION_MANAGE_CONNECTION, 			"page" => "panel_standard_single_grid.php", "superuser_only" => false),
				array("action" => ADMIN_ACTION_MANAGE_CONNECTION, 			"page" => "niota_admin_grid.php", "superuser_only" => false),

				array("action" => ADMIN_ACTION_MANAGE_LOGGING,				"page" => "niota_admin_grid.php", "superuser_only" => true),
				array("action" => ADMIN_ACTION_MANAGE_SYSTEMCONFIG, 		"page" => "niota_admin_grid.php", "superuser_only" => true),
				array("action" => ADMIN_ACTION_MANAGE_SEQUENCE, 			"page" => "niota_admin_grid.php", "superuser_only" => true),
				array("action" => ADMIN_ACTION_MANAGE_MESSAGETEXT, 			"page" => "niota_admin_grid.php", "superuser_only" => true)
		]), 	
		array("group" => ADMIN_GROUP_CATALOG, "actions" => [
				array("action" => ADMIN_ACTION_MANAGE_CATALOG_ADD, 			"page" => "niota_admin_grid.php", "superuser_only" => false),
				array("action" => ADMIN_ACTION_MANAGE_CATALOG, 				"page" => "niota_admin_grid.php", "superuser_only" => false),
				array("action" => ADMIN_ACTION_MANAGE_CATALOG_ACCESS, 		"page" => "niota_admin_grid.php", "superuser_only" => false),
				array("action" => ADMIN_ACTION_MANAGE_CATALOG_CONFIG, 		"page" => "niota_admin_grid.php", "superuser_only" => false)
		]),
		array("group" => ADMIN_GROUP_LOOKUP, "actions" => [
				array("action" => ADMIN_ACTION_MANAGE_LOOKUP, 				"page" => "niota_admin_grid.php", "superuser_only" => false),
				array("action" => ADMIN_ACTION_MANAGE_CONSTRAINT, 			"page" => "niota_admin_grid.php", "superuser_only" => false),
				array("action" => ADMIN_ACTION_MANAGE_CATALOG_COLPROP, 		"page" => "niota_admin_grid.php", "superuser_only" => false),
				array("action" => ADMIN_ACTION_MANAGE_CATALOG_COLFORMAT, 	"page" => "niota_admin_grid.php", "superuser_only" => false)

		]),
		array("group" => ADMIN_GROUP_USER, "actions" => [
				array("action"	=> ADMIN_ACTION_MANAGE_USER, 				"page" => "niota_admin_grid.php", "superuser_only" => false),
				array("action" 	=> ADMIN_ACTION_MANAGE_USERGROUP, 			"page" => "niota_admin_grid.php", "superuser_only" => false),
				array("action"	=> ADMIN_ACTION_MANAGE_MEMBERSHIP, 			"page" => "niota_admin_grid.php", "superuser_only" => false)
		]),
		array("group" => ADMIN_GROUP_USERSETTING, "actions" => [
				array("action" 	=> ADMIN_ACTION_MANAGE_USERPARAMETER, 		"page" => "niota_admin_grid.php", "superuser_only" => false),
				array("action" 	=> ADMIN_ACTION_MANAGE_USERCONFIG, 			"page" => "niota_admin_grid.php", "superuser_only" => false),
				array("action" 	=> ADMIN_ACTION_MANAGE_USERCOMM, 			"page" => "niota_admin_grid.php", "superuser_only" => true)
		]),
		array("group" => ADMIN_GROUP_CALLABLE, "actions" => [
				array("action"	=> ADMIN_ACTION_MANAGE_CALLABLE, 			"page" => "niota_admin_grid.php", "superuser_only" => false),
				array("action"	=> ADMIN_ACTION_MANAGE_CATALOG_CALLABLE,	"page" => "niota_admin_grid.php", "superuser_only" => false),
				array("action"	=> ADMIN_ACTION_MANAGE_CALLABLE_ACCESS, 	"page" => "niota_admin_grid.php", "superuser_only" => false)
		]),
		array("group" => ADMIN_GROUP_TABLELINK, "actions" => [
				array("action" 	=> ADMIN_ACTION_MANAGE_MASTER_DETAIL, 		"page" => "niota_admin_grid.php", "superuser_only" => false),
				array("action"	=> ADMIN_ACTION_MANAGE_ADVANCED_FILTER, 	"page" => "niota_admin_grid.php", "superuser_only" => false)
		]),
		array("group" => ADMIN_GROUP_TRANSACTION, "actions" => [
				array("action"	=> ADMIN_ACTION_MANAGE_TRANSACTION, 		"page" => "niota_admin_grid.php", "superuser_only" => false),
				array("action" 	=> ADMIN_ACTION_MANAGE_TRANSACTIONMENU, 	"page" => "niota_admin_grid.php", "superuser_only" => false),
				array("action" 	=> ADMIN_ACTION_MANAGE_TRANSACTION_ACCESS, 	"page" => "niota_admin_grid.php", "superuser_only" => false)
		]),
		array("group" => ADMIN_GROUP_METADB, "actions" => [
				array("action"	=> ADMIN_ACTION_MANAGE_METADBOBJECT, 		"page" => "niota_admin_grid.php", "superuser_only" => false),
				array("action"  => ADMIN_ACTION_MANAGE_METADBREPOSITORY, 	"page" => "niota_admin_grid.php", "superuser_only" => false),

//				array("action" 	=> ADMIN_ACTION_MANAGE_METADBOBJECTLINK, 	"page" => "panel_metadbobjectlink.php", "superuser_only" => true),
//		]),
//		array("group" => ADMIN_GROUP_DEPLOY, "actions" => [
//				array("action" 	=> ADMIN_ACTION_MANAGE_DEPLOYEXPORT, 	"page" => "panel_deployexport.php", "superuser_only" => true),
//				array("action"	=> ADMIN_ACTION_MANAGE_DEPLOYIMPORT, 	"page" => "panel_deployimport.php", "superuser_only" => true),
//              array("action"	=> ADMIN_ACTION_MANAGE_DEPLOYLOG, 	    "page" => "panel_deploylog.php", "superuser_only" => true),
//				array("action"	=> ADMIN_ACTION_MANAGE_DEPLOYLOG, 		"page" => "panel_deploysimple_catalog.php", "superuser_only" => true),
//				array("action"	=> ADMIN_ACTION_MANAGE_DEPLOYARCHIVE, 	"page" => "panel_deployarchive.php", "superuser_only" => true)
		]),
		array("group" => ADMIN_GROUP_FORMATDOMAIN, "actions" => [
				array("action"	=> ADMIN_ACTION_MANAGE_FORMATDOMAINLOGC, 	"page" => "niota_admin_grid.php", "superuser_only" => false),
				array("action"	=> ADMIN_ACTION_MANAGE_FORMATDOMAINPHYS, 	"page" => "niota_admin_grid.php", "superuser_only" => false),
				array("action"	=> ADMIN_ACTION_MANAGE_FORMATDOMAINSEMA, 	"page" => "niota_admin_grid.php", "superuser_only" => false)				
		]),	
		array("group" => ADMIN_GROUP_FORMAT, "actions" => [
				array("action" 	=> ADMIN_ACTION_MANAGE_FORMATCOLUMNCOLL,	"page" => "niota_admin_grid.php", "superuser_only" => false),				
				array("action" 	=> ADMIN_ACTION_MANAGE_FORMATCOLUMNEXT,		"page" => "niota_admin_grid.php", "superuser_only" => false),	
				array("action" 	=> ADMIN_ACTION_MANAGE_FORMATOBJECTEXT,		"page" => "niota_admin_grid.php", "superuser_only" => false)				

		])	
		
);


// ADMIN PAGE - reverse direction pages
const ADMIN_OPTIONS_SIDEBAR = array(
	array("group" => ADMIN_ACTION_MANAGE_CATALOG_ADD, "actions" => [
			array("action"  => ADMIN_ACTION_MANAGE_CATALOG_ADDMAN, 				"page" => "niota_admin_grid.php", "superuser_only" => false)				
	]),
	array("group" => ADMIN_ACTION_MANAGE_CATALOG_ACCESS, "actions" => [
			array("action"  => ADMIN_ACTION_MANAGE_CATALOG_ACCESS_REVERSE, 		"page" => "niota_admin_grid.php", "superuser_only" => false)
	]),
	array("group" => ADMIN_ACTION_MANAGE_MEMBERSHIP, "actions" => [
			array("action"  => ADMIN_ACTION_MANAGE_MEMBERSHIP_REVERSE, 			"page" => "niota_admin_grid.php", "superuser_only" => false)
	]),
	array("group" => ADMIN_ACTION_MANAGE_TRANSACTION_ACCESS, "actions" => [
			array("action"  => ADMIN_ACTION_MANAGE_TRANSACTION_ACCESS_REVERSE, 	"page" => "niota_admin_grid.php", "superuser_only" => false)
	]),
	array("group" => ADMIN_ACTION_MANAGE_CALLABLE_ACCESS, "actions" => [
			array("action"  => ADMIN_ACTION_MANAGE_CALLABLE_ACCESS_REVERSE, 	"page" => "niota_admin_grid.php", "superuser_only" => false)
	]),
	array("group" => ADMIN_ACTION_MANAGE_CATALOG_CALLABLE, "actions" => [
			array("action"  => ADMIN_ACTION_MANAGE_CATALOG_CALLABLE_REVERSE, 	"page" => "niota_admin_grid.php", "superuser_only" => false)
	]),
	array("group" => ADMIN_ACTION_MANAGE_SYSTEMCONFIG, "actions" => [
			array("action"  => ADMIN_ACTION_MANAGE_SYSTEMCONFIG_REVERSE,		"page" => "niota_admin_grid.php", "superuser_only" => false)
	]),
	array("group" => ADMIN_ACTION_MANAGE_SEQUENCE, "actions" => [
			array("action"  => ADMIN_ACTION_MANAGE_SEQUENCE_REVERSE, 			"page" => "niota_admin_grid.php", "superuser_only" => false)
	]),
	array("group" => ADMIN_ACTION_MANAGE_USERCONFIG, "actions" => [
			array("action"  => ADMIN_ACTION_MANAGE_USERCONFIG_REVERSE, 			"page" => "niota_admin_grid.php", "superuser_only" => false)
	]),
	array("group" => ADMIN_ACTION_MANAGE_MESSAGETEXT, "actions" => [
			array("action"  => ADMIN_ACTION_MANAGE_MESSAGETEXT_REVERSE, 		"page" => "niota_admin_grid.php", "superuser_only" => false)
	])
);

?>	
	