<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<?php
/* ===========+========+===== changelog ==========================================
 -- YYYY.MM.DD | author | change
 -- -----------+--------+----------------------------------------------------------
 -- 2022.08.04   rre      added new sortorder
 -- *******************************************************************************
 */
include("../../conf/conf.php");

// HEADER INIT INCLUDE
include "admin_header_init.php";

$fileName = basename(__FILE__, ".php");

// MASTER (AND DETAIL) TABLE KEY(S)
$tableKey 			= T_CATALOGOBJECT;
$detailTableKey_1 	= T_CATALOGOBJECTINST;

$localOptionKey = isset($_GET['ok']) ? $_GET['ok'] : "";
$_SESSION['panel_name'] = $localOptionKey;

// HEADER INCLUDE
include "admin_header.php";

// ALL PARAMETERS FOR MASTER TABLE
$masterParams = ET_GeneralHelperAdmin::generateDefaultParams($fullTableName,
   				
	/* lookup */		array(["lookup_name" => "DB_CONNECTION", "target_column" => "conn_name"],
							  ["lookup_name" => "NIOTAUSER", "target_column" => "username_owner", "ind_add_null" => true],
							  ["lookup_name" => "NIOTAUSERGROUP", "target_column" => "usergroupname_deputy", "ind_add_null" => true],
							  ["lookup_name" => "CUSTFLAG_XX", "target_column" => "ind_cust_01", "ind_add_null" => true],
							  ["lookup_name" => "CUSTFLAG_XX", "target_column" => "ind_cust_02", "ind_add_null" => true],
							  ["lookup_name" => "CUSTFLAG_XX", "target_column" => "ind_cust_03", "ind_add_null" => true],
							  ["lookup_name" => "CUSTFLAG_XX", "target_column" => "ind_cust_04", "ind_add_null" => true],
							  ["lookup_name" => "CUSTFLAG_XX", "target_column" => "ind_cust_05", "ind_add_null" => true],
							  ["lookup_name" => "CUSTFLAG_XX", "target_column" => "ind_cust_06", "ind_add_null" => true],
							  ["lookup_name" => "CUSTFLAG_XX", "target_column" => "ind_cust_07", "ind_add_null" => true],
							  ["lookup_name" => "CUSTFLAG_XX", "target_column" => "ind_cust_08", "ind_add_null" => true],
							  ["lookup_name" => "CUSTFLAG_XX", "target_column" => "ind_cust_09", "ind_add_null" => true],
							  ["lookup_name" => "CUSTFLAG_XX", "target_column" => "ind_cust_10", "ind_add_null" => true]		  
							),
	/* readonly */			"",
	/* checkboxes */		array(),
	/* merged columns */	array(),
	/* hidden columns */ 	array(),
	/* crud, empty = all */	"RU",
	/* subgrid number */	"",
	/* logical link */		"",
	/* projection list */	" mdLookup_SortOrder('catalog_id', catalog_id) as sort_id, 
	                          catalog_id, conn_name, object, description, date_activation, ind_active, objectcategory, format_file_prefix,
							  username_owner, usergroupname_deputy, ind_nolog_upload, ind_cust_01, ind_cust_02, ind_cust_03, ind_cust_04,
							  ind_cust_05, ind_cust_06, ind_cust_07, ind_cust_08, ind_cust_09, ind_cust_10", 
	/* filter */			"ind_active is not null",
	/* object join */		"",
	/* fixed values*/		array(),
	/* order by*/			"order by sort_id, catalog_id desc"
	
	);

//ALL PARAMETERS FOR DETAIL TABLE
$detailParams = ET_GeneralHelperAdmin::generateDefaultParams($detailFullTableName_1,
	/* lookup */			array(),
	/* readonly list */		"",
	/* checkboxes */		array(),
	/* merged columns */	array(),
	/* hidden columns */ 	array(),
	/* crud, empty = all */	"CRU",
	/* subgrid number*/		$detailTableNumber_1,
	/* logical link*/		$detailTableLogicalLink_1,
	/* projection list */	"*",
	/* filter */			"ind_active is not null",
	/* object join */		""
	);

ET_GeneralHelperAdmin::createDetailGridAndFillMasterParams($masterParams, $detailParams, $detailFullTableName_1,
	/*referencig column master: */ 		array("catalog_id"),
	/*referencig column detail: */ 		array("catalog_id"),
	/*menu item name*/					$optionKey
	);

// CREATE MASTER DATAGRID
$datagrid = new ET_DataGridAdmin($catalogInstanceId, $masterParams, $optionKey);
$datagrid->displayGrid();

// FOOTER INCLUDE
include "admin_footer.php";
