<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<?php
/* ===========+========+===== changelog ==========================================
 -- YYYY.MM.DD | author | change
 -- -----------+--------+----------------------------------------------------------
 -- 2022.08.04   rre      added new sortorder
 -- *******************************************************************************
 */

include("../../conf/conf.php");

// HEADER INIT INCLUDE
include "admin_header_init.php";

$fileName = basename(__FILE__, ".php");

// MASTER (AND DETAIL) TABLE KEY(S)
$tableKey 			= T_CATALOGOBJECTINST;
$detailTableKey_1 	= T_CATOBJACCESS;

$localOptionKey = isset($_GET['ok']) ? $_GET['ok'] : "";
$_SESSION['panel_name'] = $localOptionKey;

// HEADER INCLUDE
include "admin_header.php";

// ALL PARAMETERS FOR MASTER TABLE
$masterParams = ET_GeneralHelperAdmin::generateDefaultParams($fullTableName, 
	/* lookup       */	array(), 
	/* readonly     */	"", 
	/* checkboxes   */	array(), 
	/* merged       */	array(),
	/* hidden       */	array(), 
	/* crud,        */	"R",
	/* subgrid #    */	"",
	/* logical link */	"",
	/* projection   */	"mdLookup_SortOrder('catalog_id', catalog_id) as sort_id, catalog_id, instance_name, description, ind_active",
	/* filter       */	"ind_active is not null",
	/* object join  */	"",
	/* fixed values*/	array(),
	/* order by */		"order by sort_id, catalog_id desc"
	);

//ALL PARAMETERS FOR DETAIL TABLE
$detailParams = ET_GeneralHelperAdmin::generateDefaultParams($detailFullTableName_1, 
	/* lookup       */	array(	["lookup_name" => "USERGROUP", "target_column" => "usergroupname"]),
	/* readonly     */  "",
	/* checkbox     */	array(),
	/* merged col   */	array(),
	/* hidden col   */ 	array(),
	/* crud         */	"CRUD",
	/* subgrid #    */	$detailTableNumber_1,
	/* logical link */	$detailTableLogicalLink_1,
	/* projection */	'usergroupname, catalog_id, instance_name, ind_active,
						 ind_allow_ins, ind_allow_upd, ind_allow_del, ind_allow_import,
						 ind_allow_export, ind_hidden, ind_allow_upd_partial, ind_allow_upload_partial',
	/* filter */				"ind_active is not null",
	/* object join */	"",
	/* fixed values*/	array()
);

ET_GeneralHelperAdmin::createDetailGridAndFillMasterParams($masterParams, $detailParams, $detailFullTableName_1, 
	/*referencig column master: */ 		array("catalog_id", "instance_name"),
	/*referencig column detail: */ 		array("catalog_id", "instance_name"),
	/*menu item name*/					$optionKey
		);

// CREATE MASTER DATAGRID
$datagrid = new ET_DataGridAdmin($catalogInstanceId, $masterParams, $optionKey);
$datagrid->displayGrid();

// FOOTER INCLUDE
include "admin_footer.php";
