<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<?php
/* ===========+========+===== changelog ==========================================
 -- YYYY.MM.DD | author | change
 -- -----------+--------+----------------------------------------------------------
 -- 2022.08.04   rre      added new sortorder
 -- *******************************************************************************
 */
include("../../conf/conf.php");

// HEADER INIT INCLUDE
include "admin_header_init.php";

$fileName = basename(__FILE__, ".php");

// MASTER (AND DETAIL) TABLE KEY(S)
$tableKey 			= T_CATALOGOBJECT;

// initialize lookup for catalog id; retrieve option key
$catalogid_lookupname = "catalog_id";
$localOptionKey = isset($_GET['ok']) ? $_GET['ok'] : "";

if ($localOptionKey == ADMIN_ACTION_MANAGE_CATALOG_ADD) {
   $catalogid_lookupname = 'catalog_id'; 
}

if ($localOptionKey == ADMIN_ACTION_MANAGE_CATALOG_ADDMAN) {
    $catalogid_lookupname = '*NONE'; 

}
$_SESSION['panel_name'] = $localOptionKey;


// HEADER INCLUDE
include "admin_header.php";

// ALL PARAMETERS FOR MASTER TABLE
$masterParams = ET_GeneralHelperAdmin::generateDefaultParams($fullTableName,
   				
	/* lookup */		array(["lookup_name" => "DB_CONNECTION", "target_column" => "conn_name"],
							  ["lookup_name" => "CATALOGIDNEXT", "target_column" => $catalogid_lookupname]		  
							),
	/* readonly */			"",
	/* checkboxes */		array(),
	/* merged columns */	array(),
	/* hidden columns */ 	array(),
	/* crud, empty = all */	"CR",
	/* subgrid number */	"",
	/* logical link */		"",
	/* projection list */	" mdLookup_SortOrder('catalog_id', catalog_id) as sort_id, 
	                         catalog_id, conn_name, object, description, ind_active, objectcategory, format_file_prefix",
	/* filter */			"date_activation = current_date() or date_activation is null",
	/* object join */		"",
	/* fixed values*/		array(),
	/* order by*/			"order by sort_id, catalog_id desc"
	
	);


// CREATE MASTER DATAGRID
$datagrid = new ET_DataGridAdmin($catalogInstanceId, $masterParams, $optionKey);
$datagrid->displayGrid();

// FOOTER INCLUDE
include "admin_footer.php";
