<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<?php
/* ===========+========+===== changelog ==========================================
 -- YYYY.MM.DD | author | change
 -- -----------+--------+----------------------------------------------------------
 -- 2022.03.02   rre      added lookup for extended lookup column
 -- *******************************************************************************
 */
	include("../../conf/conf.php");
	
	// HEADER INIT INCLUDE
	include "admin_header_init.php";
	
	$fileName = basename(__FILE__, ".php");
	
	// MASTER (AND DETAIL) TABLE KEY(S)
$tableKey 			= T_CATALOGOBJECT;
$detailTableKey_1 	= T_CATALOGOBJCOLPROP;
	
	
// HEADER INCLUDE
	include "admin_header.php";

$masterParams = ET_GeneralHelperAdmin::generateDefaultParams($fullTableName,
   				
	/* lookup       */	array(), 
	/* readonly     */	"", 
	/* checkboxes   */	array("ind_active"), 
	/* merged       */	array(),
	/* hidden       */	array(), 
	/* crud,        */	"R",
	/* subgrid #    */	"",
	/* logical link */	"",
	/* projection   */	"mdLookup_SortOrder('catalog_id', catalog_id) as sort_id, catalog_id, object, description, ind_active",
	/* filter       */	"ind_active is not null", 
	/* object join  */	"",
	/* fixed values*/	array(),
	/* order by */		"order by sort_id, catalog_id desc"
		);
		
//ALL PARAMETERS FOR DETAIL TABLE
$detailParams = ET_GeneralHelperAdmin::generateDefaultParams($detailFullTableName_1,
	/* lookup */		array(	["lookup_name" => "LOOKUPDEF", "target_column" => "lookup_name", "ind_add_null" => true],
								["lookup_name" => "CONSTRAINTDEF", "target_column" => "constraint_name", "ind_add_null" => true],
								["lookup_name" => "LOOKUPDEFEXT", "target_column" => "lookup_name_extended", "ind_add_null" => true]								
							),	
	/* readonly     */	"", 
	/* checkboxes   */	array(),
	/* merged       */	array(),
	/* hidden       */	array(), 
	/* crud,        */	"",
	/* subgrid #    */	$detailTableNumber_1,
	/* logical link */	$detailTableLogicalLink_1,
	/* projection   */	"*",
	/* filter       */	"ind_active is not null",
	/* object join  */	 ""
		);

ET_GeneralHelperAdmin::createDetailGridAndFillMasterParams($masterParams, $detailParams, $detailFullTableName_1, 
	/*referencig column master: */ 		array("catalog_id"),
	/*referencig column detail: */ 		array("catalog_id"),
	/*menu item name*/					$optionKey
		);
		
	// CREATE MASTER DATAGRID
	$datagrid = new ET_DataGridAdmin($catalogInstanceId, $masterParams, $optionKey);
	$datagrid->displayGrid();
	
	// FOOTER INCLUDE
	include "admin_footer.php";
?>
