<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<?php
/* ===========+========+===== changelog ==========================================
 -- YYYY.MM.DD | author | change
 -- -----------+--------+----------------------------------------------------------
 -- 2022.03.02   rre      added lookuptype in projection list
 -- *******************************************************************************
 */
include("../../conf/conf.php");

// HEADER INIT INCLUDE
include "admin_header_init.php";

$fileName = basename(__FILE__, ".php");

// MASTER (AND DETAIL) TABLE KEY(S)
$tableKey 			= T_LOOKUP;

// HEADER INCLUDE
include "admin_header.php";

// ALL PARAMETERS FOR MASTER TABLE
$masterParams = ET_GeneralHelperAdmin::generateDefaultParams($fullTableName,
		/* lookups */				array([	"lookup_name" => "CATANDINSTANCE", 	"target_column" => "catalog_instance_tmp" ],
											["lookup_name" => "LOOKUPTYPE", 	"target_column" => "lookup_type" ]
											),
		/* readonly list */			"",
		/* checkboxes */			array("ind_active"),
		/* merged columns */		array(),
		/* hidden columns */ 		array("column_names" => array("catalog_id_lookup", "instance_name_lookup"),	"editable" => false),
		/* crud, empty = all */		"CRU",
		/* subgrid number */		"",
		/* logical link */			"",
		/* projection */			'lookup_name, description, ind_active, lookup_type, catalog_id_lookup, instance_name_lookup, $gcol.{aux_catalog_instance_lookup}',
		/* filter */				"ind_active is not null",
		/* object join */			"",
		/*fixed values*/ 			array ('catalog_id_lookup' => '$split($col.{catalog_instance_tmp}, 0)',
										   'instance_name_lookup' => '$split($col.{catalog_instance_tmp}, 1)'
									),
		/*order by*/				"order by lookup_name"									
		);

// CREATE MASTER DATAGRID
$datagrid = new ET_DataGridAdmin($catalogInstanceId, $masterParams, $optionKey);
$datagrid->displayGrid();

// FOOTER INCLUDE
include "admin_footer.php";
?>



