<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<?php
	include("../../conf/conf.php");
	
	// HEADER INIT INCLUDE
	include "admin_header_init.php";
	
	$fileName = basename(__FILE__, ".php");
	
	// MASTER (AND DETAIL) TABLE KEY(S)
	$tableKey 			= T_MASTERDETAIL;
	$detailTableKey_1	= T_MASTERDETAILLINK; 

	// HEADER INCLUDE
	include "admin_header.php";

	// ALL PARAMETERS FOR MASTER TABLE
	$masterParams = ET_GeneralHelperAdmin::generateDefaultParams($fullTableName,
		/* lookup   */				array(["lookup_name" => "CIID_MASTER", "target_column" => "ciid_master_tmp"],
										  ["lookup_name" => "CIID_DETAIL", "target_column" => "ciid_detail_tmp"],
										  ["lookup_name" => "DETAILGRIDPOSITION", "target_column" => "grid_location_detail"]										  
										  ),
		/* readonly */				"",
		/* checkbox */				"",
		/* merged	*/				"",
		/* hidden   */ 				array(),
		/* crud, */					"CRU",
		/* subgrid number */		"",
		/* logical link */			"",
		/* projection */			'catalog_id_master, instance_name_master, $gcol.{aux_ciid_master}, logical_link,
									 catalog_id_detail, instance_name_detail, $gcol.{aux_ciid_detail}, linktype, 
									 ind_logical_link_default, grid_location_detail', 
									'linktype = 0',
		/* object join */			'',
		/*fixed values*/ 			array ('catalog_id_master' => '$split($col.{ciid_master_tmp}, 0)',
										   'instance_name_master' => '$split($col.{ciid_master_tmp}, 1)',
										   'catalog_id_detail' => '$split($col.{ciid_detail_tmp}, 0)',
										   'instance_name_detail' => '$split($col.{ciid_detail_tmp}, 1)'
									)
									);
	
	$detailParams = ET_GeneralHelperAdmin::generateDefaultParams($detailFullTableName_1,
		/* lookup */				array(["lookup_name" => "OPERATION", "target_column" => "operation"]),
		/* readonly list */			"",
		/* checkboxes */			array(),
		/* merged columns */		array(),
		/* hidden columns */ 		array(),
		/* crud, empty = all */		"",
		/* subgrid number*/			$detailTableNumber_1,
		/* logical link*/			$detailTableLogicalLink_1,
        /* projection */			"*",
									"",
		/* object join */			""
									);
	
	ET_GeneralHelperAdmin::createDetailGridAndFillMasterParams($masterParams, $detailParams, $detailFullTableName_1,
			/*referencig column master: */ 		array("catalog_id_master", "instance_name_master", "logical_link"),
			/*referencig column detail: */ 		array("catalog_id_master", "instance_name_master", "logical_link"),
			/*menu item identifier*/			$optionKey
			);
	
	// CREATE MASTER DATAGRID
	$masterParams["edit_flags"] = 1;
	
	$datagrid = new ET_DataGridAdmin($catalogInstanceId, $masterParams, $optionKey);
	$datagrid->displayGrid();
	
	// FOOTER INCLUDE
	include "admin_footer.php";
	
	


