<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<?php
/* ===========+========+===== changelog ==========================================
 -- YYYY.MM.DD | author | change
 -- -----------+--------+----------------------------------------------------------
 -- 2022.03.02   rre      create this generic standard admin page call
 -- *******************************************************************************
 */
include("../../conf/conf.php");
include "admin_header_init.php";

$fileName = basename(__FILE__, ".php");

$localOptionKey = isset($_GET['ok']) ? $_GET['ok'] : "";
$_SESSION['panel_name'] = $localOptionKey;

$tableKey = T_LOOKUP;
$admin_lookup = "";
$admin_read_only_list = "";
$admin_checkbox_list = "";
$admin_merged_list = "";
$admin_hidden_list = "";
$admin_CRUD = "R";
$admin_subgrid_number = "";
$admin_logical_link = "";
$admin_projection_list = "*";
$admin_objectfilter = "";
$admin_objectjoin = "";
$admin_fixed_values = "";
$admin_objectorder = "";

 $_SESSION['instance_name'] = INSTANCE_NAME_ADMIN_OBJECTS;

 
if ($localOptionKey == ADMIN_ACTION_MANAGE_CONNECTION) {
$tableKey = T_CONNECTION;
 
    $admin_lookup 			= array(["lookup_name" => "CONN_TYPE",  "target_column" => "conn_type"],
	                                ["lookup_name" => "DB_CONNECTION", "target_column" => "conn_name_msg", "ind_add_null" => true]);
	$admin_CRUD 			= "CRU";
	$admin_projection_list 	= "*";
}

if ($localOptionKey == ADMIN_ACTION_MANAGE_LOGGING) {
$tableKey 			= T_LOGGING;
    $admin_lookup 			=  array(["lookup_name" => "DB_CONNECTION", "target_column" => "conn_name"],
									 ["lookup_name" => "CALLABLE_LOGGER", "target_column" => "callable_object", "ind_add_null" => true]);
	$admin_CRUD 			= "";
	$admin_projection_list 	= "*";
}

if ($localOptionKey == ADMIN_ACTION_MANAGE_SYSTEMCONFIG) {
$tableKey = T_SYSTEMCONFIG;

	$admin_CRUD 			= "RU";
	$admin_projection_list 	= "*";
	$admin_objectfilter 	= "appcode_cfg = mdinfo_sysConstant('APPCODE')";
}

if ($localOptionKey == ADMIN_ACTION_MANAGE_SYSTEMCONFIG_REVERSE) {
$tableKey = T_SYSTEMCONFIG;
$_SESSION['instance_name'] .= "_CUST";
	
	$admin_CRUD 			= "CRUD";
	$admin_projection_list 	= "*";
	$admin_objectfilter 	= "appcode_cfg <> mdinfo_sysConstant('APPCODE')";
}

if ($localOptionKey == ADMIN_ACTION_MANAGE_SEQUENCE) {
$tableKey = T_SEQUENCE;

	$admin_CRUD 			= "RU";
	$admin_projection_list 	= "*";
	$admin_objectfilter 	= "appcode_seq = mdinfo_sysConstant('APPCODE')";
}

if ($localOptionKey == ADMIN_ACTION_MANAGE_SEQUENCE_REVERSE) {
$tableKey = T_SEQUENCE;
$_SESSION['instance_name'] .= "_CUST";


	$admin_CRUD 			= "CRUD";
	$admin_projection_list 	= "*";
	$admin_objectfilter 	= "appcode_seq <> mdinfo_sysConstant('APPCODE')";
}

if ($localOptionKey == ADMIN_ACTION_MANAGE_MESSAGETEXT) {
$tableKey = T_MESSAGETEXT;

	$admin_CRUD 			= "RU";
	$admin_projection_list 	= "*";
	$admin_objectfilter 	= "appcode_msg = mdinfo_sysConstant('APPCODE')";
}

if ($localOptionKey == ADMIN_ACTION_MANAGE_MESSAGETEXT_REVERSE) {
$tableKey = T_MESSAGETEXT;
$_SESSION['instance_name'] .= "_CUST";

	$admin_CRUD 			= "CRUD";
	$admin_projection_list 	= "*";
	$admin_objectfilter 	= "appcode_msg <> mdinfo_sysConstant('APPCODE')";
}


if ($localOptionKey == ADMIN_ACTION_MANAGE_CATALOG_ADD) {
$tableKey 			= T_CATALOGOBJECT;
$_SESSION['instance_name'] .= "_ADD";

    $admin_lookup 			= array(["lookup_name" => "DB_CONNECTION", "target_column" => "conn_name"],
									["lookup_name" => "CATALOGIDNEXT", "target_column" => "catalog_id"]);
	$admin_CRUD 			= "CR";
	$admin_projection_list 	= "mdLookup_SortOrder('catalog_id', catalog_id) as sort_id, 
	                         catalog_id, conn_name, object, description, ind_active, objectcategory, format_file_prefix";
	$admin_objectfilter 	= "date_activation = current_date() or date_activation is null";
    $admin_objectorder 		= "order by sort_id, catalog_id desc";
	
}

if ($localOptionKey == ADMIN_ACTION_MANAGE_CATALOG_ADDMAN) {
$tableKey 			= T_CATALOGOBJECT;
$_SESSION['instance_name'] .= "_ADDMAN";

    $admin_lookup 			= array(["lookup_name" => "DB_CONNECTION", "target_column" => "conn_name"]);
	
	$admin_CRUD 			= "CR";
	$admin_projection_list 	= "mdLookup_SortOrder('catalog_id', catalog_id) as sort_id, 
	                         catalog_id, conn_name, object, description, ind_active, objectcategory, format_file_prefix";
	$admin_objectfilter 	= "date_activation = current_date() or date_activation is null";
    $admin_objectorder 		= "order by sort_id, catalog_id desc";
	
}


if ($localOptionKey == ADMIN_ACTION_MANAGE_LOOKUP) {
    $tableKey = T_LOOKUP;
    $admin_lookup 			= array(["lookup_name" => "CIID_LOOKUP", "target_column" => "catalog_instance_tmp"],
                   	                ["lookup_name" => "LOOKUPTYPE",  "target_column" => "lookup_type"]);
	$admin_CRUD 			= "CRU";
	$admin_projection_list 	= 'lookup_name, description, ind_active, lookup_type, catalog_id_lookup, instance_name_lookup, $gcol.{aux_catalog_instance_lookup}';
	$admin_objectfilter 	= "ind_active is not null";
	$admin_fixed_values 	= array ('catalog_id_lookup' => '$split($col.{catalog_instance_tmp}, 0)',
									 'instance_name_lookup' => '$split($col.{catalog_instance_tmp}, 1)');
    $admin_objectorder 		= "order by lookup_name";						 
}

if ($localOptionKey == ADMIN_ACTION_MANAGE_CONSTRAINT) {
    $tableKey = T_CONSTRAINT;
    $admin_lookup 			= array(["lookup_name" => "COLUMNTYPE", "target_column" => "column_type"],
								    ["lookup_name" => "OPERATION", "target_column" => "operation"]);
	$admin_CRUD 			= "CRU";
	$admin_projection_list 	= '*';
	$admin_objectfilter 	= "ind_active is not null";
	$admin_fixed_values 	= "";
    $admin_objectorder 		= "order by constraint_name";						 
}

if ($localOptionKey == ADMIN_ACTION_MANAGE_USER) {
    $tableKey = T_USER;
    $admin_lookup 			= array(["lookup_name" => "UILANG", "target_column" => "lang_grid"]);
	$admin_CRUD 			= "CRU";
	$admin_projection_list 	= '*';
	$admin_objectfilter 	= "ind_active is not null and username not in ('superuser', '*ALL_GROUP')";
	$admin_fixed_values 	= "";
    $admin_objectorder 		= "";						 
}

if ($localOptionKey == ADMIN_ACTION_MANAGE_USERGROUP) {
    $tableKey = T_USERGROUP;
    $admin_lookup 			= array(["lookup_name" => "USERGROUPTYPE", "target_column" => "usergroup_type"]);
	$admin_CRUD 			= "CRU";
	$admin_projection_list 	= "*";
	$admin_objectfilter 	= "ind_active is not null and usergroup_type in (1, 2)";
	$admin_fixed_values 	= "";
    $admin_objectorder 		= "order by usergroup_type desc, usergroupname";						 
}

if ($localOptionKey == ADMIN_ACTION_MANAGE_USERCONFIG) {
$tableKey 			= T_USERCONFIG;
    $admin_lookup 			= array(["lookup_name" => "ALLUSER", 	"target_column" => "username" ],
									["lookup_name" => "USERCONFIG", 	"target_column" => "cfg_id" ]);
	$admin_CRUD 			= "CRU";
	$admin_projection_list 	= "*";
	$admin_objectfilter 	= "appcode_cfg = mdinfo_sysConstant('APPCODE')";
}

if ($localOptionKey == ADMIN_ACTION_MANAGE_USERCONFIG_REVERSE) {
$tableKey 			= T_USERCONFIG;

	$admin_CRUD 			= "CRUD";
	$admin_projection_list 	= "*";
	$admin_objectfilter 	= "appcode_cfg <> mdinfo_sysConstant('APPCODE')";					 
}


if ($localOptionKey == ADMIN_ACTION_MANAGE_USERCOMM) {
$tableKey 			= T_USERCOMMAREA;

	$admin_CRUD 			= "CRUD";
	$admin_projection_list 	= "*";
	$admin_objectfilter 	= "";					 
}

if ($localOptionKey == ADMIN_ACTION_MANAGE_METADBOBJECT) {
$tableKey 			= T_METADBOBJECT;

    $admin_lookup 			= array(["lookup_name" => "CONNECTION", "target_column" => "conn_name"]);
	$admin_CRUD 			= "CRUD";
	$admin_projection_list 	= "*";
	$admin_objectfilter 	= "";					 
}

// echo $localOptionKey;

include "admin_header.php";

$_SESSION[SESS_CATALOG_INSTANCE_ID_DETAIL_ADMIN] = "?";
 
// ALL PARAMETERS FOR MASTER TABLE
$masterParams = ET_GeneralHelperAdmin::generateDefaultParams(
 $fullTableName,
 $admin_lookup,
 $admin_read_only_list,
 $admin_checkbox_list,
 $admin_merged_list,
 $admin_hidden_list,
 $admin_CRUD,
 $admin_subgrid_number,
 $admin_logical_link,
 $admin_projection_list,
 $admin_objectfilter,
 $admin_objectjoin,
 $admin_fixed_values, 
 $admin_objectorder									
);



// CREATE MASTER DATAGRID
$datagrid = new ET_DataGridAdmin($catalogInstanceId, $masterParams, $optionKey);

// echo "***** " . $catalogInstanceId . "***** " . "<br>";
// echo "***** " . $catalogInstanceId . "***** " . "<br>";

$datagrid->displayGrid();

// FOOTER INCLUDE
include "admin_footer.php";
?>



