<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<?php
include("../../conf/conf.php");

// HEADER INIT INCLUDE
include "admin_header_init.php";

$fileName = basename(__FILE__, ".php");

// MASTER (AND DETAIL) TABLE KEY(S)
$tableKey 			= T_TRANSACTION;
$detailTableKey_1 	= T_TRANSACTPARAMSET;

// HEADER INCLUDE
include "admin_header.php";

// ALL PARAMETERS FOR MASTER TABLE
$masterParams = ET_GeneralHelperAdmin::generateDefaultParams($fullTableName,
	/* lookups */				array(["lookup_name" => "TARGETPAGE", "target_column" => "targetpage"]),
	/* readonly list */			"",
	/* checkboxes */			array("ind_active"),
	/* merged columns */		array(),
	/* hidden columns */ 		array("column_names" => array("targetpage"), "editable" => true),
	/* crud, empty = all */		"CRU",
	/* subgrid number */		"",
	/* logical link */			"",
	/* projection list */		"*",
	/* filter */				"ind_active is not null",
	/* object join */			""
		);

//ALL PARAMETERS FOR DETAIL TABLE
$detailParams = ET_GeneralHelperAdmin::generateDefaultParams($detailFullTableName_1,
	/* lookup */				array(["lookup_name" => "TRANSACTIONPARAM", "target_column" => "param_name"]),
	/* readonly list */			"transaction_code, param_set",
	/* checkboxes */			array("ind_active"),
	/* merged columns */		array(),
	/* hidden columns */ 		array("column_names" => array("transaction_code", "param_set"), "editable" => true),
	/* crud, empty = all */		"",
	/* subgrid number*/			$detailTableNumber_1,
	/* logical link*/			$detailTableLogicalLink_1,
	/* projection list */		"*",
	/* filter */				"",
	/* object join */			""
	);

ET_GeneralHelperAdmin::createDetailGridAndFillMasterParams($masterParams, $detailParams, $detailFullTableName_1,
		/*referencig column master: */ 		array("transaction_code", "param_set"),
		/*referencig column detail: */ 		array("transaction_code", "param_set"),
		/*menu item name*/					$optionKey
		);

// CREATE MASTER DATAGRID
$datagrid = new ET_DataGridAdmin($catalogInstanceId, $masterParams, $optionKey);
$datagrid->displayGrid();

// FOOTER INCLUDE
include "admin_footer.php";

