<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<?php
include("../../conf/conf.php");

// HEADER INIT INCLUDE
include "admin_header_init.php";

$fileName = basename(__FILE__, ".php");

// MASTER (AND DETAIL) TABLE KEY(S)
$tableKey 			= T_TRANSACTMENU;
$detailTableKey_1 	= T_TRANSACTMENU;

// HEADER INCLUDE
include "admin_header.php";

// ALL PARAMETERS FOR MASTER TABLE
$masterParams = ET_GeneralHelperAdmin::generateDefaultParams($fullTableName,
	/* lookups */				array(["lookup_name" => "TRANSACTION", "target_column" => "transaction_code", "ind_add_null" => true]),
	/* readonly list */			"transaction_code",
	/* checkboxes */			array("ind_active"),
	/* merged columns */		array(),
	/* hidden columns */ 		array("column_names" => array("transaction_code", "menue_id_parent", "icon_menu"), "editable" => true),	
	/* crud, empty = all */		"CRU",
	/* subgrid number */		"",
	/* logical link */			"",
	/* projection list */		"*",
	/* filter */				"ind_active is not null and transaction_code is null",
	/* object join */			""
	);

//ALL PARAMETERS FOR DETAIL TABLE
$detailParams = ET_GeneralHelperAdmin::generateDefaultParams($detailFullTableName_1,
	/* lookups */				array(["lookup_name" => "TRANSACTION", "target_column" => "transaction_code", "ind_add_null" => true]),
	/* readonly list */			'menu_id_parent',
	/* checkboxes */			array("ind_active"),
	/* merged columns */		array(),
	/* hidden columns */ 		array("column_names" => array("description", "menu_id_parent", "icon_menu"), "editable" => true),
	/* crud, empty = all */		"",
	/* subgrid number*/			$detailTableNumber_1,
	/* logical link*/			$detailTableLogicalLink_1,
	/* projection list */		"*",
	/* filter */				"ind_active is not null and menu_id not in (select distinct coalesce(menu_id_parent,0) from et_transaction_menu)",
	/* object join */			""
		);

$detailParams['reload_master_after_submit'] = 1;
ET_GeneralHelperAdmin::createDetailGridAndFillMasterParams($masterParams, $detailParams, $detailFullTableName_1,
	/*referencig column master: */ 		array("menu_id"),
	/*referencig column detail: */ 		array("menu_id_parent"),
	/*menu item name*/					$optionKey
	);

// CREATE MASTER DATAGRID
$datagrid = new ET_DataGridAdmin($catalogInstanceId, $masterParams, $optionKey);
$datagrid->displayGrid();

// FOOTER INCLUDE
include "admin_footer.php";

