<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<?php
/* ===========+========+===== changelog ==========================================
 -- YYYY.MM.DD | author | change
 -- -----------+--------+----------------------------------------------------------
 -- 2022.03.01   rre      added lookup for language
 -- *******************************************************************************
 */
include("../../conf/conf.php");

// HEADER INIT INCLUDE
include "admin_header_init.php";

$fileName = basename(__FILE__, ".php");

// MASTER (AND DETAIL) TABLE KEY(S)
$tableKey 			= T_USER;

// HEADER INCLUDE
include "admin_header.php";

// ALL PARAMETERS FOR MASTER TABLE
$masterParams = ET_GeneralHelperAdmin::generateDefaultParams($fullTableName,
/* lookups */							array([	"lookup_name" => "UILANG", 	"target_column" => "lang_grid" ]),
		/* readonly list */				"",
		/* checkboxes */				array("ind_active", "ind_is_admin", "ind_active_ldap"),
		/* merged columns */			array(),
		/* hidden columns */ 			array("column_names" => array("password", "email", "phone", "username_ldap", "ind_active_ldap"),
												"editable" => true
										),
		/* crud, empty = all rights */	"CRU",
		/* subgrid number */			"",
		/* logical link */				"",
		/* projection list */			"*",
		/* filter */					"ind_active is not null and username not in ('superuser', '*ALL_GROUP')",
		/* object join */				""
		);

// CREATE MASTER DATAGRID
$datagrid = new ET_DataGridAdmin($catalogInstanceId, $masterParams, $optionKey);
$datagrid->displayGrid();

// FOOTER INCLUDE
include "admin_footer.php";
?>



