<?php
/* ===========+========+===== changelog ==========================================
 -- YYYY.MM.DD | author | change
 -- -----------+--------+----------------------------------------------------------
 -- 2022.03.02   rre      added new uca columns
 -- *******************************************************************************
 */
$dg -> set_col_required("callable_object, description, ind_active, callobject_type, conn_name, command, callobject_category, sortorder");

$dg -> set_col_edittype("command", "textarea");
$dg -> set_col_property("command", array("editoptions"=>array("rows"=>5, "cols"=> 100)));

$dg -> set_col_property("ind_messaging", array("editoptions"=>array("size"=>1, "maxlength"=>1)));
$dg -> set_col_edittype("ind_messaging", "checkbox", "1:0");
$dg -> set_col_default("ind_messaging", '1');

$dg -> set_col_property("ind_reload_grid", array("editoptions"=>array("size"=>1, "maxlength"=>1)));
$dg -> set_col_edittype("ind_reload_grid", "checkbox", "1:0");
$dg -> set_col_default("ind_reload_grid", '1');

$dg -> set_col_property("ind_seq", array("editoptions"=>array("size"=>1, "maxlength"=>1)));
$dg -> set_col_edittype("ind_seq", "checkbox", "1:0");
$dg -> set_col_default("ind_seq", '0');

$dg -> set_col_property("prompage_type", array("editoptions"=>array("size"=>1, "maxlength"=>1)));
$dg -> set_col_property("icon_callable", array("editoptions"=>array("size"=>50, "maxlength"=>50)));

$dg -> set_col_default("ind_use_uca", '0');
$dg -> set_col_default("ind_save_uca", '0');

$dg -> set_col_edittype("uca", "textarea");
$dg -> set_col_property("uca", array("editoptions"=>array("rows"=>5, "cols"=> 100)));

$dg->set_conditional_format("ind_active","ROW",array("condition"=>"eq",
                                                      "value"=>"0",
                                                      "css"=> array("color"=>COLOR_INACTIV_TEXT,"background-color"=>COLOR_INACTIV_BACKGROUND)));

$dg -> set_form_dimension(FORMSIZE_ADMINPAGE_MEDIUM);


if (GRID_AREA_LANGUAGE == 'de') {

 $dg -> set_caption (CAPTION_ADMINPAGE_OPEN_TAG."aufrufbare Objekte".CAPTION_ADMINPAGE_CLOSE_TAG);
  
 $dg -> set_col_title("callobject_category","Kategorie<br>Aufruf-Objekt");
 $dg -> set_col_title("callobject_type","Objekttype");
 $dg -> set_col_title("command","Befehl");
 $dg -> set_col_title("description","Beschreibung<br>aufrufbares Objekt");
 $dg -> set_col_title("ind_messaging","Meldungen<br>auswerten");
 $dg -> set_col_title("ind_reload_grid","Tabelle<br>neu laden");
 $dg -> set_col_title("sortorder","Sortier<br>folge");
 //new:
 $dg -> set_col_title("ind_seq","ist Sequenz");
 $dg -> set_col_title("promptpage_type","Prompttyp");
 $dg -> set_col_title("icon_callable","Icondateiname");
 
 $dg -> set_col_headerTooltip("callable_object","Aufrufbares (ausführbares) Objekt - Name für ein Datenbankobjekt/ein Datenbankskript, dass von niota aufgerufen und ausgeführt werden kann.");
 $dg -> set_col_headerTooltip("callobject_category","Kategorie des aufrufbaren Objekts - Wahlfrei Gruppierung von logisch zusammengehörenden aufrufbaren Objekten");
 $dg -> set_col_headerTooltip("callobject_type","Typ des aufrufbaren Objekts - SQL Befehl, gespeicherte Prozedure, Script, ...");
 $dg -> set_col_headerTooltip("command","Befehlzeichenkette, die von niota ausgeführt wird. Vor der Ausführung erfolgt eine Parameter-Ersetzung. Bei gespeicherten Prozeduren zur Qualifizierung der Prozedur die Systemvariable callableFullDbname verwenden! Siehe: conf\callable_substitutions_help.txt");
 $dg -> set_col_headerTooltip("description","Beschreibung des aufrufbaren Objekts");  
 $dg -> set_col_headerTooltip("ind_messaging","Benutzermeldungen aktiv/inaktiv. Für die Kommunikation mit niota müssen sessionId und msgGuid an das aufrufbare Objekt übergeben werden. Die Inhalte dieser Systemvariablen müssen in die Meldungstabelle geschrieben werden.");  
 $dg -> set_col_headerTooltip("ind_reload_grid","Aktualisierung der Anzeige nach Aufruf des aufrufbaren Objekts - aktiv/inaktiv");  
 $dg -> set_col_headerTooltip("sortorder","Position für Sortierung der aufrufbaren Objekte bei der Anzeige. Gilt innerhalb einer Zuordnung zu einem Katalogobjekt (Tabelle/Sicht)");  
 //new:
 $dg -> set_col_title("ind_seq","Ist es eine Sequenz oder ein einzelnes aufrufbares Objekt");
}

if (GRID_AREA_LANGUAGE == 'en') {

 $dg -> set_caption (CAPTION_ADMINPAGE_OPEN_TAG."callable objects".CAPTION_ADMINPAGE_CLOSE_TAG);
  

 $dg -> set_col_title("callobject_category","Category<br>of Object");
 $dg -> set_col_title("callobject_type","Objecttype");
 $dg -> set_col_title("command","Command");
 $dg -> set_col_title("description","Description<br>callable Object");
 $dg -> set_col_title("ind_messaging","Messages<br>on");
 $dg -> set_col_title("ind_reload_grid","Table refresh<br>on");
 $dg -> set_col_title("sortorder","sort<br>order");
 //new:
 $dg -> set_col_title("ind_seq","is sequence");
 $dg -> set_col_title("promptpage_type","type of prompt");
 $dg -> set_col_title("icon_callable","iconfile (with extension)");
 $dg -> set_col_title("ind_use_uca","use user<br>communication area");
 $dg -> set_col_title("ind_save_uca","save user comm. area<br>after call");
 
 
 $dg -> set_col_headerTooltip("callable_object","Callable (executeable) Object - Name of a database object / database script, which can be called by niota.");
 $dg -> set_col_headerTooltip("callobject_category","Category of the callable object - Optional grouping of callable objects which belongs together logical");
 $dg -> set_col_headerTooltip("callobject_type","Type of the callable object - SQL command, stored procedure, script, ...");
 $dg -> set_col_headerTooltip("command","Commandstring, that is executed/call by niota. Previous to execution there is a paramater substitution. With stored procedure ist is recommended to use systemvaariable  callableFullDbname to qualify stored procedure object! See: conf\callable_substitutions_help.txt");
 $dg -> set_col_headerTooltip("description","Description of the callable object");  
 $dg -> set_col_headerTooltip("ind_messaging","User messaging - active/inactive. To commincation via niota systemvariables sessionId and msgGuid must be passed to the callable object. The content of this systemvariables must be written in the message table.");  
 $dg -> set_col_headerTooltip("ind_reload_grid","Refresh grid display after execution of the callable object - active/inactive");  
 $dg -> set_col_headerTooltip("sortorder","Ordianal position of the callable object when displayed on screen. The order is ment within an assignment to a catalog object (table/view)"); 
 //new:
 $dg -> set_col_headerTooltip("ind_seq","Is it a sequence or a singel callable object");
 
}
?>
