<?php
/* ===========+========+===== changelog ==========================================
 -- YYYY.MM.DD | author | change
 -- -----------+--------+----------------------------------------------------------
 -- 2022.08.04   rre      added new sortorder
 -- *******************************************************************************
 */
 
$dg -> set_col_required("catalog_id, instance_name, description, ind_active");
$dg -> set_col_default('ind_active', '1');
$dg -> set_col_default('ind_use_as_lookup', '0');
$dg -> set_col_default('ind_use_as_filter', '0');
$dg -> set_col_default('ind_use_as_grid', '1');
$dg -> set_col_default('ind_use_as_detail', '0');
$dg -> set_col_hidden("sort_id");
$dg->set_conditional_format("ind_active","ROW",array("condition"=>"eq",
                                                      "value"=>"0",
                                                      "css"=> array("color"=>COLOR_INACTIV_TEXT,"background-color"=>COLOR_INACTIV_BACKGROUND)));
$dg -> set_form_dimension(FORMSIZE_ADMINPAGE_MEDIUM);

if (isset($_SESSION['panel_name'])) {
	if ($_SESSION['panel_name'] == 'CATALOG') {
		
		$dg -> set_col_readonly("catalog_id");
		$dg -> set_col_hidden("projection_list, ind_active_projection_list,
	                       read_only_list, ind_active_read_only_list,
						   objectfilter, ind_active_objectfilter,
						   objectjoin, ind_active_objectjoin,
						   objectgroupby, ind_active_objectgroupby,
						   objectorder, ind_active_objectorder,
						   objectunion, ind_active_objectunion, 
						   ind_use_as_lookup, ind_use_as_filter, ind_use_as_grid, ind_use_as_detail", true);
	}
}

$dg -> set_col_property("catalog_id", array("formoptions"=>array("rowpos"=>1,"colpos"=>1)));
$dg -> set_col_property("sort_id", array("formoptions"=>array("rowpos"=>1,"colpos"=>2)));
																						 
$dg -> set_col_property("instance_name", array("formoptions"=>array("rowpos"=>2,"colpos"=>1)));
$dg -> set_col_property("description", array("formoptions"=>array("rowpos"=>3,"colpos"=>1)));
$dg -> set_col_property("ind_active", array("formoptions"=>array("rowpos"=>4,"colpos"=>1)));

$dg -> set_col_property("projection_list", array("formoptions"=>array("rowpos"=>5,"colpos"=>1)));
$dg -> set_col_property("ind_active_projection_list", array("formoptions"=>array("rowpos"=>5,"colpos"=>2)));
$dg -> set_col_edittype("ind_active_projection_list", "checkbox", "1:0");

$dg -> set_col_property("read_only_list", array("formoptions"=>array("rowpos"=>6,"colpos"=>1)));
$dg -> set_col_property("ind_active_read_only_list", array("formoptions"=>array("rowpos"=>6,"colpos"=>2)));
$dg -> set_col_edittype("ind_active_read_only_list", "checkbox", "1:0");

$dg -> set_col_property("objectjoin", array("formoptions"=>array("rowpos"=>7,"colpos"=>1)));
$dg -> set_col_property("ind_active_objectjoin", array("formoptions"=>array("rowpos"=>7,"colpos"=>2)));
$dg -> set_col_edittype("ind_active_objectjoin", "checkbox", "1:0");

$dg -> set_col_property("objectfilter", array("formoptions"=>array("rowpos"=>8,"colpos"=>1)));
$dg -> set_col_property("ind_active_objectfilter", array("formoptions"=>array("rowpos"=>8,"colpos"=>2)));
$dg -> set_col_edittype("ind_active_objectfilter", "checkbox", "1:0");

$dg -> set_col_property("objectgroupby", array("formoptions"=>array("rowpos"=>9,"colpos"=>1)));
$dg -> set_col_property("ind_active_objectgroupby", array("formoptions"=>array("rowpos"=>9,"colpos"=>2)));
$dg -> set_col_edittype("ind_active_objectgroupby", "checkbox", "1:0");

$dg -> set_col_property("objectorder", array("formoptions"=>array("rowpos"=>10,"colpos"=>1)));
$dg -> set_col_property("ind_active_objectorder", array("formoptions"=>array("rowpos"=>10,"colpos"=>2)));
$dg -> set_col_edittype("ind_active_objectorder", "checkbox", "1:0");

$dg -> set_col_property("objectunion", array("formoptions"=>array("rowpos"=>11,"colpos"=>1)));
$dg -> set_col_property("ind_active_objectunion", array("formoptions"=>array("rowpos"=>11,"colpos"=>2)));
$dg -> set_col_edittype("ind_active_objectunion", "checkbox", "1:0");

$dg -> set_col_edittype("description", "textarea");
$dg -> set_col_property("description", array("editoptions"=>array("rows"=>2, "cols"=> 32)));

$dg -> set_col_edittype("projection_list", "textarea");
$dg -> set_col_property("projection_list", array("editoptions"=>array("rows"=>4, "cols"=> 75)));

$dg -> set_col_edittype("read_only_list", "textarea");
$dg -> set_col_property("read_only_list", array("editoptions"=>array("rows"=>4, "cols"=> 75)));

$dg -> set_col_edittype("objectfilter", "textarea");
$dg -> set_col_property("objectfilter", array("editoptions"=>array("rows"=>4, "cols"=> 75)));

$dg -> set_col_edittype("objectjoin", "textarea");
$dg -> set_col_property("objectjoin", array("editoptions"=>array("rows"=>4, "cols"=> 75)));

$dg -> set_col_edittype("objectunion", "textarea");
$dg -> set_col_property("objectunion", array("editoptions"=>array("rows"=>4, "cols"=> 75)));

$dg -> set_col_edittype("objectgroupby", "textarea");
$dg -> set_col_property("objectgroupby", array("editoptions"=>array("rows"=>4, "cols"=> 75)));

$dg -> set_col_edittype("objectorder", "textarea");
$dg -> set_col_property("objectorder", array("editoptions"=>array("rows"=>4, "cols"=> 75)));

$dg -> set_col_edittype("ind_use_as_lookup", "checkbox", "1:0");
$dg -> set_col_edittype("ind_use_as_filter", "checkbox", "1:0");
$dg -> set_col_edittype("ind_use_as_grid", "checkbox", "1:0");
$dg -> set_col_edittype("ind_use_as_detail", "checkbox", "1:0");

if (GRID_AREA_LANGUAGE == 'de') {
$dg -> set_caption (CAPTION_ADMINPAGE_OPEN_TAG."Katalogverwaltung - Instanzen".CAPTION_ADMINPAGE_CLOSE_TAG);

$dg -> set_col_title("description","Beschreibung<br>Instanz");
$dg -> set_col_title("ind_active_objectfilter","Filter<br>verwenden");
$dg -> set_col_title("ind_active_objectjoin","Objektverknüpfung<br>verwenden");
$dg -> set_col_title("ind_active_projection_list","Spaltenliste<br>verwenden");
$dg -> set_col_title("ind_active_read_only_list","Schreibschutzliste<br>verwenden");
$dg -> set_col_title("ind_active_objectunion","Vereinigung<br>verwenden");
$dg -> set_col_title("ind_active_objectgroupby","Gruppierung<br>verwenden");
$dg -> set_col_title("ind_active_objectorder","Sortierung<br>verwenden");

$dg -> set_col_title("objectfilter","Filter");
$dg -> set_col_title("objectjoin","Objektverknpfung");
$dg -> set_col_title("objectunion","Vereinigung (UNION)");
$dg -> set_col_title("objectgroupby","Gruppierung");
$dg -> set_col_title("objectorder","Sortierung");

$dg -> set_col_title("projection_list","Spaltenliste");
$dg -> set_col_title("read_only_list","Schreibschutzliste");

$dg -> set_col_headerTooltip("description","Beschreibung der Objektinstanz");
$dg -> set_col_headerTooltip("instance_name","Instanz - Eine Instanz ist eine spezielle Ausprägung eines Katalogobjekts hinsichtlich Anzeigeeigenschaften und Datenfilter");
}

if (GRID_AREA_LANGUAGE == 'en') {
$dg -> set_caption (CAPTION_ADMINPAGE_OPEN_TAG."catalog management - instances".CAPTION_ADMINPAGE_CLOSE_TAG);

$dg -> set_col_title("description","Description <br> Instance");
$dg -> set_col_title("ind_active_objectfilter","use Filter");
$dg -> set_col_title("ind_active_objectjoin","use Join");
$dg -> set_col_title("ind_active_projection_list","use Columnlist");
$dg -> set_col_title("ind_active_read_only_list","use Read-only list");
$dg -> set_col_title("ind_active_objectunion","use Union ");
$dg -> set_col_title("ind_active_objectgroupby","use Group by");
$dg -> set_col_title("ind_active_objectorder","use Order by");

$dg -> set_col_title("objectfilter","Filter");
$dg -> set_col_title("objectjoin","Join");
$dg -> set_col_title("objectunion","Union");
$dg -> set_col_title("objectgroupby","Group by");
$dg -> set_col_title("objectorder","Order by");

$dg -> set_col_title("projection_list","Columnlist");
$dg -> set_col_title("read_only_list","Read-only list");

$dg -> set_col_title("ind_use_as_lookup","use as lookup");
$dg -> set_col_title("ind_use_as_filter","use as filter");
$dg -> set_col_title("ind_use_as_grid","use as grid");
$dg -> set_col_title("ind_use_as_detail","use as detail");														  
$dg -> set_col_headerTooltip("description","Description of the Object Instance");
$dg -> set_col_headerTooltip("instance_name","Instance - An Instance is a specific representation of a catalog object in display properties and filter");
}
?>
