<?php
/* ===========+========+===== changelog ==========================================
 -- YYYY.MM.DD | author | change
 -- -----------+--------+----------------------------------------------------------
 -- 2022.03.02   rre      added grid language
 -- *******************************************************************************
 */
$dg -> set_col_required("username, description, ind_active, firstname, lastname");
$dg -> set_col_default('ind_active', '1');
$dg -> set_col_default('password', 'niota');
$dg -> set_col_default('lang_grid', 'en');

$dg->set_conditional_format("ind_active","ROW",array("condition"=>"eq",
                                                      "value"=>"0",
                                                      "css"=> array("color"=>COLOR_INACTIV_TEXT,"background-color"=>COLOR_INACTIV_BACKGROUND)));

$dg -> set_form_dimension(FORMSIZE_ADMINPAGE_SMALL);

$dg -> set_col_property("username", array("formoptions"=>array("rowpos"=>1,"colpos"=>1)));
$dg -> set_col_property("description", array("formoptions"=>array("rowpos"=>2,"colpos"=>1)));
$dg -> set_col_edittype("description", "textarea");
$dg -> set_col_property("description", array("editoptions"=>array("rows"=>3, "cols"=> 50)));

 
if (GRID_AREA_LANGUAGE == 'de') {
 $dg -> set_caption (CAPTION_ADMINPAGE_OPEN_TAG."Benutzerverwaltung - Benutzerliste".CAPTION_ADMINPAGE_CLOSE_TAG);
  
 $dg -> set_col_title("description","Beschreibung<br>Benutzer");
 $dg -> set_col_title("email","eMail");
 $dg -> set_col_title("firstname","Vorname");

 $dg -> set_col_title("ind_active_ldap","LDAP aktiv");
 $dg -> set_col_title("ind_is_admin","Administrator");
 $dg -> set_col_title("lastname","Nachname");
 $dg -> set_col_title("password","Passwort");
 $dg -> set_col_title("phone","Telefon");

 $dg -> set_col_title("username_ldap","Benutzer ID<br>LDAP");  

 $dg -> set_col_headerTooltip("username","Technischer Name des Benutzerkontos"); 
 $dg -> set_col_headerTooltip("description","Beschreibung des Benutzerkontos");
 $dg -> set_col_headerTooltip("firstname","Vorname");
 $dg -> set_col_headerTooltip("ind_active_ldap","LDAP Anbindung für Benutzerauthentifizierung aktiv/inaktiv. LDAP Verbindung muss in connections.php definiert sein");
 $dg -> set_col_headerTooltip("ind_is_admin","Administrator-Berechtigungen für Benutzerkonto aktiv/inaktiv");
 $dg -> set_col_headerTooltip("lastname","Nachname"); 
 $dg -> set_col_headerTooltip("password","Passwort - wird vom System verschlüsselt. Kann vom Benutzer über persönsliche Einstellungen geändert werden.");
 $dg -> set_col_headerTooltip("phone","Telefonnummer");
 $dg -> set_col_headerTooltip("username_ldap","Technischer Name des Benutzerkontos, welches für LDAP Authentifizierung herangezogen wird");
}

if (GRID_AREA_LANGUAGE == 'en') {
 $dg -> set_caption (CAPTION_ADMINPAGE_OPEN_TAG."user management - users".CAPTION_ADMINPAGE_CLOSE_TAG);
  
 $dg -> set_col_title("description","Description<br>User");
 $dg -> set_col_title("email","e-mail");
 $dg -> set_col_title("firstname","Firstname");
 $dg -> set_col_title("ind_active_ldap","LDAP active");
 $dg -> set_col_title("ind_is_admin","Administrator");
 $dg -> set_col_title("lastname","Lastname");
 $dg -> set_col_title("password","Password");
 $dg -> set_col_title("phone","Phone");
 $dg -> set_col_title("username_ldap","User ID<br>LDAP");
 $dg -> set_col_title("lang_grid","Grid edit<br>language");  
}
?>