<?php

require_once __DIR__ . '/../conf/conf.php';

if(!isset($_SESSION))
	session_start();

	$adminPage = null;
	
	if (isset($_POST["co_source"])) {
		$coSource 	= $_POST["co_source"];
		$user 		= ET_NiotaUser::getNiotaUserFromSession();
		
		if ($coSource == CO_CALL_FROM_GRID) {
			
			$coName 			= $_POST["co_name"];		
			$coBindingLevel 	= $_POST["co_binding_level"];			
			
			$emptySelection 	= false;
			$selected_rows 		= array();	
			$feedbackData 		= array();
			$messagingActive	= false;
			$ret 				= array();
			$adminPage			= (isset($_POST["option_key"]) && !empty($_POST["option_key"])) ? true : false;
			$catalogInstanceId 	= $adminPage ? $_SESSION[SESS_CATALOG_INSTANCE_ID_MASTER_ADMIN] : $_SESSION[SESS_CATALOG_INSTANCE_ID_MASTER];
			$pageType 			= $adminPage ? PAGE_TYPE_SYSTEM : PAGE_TYPE_GRID;
			
			if ($coBindingLevel == BINDING_LEVEL_LINE) {
				
				if (!isset($_POST["selected_rows"]) || empty($_POST["selected_rows"])) {
	
					$feedbackData['cell_content'] = ET_DisplayHelper::localize("SELECTION_EMPTY", null, $pageType);
					$feedbackData['message'] = false;
					$feedbackData['header'] = "";
					echo json_encode($feedbackData);
					ET_UploadFileDataSessionManager::resetUpoladedFileData();
					return 0;
				}
				else {
					$selectedRowsPost = $_POST["selected_rows"];
					
					// if multiselect is turned off,  the $_POST["selected_rows"] is a string.
					if (gettype($selectedRowsPost) == 'string') {						
						array_push($selected_rows, $selectedRowsPost);
					}
					else {
						$selected_rows = $selectedRowsPost;
					}
					
				}							
			}
			
			try {
				$callableObject = array();
				
				if ($adminPage) {
					$optionKey 		= $_POST["option_key"];
					$callableObject = $user->getAdminCallableObject($optionKey, $coName);					
				}
				else {
					$callableObject = $user->getCallableObject($coName);					
				}

				if (is_null($callableObject)) { 
					ET_UploadFileDataSessionManager::resetUpoladedFileData();
					throw new Exception("Callable object with name " . $coName . " was not found in user mapping!");
				}
					
				$ret = 	ET_CallableObjectHelper::callFromGrid($callableObject, $coBindingLevel, $user, $catalogInstanceId, $selected_rows, $adminPage);
				
			} catch (Exception $e) {
				echo $e->getMessage();
				$msg = $e->getMessage();
				$feedbackData['cell_content'] 	= getFailureSignHtml();
				$feedbackData['message'] 		= ET_DisplayHelper::localize("CO_OBJECT_CALL_ERROR", null, $pageType) . " " . $msg;
				ET_UploadFileDataSessionManager::resetUpoladedFileData();
				return 0;
			}
			
			$error = $ret[CO_EXECUTION_ERROR];
			
			if ($coBindingLevel == BINDING_LEVEL_TABLE) {
				$feedbackData['cell_content'] = $error ? getFailureSignHtml() : getSuccessSignHtml($ret);
			}
			else {
				$processedRowNum 				= $ret[CO_LINE_LEVEL_PROCESSED_ROWS];
				$connName 						= !empty($ret[CO_MESSAGE_CONN_NAME]) ? $ret[CO_MESSAGE_CONN_NAME] : $ret[CO_CONN_NAME];
				
				$feedbackData['cell_content'] 	= $error ? getFailureSignHtml() : getSuccessSignLineLevel($ret, $selected_rows, $connName, $coName);
			}
			
			if ($ret[CO_RELOAD_GRID])
				$feedbackData['cell_content'] .= '<script>reloadMasterGrid();</script>';
			
			$feedbackDataRaw 			= ET_MessageHelper::processMessageLines($ret[CO_MESSAGES], $ret[CO_MESSAGE_CONN_NAME], $adminPage);	
			$feedbackData['message'] 	= $feedbackDataRaw['messages'];
			$feedbackData['header'] 	= $feedbackDataRaw['header'];
			
			ET_UploadFileDataSessionManager::resetUpoladedFileData();
			
			//HERE IS THE RETURN OF THE TABLE-CALL
			echo json_encode($feedbackData);							
		} 
		else if ($coSource == CO_CALL_FROM_MENU) {
			$messagesHtml = array();
			
			if (isset($_POST['callable_object'])){
				
				$coName 		= $_POST['callable_object'];
				$coLabel		= $_POST['menu_label'];					
				$ret 			= array();				
				$callableObject = $user->getCallableObject($coName);
				
				if (is_null($callableObject)) {					
					$messagesHtml['header'] = getFailureSignHtml() . "<b> Error!</b>";
					$messagesHtml['message'] = "Callable object with name '" . $coName . "' was not found among accessible ones!";					
				} else {
					
					try {
						$ret = ET_CallableObjectHelper::callFromMenu($coName, $coLabel);
						$temp 						= ET_MessageHelper::processMessageLines($ret[CO_MESSAGES], $ret[CO_MESSAGE_CONN_NAME], false);
						$messagesHtml['message'] 	= $temp['messages'];
						$messagesHtml['header'] 	= $temp['header'];
					} catch (Exception $exc) {
						
						$messagesHtml['header'] = getFailureSignHtml() . "<b> Error!</b>";
						$messagesHtml['message'] = $exc->getMessage();
					}
					
				}	
				
				ET_UploadFileDataSessionManager::resetUpoladedFileData();
				
				echo json_encode($messagesHtml);
			}		
		}
	}
	else if (isset($_POST['replay_last'])) {
		
		$lastItemHTML 	= $_POST['last_executed'];
		$form 			= $_POST['form'];
		$id 			= $_POST['id'];
		$id				= ET_StringCheck::resolveSubstitutedCharactersInGET($id);
		$imgReplay 		= new HTMLImage();
		$niotaUser 		= ET_NiotaUser::getNiotaUserFromSession();
		
		$menuItem 		= $niotaUser->getDynamicMenuItemById($id);
		$title			= $menuItem->get_menuLabel();
		
		$imgReplay->set_src("images/replay.png")->set_title($title)->set_class("pointer");
		
		if ($form == "true") {
			$cutStart 	= strpos($lastItemHTML, "<a ");
			
			$cutStop1 	= strpos($lastItemHTML, " true);\">");			
			$cutStop2 	= strpos($lastItemHTML, " true);'>");
			$cutStop	= $cutStop1 > $cutStop2 ? $cutStop1 : $cutStop2;
			
			//$cutStop	= strpos($lastItemHTML, " href=\"#\"");	;
			
			//$cutStop 	+= 9;
			
			$cutStop = strpos($lastItemHTML, ">", $cutStart);
			$length 	= ($cutStop + 1) - $cutStart;
			
			$lastItemHTMLPart1 = substr($lastItemHTML, $cutStart, $length);			
			
			$lastItemHTML = $lastItemHTMLPart1  . $imgReplay->printOpeningTag(true) . "</a>";			
			$_SESSION[SESS_REPLAY_LAST_DYNAMIC_MENU_ITEM] = $lastItemHTML;
			
			echo $lastItemHTML;
		}
		else {
			
			//cut this part: >execute select</a> (only the text)
			$cutStart = strpos($lastItemHTML, ">");
			$cutStop = strpos($lastItemHTML, "</a");
			$lastItemHTMLPart1 = substr($lastItemHTML, 0, $cutStart+1);
			$lastItemHTMLPart2 = substr($lastItemHTML, $cutStop);
			
			$lastItemHTML = $lastItemHTMLPart1  . $imgReplay->printOpeningTag(true) . $lastItemHTMLPart2;
				
			$_SESSION[SESS_REPLAY_LAST_DYNAMIC_MENU_ITEM] = $lastItemHTML;
			echo $lastItemHTML;
		}
		
	}

	function getSuccessSignHtml($ret) {
		
		global $adminPage;
		$imgSrc = $adminPage ? "../images/success.png" : "images/success.png";
		$titleText = addToolttipSystemSubstitutions($ret);
		
		return "<img src='$imgSrc' title=\"$titleText\">";
	}
	
	function getFailureSignHtml() {
		
		global $adminPage;
		$imgSrc = $adminPage ? "../images/unsuccess.png" : "images/unsuccess.png";
		return "<img src='$imgSrc'>";
	}
	
	function getSuccessSignTooltipSection($ret, $grid_selection, $coName) {
		
		$titleText 				= '';
		$rowIdStrings			= $ret[CO_ROWID_STRINGS];
		$callableSubstitutions 	= $ret[CO_SUBSTITUTION_VARS];
		
		$textsubsSystem 	= "";	
		$titleText			= "";	
		$wasSubstitution 	= false;
		
		$titleText = addToolttipSystemSubstitutions($ret);
		
		if (!empty($grid_selection)) {
			
			for ($i = 0; $i < count($rowIdStrings); $i++) {
				
				$rowId 				= $rowIdStrings[$i];
				$actualRow 			= $callableSubstitutions[$rowId];
				$gridSubstitutions 	= $actualRow->getSubstitutions();
				
				$titleText.= "Substitutions for row: [$rowId] \n";
				
				
				for ($j = 0; $j < count($gridSubstitutions); $j++) {
					
					$actItem 		= $gridSubstitutions[$j];
					$actItemValues 	= $actItem->getSubstitutions();
					$actItemName	= $actItem->getCallableName();
					
					$titleText.= "\tcallable: \t '$actItemName'\n\t";
					
					foreach ($actItemValues as $colName => $colValue) {
						$titleText.= "\t$colName: '$colValue' ";
					}
					
					$titleText .= "\n";
					$wasSubstitution = true;
				}
				if ($i != count($callableSubstitutions) - 1 && $wasSubstitution)
					$titleText.= "--------\n";				
			}
			
		}
		else {
			$titleText = "Callable object call was successful for callable '" . $coName . "'\n";
		}
		return $titleText;
	}
	
	function getSuccessSignLineLevel ($ret, $grid_selection, $connName, $coName) {
		
		$titleText 				= "";
		//$systemSubstitutions 	= isset($ret[CO_SUBSTITUTION_VARS_SYS]) ? $ret[CO_SUBSTITUTION_VARS_SYS] : null;
		
		if (!empty($grid_selection)) {
			$titleText = getSuccessSignTooltipSection($ret, $grid_selection, $coName);
		}
		
		global $adminPage;
		$imgSrc = $adminPage ? "../images/success.png" : "images/success.png";
		
		
		if (strlen($titleText > 490)) {
			$titleText = substr($titleText, 0, 490);
			$titleText .= "...";
		}
		if (ET_ConnHelper::isDbConnection($connName))
			$titleText = ET_StringCheck::convertToUTF8($titleText, $connName);		
		
		return "<img src='$imgSrc' title=\" $titleText\">";		
	}
	
	function addToolttipSystemSubstitutions ($ret) {
		
		$systemSubstitutions 	= isset($ret[CO_SUBSTITUTION_VARS_SYS]) ? $ret[CO_SUBSTITUTION_VARS_SYS] : array();
		$titleText 				= "";
		
		if (!empty($systemSubstitutions)) {
			$titleText	.= "System substitutions:\n";
			$count 		= 0;
			
			foreach ($systemSubstitutions as $key => $value) {
				
				$titleText	.= "\t$key: \t '$value' \n";
				
				if ($count < count($systemSubstitutions) - 1)
					$titleText.= "\n";
			}
		}
		return $titleText;
	}
?>





