<?php
	class ET_AdvancedFilterHelper {
		
		public static function resolveFilterMappings($filterMappings, $filterKeyPairs, $metaColumnInfo, $alias = "") {
			$ret = "";
			
			foreach ($filterMappings as $mapping) {
				$sourceColName 	= $mapping['column_name_master'];			
				$destColName	= $mapping['column_name_detail'];
				$operation		= $mapping['operation'];
				$operationSign 	= "=";

				$filterKeyPairsLower 	= ET_MetaDataConnector::getInstance()->arrayKeysToLower($filterKeyPairs);				
				$val 					= isset ($filterKeyPairsLower[strtolower($sourceColName)]) ? $filterKeyPairsLower[strtolower($sourceColName)] : "";
				
				if (!empty($val)) {					
					$quotesNeeded = ET_CallableObjectHelper::isQuotesNeededForColumnName($destColName, $metaColumnInfo);
					
					if ($operation != 0) {
						$destColName = $alias != "" ? $alias . "." . $destColName : $destColName;	
						//there can be same column names in differenet advanced filters
						//to avoid to put one column more times into the "WHERE" clause we need the "if (...)" below
						if (strpos($ret, $destColName) === false) {
							$ret 		.= $destColName . " " . self::getValueWithOperator($val, $operation, $quotesNeeded);
							$ret 		.= " AND ";
						}
						
					}
				} 				
			}
			
			if (self::endsWith($ret, " AND ")) {
				$ret = substr($ret, 0, strlen($ret) - 5);
			}
			
			return $ret;			
			
		}
		
		public static function resolveOrderBy ($filterMappings, $alias = "", $useAdvancedFiltering = false) {
			$ret = "";
				
			$tempArray 				= [];
			$colNames 				= [];					
			$logicalLink			= isset($_SESSION[SESS_ADVANCED_FILTER_LOGICAL_LINK]) ? $_SESSION[SESS_ADVANCED_FILTER_LOGICAL_LINK] : "";
			//echo $logicalLink . "<br><br>";
			foreach ($filterMappings as $mapping) {
				$sourceColName 	= $mapping['column_name_master'];
				$destColName	= $mapping['column_name_detail'];
				$sortorder		= $mapping['sortorder'];
				
				if (!is_null($sortorder) && !in_array($destColName, $colNames) && $logicalLink == $mapping['logical_link']) {
					$tempArray[$sortorder] 	= $destColName;
					$colNames[] 			= $destColName;
				} else {
					continue;
				}
			}
			
			if ($useAdvancedFiltering)
				unset($_SESSION[SESS_ADVANCED_FILTER_LOGICAL_LINK]);
			
			ksort($tempArray);
			
			foreach ($tempArray as $key => $value) {
				//$ret .= $objectjoin ? OBJECT_JOIN_ALIAS_PREFIX . $catalogId . "." . $value . "," : $value . ",";
				$ret .= $alias == "" ? $value . "," : $alias . "." . $value . ",";
			}
			
			if (self::endsWith($ret, ",")) {
				$ret = substr($ret, 0, strlen($ret) - 1);
			}
			
			return $ret;
				
		}
		
		public static function endsWith($haystack, $needle)
		{
			$length = strlen($needle);
			if ($length == 0) {
				return true;
			}
		
			return (substr($haystack, -$length) === $needle);
		}
		
		public static function getValueWithOperator($val, $operation, $quotesNeeded) {
			$quoteString = $quotesNeeded ? "'" : "";
			
			switch ($operation) {
				case 1:
					return "=" . $quoteString . $val . $quoteString;					
				case 2:
					return "<> " . $quoteString . $val . $quoteString;
				case 3:
					return "> " . $quoteString . $val . $quoteString;
				case 4:
					return "< " . $quoteString . $val . $quoteString;
				case 5:
					return ">= " . $quoteString . $val . $quoteString;
				case 6:
					return "<= " . $quoteString . $val . $quoteString;
				case 9:
					return "like('%" . $val . "%')";
				case 10:
					return "not like('%" . $val . "%')";
				case 11:
					return "like('" . $val . "%')";
				case 12:
					return "not like('" . $val . "%')";
				case 13:
					return "like('%" . $val . "')";
				case 14:
					return "not like('%" . $val . "')";
				default:
					return "= " . $val;
			}
		}
		
	}
	
	?>