<?php

	class ET_BrowsingStore{
		protected $browsingStates = array();
		
		public static function getBrowsingStore() {
			return unserialize($_SESSION[SESS_BROWSING_STORE]);
		}
		
		public function flushBrowsingStore() {
			$_SESSION[SESS_BROWSING_STORE] = serialize($this);
		}
		
		public function get_browsingState($catalogInstanceId) {
			if (isset($this->browsingStates[$catalogInstanceId]))
				return $this->browsingStates[$catalogInstanceId];
			return null;
		}
		
		public function create_browsingState($catalogInstanceId) {
			/*if (!isset($this->browsingStates[$catalogInstanceId]))
				$this->browsingStates[$catalogInstanceId] = new ET_BrowsingState();*/
			if(!array_key_exists($catalogInstanceId, $this->browsingStates)) {
				$this->browsingStates[$catalogInstanceId] = new ET_BrowsingState();
			}
		}
		
		/***
		 * Ususally this identifier is the catalog-instance-id. Logical link is needed for master-detail settings.
		 * $optionKey is used for admin page user-setting identifiers (table, column sizes etc.).
		 * @param string $catalogInstanceId
		 * @param string $logicalLink
		 * @param string $optionKey
		 * @return string
		 */
		public function generateGridIdentifier($catalogInstanceId, $logicalLink = "", $optionKey = "") {
			
			return !empty($logicalLink) ? $catalogInstanceId . FORMATTING_LINK_SEPARATOR . $logicalLink
			: (!empty($optionKey) ? $catalogInstanceId . FORMATTING_LINK_SEPARATOR . $optionKey : $catalogInstanceId);
			
		}
		
		public function get_minMaxInfo($catalogInstanceId, $colName, $subgridStr, $field) {
			return $this->get_browsingState($catalogInstanceId)->get_minMaxInfo($colName, $subgridStr, $field);
		}
		
		public function add_minMaxInfo($catalogInstanceId, $colName, $subgridStr, $field, $value){
			
			$this->get_browsingState($catalogInstanceId)->add_minMaxInfo($colName, $subgridStr, $field, $value);
		}
		
		public function clear_minMaxInfo($catalogInstanceId) {
			$this->get_browsingState($catalogInstanceId)->clear_minMaxInfo();
		}
		
		public function get_isLookupConnecetionError($catalogInstanceId) {
			return $this->get_browsingState($catalogInstanceId)->get_isLookupConnecetionError();
		}
		
		public function set_isLookupConnecetionError($catalogInstanceId, $value){
			$this->get_browsingState($catalogInstanceId)->set_isLookupConnecetionError($value);
		}
		
		public function get_virtualColumnPosition($catalogInstanceId) {
			return $this->get_browsingState($catalogInstanceId)->get_virtualColumnPosition();
		}
		
		public function set_virtualColumnPosition($catalogInstanceId, $value){
			$this->get_browsingState($catalogInstanceId)->set_virtualColumnPosition($value);
		}
		
		public function get_selectedColumnInfo($catalogInstanceId) {
			return $this->get_browsingState($catalogInstanceId)->get_selectedColumnInfo();
		}
		
		public function set_selectedColumnInfo($catalogInstanceId, $value){
			$this->get_browsingState($catalogInstanceId)->set_selectedColumnInfo($value);
		}
		
		public function get_selectedPrimaryKeys($catalogInstanceId) {
			return $this->get_browsingState($catalogInstanceId)->get_selectedPrimaryKeys();
		}
		
		public function set_selectedPrimaryKeys($catalogInstanceId, $value){
			$this->get_browsingState($catalogInstanceId)->set_selectedPrimaryKeys($value);
			}
		
		public function set_connName($catalogInstanceId, $connName){
			$this->get_browsingState($catalogInstanceId)->set_connName($connName);
		}
		
		public function get_connName($catalogInstanceId){
			return $this->get_browsingState($catalogInstanceId)->get_connName();
		}
		
		public function get_fullTableName($catalogInstanceId) {
			return $this->get_browsingState($catalogInstanceId)->get_fullTableName();
		}
		
		public function set_fullTableName($catalogInstanceId, $value){
			$this->get_browsingState($catalogInstanceId)->set_fullTableName($value);
		}
		
		public function get_filterKeyPair($catalogInstanceId) {
			return $this->get_browsingState($catalogInstanceId)->get_filterKeyPair();
		}
		
		public function set_filterKeyPair($catalogInstanceId, $value){
			$this->get_browsingState($catalogInstanceId)->set_filterKeyPair($value);
		}
		
		public function set_mergedColumns($catalogInstanceId, $logicalLink, $value){
			$this->get_browsingState($catalogInstanceId)->set_mergedColumns($logicalLink, $value);
		}
		
		public function get_mergedColumns($catalogInstanceId, $logicalLink = ''){
			return $this->get_browsingState($catalogInstanceId)->get_mergedColumns($logicalLink);
		}
		
		public function clear_allFilterKeyPair() {
			foreach ($this->browsingStates as $key => $value) {
				$value->set_filterKeyPair([]);
				
				$sqlObj = $value->get_gridSqlObject();
				
				if(!is_null($sqlObj)) {
					$sqlObj->setWhereObjectFilter("");
					$sqlObj->setObjectOrder("");
					$value->set_gridSqlObject($sqlObj);
				}				
			}
		}
		
		public function set_excelPartialDeleteWhere($catalogInstanceId, $value = "") {
			$this->get_browsingState($catalogInstanceId)->set_excelPartialDeleteWhere($value);
		}
		
		public function get_excelPartialDeleteWhere($catalogInstanceId) {
			return $this->get_browsingState($catalogInstanceId)->get_excelPartialDeleteWhere();
		}
		
		public function set_fixedValues($catalogInstanceId, $subgrid_logical_link, $fixedValues) {
			$this->get_browsingState($catalogInstanceId)->set_fixedValues($subgrid_logical_link, $fixedValues);
		}
		
		public function get_fixedValues($catalogInstanceId, $subgrid_logical_link) {
			return $this->get_browsingState($catalogInstanceId)->get_fixedValues($subgrid_logical_link);
		}
		
		public function set_lookupSettings($catalogInstanceId, $lookupSettings) {
			$this->get_browsingState($catalogInstanceId)->set_lookupSettings($lookupSettings);
		} 
		
		public function get_lookupSettings($catalogInstanceId) {
			return $this->get_browsingState($catalogInstanceId)->get_lookupSettings();
		}
		
		public function set_constraintSettings($catalogInstanceId, $constraintSettings) {
			$this->get_browsingState($catalogInstanceId)->set_constraintSettings($constraintSettings);
		}
		
		public function get_constraintSettings($catalogInstanceId) {
			return $this->get_browsingState($catalogInstanceId)->get_constraintSettings();
		}
		
		public function set_groupBy($catalogInstanceId, $groupBy) {
			$this->get_browsingState($catalogInstanceId)->set_groupBy($groupBy);
		}
		
		public function get_groupBy($catalogInstanceId) {
			return $this->get_browsingState($catalogInstanceId)->get_groupBy();
		}
		
		public function set_orderBy($catalogInstanceId, $orderBy) {
			$this->get_browsingState($catalogInstanceId)->set_orderBy($orderBy);
		}
		
		public function get_orderBy($catalogInstanceId) {
			return $this->get_browsingState($catalogInstanceId)->get_orderBy();
		}
		
		public function set_objectFilter($catalogInstanceId, $filter) {
			$this->get_browsingState($catalogInstanceId)->set_objectFilter($filter);
		}
		
		public function get_objectFilter($catalogInstanceId) {
			return $this->get_browsingState($catalogInstanceId)->get_objectFilter();
		}
		
		public function set_gridSqlObject($catalogInstanceId, $gridSqlObject) {
			$this->get_browsingState($catalogInstanceId)->set_gridSqlObject($gridSqlObject);
		}
		
		public function get_gridSqlObject($catalogInstanceId) {
			return $this->get_browsingState($catalogInstanceId)->get_gridSqlObject();
		}
		
		public function getBrowsingStates() {
			return  $this->browsingStates;
		}
		
	}

	class ET_BrowsingState {
		protected $virtualColumnPosition;    
		protected $isLookupConnecetionError;
		protected $selectedColumnInfo;
		protected $selectedPrimaryKeys;
		protected $fullTableName;
		protected $minMaxInfo 		= array();
		protected $filterKeyPair 	= array();
		protected $connName;
		protected $mergedColumns	= array();
		protected $excelPartialDeleteWhere;
		protected $fixedValues 		= array();
		protected $lookupSettings 	= array();
		protected $constraintSettings = array();
		protected $groupBy			= "";
		protected $orderBy 			= "";
		protected $objectFilter		= "";
		protected $gridSqlObject	= null;
		
		public function get_filterKeyPair() {
			return $this->filterKeyPair;
		}
		
		public function set_filterKeyPair($value){
			$this->filterKeyPair = $value;
		}
		
		public function get_isLookupConnecetionError() {
		  return $this->isLookupConnecetionError;
		}
		
		public function set_isLookupConnecetionError($value){
		  $this->isLookupConnecetionError = $value;
		}		
		
		public function get_virtualColumnPosition() {
		  return $this->virtualColumnPosition;
		}
		
		public function set_virtualColumnPosition($value){
		  $this->virtualColumnPosition = $value;
		}
		    
		public function get_selectedColumnInfo() {
			return $this->selectedColumnInfo;
		}
		
		public function set_selectedColumnInfo($value){
			$this->selectedColumnInfo = $value;
		}

		public function get_selectedPrimaryKeys() {
			return $this->selectedPrimaryKeys;
		}
		
		public function set_selectedPrimaryKeys($value){
			$this->selectedPrimaryKeys = $value;
		}
		
		
		public function get_minMaxInfo($colName, $subgridStr, $field) {
			if (isset($this->minMaxInfo[$colName . ":" . $subgridStr][$field]))
				return $this->minMaxInfo[$colName . ":" . $subgridStr][$field];
			return null;
		}
		
		public function add_minMaxInfo($colName, $subgridStr, $field, $value){
			if (!isset($this->minMaxInfo[$colName . ":" . $subgridStr])) {
				$this->minMaxInfo[$colName . ":" . $subgridStr] = array();
			}
			$this->minMaxInfo[$colName . ":" . $subgridStr][$field] = $value;
		}
		
		public function clear_minMaxInfo() {
			unset($this->minMaxInfo);
			$this->minMaxInfo = array();
		}
		
		public function set_connName($connName){
			$this->connName = $connName;
		}
		
		public function get_connName(){
			return $this->connName;
		}

		public function get_fullTableName() {
			return $this->fullTableName;
		}
		
		public function set_fullTableName($value){
			$this->fullTableName = $value;
		}
		
		public function set_mergedColumns ($logicalLink, $value) {
			if ($logicalLink == '')
				$logicalLink = 'EMPTY_LOGICAL_LINK';
			$this->mergedColumns[$logicalLink] = $value;
		}
		
		public function get_mergedColumns($logicalLink) {
			if ($logicalLink == '')
				$logicalLink = 'EMPTY_LOGICAL_LINK';
				
			return isset($this->mergedColumns[$logicalLink]) ? $this->mergedColumns[$logicalLink] : array();
		}
		
		public function set_excelPartialDeleteWhere($value) {
			$this->excelPartialDeleteWhere = $value;
		}
		
		public function get_excelPartialDeleteWhere() {
			return $this->excelPartialDeleteWhere;
		}
		
		public function set_fixedValues($subgrid_logical_link, $fixedValues) {
			
			if ($subgrid_logical_link== '')
				$subgrid_logical_link= 'EMPTY_LOGICAL_LINK';
			
			$this->fixedValues[$subgrid_logical_link] = $fixedValues;
		}
		
		public function get_fixedValues ($subgrid_logical_link) {
			
			if ($subgrid_logical_link == '')
				$subgrid_logical_link = 'EMPTY_LOGICAL_LINK';
				
				return isset($this->fixedValues[$subgrid_logical_link]) ? $this->fixedValues[$subgrid_logical_link] : array();
		}
		
		public function set_lookupSettings($value) {
			$this->lookupSettings = $value;
		}
		
		public function get_lookupSettings() {
			return $this->lookupSettings;
		}
		
		public function set_constraintSettings($value) {
			$this->constraintSettings = $value;
		}
		
		public function get_constraintSettings() {
			return $this->constraintSettings;
		}
		
		public function set_orderBy($orderBy) {
			$this->orderBy = $orderBy;
		}
		
		public function get_orderBy() {
			return $this->orderBy;
		}
		
		public function set_groupBy($groupBy) {
			$this->groupBy = $groupBy;
		}
		
		public function get_groupBy() {
			return $this->groupBy;
		}
		
		public function set_objectFilter($filter) {
			$this->objectFilter = $filter;
		}
		
		public function get_objectFilter() {
			return $this->objectFilter;
		}
		
		public function set_gridSqlObject($object) {
			$this->gridSqlObject = $object;
		}
		
		public function get_gridSqlObject() {
			return $this->gridSqlObject;
		}
		
	}