<?php

	class ET_CallableObjectHelper {
				
		
		protected static function fillErrorMessage(&$ret, $conn, $result, $coDisplayName, $menuLabel = "", $addSuccessMessage = false, $isAdminGrid) {
			
			$pageType = ET_DisplayHelper::detectPageType($isAdminGrid);
			
			if ($conn->_connectionID === false) {
				$ret[CO_EXECUTION_ERROR] = true;
				self::addMessage($ret, 
						empty($menuLabel) ? ET_DisplayHelper::localize("CO_CONNECTION_ERROR", null, $pageType) : ET_DisplayHelper::localize("CO_DYNAMIC_MENU_CONNECTION_ERROR", array($menuLabel), $pageType),
						CO_MESSAGE_TYPE_FAILURE_SYSTEM);
				return 0;
			} else if ($result === FALSE) {
				$ret[CO_EXECUTION_ERROR] = true;
				self::addMessage($ret, 
						empty($menuLabel) ? ET_DisplayHelper::localize("CO_SQL_ERROR", array($coDisplayName), $pageType) : ET_DisplayHelper::localize("CO_DYNAMIC_MENU_SQL_ERROR", array($menuLabel), $pageType),
						CO_MESSAGE_TYPE_FAILURE_SYSTEM);
				return 1;
			} else if ($addSuccessMessage) {				
				self::addMessage($ret, 
						empty($menuLabel) ? ET_DisplayHelper::localize("CO_CALL_SUCCESS", null, $pageType) : ET_DisplayHelper::localize("CO_DYNAMIC_MENU_CALL_SUCCESS", array($menuLabel), $pageType), 
						CO_MESSAGE_TYPE_SUCCESS_SYSTEM);
			}
			return 2;
		}
		
		protected static function loadFileContent($fileName, $adminPage, $type, &$ret) {
			
			$clientSetting  = isset($_SESSION[SESS_CLIENT]) ? $_SESSION[SESS_CLIENT] : CLIENT_SYSTEM;
			$rootPath		= "";
			$resourceFolder = '';
			$logTypeError	= $type == CO_TYPE_BATCH_COMMAND ? LOG_TYPE_ERROR_SQL : LOG_TYPE_ERROR_WS;
			
			if ($clientSetting == CLIENT_SYSTEM || $adminPage) {
				$rootPath 		= __DIR__ . "/../../";	
				
				if (!$adminPage && $clientSetting == CLIENT_SYSTEM) {
					$rootPath .= "conf/";
				}
				
			} else {
				$clientFolderName 	= ET_PropertiesStartUp::getInstance()->myParameter('conffolder');
				//$rootPath			= dirname(__FILE__)  . "/../../../conf/$clientFolderName/";
				$rootPath			= $_SESSION[SESS_CLIENT_FOLDER_PATH] . "/";
			}
			
			if ($type == CO_TYPE_BATCH_COMMAND) {
				if ($adminPage) {					
					$resourceFolder = $rootPath . CO_SQL_FILE_PATH_ADMIN;
				} else { 
					$resourceFolder = $rootPath . CUSTOM_SCRIPT_FOLDER . "/" . CUSTOM_CALLABLE_SUBFOLDER_SQL;
				}
			}
			else if ($type == CO_TYPE_WEB_SERVICE_CALL) {
				
				if ($adminPage) {					
					$resourceFolder = $rootPath . CO_WS_FILE_PATH_ADMIN;
				}
				else {
					$resourceFolder = $rootPath . CUSTOM_SCRIPT_FOLDER . "/" . CUSTOM_CALLABLE_SUBFOLDER_WS;
				}
			}
			
			$resourceFileNamePath 	=  $resourceFolder . "/" . $fileName ;
			
			//not so nice:
			//TODO: separate the 'empty' and the 'file not found' case
			if (file_exists($resourceFileNamePath)) {
				$content	= file_get_contents($resourceFileNamePath);
				
				if (!empty($content))
					return $content;
				
			} else {
				$systemLogger = new \ET_LoggingHelperSystem();
				$systemLogger->addSystemLogEntry($logTypeError,  "FILE NOT FOUND" . "\n[file:]\t" . $resourceFileNamePath);
				
				self::addMessage($ret, ET_DisplayHelper::localize("CO_SQL_FILE_NOT_FOUND_OR_EMPTY", array($resourceFileNamePath), ET_DisplayHelper::detectPageType($adminPage)), CO_MESSAGE_TYPE_ERROR_SYSTEM);
				
				return false;
			}
		}
		
		protected static function processSQLFileString ($content) {
			
			$lines 	= explode("===", $content);
			$ret 	= array();
			
			for ($i = 0; $i < count($lines); $i++) {
				$line = $lines[$i];
				$pos = strpos($line, ":");
				
				if ($pos === false)
					continue;
					
				$key = substr($line, 0, $pos);
				$value = substr($line, $pos + 1);
				
				$tmpArray = array();
				$tmpArray['label'] 	= trim($key);
				$tmpArray['sql'] 	= trim($value);
				
				$ret[] = $tmpArray;
			}
			
			return $ret;
		}
		
		protected static function callLineLevel($callableConn, $callableConnName, $callableObject, $catalogInstanceId, $grid_selection, &$ret, $isAdminGrid = false) {
			
			$browsingStore 		= ET_BrowsingStore::getBrowsingStore();
			$catalogConnName 	= $browsingStore->get_connName($catalogInstanceId);			
			$fullTableName 		= $catalogInstanceId != "" ? $browsingStore->get_fullTableName($catalogInstanceId) : "";			
			$columnInfo 		= $browsingStore->get_selectedColumnInfo($catalogInstanceId);
			$primaryKeys 		= $browsingStore->get_selectedPrimaryKeys($catalogInstanceId);
			$substitutedVars 	= array();
			$callableConnArray 	= ET_ConnHelper::getConnectionArrayFromConnectionName($callableConnName);
			$callableDbConnection	
								= ET_ConnHelper::isDbConnection($callableConnName);
			$callableDisplayName = self::getCallableDisplayName($callableObject);
			$queryString 		= $callableObject['command'];
			$catalogConn		= $callableConn;
			
			if ($catalogConnName != $callableConnName) {
				$catalogConn = ET_ConnHelper::getConnection($catalogConnName);
			}
			$catalogConn->SetFetchMode(ADODB_FETCH_ASSOC);
			
			$count = 0;
			$substitutedQueryStr = $queryString;
			//grid_selection CONTAINS THE PRIMARY KEYS OF THE ROW			
			for ($i = 0; $i < count($grid_selection); $i++) {
				
				self::customErrorHandlerToHideWarning();				
				//EXECUTE CALLABLE OBJECT ON CURRENT ROW:
				self::runCallableObjectWithSequenceCheck($callableConn, $callableObject, $ret, $grid_selection[$i], "", $isAdminGrid);

				if ($ret[CO_EXECUTION_ERROR] === true) {					
					break;
				}
				
				$count++;
				//custom error handling ends
				restore_error_handler();
			}
			
			//self::setSubstitutedVariables($substitutedVars);			
			$ret[CO_LINE_LEVEL_PROCESSED_ROWS] = $count;

			if ($ret[CO_EXECUTION_ERROR] !== true) {
				self::addMessage($ret, ET_DisplayHelper::localize("CO_CALL_SUCCESS_EXT", array($callableDisplayName), ET_DisplayHelper::detectPageType($isAdminGrid)), CO_MESSAGE_TYPE_SUCCESS_SYSTEM);
			}
		}
		
		
		public static function callTableLevel($callableConn, $callableObject, &$ret, $isAdminGrid = false) {
			
			self::runCallableObjectWithSequenceCheck($callableConn, $callableObject, $ret, null, "", $isAdminGrid);
			
			if ($ret[CO_EXECUTION_ERROR] !== true) {
				$callableDisplayName = self::getCallableDisplayName($callableObject);
				self::addMessage($ret, ET_DisplayHelper::localize("CO_CALL_SUCCESS_EXT", array($callableDisplayName), ET_DisplayHelper::detectPageType($isAdminGrid)), CO_MESSAGE_TYPE_SUCCESS_SYSTEM);
			}
			
		}
		
		public static function loadCOFileContent (&$callableObject, $adminPage, &$ret) {
			$callableType = $callableObject['callobject_type'];
			
			if ($callableType == CO_TYPE_BATCH_COMMAND || $callableType == CO_TYPE_WEB_SERVICE_CALL) {
			
				$fileName 			= $callableObject['command'];
				$labeledFileContent = self::loadFileContent($fileName, $adminPage, $callableType, $ret);
				
				if ($labeledFileContent === false) {
					$ret[CO_EXECUTION_ERROR] = true;
					return false;					
				}
				else {
					$callableObject['command'] = $labeledFileContent;
				}
			}
			return true;
		}
		
		public static function callFromGrid($callableObject, $coBindingLevel, $user, $catalogInstanceId, $grid_selection = array(), $adminPage = false) {
			$catalogId		= explode(".", $catalogInstanceId)[0];
			
			$coDisplayName			= !empty($callableObject['description']) ? $callableObject['description'] : $callableObject['name'];
			$ret 					= self::createDefaultCOResult($coDisplayName);			
			$callableConnName 		= $callableObject['conn_name'];			
			
			$ret[CO_RELOAD_GRID] 	= $callableObject['reload_grid'];
			$ret[CO_CONN_NAME]		= $callableConnName;
			
			self::customErrorHandlerToHideWarning();
			$callableConn	 = ET_ConnHelper::getConnection($callableConnName);
			restore_error_handler();
			
			// line level
			if ($coBindingLevel == BINDING_LEVEL_LINE) {
				
				try{
					self::callLineLevel($callableConn, $callableConnName, $callableObject, $catalogInstanceId, $grid_selection, $ret, $adminPage);
				}
				catch (Exception $e){
					ET_CallableObjectHelper::addMessage($ret, $e->getMessage(), CO_MESSAGE_TYPE_ERROR_SYSTEM);
					$ret[CO_EXECUTION_ERROR] = true;
					
					return $ret;
				}
			}
			// table level
			else {				
				self::callTableLevel($callableConn, $callableObject, $ret, $adminPage);
			}
			
			return $ret;
		}
		
		public static function getCatalogInstanceId($isAdminPage) {
			
			if ($isAdminPage) {
				return isset( $_SESSION[SESS_CATALOG_INSTANCE_ID_MASTER_ADMIN]) ? $_SESSION[SESS_CATALOG_INSTANCE_ID_MASTER_ADMIN] : null;
			} else {
				return isset($_SESSION[SESS_CATALOG_INSTANCE_ID_MASTER]) ? $_SESSION[SESS_CATALOG_INSTANCE_ID_MASTER] : null;
			}	
		}
		
		public static function callFromMenu($coName, $coLabel) {
			
			$user 				= ET_NiotaUser::getNiotaUserFromSession();
			$callableObject		= $user->getCallableObject($coName);
			$coDisplayName		= !empty($callableObject['description']) ? $callableObject['description'] : $callableObject['name'];
			$ret 				= self::createDefaultCOResult($coDisplayName);			
			$coConnName			= $callableObject["conn_name"];
			$callableConn		= ET_ConnHelper::getConnection($coConnName);
			
			if (is_null($callableObject)) {				
				self::addMessage($ret, ET_DisplayHelper::localize("DYNAMIC_MENU_CALL_FAILED", array($coLabel), PAGE_TYPE_GRID), CO_MESSAGE_TYPE_ERROR_SYSTEM);
				return $ret;
			}
			
			self::runCallableObjectWithSequenceCheck($callableConn, $callableObject, $ret, null, $coLabel, false);
			
			if ($ret[CO_EXECUTION_ERROR] !== true) {
				self::addMessage($ret, ET_DisplayHelper::localize("CO_CALL_SUCCESS", null, PAGE_TYPE_GRID), CO_MESSAGE_TYPE_SUCCESS_SYSTEM);
			}
			
			return $ret;

		}
		
		public static function callLoggingToDB($callObjectName, $sql, $actionCode = "") {
			
			$user 				= ET_NiotaUser::getNiotaUserFromSession(); 
			//$catalogInstanceId 	= $_SESSION[SESS_CATALOG_INSTANCE_ID_MASTER];
			$catalogInstanceId 	= self::getCatalogInstanceId(false);
			$browsingStore 		= ET_BrowsingStore::getBrowsingStore();
			$callableObject 	= $user->getCallableObject($callObjectName);
			
			if (is_null($callableObject))
				throw new Exception("Callable object with name " . $callObjectName . " was not found in user mapping!");
			
			$coConnName 	= $callableObject['conn_name'];
			$coCommand 		= $callableObject['command'];
			
			$db_type	= ET_ConnHelper::getConnectionTypeByName($coConnName);
			$db_charset = ET_ConnHelper::getConnectionCharsetByName($coConnName);
			$conn		= ET_ConnHelper::getConnection($coConnName);
		
			$sql 			= str_replace("'", "''", $sql);					
			$queryString 	= str_replace('$sql', $sql, $coCommand);			
			$queryString 	= str_replace('$dateTime', date("Y-m-d H:i:s"), $queryString);
			$queryString 	= str_replace('$action', $actionCode, $queryString);
		
			if ($db_type == "odbc_mssql" || $db_type == 'odbc_teradata') {
				$queryString= iconv("utf-8", $db_charset, $queryString);
			}
			
			$ret = self::runQuery($conn, $coConnName, $queryString, $browsingStore, null, false);
				
			return $ret;
		}
		
		protected static function addSqlDebugString (&$ret, $query, $coDisplayName) {
						
				$user = ET_NiotaUser::getNiotaUserFromSession();
				$debug = $user->getDebugGridConfig();
				
				if ($debug) {			
					$logger = new ET_LoggingHelperSystem();
					$logger->addSystemLogEntry(LOG_TYPE_DEBUG, "Callable debug: \t display name:\t" . 
							$coDisplayName . ", statement:\t" . $query);
				}
		}
		
		protected static function getColNameFromCommand($queryString, $offset) {
			$firstColPos = strpos($queryString, '$col.', $offset);
			
			if ($firstColPos !== false) {
				
				$firstFieldPos = $firstColPos + 6;
				$endFieldPos = strpos($queryString, "}", $firstFieldPos);
					
				$length = $endFieldPos - $firstFieldPos;
				
				if ($length > 0){
					return array(substr($queryString, $firstFieldPos, $length), $endFieldPos);
				}
			}		
			return false;
		}

		public static function runSequenceCall(&$callableConn, $callableObject, &$ret, $selectedPKVals, $menuLabel, $isAdminGrid) {
					
			$coName					= $callableObject['name'];
			$callableSequence 		= array();
			$callableSequenceOthers = ET_MetaDataConnector::getInstance()->getCallableSequence($coName);
			
			array_push($callableSequence, $callableObject);
			
			for ($h = 0; $h < count($callableSequenceOthers); $h++) {
				array_push($callableSequence, $callableSequenceOthers[$h]);
			}
			
			for ($k = 0; $k < count($callableSequence); $k++) {
				
				$currentCallableObject 	= $callableSequence[$k];
				$currentCallableConn	= ET_ConnHelper::getConnection($currentCallableObject['conn_name']);
				//var_dump($currentCallableObject);
				self::runCallableObject($currentCallableConn, $currentCallableObject, $ret, $selectedPKVals, $menuLabel, $isAdminGrid);
				
				if ($ret[CO_MESSAGE_STOPPED] == 1) {
					ET_CallableObjectHelper::addMessage($ret, ET_DisplayHelper::localize('CO_CHAIN_STOPPED', null, ET_DisplayHelper::detectPageType($isAdminGrid)), CO_MESSAGE_TYPE_WARNING);
					break;
				}
			}
					
		}
		
		
		protected static function runCallableObjectWithSequenceCheck(&$callableConn, $callableObject, &$ret, $selectedPKVals = null, $menuLabel = "", $isAdminGrid = false) {
			
			if ($callableObject['sequence']) {
				ET_CallableObjectHelper::runSequenceCall($callableConn, $callableObject, $ret, $selectedPKVals, $menuLabel, $isAdminGrid);
				//$ret = ET_MessageHelper::mergeMessages($rets);
			}
			else {				
				ET_CallableObjectHelper::runCallableObject($callableConn, $callableObject, $ret, $selectedPKVals, $menuLabel, $isAdminGrid);
			}
			
		}
		
		protected static function runCallableObject(&$callableConn, $callableObject, &$ret, $selectedPKVals = null, $menuLabel = "", $isAdminGrid = false) {
			
			$callableConnName 	= $callableObject['conn_name'];
			$callableType		= $callableObject['callobject_type'];
			$coCommand 			= $callableObject['command'];
			$messagingActive 	= $callableObject['messaging_active'];
			$browsingStore		= ET_BrowsingStore::getBrowsingStore();
			$result				= null;
			$actual_vals		= null;
			$primaryKeys 		= array();
			$colNames 			= array();
			$columnInfo			= array();
			$needQuotes			= null;
			$coDisplayName		= self::getCallableDisplayName($callableObject);
			$catalogInstanceId 	= self::getCatalogInstanceId($isAdminGrid);
			
			//user communication area:
			$useUCA				= $callableObject['use_uca'];
			$saveUCA			= $useUCA ? $callableObject['save_uca'] : false;
			$uca				= $useUCA ? $callableObject['uca'] : "";
			$ucaData			= $useUCA ? ["save_uca"=> $saveUCA, "uca" => $uca] : array();	
			
			if ($messagingActive) {
				$ret[CO_MESSAGE_GUID] 	= self::getGUID();
			}
			
			$coFileName = $callableType == CO_TYPE_WEB_SERVICE_CALL || $callableType == CO_TYPE_BATCH_COMMAND ?  $callableObject['command'] : "";
			
			//$callableObject['command'] is overwritten here: - not so nice
			if (!self::loadCOFileContent($callableObject, $isAdminGrid, $ret)) {
				return $ret;
			}
				
			$commandString 	= $callableObject['command'];
			
			// if $catalogInstanceId is NULL there is no grid on screen!
			// grid substitutions cannot be resolved!
			if (!is_null($catalogInstanceId)) {
				
				$primaryKeys 		= $browsingStore->get_selectedPrimaryKeys($catalogInstanceId);
				$columnInfo 		= $browsingStore->get_selectedColumnInfo($catalogInstanceId);
				$needQuotes 		= self::getQuotesInfoForPK($columnInfo, $primaryKeys);
				
				//this is only for $col.{...} sstitution
				$colDefArray 		= self::getColNameFromCommand($commandString, 0);
				
				$catalogConn		= $callableConn;
				$catalogConnName 	= $browsingStore->get_connName($catalogInstanceId);
				
				if ($catalogConnName != $callableConnName) {
					$catalogConn = ET_ConnHelper::getConnection($catalogConnName);
				}
				$catalogConn->SetFetchMode(ADODB_FETCH_ASSOC);
				
				while ($colDefArray) {
					$fieldName 	= $colDefArray[0];
					$nextPos 	= $colDefArray[1];
					
					array_push($colNames , $fieldName);
					
					if ($nextPos > 0) {
						$colDefArray = self::getColNameFromCommand($commandString, $nextPos);
					} else {
						$colDefArray = false;
					}
				}
								
				if (!empty($selectedPKVals))
					$actual_vals 	= explode(PK_DELIMITER, $selectedPKVals);
					
				$rowValues 	 	= array();				
				
				if (count($colNames) > 0) {
					$actualSubstitutions 	= null;
					$rowIdString			= "";
					$whereCond 				= " where";
					$fullTableName 			= $catalogInstanceId != "" ? $browsingStore->get_fullTableName($catalogInstanceId) : "";
										
					$whereCondTmp 		= self::setUpWhereConditionAndRowIdString($catalogInstanceId, $actual_vals);
					$whereCond 			.= $whereCondTmp[0];
					$rowIdString 		.= $whereCondTmp[1];
					
					if (ET_StringCheck::endsWith($rowIdString, ',')) {
						$rowIdString = rtrim($rowIdString, ',');
					}
					$actualQuery = "select " . implode(", ", $colNames) . " from " . $fullTableName . $whereCond;
						
					//GET VALUES FROM ROW:
					$actualResult = $catalogConn->Execute($actualQuery);
						
					if ($actualResult) {
						while ($r = $actualResult->fetchRow()) {
							
							foreach ($r as $key => $value) {
								
								if ($callableDbConnection) {
									$rowValues[$key] = ET_StringCheck::convertToDbCharset($value, $callableConnName);
								}
								else {
									$rowValues[$key] = $value;
								}
							}
						}
						
						if (isset($ret[CO_SUBSTITUTION_VARS][$rowIdString])) {
							$actualSubstitutions = $ret[CO_SUBSTITUTION_VARS][$rowIdString];
						} else {
							$actualSubstitutions = new ET_CallableSubstitutions($rowIdString);
						}
								
						$actualItem = new ET_SubstitutionItem($coDisplayName, $rowValues);
						$actualSubstitutions->addGridSubstitutionRow($actualItem);
								
						$ret[CO_SUBSTITUTION_VARS][$rowIdString] = $actualSubstitutions;
						
						if (!empty($ret[CO_ROWID_STRINGS])) {
							$lastRowIdStr = $ret[CO_ROWID_STRINGS][count($ret[CO_ROWID_STRINGS]) - 1];
							
							if ($lastRowIdStr !== $rowIdString) {
								array_push($ret[CO_ROWID_STRINGS], $rowIdString);
							}
						}
						else {
							array_push($ret[CO_ROWID_STRINGS], $rowIdString);
						}						
					}
					else {
						throw new Exception("The sql statement could not be executed: $actualQuery");
					}
				}
				
				$commandString = self::resolveLineLevelVariables($rowValues, $commandString);
				
			} else {
				// not doing any row-level substitutions
			}
			
			if ($callableType == CO_TYPE_BATCH_COMMAND) {
				
				$labeledCommands = self::processSQLFileString($commandString);
				
				if ($labeledCommands === false) {			
					self::addMessage($ret, ET_DisplayHelper::localize("CO_SQL_FILE_NOT_FOUND_OR_EMPTY", array($coCommand), ET_DisplayHelper::detectPageType($isAdminGrid)), CO_MESSAGE_TYPE_ERROR_SYSTEM);
					return $ret;
				}
				
				for ($i = 0; $i < count($labeledCommands); $i++) {
				
					$labeledCommand = $labeledCommands[$i];
					$sqlLabel		= $labeledCommand['label'];
					$queryString 	= $labeledCommand['sql'];
					$result			= null;
					
					try {
						$result = self::runQuery($callableConn, $callableConnName, $queryString, $browsingStore, $selectedPKVals, true, $ret[CO_MESSAGE_GUID], $isAdminGrid, $coDisplayName, $ret, $actual_vals, $ucaData, $coFileName);					
					}
					catch (Exception $e) {
						self::addMessage($ret, $e->getMessage(), CO_MESSAGE_TYPE_WARNING_SYSTEM);						
						break;
					}
					$returnCode = self::fillErrorMessage($ret, $callableConn, $result, $coDisplayName, self::getLabelForErrorMessage($menuLabel, $sqlLabel), false, $isAdminGrid);
					if ($returnCode === 0) {
						break;
					}
					// SQL error
					else if ($returnCode === 1) {
						break;
					}
					
				}
			} else if ($callableType == CO_TYPE_WEB_SERVICE_CALL) {
				
				try {					
					$result 	= self::callWebService($callableConn, $callableConnName, $commandString, $browsingStore, $selectedPKVals,
							true, $ret[CO_MESSAGE_GUID], $isAdminGrid, $coDisplayName, $ret, $actual_vals, $ucaData, $coFileName);
					self::addMessage($ret, $result, CO_MESSAGE_TYPE_SUCCESS_SYSTEM);
				} catch (Exception $e) {
					self::addMessage($ret, $e->getMessage(), CO_MESSAGE_TYPE_WARNING_SYSTEM);
					$ret[CO_EXECUTION_ERROR] = true;
				}
				
			} else {				
				try {
					$result = self::runQuery($callableConn, $callableConnName, $commandString, $browsingStore, $selectedPKVals, true, $ret[CO_MESSAGE_GUID], $isAdminGrid, $coDisplayName, $ret, $actual_vals, $ucaData);
				}
				catch (Exception $e) {
					self::addMessage($ret, $e->getMessage(), CO_MESSAGE_TYPE_WARNING_SYSTEM);
				}
				self::fillErrorMessage($ret, $callableConn, $result, $coDisplayName, $menuLabel, false, $isAdminGrid);
				
			}
			
			if ($messagingActive) {				
				ET_MessageHelper::getMessage($callableConnName, $ret, $isAdminGrid);
			}
			
		}
		
		public static function setUpWhereConditionAndRowIdString($catalogInstanceId, $actual_pk_vals) {
			
			
			$browsingStore	= ET_BrowsingStore::getBrowsingStore();
			$primaryKeys 	= $browsingStore->get_selectedPrimaryKeys($catalogInstanceId);
			$columnInfo 	= $browsingStore->get_selectedColumnInfo($catalogInstanceId);
			$needQuotes 	= self::getQuotesInfoForPK($columnInfo, $primaryKeys);
			
			for ($k= 0; $k < count($primaryKeys); $k++) {
				$pkey 		= $primaryKeys[$k];
				$pval 		= $actual_pk_vals[$k];
				$rowIdString .= $pval + ",";
				$pval 		= ($needQuotes[$k] == "t") ? ("'" . $pval . "'") : $pval;
				
				$whereCond .= " $pkey = $pval";
				if ($k < count($primaryKeys) - 1)
					$whereCond .= " AND";
			}
			
			$ret = [$whereCond, $rowIdString];
			return $ret;
			
		}
		
		protected static function getLabelForErrorMessage($menuLabel, $sqlLabel) {
			if (empty($menuLabel))
				return $sqlLabel;
			return $menuLabel . "->" . $sqlLabel;
		}
		
		protected static function runQuery (&$callableConn, $coConnName, $queryString, $browsingStore, $lineLevelArray = null, $logging = true, $msgGuid = '', $isAdminGrid = false, 
				$coDisplayName = "", &$coRetArray = null, $actual_pk_vals = null, $ucaData = array(), $coFileName = "") {
			
			$coConnType 		= ET_ConnHelper::getConnectionTypeByName($coConnName);
			
			if (($coConnType == "oci805") && (ET_StringCheck::endsWith($queryString, ";"))) { 				
				$queryString = substr($queryString, 0, strlen($queryString) - 1);					
			}
			
			if (!empty($msgGuid)) {
				$ucaStrResolved = "";
				
				if (!empty($ucaData)) {
					$ucaStrResolved = self::handleUCAStr($ucaData, $msgGuid, $coDisplayName, $coRetArray, $coConnName, 'niota', $isAdminGrid);					
				} else {
					//nothing to do with $ucaData
				}
				$messageData = self::fillMessageData($msgGuid, $ucaStrResolved);			
				$queryString = self::resolveQueryString($queryString, $messageData, null, $coDisplayName, $coRetArray);				
			}
			
			$queryString = self::resolveGeneralVariables ($queryString, $browsingStore, $isAdminGrid, $coDisplayName, $coRetArray, $coConnName, $actual_pk_vals);
			$queryString = self::resolveLineLevelVariables ($lineLevelArray, $queryString);
			
			if (!is_null($coRetArray)) {
				self::addSqlDebugString ($coRetArray, $queryString, $coDisplayName);
			}			
			
			$queryString = ET_StringCheck::convertToDbCharset($queryString, $coConnName);
			//echo $queryString;
			$stmt 	= $callableConn->PrepareSP($queryString);			
			$ret 	= $callableConn->Execute($stmt);
			//echo $callableConn->errorMsg() . "<br><br>";	
			
			if ($logging && $ret !== false) {
				try {					
					$logConnName 	= self::getConnNameForLogging($coConnName);
					$logStr 		= ET_DisplayHelper::is_blank($coFileName) ? $queryString : $coFileName;
					ET_LoggingHelper::log($logConnName, $logStr , LOGGING_SOURCE_CALL);
				} catch (Throwable $e) {	
					
					throw new Exception(ET_DisplayHelper::localize("LOGGING_ERROR_OCCURED", null, ET_DisplayHelper::detectPageType($isAdminGrid)));
				}
			} else if ($ret === false) {
				
				$systemLogger = new \ET_LoggingHelperSystem();
				$fileInfo = ET_DisplayHelper::is_blank($coFileName) ? "" : PHP_EOL . "[file:]\t$coFileName";
				$systemLogger->addSystemLogEntry(LOG_TYPE_ERROR_SQL,  $callableConn->ErrorMsg() . $fileInfo . PHP_EOL . "[query:]\t" . $queryString);
			}
			
			return  $ret;
		}
		
		protected static function callWebService(&$callableConn, $coConnName, $soapXml, $browsingStore, $lineLevelArray = null,
				$logging = true, $msgGuid = '', $isAdminGrid = false, $coDisplayName = "", &$coRetGenerated = null, $actual_pk_vals = null, $ucaData = array(), $coFileName) {
					
				$return 		= null;
				$ucaStrResolved = "";
				
				$soapXml 		= self::resolveSOAPUserCredentials($soapXml, $coConnName);
				$soapXml 		= self::resolveGeneralVariables($soapXml, $browsingStore, $isAdminGrid, $coDisplayName, $coRetGenerated, $coConnName, $actual_pk_vals);
				//$soapXml 		= self::resolveLineLevelVariables ($lineLevelArray, $soapXml);
				
				if (!empty($ucaData)) {
					$messageConnName	= ET_MetaDataConnector::getInstance()->getMessageConnectionName($coConnName);
					$ucaStrResolved 	= self::handleUCAStr($ucaData, $msgGuid, $coDisplayName, $coRetGenerated, $messageConnName, 'niota', $isAdminGrid);
					
					$messageData 		= self::fillMessageData($msgGuid, $ucaStrResolved);
					$soapXml			= self::resolveQueryString($soapXml, $messageData, null, $coDisplayName, $coRetGenerated);
				} else {
					//nothing to do with $ucaData
				}
				
				$soapResponse = $callableConn->doRequest($soapXml);
				
				//\ET_LoggingHelperSystem() is the system logger for eg. error messages
				$systemLogger = new \ET_LoggingHelperSystem();
				
				if (empty($soapResponse)) {
					$systemLogger->addSystemLogEntry(LOG_TYPE_ERROR_WS,  "Web service call failed!" . "\n[WS call]\t");
					throw new Exception(ET_DisplayHelper::localize('SOAP_RESP_EMPTY'), null, ET_DisplayHelper::detectPageType($isAdminGrid));
				}
				
				$errorMessage = ET_WebServiceConnection::getSoapResponseFromXML($soapResponse, CO_SOAP_RESP_FAILURE);				
				
				if (!is_null($errorMessage)) {
					$systemLogger->addSystemLogEntry(LOG_TYPE_ERROR_WS,  $errorMessage . PHP_EOL . "FIle: $coFileName" .  PHP_EOL . "WS call: " . PHP_EOL . $soapXml);
					throw new Exception($errorMessage);
				} else {					
					$return = ET_WebServiceConnection::getSoapResponseFromXML($soapResponse, CO_SOAP_RESP_SUCCESS, $coFileName);	
					
					try {
						$connNameForLogging = self::getConnNameForLogging($coConnName);
						//ET_LoggingHelper::log($coConnName, $coFileName, LOGGING_SOURCE_CALL);
						ET_LoggingHelper::log($connNameForLogging, $coFileName, LOGGING_SOURCE_CALL);
					} catch (Throwable $e) {
						throw new Exception(ET_DisplayHelper::localize("LOGGING_ERROR_OCCURED", null, ET_DisplayHelper::detectPageType($isAdminGrid)));
					}
				}
				
				return $return;
		}
		
		/***
		 * 
		 * @param array $lineLevelArray
		 * @param string $inputString - stored procedure or sql statement or xml content
		 */
		protected static function resolveLineLevelVariables($lineLevelArray, $inputString) {
			
			if (!is_null($lineLevelArray)) {
				foreach ($lineLevelArray as $key => $value) {
					$inputString = self::resolveGridSelection($lineLevelArray, $inputString);
				}
			}
			
			return $inputString;
			
		}
		
		/***
		 * resolving user and system variables in SQL and XML strings
		 */
		protected static function resolveGeneralVariables ($inputStr, $browsingStore, $isAdminGrid, $coDisplayName, &$ret, $coConnName, $actual_pk_vals = null) {
			
			$catalogInstanceId	= ($isAdminGrid && isset($_SESSION[SESS_CATALOG_INSTANCE_ID_MASTER_ADMIN])) ? $_SESSION[SESS_CATALOG_INSTANCE_ID_MASTER_ADMIN] :
				(isset($_SESSION[SESS_CATALOG_INSTANCE_ID_MASTER]) ? $_SESSION[SESS_CATALOG_INSTANCE_ID_MASTER] : '');
			
			$niotaUser 		= ET_NiotaUser::getNiotaUserFromSession();
				
			$systemData		= ET_CallableObjectHelper::fillSystemData($browsingStore, $niotaUser, $catalogInstanceId, $coConnName, $actual_pk_vals);
			$systemData		= self::resolveAdminCatalogIdAndInstName($catalogInstanceId, $systemData);
			$userData 		= ET_CallableObjectHelper::fillUserData($niotaUser);
			
			$inputStr = ET_CallableObjectHelper::resolveQueryString($inputStr, $userData, null, $coDisplayName, $ret);
			$inputStr = ET_CallableObjectHelper::resolveQueryString($inputStr, $systemData, null, $coDisplayName, $ret);
			
			return $inputStr;
		}
		
		protected static function handleUCAStr($ucaData, $msgGuid, $coDisplayName, &$coRetArray, $coConnName, $phpFileName = 'niota', $isAdminGrid) {
									
			$ucaConnector 		= new ET_UCAConnector($coConnName, $msgGuid, $isAdminGrid, $ucaData);
			$ucaStrResolved 	= $ucaConnector->resolveUCAStr($coDisplayName);
			
			if ($ucaData['save_uca']) {				
				if (!$ucaConnector->updateUCATable()) {
					throw new ET_NiotaException("UCA saving error!");
				}
			}
			
			return $ucaStrResolved;
		}
		
		public static function resolveQueryString($queryString, $arr, $coResult = null, $coDisplayName = "", &$ret = null) {
			
			
			foreach ($arr as $key => $value) {
			
				if (strpos($queryString, '$' . $key) !== false) {
					
					$queryString = str_replace('$' . $key, $value, $queryString);
					
					if (!is_null($ret)) {												
						$ret[CO_SUBSTITUTION_VARS_SYS][$key] = $value;						
					}
				}
			}
			
			return $queryString;
		}
		
		public static function resolveGridSelection ($substitutionArray, $targetStr) {
			//return ET_PropertiesAdmin::getInstance()->resolveColumnValues($targetStr, $substitutionArray);
			
			foreach ($substitutionArray as $key => $value) {	
				
				$targetStr = str_replace('$col.{' . $key . '}' , $value, $targetStr);				
			}
			
			return $targetStr;
		}
		
		public static function fillSystemData($browsingStore, $user, $catalogInstanceId = "", $connNameCallableObject = "", $actual_pk_vals = null) {
			
			$ret 			= self::initilaizeSystemData();
			$catalogId 		= "0";
			$instanceName 	= "?";			
			$connName		= "?";
			$fullTableName	= "?";
			$tableName		= "?";
			$userName		= is_null($user) ? "?" : $user->get_username();
			
			if ($catalogInstanceId != "") {
				$connName 		= $browsingStore->get_connName($catalogInstanceId);
				$fullTableName 	= $browsingStore->get_fullTableName($catalogInstanceId);
				$tableName 		= ($fullTableName != "" || $fullTableName != "?" ) ? ET_CatalogInstance::getTableNameFromFullyQualifiedForm($fullTableName) : "?";
				
			}
			
			$installation 	= defined('INSTALLATION_NAME') ? INSTALLATION_NAME : 'niota';			
			
			if (strpos($catalogInstanceId, ".")) {
				$catalogId 		= explode(".", $catalogInstanceId)[0];
				$instanceName	= explode(".", $catalogInstanceId)[1];				
			} else {
				$catalogInstanceId = "?";
			}
			
			$ret["domain"] 				= $connName;
			$ret["fullTableName"] 		= $fullTableName;
			$ret["tableName"] 			= $tableName;
			
			if ($connName !== "?") {
				$ret["dbName"]				= ET_ConnHelper::getDbNameByConnectionName($connName);
				$ret["connectionType"] 		= ET_ConnHelper::getConnectionTypeByName($connName);
				$ret["fullDbName"]			= ET_ConnHelper::getfullDbName($connName);
			}			
			
			$ret["userName"] 			= $userName;
			$ret["installation"] 		= $installation;
			
			$ret["catalogId"]			= $catalogId;
			$ret["instanceName"]		= $instanceName;			
			$ret["catalogInstanceId"]	= $catalogInstanceId;
			
			$ret["client"]				= isset($_SESSION[SESS_CLIENT]) ? $_SESSION[SESS_CLIENT] : CLIENT_SYSTEM;
			
			if (!empty($actual_pk_vals)) {
				$ret["rowWhere"] = self::setUpWhereConditionAndRowIdString($catalogInstanceId, $actual_pk_vals)[0];
			}
			
			if (ET_UploadFileDataSessionManager::isThereUploadedFile()) {
				$ret["uploadFolder"] 	= ET_UploadFileDataSessionManager::getUploadFolderPath();
				$ret["uploadFile"]		= ET_UploadFileDataSessionManager::getUploadedFileName();
				$ret["uploadPath"]		= ET_UploadFileDataSessionManager::getUploadedFileFullPath();
			}
						
			$callableDbConnection	= !empty($connNameCallableObject) ? ET_ConnHelper::isDbConnection($connNameCallableObject) : false;
			
			if	($callableDbConnection)	{ 
				$ret["callableFullDbName"] = ET_ConnHelper::getfullDbName($connNameCallableObject); 
			}
			else { 
				$ret["callableFullDbName"] = ET_DisplayHelper::localize("NOT_DB_CONNECTION", null, PAGE_TYPE_SYSTEM); 
			}
			
			$ret['sessionId'] 	= session_id();
			$ret['lang']		= self::fillUserAreLangSubstitutionVariable($user);
			$ret['langSystem']	= defined('SYSTEM_LANGUAGE') ? SYSTEM_LANGUAGE : 'en';
			$ret['langGrid']	= defined('GRID_AREA_LANGUAGE') ? GRID_AREA_LANGUAGE: 'en';
			
			//sort array by keys in descsnding order
			//needs for $lang <-> $langGrid/$LangSystem resolve conflicts
			krsort($ret, SORT_STRING);
			
			return $ret;
		}
		
		public static function fillUserData($user) {
			
			$ret = self::initializeUserData();
			
			if (!is_null($user)) {
				$ret["userName"] 	= $user->get_username();
				$ret["email"] 		= ET_DisplayHelper::is_blank($user->get_email()) ? "?" : $user->get_email();
				$ret["firstName"] 	= ET_DisplayHelper::is_blank($user->get_firstname()) ? "?" : $user->get_firstname();
				$ret["lastName"] 	= ET_DisplayHelper::is_blank($user->get_lastname()) ? "?" : $user->get_lastname();
				$ret["phone"]		= ET_DisplayHelper::is_blank($user->get_phone()) ? "?" : $user->get_phone();
			}
			
			return $ret;
		}
		
		public static function fillMessageData ($msgGuid, $ucaStrResolved) {
			
			$ret 			= array();
			$ret["msgGuid"] = ET_DisplayHelper::is_blank($msgGuid) ? "?" : $msgGuid;
			$ret['uca'] 	= ET_DisplayHelper::is_blank($ucaStrResolved) ? "?" : $ucaStrResolved;
			
			return $ret;			
		} 
		
		public static function getQuotesInfoForPK($metaColumnInfo, $primaryKeys) {
			$ret = array();
			for ($i = 0; $i < count($primaryKeys); $i++) {
				$pkey = $primaryKeys[$i];

				$c = self::isQuotesNeededForColumnName($pkey, $metaColumnInfo);
				
				array_push($ret, $c ? "t" : "f");
			}
			return $ret;
		}
		
		public static function isQuotesNeededForColumnName($colName, $metaColumnInfo) {
			$ret = array();
		
			$metaColumnMetaTypeLowerCase = array();
			$keys = array_keys($metaColumnInfo);
		
			foreach ($keys as $key) {
				$metaColumnMetaTypeLowerCase[strtolower($key)] = $metaColumnInfo[$key]['metaType'];
			}
			$colMetaType = $metaColumnMetaTypeLowerCase[strtolower($colName)];
			
			$c = ($colMetaType == 'C' || $colMetaType == 'D' || $colMetaType == 'T' || $colMetaType == 'X');
			return $c;
		}
		
		/***
		 *
		 * @param unknown $callableConn
		 * @param unknown $coConnName
		 * @param unknown $coFileName
		 * @param array $registrationVaraibles
		 * @throws Exception
		 * @return boolean
		 */
		public static function callWebServiceSimple($callableConn, $coConnName, $coFileName, $registrationVaraibles = array()) {
			
			$ret 			= self::createDefaultCOResult('');
			$br 			= null;
			$isAdminGrid 	= false;
			$coDisplayName	= "";
			$success		= false;
			$soapXml 		= self::loadFileContent($coFileName, false, CO_TYPE_WEB_SERVICE_CALL, $ret);
			
			if ($soapXml === false) {
				return $success;
			}
			$soapXml 	= self::resolveSOAPUserCredentials($soapXml, $coConnName);
			
			//directly resolve $userName, $email and $verifylink substitutions!
			$soapXml	= self::resolveQueryString($soapXml, $registrationVaraibles);
			$soapXml 	= self::resolveGeneralVariables($soapXml, $br, $isAdminGrid, "", $ret, $coConnName);
			
			$soapResponse = $callableConn->doRequest($soapXml);
			
			//\ET_LoggingHelperSystem() is the system logger for eg. error messages
			$systemLogger = new \ET_LoggingHelperSystem();
			
			if (empty($soapResponse)) {
				$systemLogger->addSystemLogEntry(LOG_TYPE_ERROR_WS,  "Web service call failed!" . "\n[WS call]\t");
				throw new Exception(ET_DisplayHelper::localize('SOAP_RESP_EMPTY', null, ET_DisplayHelper::detectPageType($isAdminGrid)));
			}
			
			$errorMessage = ET_WebServiceConnection::getSoapResponseFromXML($soapResponse, CO_SOAP_RESP_FAILURE);
			
			if (!is_null($errorMessage)) {
				$systemLogger->addSystemLogEntry(LOG_TYPE_ERROR_WS,  $errorMessage . PHP_EOL . "FIle: $coFileName" .  PHP_EOL . "WS call: " . PHP_EOL . $soapXml);
			} else {
				$success = true;
				$zagreusJobId = ET_WebServiceConnection::getSoapResponseFromXML($soapResponse, CO_SOAP_RESP_SUCCESS);
				try {
					$systemLogger->addSystemLogEntry(LOG_TYPE_DEBUG, "WS call succeeded. Response is: $zagreusJobId");
				} catch (Throwable $e) {
					throw new Exception(ET_DisplayHelper::localize("LOGGING_ERROR_OCCURED", null, ET_DisplayHelper::detectPageType($isAdminGrid)));
				}
			}
			return $success;
		}
		
		
		protected static function fillUserAreLangSubstitutionVariable ($user) {
			
			$ret = "?";
			if (!is_null($user)) {
				$ret = ET_DisplayHelper::is_blank($user->getGridLanguage()) ?
				(defined('SYSTEM_LANGUAGE') ? SYSTEM_LANGUAGE : 'en') : $user->getGridLanguage();
			}
			return $ret;
		}
		
		protected static function customErrorHandlerToHideWarning(){
			set_error_handler(
					function ($severity, $message, $filename, $lineno) {
						if (error_reporting() == 0) {
							return;
						}
						if (error_reporting() & $severity) {
							//global $errorMessage;
							//$errorMessage = $message;
							return;
						}
					});
		}
		
		protected static function createDefaultCOResult($coDisplayName) {
			
			$ret = array();
			
			$ret[CO_EXECUTION_ERROR] 			= false;
			$ret[CO_MESSAGE_RECEIVED]			= false;
			$ret[CO_LINE_LEVEL_PROCESSED_ROWS] 	= 0;
			$ret[CO_MESSAGE_CONN_NAME] 			= "";
			$ret[CO_MESSAGE_GUID] 				= "";
			$ret[CO_MESSAGE_STOPPED] 			= 0;
			$ret[CO_MESSAGES]	 				= array();
			$ret[CO_RELOAD_GRID] 				= 0;
			$ret[CO_SUBSTITUTION_VARS]			= array();
			$ret[CO_ROWID_STRINGS]				= array();
			$ret[CO_SUBSTITUTION_VARS_SYS]		= array();
			$ret[CO_DEBUG_SQL]					= "";
			
			return $ret;
		}

		protected static function resolveSOAPUserCredentials ($xmlString, $connName) {
			
			$connArray	= ET_ConnHelper::getConnectionArrayFromConnectionName($connName);
			$username	= $connArray[PHPGRID_WS_USERNAME];
			$pw			= ET_ConnHelper::resolveDbPw($connArray);
			
			$xmlString 	= str_replace(CO_SOAP_USERNAME, $username, $xmlString);
			$xmlString 	= str_replace(CO_SOAP_PASSWORD_BASE64, base64_encode($pw), $xmlString);
			$xmlString 	= str_replace(CO_SOAP_PASSWORD, $pw, $xmlString);
			
			return $xmlString;
			
		}

		public static function addMessage(&$coResult, $msgText, $msgType) {
			$messages 	= $coResult[CO_MESSAGES];
			$tmp 		= array();
			
			$tmp[CO_MESSAGE_TEXT] = $msgText;
			$tmp[CO_MESSAGE_TYPE] = $msgType;
			
			$messages[] = $tmp;
			
			$coResult[CO_MESSAGES] = $messages;
		}
		
		public static function getGUID(){
			if (function_exists('com_create_guid')) {
				return com_create_guid();
			} else {
				mt_srand((double)microtime()*10000);//optional for php 4.2.0 and up.
				$charid = strtoupper(md5(uniqid(rand(), true)));
				//$hyphen = chr(45);// "-"
				$uuid = 
				 substr($charid, 0, 8)
				.substr($charid, 8, 4)
				.substr($charid,12, 4)
				.substr($charid,16, 4)
				.substr($charid,20,12);
				
				return $uuid;
			}
		}
		
		public static function handleFileUpload() {
			
			if (isset($_POST['upload_and_process'])) {
				$fileMoveSuccess = false;
				
				$fileName		= basename($_FILES["file_to_upload"]["name"]);
				$targetDir 		= defined('CUSTOM_UPLOAD_FOLDER') ? CUSTOM_UPLOAD_FOLDER : "";
				$networkPath	= defined('CUSTOM_UPLOAD_FOLDER_NETWORK') ? CUSTOM_UPLOAD_FOLDER_NETWORK : false;
				$targetDirPath 	= "";
				$clientName		= $_SESSION[SESS_CLIENT];
				
				if ($networkPath) {
					$targetDirPath = $targetDir;
				}
				else {
					//$targetDirPath  = ET_PathHelper::getAbsolutePath($targetDir);
					if ($clientName == CLIENT_SYSTEM) {
						$targetDirPath = ET_PathHelper::getAbsolutePath("/conf/" . $targetDir);
					} else {
						$targetDirPath = ET_PathHelper::getClientConfSubFolderAbsolutePath($targetDir);
					}
				}
			
				$targetDirPath = ET_DisplayHelper::resolvePathSubstitutiontVariables($targetDirPath);	
					
				$targetFile 	=  $targetDirPath . $fileName;
				$extensionOK 	= self::validateUploadedFileExtension($fileName);
				
				if ($extensionOK) {
					$fileMoveSuccess = move_uploaded_file($_FILES["file_to_upload"]["tmp_name"], $targetFile);
				} else {
					return false;
				}
				
				if ($fileMoveSuccess) {
					ET_UploadFileDataSessionManager::storeUploadedFileName($fileName);
					ET_UploadFileDataSessionManager::storeUploadedFileFullPath($targetFile);
					ET_UploadFileDataSessionManager::storeUploadFolderPath($targetDirPath);
				}
				return $fileMoveSuccess;
			}
		}
		
		protected static function validateUploadedFileExtension($fileName) {
			
			$extension 			= pathinfo($fileName, PATHINFO_EXTENSION);			
			$validExtensions 	= CUSTOM_UPLOAD_VALID_EXTENSIONS;
			
			if (in_array($extension, $validExtensions)) {
				return true;
			}
			else {
				return false;
			}
		}
		
		/***
		 * 
		 * @param array() $callableObject
		 */
		protected static function getCallableDisplayName ($callableObject) {
			
			return !empty($callableObject['description']) ? $callableObject['description'] : $callableObject['name'];
			
		}
		
		/***
		 * fill system parameters with default values
		 */
		protected static function initilaizeSystemData () :array{
			
			$ret 						= array();
			$ret["domain"] 				= "?";
			$ret["fullTableName"] 		= "?";
			$ret["tableName"] 			= "?";
			$ret["dbName"]				= "?";
			$ret["connectionType"] 		= "?";
			$ret["userName"] 			= "?";
			$ret["installation"] 		= "?";
			$ret["catalogId"]			= "0";
			$ret["instanceName"]		= "?";
			$ret["catalogInstanceId"]	= "?";
			$ret["fullDbName"]			= "?";
			$ret["callableFullDbName"] 	= "?";
			$ret["rowWhere"] 			= "?";
			$ret["uploadPath"]			= "?";
			$ret["uploadFolder"]		= "?";
			$ret["uploadFile"]			= "?";
			$ret["client"]				= "?";			
			$ret["rowWhere"] 			= "?";			
			$ret["uploadFolder"] 		= "?";
			$ret["uploadFile"]			= "?";
			$ret["uploadPath"]			= "?";		
			$ret['sessionId'] 			= "?";
			$ret['lang']				= "?";
			$ret['langSystem']			= "?";
			$ret['sessionId'] 			= "?";
			
			return $ret;
		}
		
		/***
		 * 
		 * initilaize user substitution data
		 * @return array
		 */
		 
		protected static function initializeUserData () :array {
			$ret = array();
			
			$ret["userName"] 	= "?";
			$ret["email"] 		= "?";
			$ret["firstName"] 	= "?";
			$ret["lastName"] 	= "?";
			$ret["phone"]		= "?";
			
			return $ret;
		}
		
		/***
		 * 
		 * Finds the appropriate connection whose log connection has to be used for db logging.
		 * E.g.: if call from grid-menu callable objects has to use the log connection defined for grid.
		 * If the call is from transaction-menu logging has to use the log connection of the callable object.
		 * 
		 * @param string $connNameCallable - callable object connection name
		 * @return string
		 */
		protected static function getConnNameForLogging ($connNameCallable) :string{
			
			//$connNameLog will be the connection whose log-connection will be used
			//it is not the connection used for logging!
			$connNameLog 	= "";			
			$callFrom 		= isset($_POST["co_source"]) ? $_POST["co_source"] : "menu";
						
			if ($callFrom == CO_CALL_FROM_GRID) {
				$br 		 		= ET_BrowsingStore::getBrowsingStore();
				$optionKeyAdminPage	= isset($_POST['option_key']) ? $_POST['option_key'] : null;
				$isAdminGrid  		= ET_DisplayHelper::is_blank($optionKeyAdminPage) ? false : true;				
				$ciid 		 		= self::getCatalogInstanceId($isAdminGrid);
				$connNameLog 		= $br->get_connName($ciid);
			} else {
				$connNameLog 	= $connNameCallable;
			}
			
			return $connNameLog;
			
		}
		
		public static function resolveAdminCatalogIdAndInstName($catalogInstId, $systemData) {
					
			$tmpIds 	= explode('.', $catalogInstId);
			
			if (strpos($catalogInstId, ".") && preg_match("/^[a-zA-Z]/", $catalogInstId)) {
				
				//in the case of admin gridds this is equivalent to table name:
				$instName		= explode('.', $catalogInstId)[1];					
				$formatter 		= new ET_GridFormatter();
				
				$catalogId		= $formatter->getSystemCatalogID($instName);
				$instName 		= $_SESSION[SESS_INSTANCE_NAME_MASTER_ADMIN];  
				$catalogInstId	= $catalogId . "." . $instName;
				
				$systemData['catalogId'] 			= $catalogId;
				$systemData['instanceName']			= $instName;
				$systemData['catalogInstanceId'] 	= $catalogInstId;
			} 
			return $systemData;
			
		}
			
	}
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	