<?php
class ET_CascadingLookupInstance extends ET_LookupInstance {
	
	private $filterLookupName 	= "";
	private $filterColumnName	= "";
	private $columnName			= "";
		
	public function __construct($lookupSettings) {
		
		$catalogId 			= $lookupSettings['catalogId'];
		$instanceName 		= $lookupSettings['instanceName'];
		$useExtendedLookup	= $lookupSettings['useExtendedDef'];
		$addNulItem 		= $lookupSettings['addNullItem'];
		
		parent::__construct($catalogId, $instanceName, $addNulItem, LOOKUP_TYPE_CASCADING, $useExtendedLookup);
		
		$this->columnName		= $lookupSettings['columnName'];
		$this->filterColumnName = $lookupSettings['extendedColumn'];
		$this->filterLookupName = $lookupSettings['extendedLookup'];
		
		
	} 	
	
	public function generateFilterLookupDataName () : string {		
		return $this->filterColumnName . $this->columnName . "data";
	}
	
	public function generateFilterLookupData() :array {
	
		$ret 					= array();
		$filterLookupIdArr 		= ET_MetaDataConnector::getInstance()->getLookupCatalogInstanceIdByName($this->filterLookupName);		
		$filterLookupNullable	= $this->getFilterLookupNullable();
		
		$filterLookupInstance	= new ET_LookupInstance($filterLookupIdArr['catalogId'], $filterLookupIdArr['instanceName'], $filterLookupNullable); 
		$filterSql				= $filterLookupInstance->get_LookupSql();
		
		$conn					= ET_ConnHelper::getConnection($filterLookupInstance->connName);
		
		$conn->SetFetchMode(ADODB_FETCH_NUM);
		$filterLookupDataRaw	= $conn->Execute($filterSql);
		
		if ($filterLookupDataRaw !== false) {
			$ret = $this->setUpFilterLokoupData($filterLookupDataRaw, $filterLookupNullable);
		} else {
			$this->error = true;
		}
		
		return $ret;
	}
	
	protected function setUpFilterLokoupData($rawData, $filterLookupNullable) : array {
		
		$ret 			= array();
		$fieldCount 	= $rawData->fieldCount();
		$mainIdActual	= '';
		$counter 		= 0;
				
		if ($fieldCount < 2) {
			
			$this->error = true;
			return $ret;			
		} else {
			
			while ($row = $rawData->fetchRow()) {				
				
				//$metaType = "";
				$tmp = array();
				
				if ($mainIdActual !== $row[0]) {
					$mainIdActual = $row[0];
				}
				
				$tmp['id'] 		= $row[1];
				$tmp['text'] 	= $row[1];
				
				if ($fieldCount == 2){					
					$tmp['text'] .= ', -';
				} else if ( $fieldCount === 3) {					
					$tmp['text'] .=  ", " . $row[2];
				} else if ($fieldCount > 3) {					
					$tmp['text'] = $this->concatenateTextTags($row, $fieldCount);
				} 
				
				$ret[$mainIdActual] []= $tmp;
			}
			
			if ($this->addNullItem && $filterLookupNullable) {
				
				$tmp 			= array();
				$tmp['id'] 		= '~';
				$tmp['text'] 	= '~, ' . ET_DisplayHelper::localize("LOOKUP_NULL_VALUE_DESCR", PAGE_TYPE_GRID);
				$ret['~']		[]= $tmp;
				
			} else if (!$this->addNullItem && $filterLookupNullable) {
				//cat.inst.id
				$cIId	= $_SESSION[SESS_CATALOG_INSTANCE_ID_MASTER];
				// col.info source table
				$cis = ET_BrowsingStore::getBrowsingStore()->get_selectedColumnInfo($cIId);
				//tagrget column not null
				$tcnn = $cis[$this->columnName]['notNull'];
								
				$displayText = $tcnn ? ET_DisplayHelper::localize("WARN_LOOKUP_ELEMENT_NULL_NOT_FOUND", PAGE_TYPE_GRID) 
										: ET_DisplayHelper::localize("LOOKUP_ELEMENT_NULL_NOT_FOUND", PAGE_TYPE_GRID); 
				
				$tmp 			= array();
				$tmp['id'] 		= '~';
				$tmp['text'] 	= '~, ' . $displayText;
				$ret['~']		[]= $tmp;
				
				//ET_DisplayHelper::addErrorLine("Cascading lookup null inconsitency! Verify column properties!", "niota");
			} else {
				foreach ($ret as $key => $val) {
					
					if ($this->addNullItem && !$filterLookupNullable) {
						$tmp 			= array();
						$tmp['id'] 		= '~';
						$tmp['text'] 	=  '~, '  .ET_DisplayHelper::localize("LOOKUP_NULL_VALUE_DESCR", PAGE_TYPE_GRID);;						
						array_push($ret[$key], $tmp);
					} 
				}
			}
			
		}
		
		return $ret;
		
	}
	
	protected function concatenateTextTags($row, $fieldCount) : string{
		
		$ret = $row[1] . ", ";
		
		for ($i = 2; $i < $fieldCount; $i++) {
			$ret .= $row[$i];
			
			if ($i < $fieldCount - 1) {
				$ret .= '-';
			}
		}
		
		return $ret;
	}
	
	protected function getFilterLookupNullable () {
	
		$catalgInstanceIdGrid	= $_SESSION[SESS_CATALOG_INSTANCE_ID_MASTER];
		$catalgId				= explode(".", $catalgInstanceIdGrid)[0];
		
		return ET_MetaDataConnector::getInstance()->getLookupNullable($catalgId, $this->filterColumnName);
		
	}
	
	public function getColumnName() : string {
		return $this->columnName;
	}
	
	public function getFilterLookupName () : string {
		return $this->filterLookupName;		
	}
	
	public function getFilterColumnName () : string {
		return $this->filterColumnName;
	}
	
}