<?php
	
	class ET_CatalogInstance {
		
		protected $dataGrid			= null;
		protected $niotaUser;
		protected $superUser;
				
		protected $catalogInstanceId;
		protected $subgridNumber;
		protected $subgridLogicalLink	= null;
		protected $catalogId;
		protected $instanceName;
		protected $predefinedPrimaryKeys = array();
		
		protected $connName		 		= "";
		protected $object			 	= "";
		protected $tableDescription 	= "";
		protected $instanceDescription 	= "";
		protected $projectionList		= "";
		protected $isActiveProjList		= null;
		protected $readOnlyList			= "";
		protected $isActiveReadOnlyList = null;
		protected $objectFilter			= "";
		protected $isActiveObjectfilter	= null;
		protected $objectjoin			= null;
		protected $isActiveObjectjoin 	= null;
		protected $objectjoinAlias		= null;
		protected $objectCategory		= "";
		protected $formatFilePrefix		= "";
		protected $columnInfo;
		protected $error				= null;
		
		protected $objectunion			= "";
		protected $isAcitveObjectunion	= null;
		protected $objectgroupby		= "";
		protected $isActiveObjectgroupby = null;
		protected $objectorder			= "";
		protected $isActiveObjectorder	= null;
		
		
		protected $userRights			= array();
		protected $lookups				= array();
		protected $constraints			= array();
		
		protected $filterMappings 		= array();
		protected $filteredInstanceId 	= "";
		protected $filteringInstanceId	= "";
		protected $useAdvancedFiltering = false;
		protected $selectionTable		= FALSE;
		
		protected $detailGridInfos		= array();
		protected $detailDataGrids 		= array();
		
		protected $allowExcelImport 	= 1; 
		protected $allowExcelExport 	= 1;
		
		protected $metaDataConnector 	= null;		
		protected $userSettings 		= array();
		
		
		public function __construct($catalogId, $instanceName, $subgridNumber = '', $filterDialog = false, $useAdvancedFiltering = false, $predefinedLookups = null, $subgridLogicalLink = '') {
			$this->catalogId 			= $catalogId;
			$this->instanceName 		= $instanceName;
			$this->subgridNumber 		= $subgridNumber;
			$this->subgridLogicalLink 	= $subgridLogicalLink;
			
			$this->metaDataConnector = ET_MetaDataConnector::getInstance();
			$this->catalogInstanceId = $this->metaDataConnector::getInstance()->generateCatalogInstanceId($this->catalogId, $this->instanceName); 
			
			$this->useAdvancedFiltering = $useAdvancedFiltering;
			
			$this->initializeProperties($catalogId, $instanceName);
			
			$this->fillUserRights($filterDialog);
			
			if (is_null($predefinedLookups)) {
				$this->fillLookups();
			} else {
				$this->lookups = $predefinedLookups;
			}
			
			$this->fillConstraints();			
			$this->fillFilterMappings();			
			$this->fillPredefinedPrimaryKeys($catalogId);
			
			if (empty($subgridNumber)) {
				$this->fillDetailGridInfos();
				$this->createDetailCatalogInstances();				
			}
			
			$this->fillUserSettings();
			//$this->createDataGrid($filterDialog, $useAdvancedFiltering);
			try{
				$this->createDataGrid($filterDialog, $useAdvancedFiltering);
			} catch (Exception $e) {
				throw new Exception($e->getMessage());
			}
			
		}

		protected function initializeProperties($catalogId, $instanceName) {
			
			$arr = $this->metaDataConnector->getCatalogInstanceInfo($catalogId, $instanceName);
		
			$this->connName 				= $arr['conn_name'];
			$this->object 					= $arr['object'];
			$this->tableDescription 		= $arr['table_description'];
			$this->instanceDescription 		= $arr['instance_description'];
			$this->projectionList 			= $arr['proj_list'];
			$this->isActiveProjList 		= $arr['ind_active_proj_list'];
			$this->readOnlyList 			= $arr['read_only_list'];
			$this->isActiveReadOnlyList 	= $arr['ind_active_read_only_list'];
			$this->objectFilter 			= $arr['objectfilter'];
			$this->isActiveObjectfilter 	= $arr['ind_active_objectfilter'];
			$this->objectjoin 				= $arr['objectjoin'];
			$this->isActiveObjectjoin 		= $arr['ind_active_objectjoin'];
			$this->objectCategory			= $arr['objectcategory'];
			$this->formatFilePrefix			= $arr['format_file_prefix'];
			
			$this->objectunion				= $arr['objectunion'];
			$this->isAcitveObjectunion		= $arr['ind_active_objectunion'];
			$this->objectgroupby			= $arr['objectgroupby'];
			$this->isActiveObjectgroupby 	= $arr['ind_active_objectgroupby'];
			$this->objectorder				= $arr['objectorder'];
			$this->isActiveObjectorder		= $arr['ind_active_objectorder'];
			
			//coocoo's egg: $objectJoinAlias is generated and not passed in the array
			if ($this->isActiveObjectjoin) {
				$this->objectjoinAlias = ET_MetaDataConnector::getInstance()->resolveObjectJoinAlias($this->catalogId);
			}
			
		}
		
		protected function createDataGrid($filterDialog, $useAdvancedFiltering) {
			
			$projection = $this->isActiveProjList ? $this->projectionList : null;
			$objFilter 	= $this->isActiveObjectfilter ? $this->objectFilter : null;
			$objectjoin = $this->isActiveObjectjoin ? $this->objectjoin : null;
			
			$objectOrderBy = $this->isActiveObjectorder ?  $this->objectorder : null;
			$objectGroupBy = $this->isActiveObjectgroupby ? $this->objectgroupby : null;
			$objectUnion	= $this->isAcitveObjectunion ? $this->objectunion : null;
			
			$tmpArr = array();
			try {
				$tmpArr = $this->metaDataConnector->getCatalogMetaDataInfo($this->connName, 
																		$this->catalogInstanceId, 
																		$this->object, 
																		$this->predefinedPrimaryKeys, 
																		$projection, 
																		$objectjoin, 
																		$objFilter, 
																		!empty($this->subgridNumber), 
																		$this->subgridNumber, 
																		$useAdvancedFiltering,
																		$objectUnion,
																		$objectOrderBy,
																		$objectGroupBy,
																		$filterDialog);
			}
			catch (Exception $e) {
				throw new Exception($e->getMessage());
			}
			
			$this->setQueryObjectIntoSession($this->subgridLogicalLink, $useAdvancedFiltering, $tmpArr['column_info'], $tmpArr['default_order_by']);
			
			$tmpArr['lookups'] 					= $this->lookups;
			$tmpArr['constraints'] 				= $this->constraints;
			$tmpArr['user_rights'] 				= $this->userRights;
			$tmpArr['super_user'] 				= $this->superUser;
			$tmpArr['conn_name'] 				= $this->connName;
			$tmpArr['readonly_list']			= $this->isActiveReadOnlyList ? $this->readOnlyList : null;
			$tmpArr['filter_dialog'] 			= $filterDialog;
			$tmpArr['filter_mappings'] 			= $this->filterMappings;
			$tmpArr['selection_table']			= $this->selectionTable;
			$tmpArr['filtered_instance_id'] 	= $this->filteredInstanceId;
			$tmpArr['format_file_prefix'] 		= $this->formatFilePrefix;
			$tmpArr['subgrid_number']			= $this->subgridNumber;
			$tmpArr['subgrid_logical_link']		= $this->subgridLogicalLink;
			$tmpArr['detail_grid_infos']		= $this->detailGridInfos;
			$tmpArr['detail_datagrids'] 		= $this->detailDataGrids;
			$tmpArr['object_join']				= $objectjoin;
			$tmpArr['view']						= !empty($this->predefinedPrimaryKeys)/* || (!empty($this->objectjoin && ($this->isActiveObjectjoin == 1)))*/;
			$tmpArr['user_settings_for_catalog']
												= $this->userSettings;
			$tmpArr['admin_datagrid'] 			= 0;
			
			//overwrite grid sql with the generated one:
			$tmpArr['sql_for_datagrid']			= ET_BrowsingStore::getBrowsingStore()->get_gridSqlObject($this->catalogInstanceId)->generateSql();	
			
			$this->columnInfo 	= $tmpArr['column_info'];
			$this->dataGrid 	= new ET_DataGrid($this->catalogInstanceId, $tmpArr);
						
			//if (DEBUG_GRID) {
			
			if ($this->niotaUser->getDebugGridConfig()) {
				
				$br				 =  ET_BrowsingStore::getBrowsingStore();				
				$sysLogger = new ET_LoggingHelperSystem();
				$message = $sysLogger->setGridDebugEyeCacher($this->catalogInstanceId) . PHP_EOL;
				$message .= $tmpArr['debug_info'] . PHP_EOL;
				$message .= "generated grid sql: " . $br->get_gridSqlObject($this->catalogInstanceId)->generateSql() . PHP_EOL;
				
				$sysLogger->addSystemLogEntry(LOG_TYPE_DEBUG, $message);
			}
			//var_dump($this->constraints);
		}
		
		protected function fillLookups(){			
			$this->lookups = $this->metaDataConnector->getLookupInfo($this->catalogId);
		}
		
		protected function fillUserRights($filterDialog) {
			$this->niotaUser 	= ET_NiotaUser::getNiotaUserFromSession();
			$this->superUser 	= $this->niotaUser->is_superUser();			
			$catalogInstanceId 	= $this->catalogId . "." . $this->instanceName;
						
			$userRightsTmpAll	= $this->niotaUser->get_userRights();
			
			if (array_key_exists($catalogInstanceId, $userRightsTmpAll)) {
				$this->userRights = $userRightsTmpAll[$catalogInstanceId];
			} else if ($filterDialog) {
				
				$this->userRights['allow_import'] 			= 0;
				$this->userRights['allow_export'] 			= 0;
				$this->userRights['allow_insert'] 			= 0;
				$this->userRights['allow_update'] 			= 0;
				$this->userRights['allow_delete'] 			= 0;
				$this->userRights['allow_import_partial']	= 0;
			} else {
				ET_DisplayHelper::addErrorLine(ET_DisplayHelper::localize("GRID_NOT_VISIBLE", array($catalogInstanceId)), "niota");
			}
			//$this->userRights 	= $this->niotaUser->get_userRights()[$this->catalogId . "." . $this->instanceName];
						
			
			if(!$this->superUser) {
				$this->allowExcelImport = $this->userRights['allow_import'];
				$this->allowExcelExport = $this->userRights['allow_export'];
			}
		}
		
		protected function fillConstraints() {
			$this->constraints = $this->metaDataConnector->getConstraintInfo($this->catalogId);
			
		}
		
		/***
		 * If advanced filter is used then logical link from session is used
		 * @param unknown $filterMappings
		 * @param string $logicalLink
		 * @return array
		 */
		protected function filterFilterMappings($filterMappings, $logicalLink = '') {
			$ret = array();
			$logicalLinkMatch 	= !empty($logicalLink) ? false : true;			
			
			for ($i = 0; $i < count($filterMappings); $i++) {
			
				if (!empty($logicalLink)) {
					if ($filterMappings[$i]['logical_link'] == $logicalLink) {						
						array_push($ret, $filterMappings[$i]);	
						$logicalLinkMatch = true;
					}
				} else {					
					array_push($ret, $filterMappings[$i]);							
				}
			}			
			
			if (!$logicalLinkMatch) {
				ET_DisplayHelper::addErrorLine("Master-detail relation is set but logical link name is incorrect.", "niota");
			}
			
			return $ret;
		}
		
		protected function fillFilterMappings() {
			
			$filterMappings = $this->metaDataConnector->getFilterMappings($this->catalogId, $this->instanceName);
			
			if (!empty($filterMappings)) {
				
				$masterInstanceId 			= $filterMappings[0]['catalog_id_master'] . "." . $filterMappings[0]['instance_name_master'];
				$this->filteredInstanceId 	= $filterMappings[0]['catalog_id_detail'] . "." . $filterMappings[0]['instance_name_detail'];
								
				$sessionKeyForLogicalLink = SESS_ADVANCED_FILTER_LAST_SELECTION_PREFIX . $this->filteredInstanceId;
				
				if ($masterInstanceId == $this->getCatalogInstanceId()) {					
					$this->selectionTable 	= TRUE;
					$logicalLink 			= "";
					$filterFromMenu 		= isset($_POST['filter_from_menu']) ? true : false;
					
					if ($filterFromMenu) {						
						// do not need to filter on anything
						// meta sql is ordered by default-flag so the 1st one is the default link
						$logicalLink = $filterMappings[0]['logical_link'];						
					} else {
						for ($j = 0; $j < count($filterMappings); $j++) {
							$actMapping = $filterMappings[$j];
							if ($actMapping['logical_link'] === $_POST['logical_link']) {								
								$logicalLink = $actMapping['logical_link'];	
								$_SESSION[SESS_ADVANCED_FILTER_LOGICAL_LINK] 	= $logicalLink; 
							}
						}
					}										
					$filterMappings = $this->filterFilterMappings($filterMappings, $logicalLink);
					
				} else {					
					$filterMappings = $this->filterFilterMappings($filterMappings);
				}
				
				$this->filteringInstanceId 	= $filterMappings[0]['catalog_id_master'] . "." . $filterMappings[0]['instance_name_master'];
				$this->filterMappings 		= $filterMappings;
				
				$_SESSION[SESS_ADVANCED_FILTER_FILTERMAPPINGS] 			= $this->filterMappings;
				$_SESSION[SESS_ADVANCED_FILTER_FILTERED_INSTANCE_ID]	= $this->filteredInstanceId;				
			}			
		}
		
		protected function fillDetailGridInfos() {
			// $this->detailGridInfos = $this->metaDataConnector->getMasterDetailInfoForCatalogInstance($this->catalogId, $this->instanceName);
			
			$tmp = $this->metaDataConnector->getMasterDetailInfoForCatalogInstance($this->catalogId, $this->instanceName);
			//tmp szmozott tmb, ebben k-v pairs
			for ($i = 0; $i < count($tmp); $i++) {
				
				$detailGrid = $tmp[$i]; 
				$detailCatalogInstanceId= ET_MetaDataConnector::getInstance()->generateCatalogInstanceId($detailGrid['catalog_id_detail'], $detailGrid['instance_name_detail']);
				
				if (!$this->niotaUser->isCatalogInstanceVisible($detailCatalogInstanceId)) {
					ET_DisplayHelper::addErrorLine(ET_DisplayHelper::localize("DETAIL_NOT_ACCESSIBBLE", array($detailCatalogInstanceId), PAGE_TYPE_GRID), "niota");
				} else {
					$this->detailGridInfos [] = $detailGrid;
				}
				
			}
			
		}
						
		protected  function fillPredefinedPrimaryKeys($catalogId){
			$this->predefinedPrimaryKeys = $this->metaDataConnector->getCatalogPrimaryKeys($catalogId);			
		}
		
		protected function createDetailCatalogInstances() {
			
			$lastDetailCatalogInstanceId = "";
			
			$detailNumber = 1;
			
			for ($i = 0; $i < count($this->detailGridInfos); $i++) {
				
				$detailArray = $this->detailGridInfos[$i];
				$detailCatalogId 	= $detailArray["catalog_id_detail"];
				$detailInstanceName = $detailArray["instance_name_detail"];
				$logicalLink		= $detailArray["logical_link"];
				
				$detailCatalogInstanceId = ET_MetaDataConnector::getInstance()->generateCatalogInstanceId($detailCatalogId, $detailInstanceName);
 				
				if ($detailCatalogInstanceId != $lastDetailCatalogInstanceId) {
					
					$browsingStore = ET_BrowsingStore::getBrowsingStore();
					$browsingStore->create_browsingState($detailCatalogInstanceId);
					$browsingStore-> set_connName($detailCatalogInstanceId, $this->connName);
					$browsingStore->flushBrowsingStore();
					$detailCatalogInstance = new ET_CatalogInstance($detailCatalogId, $detailInstanceName, "$detailNumber", false, false, null, $logicalLink);
					array_push($this->detailDataGrids, $detailCatalogInstance->getDataGrid());
					$detailNumber++;
					
				}
					
				$lastDetailCatalogInstanceId = $detailCatalogInstanceId;
			}			
		}
		
		protected function fillUserSettings() {
			$userName = ET_NiotaUser::getNiotaUserFromSession()->get_username();

			$this->userSettings['column_level'] = $this->getUserSettings($userName, USER_PARAM_LEVEL_COLUMN);
			$this->userSettings['catalog_level'] = $this->getUserSettings($userName, USER_PARAM_LEVEL_CATALOG);		
			
		} 
		
		protected function getUserSettings($userName, $paramLevel) {
			$settingsAny 	= $this->metaDataConnector->getUserSettings(QUERY_ANY, $paramLevel, $this->catalogInstanceId, $this->subgridLogicalLink);
			$settingsUser 	= $this->metaDataConnector->getUserSettings($userName, $paramLevel, $this->catalogInstanceId, $this->subgridLogicalLink);
			
			return array_merge($settingsAny, $settingsUser);
		}
		
		public static function getObjectJoinAlias () {			
			return OBJECT_JOIN_ALIAS_PREFIX . $this->catalogId;			
		}
		
		public function getCatalogInstanceId() {
			return $this->catalogInstanceId;
		}
		
		public function isSelectionTable() {
			return $this->selectionTable;
		}
		
		public function displayMenuItems() {
						
			ET_DisplayHelper::printAccessibleMenuItems($this->userRights, $this->dataGrid->getFullTableName(), 
					$this->niotaUser->isThereAnyCallableObjectForCatalog($this->catalogId), $this->niotaUser->get_userSettings(),
					!empty($this->filterMappings), $this->filteringInstanceId, $this->useAdvancedFiltering, $this->selectionTable,
					$this->isThereAnyLookups(), $this->isThereAnyConstraints(), $this->filterMappings);
		}
		
		public function displayPopupWindows($fileName = ""){
			
			$tableLevelCallables 	= array();
			$lineLevelCallables 	= array();
			
			if ($this->userRights['allow_import'] || $this->userRights['allow_import_partial']) {
				//ET_DisplayHelper::printExcelImportPopup($this->userRights);
				ET_DisplayHelper::printExcelImportPopup($this->userRights);
			}	
			if ($this->niotaUser->isThereAnyCallableObjectForCatalog($this->catalogId)) {
				$tableLevelCallables = $this->niotaUser->getCallableObjectsForCatalog($this->catalogId, BINDING_LEVEL_TABLE);
				$lineLevelCallables = $this->niotaUser->getCallableObjectsForCatalog($this->catalogId, BINDING_LEVEL_LINE);
				
				ET_DisplayHelper::printCallableObjectPopup($tableLevelCallables, $lineLevelCallables, "", $fileName);
			}
			if ($this->isThereAnyFileProcessCalable($tableLevelCallables, $lineLevelCallables)) {
				ET_DisplayHelper::printFileUploadAndProcessPopup();
			}
			
				
		}
		
		public function displayGrid() {
			$this->dataGrid->displayGrid();
		}
		
		public function getConnName(){
			return  $this->connName;
		}
		
		public function getFullTableName(){
			return $this->dataGrid->getFullTableName();
		}
		
		public function getLookups(){
			return $this->dataGrid->getLookups();
		}
		
		public function getConstraints(){
			return $this->dataGrid->getConstraints();
		}
		
		public function getFilterMappings() {
			return $this->filterMappings;
		}
		
		public function getColumnInfo(){
			//return $this->dataGrid->getColumnInfo();
			return $this->columnInfo;
		}
		
		public function getError() {
			return $this->error;
		}
		
		public static function getTableNameFromFullyQualifiedForm($fullTableName) {
			$ret = $fullTableName;
			if(strpos($fullTableName, ".") !== false) {
					$placeOfLastDot = strrpos($fullTableName, ".");
					$ret = substr($fullTableName, $placeOfLastDot + 1);
			}
			return $ret;
		}
		
		public function getDataGrid() {
			return $this->dataGrid;
		}
		
		protected function setQueryObjectIntoSession($logicalLink = "", $useAdvancedFiltering = false, $columnInfo = array(), $defaultOrderBy = "") {
			
			$sqlObj			= null;	
			$br 			= ET_BrowsingStore::getBrowsingStore();
			//$gridIdentifier = $br->generateGridIdentifier($this->catalogInstanceId, $logicalLink);
			
			$advencedFilterSqlObj = $br->get_gridSqlObject($this->catalogInstanceId);
			
			if (!is_null($advencedFilterSqlObj) && $advencedFilterSqlObj->getUseAdvancedFiltering()) {
				$sqlObj = $advencedFilterSqlObj;
			} else {
				$sqlObj	= new ET_GridSql();
			}
			
			$fullTableName 		= ET_MetaDataConnector::getInstance()->getFullTableName($this->object, $this->connName);
			$projection 		= $this->isActiveProjList ? $this->projectionList : "";			
			$objFilter 			=  "";
			$objectjoin 		= $this->isActiveObjectjoin ? $this->objectjoin : "";
			$objectJoinAlias 	= $this->isActiveObjectjoin ? $this->objectjoinAlias : "";
			$objectOrderBy 		= "";
			$objectGroupBy 		= $this->isActiveObjectgroupby ? $this->objectgroupby : "";
			$objectUnion		= $this->isAcitveObjectunion ? $this->objectunion : "";
			$objectOrderBy 		= $this->isActiveObjectorder ?  $this->objectorder : "";
			$objFilter 			= $this->isActiveObjectfilter ? $this->objectFilter : "";
			//advanced filter feature after filter form is submitteds:
			$whereGetFromFilterPopupSubmit	= "";
			$orderByAdvancedFiltering = "";
			
			if ($useAdvancedFiltering) {
				
				$filterMappings 				= $_SESSION[SESS_ADVANCED_FILTER_FILTERMAPPINGS];
				$filterKeyPairs 				= ET_BrowsingStore::getBrowsingStore()->get_filterKeyPair($this->catalogInstanceId);				
				//$objFilter					= ET_AdvancedFilterHelper::resolveFilterMappings($filterMappings, $filterKeyPairs, $columnInfo);
				$whereGetFromFilterPopupSubmit 	= ET_AdvancedFilterHelper::resolveFilterMappings($filterMappings, $filterKeyPairs, $columnInfo);
				//$objectOrderBy					= ET_AdvancedFilterHelper::resolveOrderBy($filterMappings);				
				$orderByAdvancedFiltering		= ET_AdvancedFilterHelper::resolveOrderBy($filterMappings, "", true);

			}
			
			//master gird id is set into $br for sure
			//if the favourite grid has got detail grids those have to be initialized in the $br
			//if (!empty($this->subgridNumber) && !isset($br->getBrowsingStates[$gridIdentifier])) {
			if (!empty($this->subgridNumber) && !isset($br->getBrowsingStates[$this->catalogInstanceId])) {
				//$br->create_browsingState($gridIdentifier);
				$br->create_browsingState($this->catalogInstanceId);
				$br->flushBrowsingStore();
				$br = ET_BrowsingStore::getBrowsingStore();
			} else {
				//do nothing
			}
			
			$sqlObj->setFullTableName($fullTableName);
			$sqlObj->setCatalogInstanceId($this->catalogInstanceId);
			$sqlObj->setProjectionList($projection);
			$sqlObj->setwhereObjectFilter($objFilter);
			$sqlObj->setObjectGroupBy($objectGroupBy);
			$sqlObj->setObjectJoin($objectjoin);
			$sqlObj->setObjectJoinAlias($objectJoinAlias);
			$sqlObj->setObjectOrder($objectOrderBy);
			$sqlObj->setObjectUnion($objectUnion);
			$sqlObj->setOrderByDefaultPK($defaultOrderBy);
			//makes up filter result:
			$sqlObj->setWhereAdvancedFilterFilteredTable($whereGetFromFilterPopupSubmit);
			$sqlObj->setOrderByAdvancedFiltering($orderByAdvancedFiltering);
			
			//after everything is set reset adv.filter flag to prevent unwanted filtering at next table load
			$sqlObj->setUseAdvancedFiltering(false);
			
			$br->set_gridSqlObject($this->catalogInstanceId, $sqlObj);
			$br->flushBrowsingStore();
			
		}		
		
		protected function isThereAnyFileProcessCalable($tableLevelCallables, $lineLevelCallables) {
			
			
			if ($this->findFileProcessCalable($tableLevelCallables)) {
				return true;
			} else if ($this->findFileProcessCalable($lineLevelCallables)) {
				return true;
			} else {
				return false;
			}
		}
		
		protected function findFileProcessCalable($inputArr) {
			
			for ($i = 0; $i < count($inputArr); $i++) {
				
				$currentItem = $inputArr[$i];
				
				if ($currentItem['promptpage_type'] == 1) {
					return true;
				}
			}
			
			return false;
		}
		
		protected function isThereAnyLookups() {
			
			return !empty($this->lookups) ? true : false;
				
		}
		
		protected function isThereAnyConstraints() {
			return !empty($this->constraints) ? true : false;
		}
		
		
		
	}
	
	
	
	