<?php
 	
	class ET_ConnHelper{
		
		public static function getConnection($connectionname) {
			
			if (!isset(ET_CONNECTIONS[$connectionname])) {
				return false;
			}
			$connArray = ET_CONNECTIONS[$connectionname];			
			return self::getConnectionFromArrayDef($connArray, $connectionname);
		}
		
		public static function getLogConnection() {
			if (!defined('ET_LOG_CONNECTION'))
				return false;
		
				$connArray = ET_LOG_CONNECTION;
		
				return self::getConnectionFromArrayDef($connArray);
		}
				
		public static function getLDAPconnection() {
			
			//$ldapConn = ldap_connect(ET_LDAP_AUTHENTICATION[PHPGRID_DB_HOSTNAME], ET_LDAP_AUTHENTICATION[PHPGRID_DB_PORT]);
			$isHostnameOk	= self::checkLdapUrl();
			
			if ($isHostnameOk) {
				$ldapConn = ldap_connect(ET_LDAP_AUTHENTICATION[PHPGRID_DB_HOSTNAME]);
			}			
			
			if(!$ldapConn || !$isHostnameOk)
				throw new Exception("LDAP connection error");
		
			return $ldapConn;
		}
		
		public static function getMetaDataConnectionName() {
			return ET_METADATA_CONNECTION;
		}
		
		public static function getConnectionArrayFromConnectionName($connName) {
			
			return ET_CONNECTIONS[$connName];
		}
		
		public static function getConnectionFromConnectionName($connName) {
			return ET_ConnHelper::getConnectionFromArrayDef(ET_CONNECTIONS[$connName]);
		}
		
		public static function getConnectionFromArrayDef($connArray, $connName = '') {
			$db_conf 				= array();
			$connType				= isset($connArray[PHPGRID_CONN_TYPE]) ? $connArray[PHPGRID_CONN_TYPE] : CONN_TYPE_DATABASE;
			
			if ($connType == CONN_TYPE_WEBSERVICE) {
				return new ET_WebServiceConnection($connName);
			}		
			
			$type 					= $connArray[PHPGRID_DB_TYPE];
			$db_conf["server"] 		= $connArray[PHPGRID_DB_HOSTNAME];
			$db_conf["user"] 		= $connArray[PHPGRID_DB_USERNAME];
			$db_conf["database"]	= $connArray[PHPGRID_DB_NAME];			
			$db_conf["password"]	= self::resolveDbPw($connArray);
						
			if (isset($connArray[PHPGRID_AUTH_MECHANISM]))
				$db_conf["auth_machanism"] = $connArray[PHPGRID_AUTH_MECHANISM];
		
			$con = null;
				
			if ($type == "odbc_mssql") {
				$con = ADONewConnection($type);
				$con->Connect($db_conf["server"], $db_conf["user"], $db_conf["password"]);
				
			}
			else if ($type == "oci805") {
				$con = ADONewConnection($type);
				$con->Connect($db_conf["server"], $db_conf["user"], $db_conf["password"], $db_conf["database"]);
			}
			else if ($type == "mssqlnative") {				
				$con = ADONewConnection($type);
				// character encoding has to be set directly to the conn as early as possible
				// have to use Adodb function for that
				$con->setConnectionParameter("CharacterSet", $connArray[PHPGRID_DB_CHARSET]);		
				//check if it is needed:
				//$con->setConnectionParameter("ConnectionPooling", false);
				//$con->setConnectionParameter("Authentication", "ActiveDirectoryServicePrincipal");
				$con->Connect($db_conf["server"], $db_conf["user"], $db_conf["password"], $db_conf["database"]);
				//d($con);
				//echo $con->ErrorMsg();
			}
			else if ($type == "odbc_teradata") {
				$con = ADONewConnection("odbc_teradata");
					
				$dsn = "DSN=".$db_conf["server"].";uid=".$db_conf["user"]."; pwd=".$db_conf["password"];
	
				if (isset($db_conf["auth_machanism"])) {
					$dsn .= "; Authentication=" . $db_conf["auth_machanism"];
				}
					
				$con->Connect($dsn);
				//$con->Connect($db_conf["server"], $db_conf["user"], $db_conf["password"]);
			}
			else {
				$con = ADONewConnection($type);
				$con->Connect($db_conf["server"], $db_conf["user"], $db_conf["password"], $db_conf["database"]);
			}
	
			return $con;
		}
		
		public static function getAllConnections() {
			$ret = array();
		
			foreach (ET_CONNECTIONS as $key => $val) {
				array_push($ret, $key);
			}
		
			return $ret;
		}
		
		public static function getConnectionTypeByName($conn_name, $isAdminGrid = false){
			
			$pageType = ET_DisplayHelper::detectPageType($isAdminGrid);
			
			if(isset(ET_CONNECTIONS[$conn_name])) {
				//if (self::isDbConnection($conn_name))
					return  ET_CONNECTIONS[$conn_name][PHPGRID_DB_TYPE];
			//else 
			//		return "";
			}
			else {
				//cannot find where is the thrown exception cought os i set it inot session to print on scrieen in error.php
				self::setErrorMsgIntoSession(ET_DisplayHelper::localize('CONN_NOT_DEFINED', array($conn_name), PAGE_TYPE_GRID));				
				throw new Exception(ET_DisplayHelper::localize('CONN_NOT_DEFINED', array($conn_name), $pageType));
			}
		}

		public static function getConnectionCharsetByName($conn_name){
			if(isset(ET_CONNECTIONS[$conn_name])) {
			//	if (self::isDbConnection($conn_name))
					return  ET_CONNECTIONS[$conn_name][PHPGRID_DB_CHARSET];
			//	else 
			//		return "";
			}
			else {
				//cannot find where is the thrown exception cought os i set it inot session to print on scrieen in error.php
				self::setErrorMsgIntoSession(ET_DisplayHelper::localize('CONN_NOT_DEFINED', array($conn_name), PAGE_TYPE_GRID));
				throw new Exception(ET_DisplayHelper::localize('CONN_NOT_DEFINED', array($conn_name), PAGE_TYPE_GRID));
			}
		}
		
		public static function getDbNameByConnectionName($conn_name){
			
			if(isset(ET_CONNECTIONS[$conn_name]))
				return 	ET_CONNECTIONS[$conn_name][PHPGRID_DB_NAME];
			
		}
		
		public static function getConnectionDisplayNameByConnName($conn_name){
			if(isset(ET_CONNECTIONS[$conn_name]))
				return 	ET_CONNECTIONS[$conn_name][PHPGRID_DB_DISPLAY_NAME];
			else {
				//cannot find where is the thrown exception cought os i set it inot session to print on scrieen in error.php
				self::setErrorMsgIntoSession(ET_DisplayHelper::localize('CONN_NOT_DEFINED', array($conn_name), PAGE_TYPE_GRID));
				throw new Exception(ET_DisplayHelper::localize('CONN_NOT_DEFINED', array($conn_name), PAGE_TYPE_GRID));
			}
		}
		
		public static  function getDecimalpointFormatByConnectionName($conn_name){
			if(isset(ET_CONNECTIONS[$conn_name]))
				return 	isset(ET_CONNECTIONS[$conn_name][PHPGRID_DISPLAY_NUMBER_DECIMALPOINT]) ? ET_CONNECTIONS[$conn_name][PHPGRID_DISPLAY_NUMBER_DECIMALPOINT] : ".";
			else
				throw new Exception(ET_DisplayHelper::localize('CONN_NOT_DEFINED'), null, PAGE_TYPE_GRID);
		}
		
		public static function getDateAndDatetimeFormat($connName, $formatType){		 
			$connType 	= ET_ConnHelper::getConnectionTypeByName($connName);
			$connArray 	= ET_ConnHelper::getConnectionArrayFromConnectionName($connName);

			if (isset($connArray[$formatType]))
				return $connArray[$formatType];
						
			$defaultFormatValue = "";

			if ($formatType == PHPGRID_SOURCE_DATE_FORMAT || $formatType == PHPGRID_DISPLAY_DATE_FORMAT)
				$defaultFormatValue = 'Y-m-d';
			else 
				$defaultFormatValue = 'Y-m-d H:i:s';
			
			if ($connType == 'odbc_teradata' && $formatType == PHPGRID_SOURCE_DATETIME_FORMAT) {
				$defaultFormatValue = 'Y-m-d H:i:s.f';
			}	
			
			return $defaultFormatValue;
		}	
		
		// use '_' instead of camelCase because of phpGrid naming convention (see refernces) 
		public static function resolveColumnName ($col_name, $dbType) {
			
			$ret =  $col_name;
			
			if ($dbType == DB_TYPE_OCI805) {
				$ret = strtoupper($ret);
			}
			
			return $ret;
		}
		
		public static function getfullDbName ($connName) {
			
			if (!empty($connName)) {
				
				$tmpDbArray = ET_CONNECTIONS[$connName];
				
				if (!empty($tmpDbArray)) {					
					if ($tmpDbArray[PHPGRID_DB_TYPE] !== DB_TYPE_OCI805) {
						return $tmpDbArray[PHPGRID_DB_NAME];
					}
					else {						
						return $tmpDbArray[PHPGRID_DB_USERNAME];
					}
				}				
			}
			else {
				return false;
			}	
		}
		
		public static function isConnPwEncrypted ($connArray) {
			
			if (isset($connArray[PHPGRID_DB_PW_ENCRYPTED]) && $connArray[PHPGRID_DB_PW_ENCRYPTED]) {
				return $connArray[PHPGRID_DB_PW_ENCRYPTED];
			}
			else if (isset($connArray[PHPGRID_WS_PASSWORD_ENCRYPTED]) && $connArray[PHPGRID_WS_PASSWORD_ENCRYPTED]) {
				return $connArray[PHPGRID_WS_PASSWORD_ENCRYPTED];
			}
			else {
				return false;
			}
		}
		
		public static function resolveDbPw ($connArray) {
				
			$pw = isset($connArray[PHPGRID_DB_PASSWORD]) ? $connArray[PHPGRID_DB_PASSWORD] : $connArray[PHPGRID_WS_PASSWORD];			
			return self::isConnPwEncrypted($connArray) ? ET_Encrypt::getInstance()->decrypt($pw) : $pw;
			
		}
		
		public static function isDbConnection($connName) {
			$connArr  = self::getConnectionArrayFromConnectionName($connName);
			$connType =  isset($connArr[PHPGRID_CONN_TYPE]) ? $connArr[PHPGRID_CONN_TYPE] : CONN_TYPE_DATABASE;
			
			return $connType == CONN_TYPE_DATABASE ? true : false;
			
		}
		
		protected static function checkLdapUrl() {
			
			$url 	= ET_LDAP_AUTHENTICATION[PHPGRID_DB_HOSTNAME];
			$expr 	= "/(ldap|ldaps):\/\/[\w\.\-@&]*:\d{1,5}/"; 
			
			if (preg_match($expr, $url)) {
				return true;
			} else {
				return false;
			}
			
		}
		
		protected static function setErrorMsgIntoSession($msg) {
			if (!isset($_SESSION["uncought_exception"])) {
				$_SESSION["uncought_exception"] = $msg;
			} else {
				$_SESSION["uncought_exception"] .= $msg;
			}
		}
		
		public static function getDBSessionCollationBehavior ($conn, $connType) {
			
			//$dbType = $db->dbType;
			$ret = null;
			switch ($connType) {
				
				case DB_TYPE_OCI805:
					$ret = self::getSessionCollationBehaviorOracle($conn);
					break;
				case DB_TYPE_MSSQL:
					DB_TYPE_ODBC_MSSQL:
					DB_TYPE_ODBC_TERADATA:
					DB_TYPE_MYSQLI:
					break;
			}
			
			return $ret;
			
		}
		
		public static function setDBSessionCollationBehavior ($conn, $connType, $settings) {
			$ret = false;
			
			switch ($connType) {
				
				case DB_TYPE_OCI805:
					$ret = self::setSessionCollationBehaviorOracle($conn, $settings['NLS_COMP'], $settings['NLS_SORT']);
					break;
				case DB_TYPE_MSSQL:
					DB_TYPE_ODBC_MSSQL:
					DB_TYPE_ODBC_TERADATA:
					DB_TYPE_MYSQLI:
					break;
			}
			return $ret;
			
		}
		
		public static function getSystemZagreusConnection () {
			
			if (defined("ET_ZAGREUS_CONNECTION")) {
				
				return self::getConnection(ET_ZAGREUS_CONNECTION);
				
			} else {
				throw new Exception("ET_ZAGREUS_CONNECTION is not defined in connections.php!");
			}
			
		}
		
		protected static function getSessionCollationBehaviorOracle($conn) :array{
			
			$ret = array();
			$SQL = "SELECT * FROM nls_database_parameters WHERE parameter = 'NLS_COMP' OR parameter = 'NLS_SORT'";
			$res = $conn->Execute($SQL);
			//echo $conn->ErrorMsg();
			if ($res == false) {
				throw new  Exception("getting NLS_COMP failed!");
			} else {
				
				while ($row = $res->fetchRow()) {
					
					if ($row['PARAMETER'] == 'NLS_SORT') {
						$ret['NLS_SORT'] = $row['VALUE'];
					} elseif ($row['PARAMETER'] == 'NLS_COMP') {
						$ret['NLS_COMP'] = $row['VALUE'];
					} 
				}			
			}
			
			return $ret;
		}
		
		protected static function setSessionCollationBehaviorOracle ($conn, $valueComp, $valueSort) {
			
			//those thwo NLS variables must set at once to use 
			$SQL = "ALTER SESSION SET NLS_COMP=$valueComp";			
			$res = $conn->Execute($SQL);
			
			$SQL2 = "ALTER SESSION SET NLS_SORT=$valueSort";
			$res2 = $conn->Execute($SQL2);
			//echo $SQL;
			//$SQL = "alter session set nls_sort = binary_ci";
			
			//echo self::getSessionCollationBehaviorOracle($conn);
			if ($res == false || $res2 == false) {
				throw new  Exception("setting NLS_COMP failed!");
			} else {
				return true;
			}
		}
		
		
	}
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	