<?php
class ET_CookieHandler {
	
	public const COOKIE_NAME_CLIENT = 'NIOTACLIENTNAME';
	
	public static function setCookieClientName() {				
		$clientName	= isset($_SESSION[SESS_CLIENT]) ? $_SESSION[SESS_CLIENT] : CLIENT_SYSTEM;
		
		setcookie(
				self::COOKIE_NAME_CLIENT,
				$clientName,
				['expires' => time()+60*60*24,
				'path' => '/',
				'domain' => '',
				'secure' => false,
				'httponly' => true,
				'samesite' => 'Strict',
				]
			);
	}
	
	public static function testCookieAccept() {
		
		$ret = null;
		
		if (isset($_COOKIE[self::COOKIE_NAME_CLIENT])) {
			$ret = true;
		} else {
			$ret = false;
			ET_DisplayHelper::addErrorLine("Warning! Cookie content cannot get. Proper working of niota is not guaranteed.", "login");
		}
				
		return $ret;
	} 
	
	public static function getCookieClientName() {
		if (isset($_COOKIE[self::COOKIE_NAME_CLIENT])) {
			return $_COOKIE[self::COOKIE_NAME_CLIENT];
		} else {
			throw new Exception ("Error! Client name cannot be retrieved");
		}
	}
	
	public static function checkIfCookieClientNameIsSet() {
		if (isset($_COOKIE[self::COOKIE_NAME_CLIENT])) {
			return true;
		} else {
			return false;
		}
	}
	
}