<?php

	use phpGrid\C_DataGrid as C_DataGrid;

	class ET_DataGrid {
		protected $dg;
		protected $catalogInstanceId;
		
		protected $filteredInstanceId;		
		protected $selectionTable;
		
		protected $connName;
		protected $db_connection;
		
		protected $fullTableName;
		protected $SQLForGrid;
		protected $primaryKeys;
		protected $columnInfo;
		protected $readonlyList;
		protected $objectjoin;
		
		protected $crud;
		
		protected $subgrid_number = '';
		protected $subgrid_logical_link = '';
		
		protected $filterDialog;		
		protected $formatFilePrefix;
		protected $lookups, $constraints, $userRights, $filterMappings, $filterKeyPairs = array();
		
		protected $detailGridInfos;
		protected $detailDataGrids;
		
		protected $decimalPoint;
		
		protected $superUser;
		protected $view;
		protected $gridCustomDimensions = null;
		protected $userSettingsCatalog;
		protected $userSettingsColumn;
		
		protected $adminDatagrid;
		
		public function __construct($catalogInstanceId, $tmpArr) {
			$this->catalogInstanceId = $catalogInstanceId;
			
			$this->connName 			= $tmpArr['conn_name'];
			$this->superUser 			= $tmpArr['super_user'];
			
			$this->lookups 				= $tmpArr['lookups'];
			
			$this->constraints 			= $tmpArr['constraints'];
			$this->userRights 			= $tmpArr['user_rights'];
			$this->selectionTable		= $tmpArr['selection_table'];
			$this->filterMappings 		= $tmpArr['filter_mappings'];
			$this->filteredInstanceId 	= $tmpArr['filtered_instance_id'];
			$this->primaryKeys 			= $tmpArr['primary_keys'];
			$this->columnInfo 			= $tmpArr['column_info'];
			$this->readonlyList			= $tmpArr['readonly_list'];
			$this->SQLForGrid 			= $tmpArr['sql_for_datagrid'];
			$this->fullTableName 		= $tmpArr['full_table_name'];
			$this->filterDialog 		= $tmpArr['filter_dialog'];
			$this->formatFilePrefix 	= $tmpArr['format_file_prefix'];
			$this->subgrid_number		= $tmpArr['subgrid_number'];
			$this->subgrid_logical_link = $tmpArr['subgrid_logical_link'];
			$this->objectjoin			= $tmpArr['object_join'];
			$this->view					= $tmpArr['view'];
			$this->detailGridInfos 		= $tmpArr['detail_grid_infos'];
			$this->detailDataGrids 		= $tmpArr['detail_datagrids'];
			$this->userSettingsCatalog 	= $tmpArr['user_settings_for_catalog']['catalog_level'];
			$this->userSettingsColumn	= $tmpArr['user_settings_for_catalog']['column_level'];
			$this->adminDatagrid		= $tmpArr['admin_datagrid'];
			
			if (isset($tmpArr['filter_key_pairs']))
				$this->filterKeyPairs = $tmpArr['filter_key_pairs'];
			
			$this->initializeDbConnection();
			
			$adminDatagrid 				= isset($tmpArr['admin_datagrid']) ? $tmpArr['admin_datagrid'] : 0;
			$editFlags 					= isset($tmpArr['edit_flags']) ? $tmpArr['edit_flags'] : 0;
			$reloadMasterAfterSubmit	= isset($tmpArr['reload_master_after_submit']) ? $tmpArr['reload_master_after_submit'] : 0;
			
			$browsingStore = ET_BrowsingStore::getBrowsingStore();
				
			$browsingStore->set_fullTableName($this->catalogInstanceId, $this->fullTableName);
			$browsingStore->set_selectedColumnInfo($this->catalogInstanceId, $this->columnInfo);
			$browsingStore->set_selectedPrimaryKeys($this->catalogInstanceId, $this->primaryKeys);
				
			$browsingStore->flushBrowsingStore();
			
			$presetFormonly = ($this->filterDialog && !empty($this->filterMappings) && $this->selectionTable) ? true : false;
			
			$this->dg = new C_DataGrid($this->SQLForGrid, $this->primaryKeys, $this->fullTableName,
					$this->db_connection, $this->catalogInstanceId, $adminDatagrid, $editFlags, $reloadMasterAfterSubmit, $presetFormonly);
			
			$this->initializeDataGrid($presetFormonly);
			$this->applyCustomFormatting();
			$this->applyUserSettingsForDataGrid();
		}
		
		public function getFullTableName() {
			return $this->fullTableName;
		}
		
		protected function initializeDataGrid($presetFormonly = false) {
			
			$colSaveDefault = "";
			
			if ($presetFormonly) {
				
				$captionPopup = $this->getCaptionPopup();				
				$this->dg->form_only(true, $captionPopup);
				
				
				$this->dg->load_form($_SESSION[SESS_USERNAME]);
				
				$filteredColumnNames = array();				
								
				
				for ($i = 0; $i < count($this->filterMappings); $i++) {
					array_push($filteredColumnNames, $this->filterMappings[$i]["column_name_master"]);					
				}				

				foreach ($this->columnInfo as $key => $val) {
					
					$colName = $val['originalColumnName'];
					
					if (!in_array($colName, $filteredColumnNames) && (strtolower($colName) != strtolower(SELECTION_TABLE_FIELD_SAVE_DEFAULT))) {
						$this->dg->set_col_hidden($colName, false);						
					}
					
					if (strtolower($colName) == strtolower(SELECTION_TABLE_FIELD_SAVE_DEFAULT))
						$colSaveDefault = $colName;					
				}
				
				$this->dg->set_col_title($colSaveDefault, "Save as default");			
				$this->dg->set_col_format($colSaveDefault, "checkbox");						
				$this->dg->set_col_edittype($colSaveDefault, "checkbox", "1:0");
				
			}
			
			if (!empty($this->filterKeyPairs)) {
				$operationsForColNames = array();
				for ($i = 0; $i < count($this->filterMappings); $i++) {
					$filterMapping = $this->filterMappings[$i];
					$operationsForColNames[strtolower($filterMapping['column_name_master'])] = $filterMapping['operation'];
				}
			
				foreach ($this->filterKeyPairs as $colName => $value) {
					$colNameLower = strtolower($colName);
					
					if ($colNameLower == strtolower(SELECTION_TABLE_FIELD_SAVE_DEFAULT))
						continue;
					
					$operation = $operationsForColNames[$colNameLower];
					
					if (!empty($value)) {
						if ($operation === '1') {
							$this->dg->set_col_readonly($colName);
							$this->dg->set_col_default($colName, $value);
						} else if ($operation === '0') {
							$this->dg->set_col_default($colName, $value);
						}
					}
				}				
			}
			
			$this->setCRUD();
			$this->setLookups();
			
			
			$this->setReadonlyList();
			$this->decimalPoint = ET_ConnHelper::getDecimalpointFormatByConnectionName($this->connName);
			$this->setConstraintValuesIntoSession();
			$this->setGridLanguage();
			$this->setColumnAlignement();
			$this->setDateTimeFormats($this->connName, $this->columnInfo);
			
			$gridColorTheme = $this->getTheme();
			$this->dg->set_theme($gridColorTheme);
			$this->dg->enable_resize(true);
			
			if (!$this->adminDatagrid) {
				$this->dg->set_pagesize(DEFAULT_PAGE_SIZE_GRID);
			}
			else {
				$this->dg->set_pagesize(DEFAULT_PAGE_SIZE_ADMIN);
			}
			
			$this->dg->enable_search(true);
			//$this->dg->set_col_format("float_val", 'number', array("thousandsSeparator" => ",", "decimalSeparator" => ".", "decimalPlaces" => '2', "defaultValue" => '0.00'));
			//TODO: rethink multiselect when we implement master-detail feature
			if (empty($this->subgrid_number) && empty($this->detailGridInfos))
				$this->dg -> set_multiselect(true, true);

			if (!is_null($this->objectjoin)) {
				$this->dg->set_caption($this->fullTableName . " joined");
				//$this->dg -> set_multiselect(false);
			}
			if (!empty($this->filterKeyPairs)) {
				$this->dg->set_caption($this->dg->get_caption() . " (filtered)");
			}
			
			if (defined('PHPGRID_EDIT_FORM_DEFAULT_WIDTH'))
				$this->dg->set_form_dimension((string)PHPGRID_EDIT_FORM_DEFAULT_WIDTH);
			
			$this->setDetailGrids();	
			
		}
		
		protected function setDetailGrids() {
			
			for ($i = 0; $i < count($this->detailDataGrids); $i++) {
				
				$detailDataGrid = $this->detailDataGrids[$i];				
				$sdg 			= $detailDataGrid->getCLSDataGrid();
				$references 	= $this->getMasterDetailReferences($detailDataGrid->getCatalogInstanceId());
				
				//line added 2022-09-21 by Zalan - protect linked columns in detail table:
				$sdg->set_col_readonly($references[1]);
				
				$this->dg->set_masterdetail($sdg, $references[1], $references[0], $detailDataGrid->getSubgridNumber(), 
						$detailDataGrid->getSubgridLogicalLink(), $references[2], $references[3]);
			}
		}
		
		protected function getMasterDetailReferences($catalogInstanceId) {
			
			$columnNamesMaster = array(); 
			$columnNamesDetail = array();
			$columnOperations  = array();
			$orderBy = "";
			
			$tempArray = array();
			
			for ($i = 0; $i < count($this->detailGridInfos); $i++) {
				$detailArray 		= $this->detailGridInfos[$i];
				$detailCatalogId 	= $detailArray["catalog_id_detail"];
				$detailInstanceName = $detailArray["instance_name_detail"];
				
				$detailCatalogInstanceId = $detailCatalogId . "." . $detailInstanceName;
				
				if ($detailCatalogInstanceId == $catalogInstanceId) {
					array_push($columnNamesMaster, $detailArray["column_name_master"]);
					array_push($columnNamesDetail, $detailArray["column_name_detail"]);
					array_push($columnOperations, $detailArray["operation"]);
					if (!is_null($detailArray["sortorder"]))
						$tempArray[$detailArray["sortorder"]] = $detailArray["column_name_detail"];
				}
			}
			
			ksort($tempArray);
				
			foreach ($tempArray as $key => $value) {
				$orderBy .= $value . ",";
			}
			if (self::endsWith($orderBy, ",")) {
				$orderBy = substr($orderBy, 0, strlen($orderBy) - 1);
			}
			
			return [$columnNamesMaster, $columnNamesDetail, $columnOperations, $orderBy];
		}
		
		protected function applyCustomFormatting() {
						
			if (!defined('APPLY_CUSTOM_FORMATTING')) 	return;
			if (!defined('CUSTOM_FORMAT_FOLDER')) 		return;
			if (APPLY_CUSTOM_FORMATTING == false) 		return;
				
			$clinetName 		= $_SESSION[SESS_CLIENT];
			$formatFolderPath 	= "";
			
			if ($clinetName == CLIENT_SYSTEM) {
				$formatFolderPath = __DIR__ . "/../../conf/" . CLIENT_FOLDER_FORMATTING;
			} else {
				$formatFolderPath 	= ET_PathHelper::getClientConfSubFolderAbsolutePath (CLIENT_FOLDER_FORMATTING);
			}
			
			$this->applyDBGridFormatting();
			
			$this->applyCustomGeneralFormatting($formatFolderPath, CUSTOM_FORMAT_SUBFOLDER_GENERAL . "/" . CUSTOM_FORMAT_FILE_GENERAL);
			$this->applyCustomDBFormatting($formatFolderPath, $this->formatFilePrefix);
			$this->applyCustomCatalogFormatting($formatFolderPath);
			
		}

		/***
		 * THIS IS CALLED FROM ADMIN FORMATTER ALSO!
		 * @param unknown $formatFolderPath
		 * @param unknown $fileName
		 * @param array $detailGrids
		 */
		protected function applyCustomGeneralFormatting($formatFolderPath, $fileName, $detailGrids = array()) {
			
			if(defined('CUSTOM_FORMAT_FILE_GENERAL')) {				
				//$generalFormatterFilePath = $formatFolderPath . "/" . CUSTOM_FORMAT_SUBFOLDER_GENERAL . "/" . $fileName;
				$generalFormatterFilePath 	= $formatFolderPath . $fileName;
				$dg 						= $this->dg;
				$crud 						= $this->crud;
				
				if ($this->adminDatagrid) {
				
					if (empty($detailGrids))  {
													
						$formatter = new ET_GridFormatter($dg);
						$tableName_2format = ET_CatalogInstance::getTableNameFromFullyQualifiedForm($_SESSION[SESS_CATALOG_INSTANCE_ID_MASTER_ADMIN]);						
						$catalogId_2format = $formatter->getSystemCatalogID($tableName_2format);
						$instanceName_2format = $_SESSION[SESS_INSTANCE_NAME_MASTER_ADMIN];

						 
						$formatter->formatGridInstanceObject($dg, $catalogId_2format, $instanceName_2format);
						$formatter->formatGridInstanceColumn($dg, $catalogId_2format, $instanceName_2format);
					}
					if (!empty($detailGrids))  {
						
						include("sdgInclude.php");
						
						// first grid
						$formatter = new ET_GridFormatter($dg);
						$tableName_2format = ET_CatalogInstance::getTableNameFromFullyQualifiedForm($_SESSION[SESS_CATALOG_INSTANCE_ID_MASTER_ADMIN]);
						$catalogId_2format = $formatter->getSystemCatalogID($tableName_2format);
						$instanceName_2format = $_SESSION[SESS_INSTANCE_NAME_MASTER_ADMIN];
													
						$formatter->formatGridInstanceObject($dg, $catalogId_2format, $instanceName_2format);
						$formatter->formatGridInstanceColumn($dg, $catalogId_2format, $instanceName_2format);
						
						// second grid
						$formatter_1 			= new ET_GridFormatter($sdg_1);
						$tableName_2format_1 	= ET_CatalogInstance::getTableNameFromFullyQualifiedForm($_SESSION[SESS_CATALOG_INSTANCE_ID_DETAIL_ADMIN]);
						$catalogId_2format_1 	= $formatter->getSystemCatalogID($tableName_2format_1);
						$instanceName_2format_1 = $_SESSION[SESS_INSTANCE_NAME_DETAIL_ADMIN];
					
						$formatter_1->formatGridInstanceObject($sdg_1, $catalogId_2format_1, $instanceName_2format_1);
						$formatter_1->formatGridInstanceColumn($sdg_1, $catalogId_2format_1, $instanceName_2format_1);
						
					}
				}
				
				if (file_exists($generalFormatterFilePath)) {
					
					//$editButtonStatus 	= strpos(strtolower($this->crud), "u") ? true : false;
					//$deleteButtonStatus = strpos(strtolower($this->crud), "d") ? true : false;
					
					$editButtonStatus 	= $this->getEditDeleteButtonStatus($this->crud, true);
					$deleteButtonStatus = $this->getEditDeleteButtonStatus($this->crud, false);						
					$dg 				= $this->dg;
					$crud 				= $this->crud;
					
					if (!empty($this->detailDataGrids)) {
						include("sdgInclude.php");
					}						
					if ($this->subgrid_number === "") {
						include($generalFormatterFilePath);
					}						
				}
				
				if (!defined('CUSTOM_FORMAT_FILE_GENERAL')) return;
				// ----------> if splitted by language load the language part/file
				if (CUSTOM_FORMAT_FILE_SPLIT_BY_LANGUAGE == true) {
					$fileNameWithoutPHP = basename(__FILE__, ".php");
					$generalFormatterFilePath_LNG = $formatFolderPath   . "/" . CUSTOM_FORMAT_SUBFOLDER_GENERAL . "/" . $fileNameWithoutPHP . "_" . GRID_AREA_LANGUAGE . ".php";
					if (file_exists($generalFormatterFilePath_LNG)) {
						if (!empty($this->detailDataGrids)) {
							include("sdgInclude.php");
						}
						include($generalFormatterFilePath_LNG);
					}
				}
				
			}
		}
		
		protected function getEditDeleteButtonStatus ($crud, $editStatus) {
			
			if ($editStatus)
				return strpos(strtolower($crud), "u") ? true : false;
			else
				return strpos(strtolower($crud), "d") ? true : false;
		}
		
		protected function applyCustomDBFormatting($formatFolderPath, $formatFilePrefix) {
			
			$formatFolderDBPath = $formatFolderPath . "/" . CUSTOM_FORMAT_SUBFOLDER_CONNECTION . "/" . $this->connName;
			//$formatFolderDBPath =  $formatFolderPath . "/" . CUSTOM_FORMAT_SUBFOLDER_GENERAL . "/" . $this->connName;
			
			$this->applyCustomFormattingFilePrefix($formatFolderDBPath, $formatFilePrefix);
		}
		
		protected function applyCustomCatalogFormatting($formatFolderPath) {
			$byName = !defined('CUSTOM_FORMATTING_BY_CATALOG_NAME') ? FALSE : CUSTOM_FORMATTING_BY_CATALOG_NAME;
			
			if ($byName) {				
				$formatFolderCatalogNamePath = $formatFolderPath . "/" . CUSTOM_FORMAT_SUBFOLDER_CONNECTION . "/" . $this->connName;
				//echo $formatFolderCatalogNamePath;
				$catalogName = ET_CatalogInstance::getTableNameFromFullyQualifiedForm($this->fullTableName);
				$this->applyCustomFormattingFilePrefix($formatFolderCatalogNamePath, $catalogName);				
			}
			else {				
				$formatFolderCatalogIdPath = $formatFolderPath . "/" . CUSTOM_FORMAT_SUBFOLDER_CATALOG_ID;
				$catalogId = ET_MetaDataConnector::getInstance()->getCatalogId($this->catalogInstanceId);
				$this->applyCustomFormattingFilePrefix($formatFolderCatalogIdPath, $catalogId);				
			}
		}
		
		protected function applyCustomFormattingFilePrefix($formatFolderPath, $formatFilePrefix, $includeInstaceName = true, $optionKeyParam = '') {
			if (is_null($formatFilePrefix) || empty($formatFilePrefix)) return;
				
			$formatterFilePath 	= $formatFolderPath . "/" . $formatFilePrefix . ".php";
			
			//variables that can be used from the included format files
			$dg 				= $this->dg;
			$crud				= $this->crud;
			$instanceName 		= $includeInstaceName ? ET_MetaDataConnector::getInstance()->getInstanceName($this->catalogInstanceId) : $formatFilePrefix;
			$detailGrids 		= $this->detailDataGrids;	// this is used by the included file
			$optionKey			= $optionKeyParam;
			$action				= $optionKeyParam;
			
			if (file_exists($formatterFilePath)) {
				
				include("sdgInclude.php");
				include($formatterFilePath);
			}
			
			if(!defined('CUSTOM_FORMAT_FILE_GENERAL')) return;
			// ----------> if splitted by language load the language part/file
			if (CUSTOM_FORMAT_FILE_SPLIT_BY_LANGUAGE == true) {
				 
				//$formatterFilePath_LNG = $formatFolderPath . "/" . $formatFilePrefix . "_" . GRID_AREA_LANGUAGE . ".php";
				$lang = ET_NiotaUser::getNiotaUserFromSession()->getGridLanguage();
				$formatterFilePath_LNG = $formatFolderPath . "/" . $formatFilePrefix . "_" . $lang . ".php";
				if (file_exists($formatterFilePath_LNG)) {		
					if (!empty($this->detailDataGrids)) {
						include("sdgInclude.php");
					}					
					include($formatterFilePath_LNG);
				}
			}
		}

		protected function applyUserSettingsForDataGrid() {			
			$this->applyUserSettingForColumn();
			$this->applyUserSettingForCatalog();
		}
		
		protected function applyUserSettingForColumn() {
			
			if (!empty($this->userSettingsColumn)) {
				foreach ($this->userSettingsColumn as $key => $value) {
					foreach ($value as $key2 => $value2) {
						if ($key2 == USER_PARAM_COL_WIDTH) {
							$this->dg->set_col_width($key, $value2);
						}
					}
				}
			}
		}
		
		// rre
		protected function applyDBGridFormatting() {
			
			$dg 					= $this->dg;
			$catalogId_2format 		= ET_MetaDataConnector::getInstance()->getCatalogId($this->catalogInstanceId);
			$instanceName_2format 	= ET_MetaDataConnector::getInstance()->getInstanceName($this->catalogInstanceId);			
			
			$formatter = new ET_GridFormatter($dg);			
			$formatter->formatGridInstanceObject($dg, $catalogId_2format, $instanceName_2format);
			$formatter->formatGridInstanceColumn($dg, $catalogId_2format, $instanceName_2format);
		}
		// rre		
		
		protected function applyUserSettingForCatalog() {
			if (!empty($this->userSettingsCatalog)) {
				
				foreach ($this->userSettingsCatalog as $key => $value) {
					if ($key == USER_PARAM_GRID_DIMENSONS) {
						$dimensions = $this->resolveGridDimensions($value);
						$this->dg->set_dimension($dimensions[0], $dimensions[1], false);
					}
				}
			}
			else {
				$this->dg->set_dimension(800, 400, false);
			}
		}
		
		protected function initializeDbConnection(){
			$connArray 	= ET_ConnHelper::getConnectionArrayFromConnectionName($this->connName);
						
			$this->db_connection["hostname"] 		= $connArray['PHPGRID_DB_HOSTNAME'];
			$this->db_connection["username"] 		= $connArray['PHPGRID_DB_USERNAME'];
			$this->db_connection["password"] 		= $connArray[PHPGRID_DB_PASSWORD];
			$this->db_connection["dbname"] 			= $connArray['PHPGRID_DB_NAME'];
			$this->db_connection["dbtype"] 			= $connArray['PHPGRID_DB_TYPE'];
			$this->db_connection["dbcharset"] 		= $connArray['PHPGRID_DB_CHARSET'];
			$this->db_connection["dbauthmechanism"] = isset($connArray['PHPGRID_AUTH_MECHANISM']) ? $connArray['PHPGRID_AUTH_MECHANISM']  : "";
			$this->db_connection["passwordEncrypted"] = $connArray[PHPGRID_DB_PW_ENCRYPTED];
		}
		
		
		protected function setCRUD() {
			$crud = "CRUD";
				
			if(!$this->superUser && !$this->filterDialog) {
				$insertInt = $this->userRights['allow_insert'];
				$updateInt = $this->userRights['allow_update'];
				$deleteInt = $this->userRights['allow_delete'];
		
				$insert = ($insertInt == 1) ? "C" : "";
				$update = ($updateInt == 1) ? "U" : "";
				$delete = ($deleteInt == 1) ? "D" : "";
					
				$crud = "$insert"."R"."$update"."$delete";
					
			}

			if ($this->view) {
				ET_DisplayHelper::addWarningLine(ET_DisplayHelper::localize("VIEW_TO_READ_ONLY", null, PAGE_TYPE_GRID), "niota");
				$crud = 'R';
			}
			else if (empty($this->primaryKeys)) {
				ET_DisplayHelper::addWarningLine(ET_DisplayHelper::localize("MISSING_PK", null, PAGE_TYPE_GRID), "niota");
				$crud = 'R';
			} else if ($this->filterDialog) {
				$crud = 'RU';
			}
			
			$this->crud = $crud;			
			$this-> dg -> enable_edit("FORM", $this->crud);
			//$this-> dg -> enable_edit("INLINE", $this->crud);
			
			
		}
		
		protected function setReadonlyList() {
			if (!(is_null($this->readonlyList) || empty($this->readonlyList))) {
				$readonly_array = explode(",", $this->readonlyList);
				
				for ($i=0; $i < count($readonly_array); $i++) {
					$readonly_array[$i] = $this->formatReadOnlyElement($readonly_array[$i]);
				}
				
				$this->dg->set_col_readonly($readonly_array);
			}
		}
		
		protected function formatReadOnlyElement($element) {
			return trim($element);
		}
		
		
		protected function correctColumnNameForReadonlyList($colName) {
			return $colName;
		}
		
		protected function setLookups() {
			
			if (!empty($this->lookups)) {	
				
					foreach ($this->lookups as $columnName => $val) {
						
						$lookupInstance		= null;
						$val['columnName']	= $columnName;						
						$lookupInstance 	= ET_LookupFactory::createLookupInstance($val);
						
						$type 				= $lookupInstance->getType();
						$useExtendedLookup	= $lookupInstance->isExtendedLookupInUse();
						
						if (!is_null($lookupInstance->getError())) {
							$this->handleLookupError();
							ET_DisplayHelper::addErrorLine(ET_DisplayHelper::localize('ERROR_LOOKUP_GENERAL', null, PAGE_TYPE_GRID), 'niota');
							return;
						}
						
						$lookupConnName = $lookupInstance->get_ConnName();
						$lookupConnType = ET_ConnHelper::getConnectionTypeByName($lookupConnName);
						$sqlForLookup 	= $lookupInstance->get_LookupSql();
							
						$temp = $this->dg->set_col_edittype($columnName, "autocomplete", $sqlForLookup, false, null, $lookupConnName, 
								$lookupConnType, self::generateProjectionList($lookupInstance->getColumnInfo()), 
								$lookupInstance->getAddNullItem(), $this->filterDialog);
						
						if ($type == LOOKUP_TYPE_CASCADING && $useExtendedLookup) {
							
							$dataSetName 	= $lookupInstance->generateFilterLookupDataName();
							$dataSet		= $lookupInstance->generateFilterLookupData();
							
							$this->dg->set_nested_dropdown($lookupInstance->getFilterColumnName(), $columnName, $dataSetName);
							echo "<script>var $dataSetName = " . json_encode($dataSet) . ";\n</script>";
							
						}
						
						if (!is_null($temp) && gettype($temp) != "object" && $temp == 2 && !$this->filterDialog) {
							$this->handleLookupError();							
						}
						
						if (defined('PHPGRID_LOOKUP_COMBO_DEFAULT_WIDTH')) {
							$this->dg->set_col_property($columnName, array("editoptions"=>array("style"=>"width:" . PHPGRID_LOOKUP_COMBO_DEFAULT_WIDTH . "px")));
						}
							
						$this->dg->set_col_format($columnName, "select");
						
					}
			}
		}
		
		
		protected function handleLookupError() {
			$this->crud = "R";
			$this-> dg -> enable_edit("FORM", $this->crud);
		}
		
		protected static function endsWith($haystack, $needle)
		{
			$length = strlen($needle);
			if ($length == 0) {
				return true;
			}
		
			return (substr($haystack, -$length) === $needle);
		}		
	
		protected function setConstraintValuesIntoSession() {
		
			$browsingStore = ET_BrowsingStore::getBrowsingStore();						
			$browsingStore->clear_minMaxInfo($this->catalogInstanceId);
				
			//setting min and max date values
			foreach ($this->constraints as $fieldName => $settings) {
				$c_op1 		= $settings['operand1'];
				$c_op2 		= $settings['operand2'];
				$c_type		= $settings['column_type'];
				$c_op 		= $settings['operation'];
				$field_name = $fieldName;
					
				$subgridStr = "";
				if (!empty($this->subgridNumber))
					$subgridStr .= "subgrid" . $this->subgridNumber;
		
				if ($c_type == 'D' || $c_type == 'T') {
					$format = $c_type == 'D' ? 'Y-m-d' : 'Y-m-d H:i:s';
					if ($c_op == 7) {
	
						$browsingStore->add_minMaxInfo($this->catalogInstanceId, $field_name, $subgridStr, MIN_DATE, $c_op1);
						$browsingStore->add_minMaxInfo($this->catalogInstanceId, $field_name, $subgridStr, MIN_DATETIME, $c_op1);
						$browsingStore->add_minMaxInfo($this->catalogInstanceId, $field_name, $subgridStr, MAX_DATE, $c_op2);
						$browsingStore->add_minMaxInfo($this->catalogInstanceId, $field_name, $subgridStr, MAX_DATETIME, $c_op2);
					}
					else if ($c_op == 3) {
						$newDate_datepicker = date($format, strtotime($c_op1 . ' +1 day'));
						$newDate_datetimepicker = date($format, strtotime($c_op1 . ' +1 second'));
						$browsingStore->add_minMaxInfo($this->catalogInstanceId, $field_name, $subgridStr, MIN_DATE, $newDate_datepicker);
						$browsingStore->add_minMaxInfo($this->catalogInstanceId, $field_name, $subgridStr, MIN_DATETIME, $newDate_datetimepicker);
					}
					else if ($c_op == 4) {
						$newDate_datepicker = date($format, strtotime($c_op1 . ' -1 day'));
						$newDate_datetimepicker = date($format, strtotime($c_op1 . ' - 1 second'));
						$browsingStore->add_minMaxInfo($this->catalogInstanceId, $field_name, $subgridStr, MAX_DATE, $newDate_datepicker);
						$browsingStore->add_minMaxInfo($this->catalogInstanceId, $field_name, $subgridStr, MAX_DATETIME, $newDate_datetimepicker);
					}
					else if ($c_op == 5) {
						$browsingStore->add_minMaxInfo($this->catalogInstanceId, $field_name, $subgridStr, MIN_DATE, $c_op1);
						$browsingStore->add_minMaxInfo($this->catalogInstanceId, $field_name, $subgridStr, MIN_DATETIME, $c_op1);
					} else if ($c_op == 6) {
						$browsingStore->add_minMaxInfo($this->catalogInstanceId, $field_name, $subgridStr, MAX_DATE, $c_op1);
						$browsingStore->add_minMaxInfo($this->catalogInstanceId, $field_name, $subgridStr, MAX_DATETIME, $c_op1);
					}
				}					
			}
			$browsingStore->flushBrowsingStore();
		}
		
		protected function getTheme () {
			return $this->getGridColorTheme(COLOR_THEME, PAGE_TYPE_GRID);
		}
		
		protected function getGridColorTheme($colorTheme, $pageType) {
			$gridColorTheme = "";
			$phpFileName = $pageType == PAGE_TYPE_GRID ? 'niota' : 'admin_footer.php';
			
			if(!defined($colorTheme)) {
				ET_DisplayHelper::addErrorLine(ET_DisplayHelper::localize("COLOR_THEME_NOT_DEFINED", null, $pageType), $phpFileName);
				$gridColorTheme = "vega";
			}
			else{
				for ($i = 0; $i < count(GRID_THEME[0]); $i++){
						
					if (GRID_THEME[0][$i] == constant($colorTheme)){
						$gridColorTheme = GRID_THEME[1][$i];
					}
				}
				if ($gridColorTheme != ""){
					return $gridColorTheme;
				}
				else{
					ET_DisplayHelper::addErrorLine(ET_DisplayHelper::localize("COLOR_THEME_NOT_DEFINED", null, $pageType), $phpFileName);
					$gridColorTheme = "vega";
				}
			}
			return $gridColorTheme;
		}
		
		protected function setDateTimeFormats($connName, $columnInfo) {
			$def_date_source_format = ET_ConnHelper::getDateAndDatetimeFormat($connName, PHPGRID_SOURCE_DATE_FORMAT);
			$def_date_destination_format = ET_ConnHelper::getDateAndDatetimeFormat($connName, PHPGRID_DISPLAY_DATE_FORMAT);
				
			$def_datetime_source_format = ET_ConnHelper::getDateAndDatetimeFormat($connName, PHPGRID_SOURCE_DATETIME_FORMAT);
			$def_datetime_destination_format = ET_ConnHelper::getDateAndDatetimeFormat($connName, PHPGRID_DISPLAY_DATETIME_FORMAT);
			
			foreach ($columnInfo as $key => $val) {				
				if ($val['metaType'] == 'D') {					
					$this->dg->set_col_date($columnInfo[$key]['originalColumnName'], $def_date_source_format, $def_date_destination_format);
					$this->dg->set_col_date(strtolower($key), $def_date_source_format, $def_date_destination_format);
					$this->dg->set_col_date(strtoupper($key), $def_date_source_format, $def_date_destination_format);
				} else if ($val['metaType'] == 'T') {					
					$this->dg->set_col_datetime($columnInfo[$key]['originalColumnName'], $def_datetime_source_format, $def_datetime_destination_format);
					$this->dg->set_col_datetime(strtolower($key), $def_datetime_source_format, $def_datetime_destination_format);
					$this->dg->set_col_datetime(strtoupper($key), $def_datetime_source_format, $def_datetime_destination_format);
				}
			}
		}
		
		protected function setColumnAlignement(){
			foreach ($this->columnInfo as $key => $val) {
				$columnName = $val['originalColumnName'];
				$metaType = $val['metaType'];
				if ($metaType == 'N' || $metaType == 'I' || $metaType == 'D' || $metaType == 'T') {
					if(($metaType == 'N' || $metaType == 'I') && strlen($columnName) <= 10){
							
						$this->dg->set_col_width($columnName, 75);
						//$this->dg->set_col_width(strtoupper($columnName), 75);
					}
					else if($metaType == 'D' ||$metaType == 'T' && strlen($columnName) <= 15){
						$this->dg->set_col_width($columnName, 130);
						//$this->dg->set_col_width(strtoupper($columnName), 130);
					}
		
					$this->dg->set_col_align($columnName, "right");
					//$this->dg->set_col_align(strtolower($columnName), "right");
					//$this->dg->set_col_align(strtoupper($columnName), "right");
				}
			}
		}
		
		protected function setGridLanguage() {
			if(defined('GRID_AREA_LANGUAGE')){
				$this->dg -> set_locale(GRID_AREA_LANGUAGE);
			}
			else{
				addErrorLine(ET_DisplayHelper::localize("GRID_LANGUAGE_NOT_DEFINED", null, PAGE_TYPE_GRID), "niota");
				$this->dg->set_locale('en');
			}
		
		}
		
		protected function printJavascript() {			
			ET_PrintGridFunctions::printNumberFormatterFunction($this->decimalPoint);
			
			$col_wysiwygs = $this->dg->get_col_wysiwygs();
			ET_PrintGridFunctions::printWysiwygFormatterFunction($col_wysiwygs);
			
			//ET_PrintGridFunctions::setColumnFormatters($this->columnInfo, $this->decimalPoint, $this->dg, $this->detailDataGrids);
			//ET_PrintGridFunctions::printCustomValidationFunctions($this->dg, $this->constraints, $this->decimalPoint, $this->catalogInstanceId);
			
			ET_PrintGridFunctions::setColumnFormattersOnly($this->columnInfo, $this->decimalPoint, $this->dg, $this->detailDataGrids);
			ET_PrintGridFunctions::printCustomValidationFunctionsWrapperStyle($this->dg, $this->constraints, $this->decimalPoint, $this->catalogInstanceId, $this->columnInfo);
			
		}
		
		protected function resolveGridDimensions($gridDimensions) {		
			$ret = array();
			$tmp = explode(";", $gridDimensions);
			
			$w = $tmp[0];
			$width = substr($w, 2);
			
			$h = $tmp[1];		
			$height = substr($h, 2);
			
			array_push($ret, $width);
			array_push($ret, $height);
			
			return $ret;
		}
		
		protected  function  getCaptionPopup() {
			$userSettings = ET_NiotaUser::getNiotaUserFromSession()->get_userSettingsCatalog($this->catalogInstanceId);
			
			if (isset($userSettings[USER_PARAM_FILTER_CAPTION])) {
				$captionPopup = $userSettings[USER_PARAM_FILTER_CAPTION];
				
				$db_charset = ET_ConnHelper::getConnectionCharsetByName(ET_METADATA_CONNECTION);
				$db_type = ET_ConnHelper::getConnectionTypeByName(ET_METADATA_CONNECTION);
				
				if ($db_type == DB_TYPE_ODBC_MSSQL) {
					$captionPopup = iconv($db_charset, "utf-8", $captionPopup);
				}
				else if ($db_type == DB_TYPE_ODBC_TERADATA) {
					$captionPopup = rtrim(iconv($db_charset, "utf-8", $captionPopup));
				}
				return $captionPopup;
			}
			else 
				return ADVANCED_FILTER_CAPTION_DEFAULT;			
		}
				
		public static function generateProjectionList($columnInfo, $lowerCase = true) {
			$ret = "";
				
			$tempArray = array();
				
			foreach ($columnInfo as $key => $value) {
				$tempArray[$value['orderNumber']] = $lowerCase ? $key : $value['originalColumnName'];
			}
				
			ksort($tempArray);
				
			foreach ($tempArray as $key => $value) {
				$ret .= $value . ",";
			}
				
			if (self::endsWith($ret, ",")) {
				$ret = substr($ret, 0, strlen($ret) - 1);
			}
			return $ret;
		}
		
		public static function getColumnNamesOrdered($columnInfo, $lowerCase = true) {
			$ret = array();
				
			$tempArray = array();
			foreach ($columnInfo as $key => $value) {
				$tempArray[$value['orderNumber']] = $lowerCase ? $key : $value['originalColumnName'];
			}
		
			ksort($tempArray);
		
			foreach ($tempArray as $key => $value) {
				$ret[] = $value;
			}
		
			return $ret;
		}
		
		
		public function displayGrid() {
			
			$this->printJavascript();
			try {
				$this->dg->display();				
			} catch (Throwable $t) {
				ET_DisplayHelper::addErrorLine(ET_DisplayHelper::localize("ERROR_GRID_LOAD", null, PAGE_TYPE_GRID), "niota");
			}
		}
		
		public function getLookups(){
			return $this->lookups;
		}
		
		public function getCatalogInstanceId(){
			return $this->catalogInstanceId;
		}
		
		public function getConstraints(){
			return $this->constraints;
		}
		
		public function getColumnInfo(){
			return $this->columnInfo;
		}
		
		public function getCLSDataGrid() {
			return $this->dg;
		}
		
		public function getSubgridNumber() {
			return $this->subgrid_number;
		}
		
		public function getSubgridLogicalLink() {
			return $this->subgrid_logical_link;
		}
		
		public function getCrud() {
			return $this->crud;
		}
						
	}
?>