<?php
class ET_DirectLogger {
	
	protected $connName;
	protected $dbName;
	protected $conn;
	protected $logTableSimple;
	protected $logTableDetailed;
	protected $connType;
	
	public const LOG_MSG_TYPE_SIMPLE 	= "simple";
	public const LOG_MSG_TYPE_DETAILED 	= "detailed";
	
	public function __construct($connNameObject) {
		
		//$this->connName 		= ET_METADATA_CONNECTION;
		$this->connName 		= ET_MetaDataConnector::getInstance()->getMessageConnectionName($connNameObject);
		$this->conn 			= ET_ConnHelper::getConnection($this->connName);
		$this->logTableSimple 	= ET_ConnHelper::getfullDbName($this->connName) . ".etx_message";
		//$this->logTableDetailed	= ET_ConnHelper::getfullDbName($this->connName) . ".etx_message_detail";
		//detailed log is bound to niota_meta db -> using customerdb is deprecated
		$this->logTableDetailed	= ET_SysTableHandler::getSpecificTableOrViewFullName(T_MESSAGEDETAIL, ET_METADATA_CONNECTION);
		$this->dbName 			= ET_ConnHelper::getDbNameByConnectionName($this->connName);
		$this->connType			= ET_ConnHelper::getConnectionTypeByName($this->connName);
	}
		
	public function log($msg, $msgGuid, $msgType, $logType, $actionType = "", $dataPk = "") {
		
		$ret		= false;			
		$idSession 	= session_id();
		$userName 	= $_SESSION[SESS_USERNAME];
		
		if ($logType == self::LOG_MSG_TYPE_SIMPLE) {
			$ret = $this->logSimple($msg, $msgGuid, $msgType, $idSession, $userName);
		} else if ($logType == self::LOG_MSG_TYPE_DETAILED) {
			
			try {				
				$ret = $this->logDetailed($msg, $msgGuid, $msgType, $idSession, $userName, $actionType, $dataPk);
			} catch (Exception $e) {
				throw $e;
			}
			
		} 
		
		return $ret;		
	}
	
	/***
	 * Function logs detailed validatiaon messages into table niota_meta.etx_message_detail.	 
	 * 
	 * @param unknown $msg
	 * @param unknown $msgGuid
	 * @param unknown $msgType
	 * @param unknown $idSession
	 * @param unknown $userName
	 * @param unknown $actionType
	 * @param unknown $dataPK
	 * @throws Exception
	 * @return unknown
	 */
	protected function logDetailed ($msg, $msgGuid, $msgType, $idSession, $userName, $actionType, $dataPK) {
		
		$ret 		= false;		
		$ts 		= date("Y-m-d H:i:s");
		$tsToUse	= "";
		$clientId 	= $_SESSION[SESS_CLIENT];
		$catInstId 	= ET_CallableObjectHelper::getCatalogInstanceId(false);//$_SESSION[SESS_CATALOG_INSTANCE_ID_MASTER];
		$catId		= ET_MetaDataConnector::getInstance()->getCatalogId($catInstId);
		$instName	= ET_MetaDataConnector::getInstance()->getInstanceName($catInstId);
		$objectTmp	= ET_BrowsingStore::getBrowsingStore()->get_fullTableName($catInstId);
		$object 	= ET_CatalogInstance::getTableNameFromFullyQualifiedForm($objectTmp);
		$dbName		= ET_ConnHelper::getfullDbName(ET_BrowsingStore::getBrowsingStore()->get_ConnName($catInstId));
		$dataPk		= "";
		$sql 		= "INSERT INTO " . $this->logTableDetailed ."
						(ts_log, id_session, guid_msg, client_id, username, action_type, db_name, catalog_id, instance_name, object, data_pk, text_msg)
						VALUES
						(%timestamp%, '$idSession', '$msgGuid', '$clientId', '$userName', '$actionType', '$dbName', $catId, '$instName', '$object', '$dataPK', '$msg')";
		
		// using customers db to store etx_message_detail table is deprecated 
		/*
		if ($this->connType == DB_TYPE_OCI805) {			
			$tsToUse = "TO_DATE('$ts','RRRR-MM-DD, HH24:MI:SS')";			
		} else {
			$tsToUse = "'$ts'";
		}	
		*/
		$tsToUse 	= "'$ts'";		
		$sql 		= str_replace("%timestamp%", $tsToUse, $sql);			
		
		return ET_MetaDataConnector::getInstance()->logDetailedValidationMessages($sql);		
		
	}
	
	protected function logSimple($msg, $msgGuid, $msgType, $idSession, $userName) {
		
				
		$sql = "INSERT INTO " . $this->logTableSimple ."
					(id_session, guid_msg, type_msg, text_msg, username) 
				VALUES ('$idSession', '$msgGuid', '$msgType', '$msg', '$userName')";
		
		$ret = $this->conn->Execute($sql);
		
		if ($ret === false) {
			$dbErrorMsg = $this->conn->ErrorMsg();
			throw new Exception("Logging error!<br>" . $dbErrorMsg);
		}
		else {
			return true;
		}
	}
}